#include "globaldecsshare.h"

tile_typ::tile_typ()
  {
  updateType(TILE_WALK1);
  }

void tile_typ::refreshType()
  {
  switch(graphic)
    {
    case TILE_BG:
    case TILE_BLOCK1:
    case TILE_BLOCK2:
    case TILE_BLOCK3:
      behavior=IMPASSABLE;
      item=ITEM_NONE;
      item_var=0;
      break;
    case TILE_HURTS:
      behavior=HURTS;
      item=ITEM_NONE;
      item_var=0;
      break;
    default:
      switch(item)
        {
        case ITEM_STAIRS_DOWN:
        case ITEM_STAIRS_UP:
        case ITEM_CASTLE:
        case ITEM_TOWN:
        case ITEM_DARKPIT:
          behavior=OPEN_TELEPORT;
          break;
        case ITEM_DOOR:
          behavior=CLOSED_DOOR;
          break;
        case ITEM_CHEST:
          behavior=CLOSED_CHEST;
          break;
        default:
          behavior=WALKABLE;
          break;
        }
      break;
    }
  }

void tile_typ::updateType(int newGraphic)
  {
  graphic=newGraphic;
  refreshType();
  }

map_typ::map_typ()
  {
  world_level=5;
  prev_level=0;
  map_edit_mode=0;
  tile_set=0;
  active_npcs=0; // the player
  left=top=0; // used for drawing properly offset characters
  startW=endW=startH=endH=0;
  }

void map_typ::copyNewMaps()
  {
  for(int i=0;;i++)
    {
    if(mapLoad(i,1))
      break;
    mapSave(i);
    }
  }

void map_typ::loadLevelUseCoord(int level)
  {
  world_level=-1; // first call
  mapLoad(level,0);
  }

void map_typ::changeSong()
  {
  destroy_midi(LEVEL_SONG);
  switch(tile_set)
      {
      case 0: LEVEL_SONG=load_midi("data//town.mid"); break;
      case 1: LEVEL_SONG=load_midi("data//overworld.mid"); break;
      default: LEVEL_SONG=load_midi("data//king.mid"); break;
      }
  play_midi(LEVEL_SONG,1); // play whatever song we've loaded
  }

void map_typ::drawMe(int centerX,int centerY)
  {
  int centerTileW=centerX>>TILE_SIDE_SHIFT;
  int centerTileH=centerY>>TILE_SIDE_SHIFT;
  centerTileW-=1; // centers camera over player
  startW=centerTileW-((SCREEN_W>>1)>>TILE_SIDE_SHIFT);
  startH=centerTileH-((SCREEN_H>>1)>>TILE_SIDE_SHIFT);
  endW=(centerTileW<<1)-startW+2;// better to overdraw than underdraw, and the last row/col are pretty cheap anyhow
  endH=(centerTileH<<1)-startH+2;

  left=(startW<<TILE_SIDE_SHIFT)+TILE_SIDE+((centerX&63)<32 ? (centerX&31)-31 : (centerX&31));
  top=(startH<<TILE_SIDE_SHIFT)+TILE_SIDE+((centerY&63)<32 ? (centerY&31)-31 : (centerY&31));

  for(int w=startW;w<endW;w++)
    for(int h=startH;h<endH;h++)
      {
      if(w>=0 && h>=0 && w<MAP_W && h<MAP_H)
        {
        blit(TILE_SET[tile_set][tiles[w][h].graphic],DB,0,0,
             (w<<TILE_SIDE_SHIFT)-left,(h<<TILE_SIDE_SHIFT)-top,
             TILE_SIDE,TILE_SIDE);
        if(tiles[w][h].item!=ITEM_NONE)
          {
          masked_blit(ITEM_SET[tiles[w][h].item],DB,0,0,
             (w<<TILE_SIDE_SHIFT)-left,(h<<TILE_SIDE_SHIFT)-top,
             TILE_SIDE,TILE_SIDE);
          }
        }
      else
        {
        blit(TILE_SET[tile_set][TILE_BG],DB,0,0,
             (w<<TILE_SIDE_SHIFT)-left,(h<<TILE_SIDE_SHIFT)-top,
             TILE_SIDE,TILE_SIDE);
        }
      }
    left+=(TILE_SIDE>>1); // adjusting to draw characters offset
    top+=(TILE_SIDE>>1);
  }

void map_typ::generateMess()
  {
  for(int w=0;w<MAP_W;w++)
    for(int h=0;h<MAP_H;h++)
      {
      tiles[w][h].graphic=rand()%TILE_TYPES;
      if(!(rand()&15))
        {
        tiles[w][h].item=rand()%ITEM_NUM;
        tiles[w][h].item_var=0;
        }
      }
  active_npcs=2+(rand()&15);
  for(int i=0;i<map.active_npcs;i++)
    {
    npc[i].mySprite=1+(rand()%(sprites_num-1)); // dodge using player's sprite
    }
  }

int mapLoad(int lev_num, int from_new)
  {
  char filename[30]; // file, then header
  char filenum[10];

  char fullname[30]; // numbered sub-elements
  char partnum[10];

  dialog.Reset(); // don't let conversations carry between maps

  if(!map.map_edit_mode && !from_new && map.world_level>=0)
    mapSave(map.world_level); // save changes

  map.prev_level=map.world_level;
  map.world_level=lev_num;

  if(from_new)
    strcpy(filename,"data//new//level");
  else
    strcpy(filename,"data//level");
  itoa(lev_num,filenum,10);
  strcat(filename,filenum);
  strcat(filename,".dat");
  set_config_file(filename);

  if(get_config_int("player","mapXpixel", -666)==-666)
    return 1; // file isn't here

  if(from_new) // ENSURE we don't keep the same cfg filename from mapSave
    strcpy(filename,"data//new//level");
  else
    strcpy(filename,"data//level");
  itoa(lev_num,filenum,10);
  strcat(filename,filenum);
  strcat(filename,".dat");
  set_config_file(filename);


  if(map.prev_level==-1)
    {
    player.x=get_config_int("player","mapXpixel", ((MAP_W<<TILE_SIDE_SHIFT)+TILE_SIDE)>>1);
    player.y=get_config_int("player","mapYpixel", ((MAP_H<<TILE_SIDE_SHIFT)+TILE_SIDE)>>1);
    player.lockToGrid();
    }

  for(int wx=0;wx<MAP_W;wx++)
    for(int wy=0;wy<MAP_H;wy++)
      {
      strcpy(filename,"i");
      itoa(wx+(wy*MAP_W),filenum,30);
      strcat(filename,filenum);
      map.tiles[wx][wy].item=get_config_int("map",filename, ITEM_NONE);

      switch(map.tiles[wx][wy].item)
        {
        case ITEM_CHEST:
        case ITEM_STAIRS_DOWN:
        case ITEM_STAIRS_UP:
        case ITEM_CASTLE:
        case ITEM_TOWN:
        case ITEM_DARKPIT:
          strcpy(filename,"iv");
          itoa(wx+(wy*MAP_W),filenum,30);
          strcat(filename,filenum);
          map.tiles[wx][wy].item_var=get_config_int("map",filename, 0);

          if(map.prev_level==map.tiles[wx][wy].item_var && map.tiles[wx][wy].item!=ITEM_CHEST)
            {
            player.x=(wx<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
            player.y=((wy-1)<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1); // come out 1 tile over
            player.lockToGrid();
            }
          break;
        default:
          break;
        }

      strcpy(filename,"m");
      itoa(wx+(wy*MAP_W),filenum,30);
      strcat(filename,filenum);
      map.tiles[wx][wy].updateType(get_config_int("map",filename, TILE_WALK1));
      }

  script.scriptNPCs=map.active_npcs=0;
  for(int i=0;i<MAX_NPCS;i++)
    {
    strcpy(filename,"npc");
    itoa(i+1,filenum,10);
    strcat(filename,filenum);
    npc[i].mySprite=get_config_int(filename,"mySprite", -1);
    if(npc[i].mySprite==-1) break;
    npc[i].x=get_config_int(filename,"mapXpixel", -1);
    npc[i].y=get_config_int(filename,"mapYpixel", -1);
    npc[i].lockToGrid();
    
    for(int ii=0;ii<DIALOG_LINES;ii++)
      {
      strcpy(fullname,"myText");
      itoa(ii+1,partnum,10);
      strcat(fullname,partnum);
      strcpy(npc[i].line[ii],get_config_string(filename,fullname, ""));
      }

    map.active_npcs++;
    }

  for(int i=0;i<DIALOG_LINES;i++)
    {
    strcpy(fullname,"myText");
    itoa(i+1,filenum,10);
    strcat(fullname,filenum);
    strcpy(dialog.bossopening1[i],get_config_string("BossText",fullname, ""));
    strcpy(dialog.bossopening2[i],get_config_string("BossText2",fullname, ""));
    }

  map.tile_set=get_config_int("map","tileSet", rand()&1);
  if(!from_new)
    map.changeSong();

  int buttonheld; // don't let move instructions carry between maps
  do
    {
    buttonheld=0;
    if(num_joysticks)
      poll_joystick();

    if(key[KEY_UP] || key[KEY_W] || (num_joysticks && joy[0].stick[0].axis[1].d1))
      { buttonheld=1; }
    if(key[KEY_LEFT] || key[KEY_A] || (num_joysticks && joy[0].stick[0].axis[0].d1))
      { buttonheld=1; }
    if(key[KEY_DOWN] || key[KEY_S] || (num_joysticks && joy[0].stick[0].axis[1].d2))
      { buttonheld=1; }
    if(key[KEY_RIGHT] || key[KEY_D] || (num_joysticks && joy[0].stick[0].axis[0].d2))
      { buttonheld=1; }
    } while(buttonheld);

  if(!from_new && script.script_num<=0)
    {
    playGameFrame();
    drawGameFrame(1);
    }
  return 0;
  }

int map_typ::whoTalkingTo()
  {
  int tx=(player.x)-(TILE_SIDE>>1),t2x;
  int ty=(player.y)-(TILE_SIDE>>1),t2y;
  tx>>=TILE_SIDE_SHIFT;
  ty>>=TILE_SIDE_SHIFT;
  int otx=tx, oty=ty; // also detect people under us

  switch(player.facing)
    {
    case UP:
      ty--;
      break;
    case RIGHT:
      tx++;
      break;
    case DOWN:
      ty++;
      break;
    case LEFT:
      tx--;
      break;
    }
  if(ty<map.startH || ty>map.endH || tx<map.startW || tx>map.endW)
    return -1; // more often offscreen than on, and this allows allows short-circuiting
  for(int i=0;i<active_npcs;i++)
    {
    t2x=(npc[i].x)-(TILE_SIDE>>1);
    t2x>>=TILE_SIDE_SHIFT;
    if(t2x==tx || t2x==otx)
      {
      t2y=(npc[i].y)-(TILE_SIDE>>1);
      t2y>>=TILE_SIDE_SHIFT;

      if(t2y==ty || t2y==oty)
        {
        player.x=(otx<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
        player.y=(oty<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
        if(map.tiles[tx][ty].behavior!=WALKABLE) // don't force over debris
          {
          npc[i].x=player.x;
          npc[i].y=player.y;
          }
        else
          {
          npc[i].x=(tx<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
          npc[i].y=(ty<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
          }
        player.lockToGrid();
        npc[i].lockToGrid();
        return i;
        }
      }
    }
  return -1;
  }

void mapSave(int lev_num)
  {
  char filename[30]; // file name then headers
  char filenum[10];

  char fullname[30]; // numbered sub-elements
  char partnum[10];

  if(lev_num<0) return; // no way

  strcpy(filename,"data//level");
  itoa(lev_num,filenum,10);
  strcat(filename,filenum);
  strcat(filename,".dat");
  delete_file(filename);
  set_config_file(filename);

  set_config_int("player","mapXpixel", player.x);
  set_config_int("player","mapYpixel", player.y);

  set_config_int("map","tileSet", map.tile_set);

  for(int wx=0;wx<MAP_W;wx++)
    for(int wy=0;wy<MAP_H;wy++)
      {
      if(map.tiles[wx][wy].item!=ITEM_NONE)
        {
        strcpy(filename,"i");
        itoa(wx+(wy*MAP_W),filenum,30);
        strcat(filename,filenum);
        set_config_int("map",filename, map.tiles[wx][wy].item);
        switch(map.tiles[wx][wy].item)
          {
          case ITEM_CHEST:
          case ITEM_STAIRS_DOWN:
          case ITEM_STAIRS_UP:
          case ITEM_CASTLE:
          case ITEM_TOWN:
          case ITEM_DARKPIT:
            strcpy(filename,"iv");
            itoa(wx+(wy*MAP_W),filenum,30);
            strcat(filename,filenum);
            set_config_int("map",filename, map.tiles[wx][wy].item_var);
            break;
          default:
            break;
          }
        }
      if(map.tiles[wx][wy].graphic!=TILE_WALK1)
        {
        strcpy(filename,"m");
        itoa(wx+(wy*MAP_W),filenum,30);
        strcat(filename,filenum);
        set_config_int("map",filename, map.tiles[wx][wy].graphic);
        }
      }

  for(int i=0;i<map.active_npcs;i++)
    {
    strcpy(filename,"npc");
    itoa(i+1,filenum,10);
    strcat(filename,filenum);
    set_config_int(filename,"mySprite", npc[i].mySprite);
    set_config_int(filename,"mapXpixel", npc[i].x);
    set_config_int(filename,"mapYpixel", npc[i].y);

    for(int ii=0;ii<DIALOG_LINES;ii++)
      {
      strcpy(fullname,"myText");
      itoa(ii+1,partnum,10);
      strcat(fullname,partnum);
      set_config_string(filename,fullname, npc[i].line[ii]);
      }
    }
  for(int i=0;i<DIALOG_LINES;i++)
      {
      strcpy(fullname,"myText");
      itoa(i+1,partnum,10);
      strcat(fullname,partnum);
      set_config_string("BossText",fullname, dialog.bossopening1[i]);
      }
  for(int i=0;i<DIALOG_LINES;i++)
      {
      strcpy(fullname,"myText");
      itoa(i+1,partnum,10);
      strcat(fullname,partnum);
      set_config_string("BossText2",fullname, dialog.bossopening2[i]);
      }
  }

void mapEdit()
  {
  int wxTile1,wyTile1,wxTile2,wyTile2;
  int holdCount=0;
  int dragGraphicOrItem=0;
  int swapVar;
  int NPCfound;

  if(mouse_x<0 || mouse_y<0 || mouse_x>=SCREEN_W || mouse_y>=SCREEN_H) return; // avoids windows crashes

  // these are pairs of commands that are mutually exclusive, but don't use tile references
  if(key[KEY_F5])
    {
    while(key[KEY_F5]);
    map.tile_set--;
    if(map.tile_set<0)map.tile_set=tileset_num-1;
    map.changeSong();
    }
  if(key[KEY_F6])
    {
    while(key[KEY_F6]);
    map.tile_set++;
    if(map.tile_set>=tileset_num)map.tile_set=0;
    map.changeSong();
    }

  if(key[KEY_F9])
    {
    while(key[KEY_F9]) ;
    if(--map.world_level<0) map.world_level=0;
    else mapLoad(map.world_level,0); // prevents us from overwriting maps by accident
    }
  else if(key[KEY_F10])
    {
    while(key[KEY_F10]) ;
    map.world_level++;
    mapLoad(map.world_level,0); // prevents us from overwriting maps by accident
    }
  if(key[KEY_F11])
    {
    while(key[KEY_F11]) ;
    mapSave(map.world_level);
    }
  else if(key[KEY_F12])
    {
    while(key[KEY_F12]) ;
    mapLoad(map.world_level,0);
    }

  // things after this comment in MapEdit will use tile references
  wxTile1=(mouse_x+map.left-32)>>TILE_SIDE_SHIFT;
  wyTile1=(mouse_y+map.top-32)>>TILE_SIDE_SHIFT;

  if(key[KEY_F7])
    {
    while(key[KEY_F7]);
    map.tiles[wxTile1][wyTile1].item_var--;
    if(map.tiles[wxTile1][wyTile1].item!=ITEM_CHEST)
      { // it's a teleport, so don't let it go below 0
      if(map.tiles[wxTile1][wyTile1].item_var<0)
        map.tiles[wxTile1][wyTile1].item_var=0;
      }
    else // it's a chest, so wrap items
      {
      if(map.tiles[wxTile1][wyTile1].item_var<0)
        map.tiles[wxTile1][wyTile1].item_var=CHEST_NUM-1;
      }
    }
  else if(key[KEY_F8])
    {
    while(key[KEY_F8]);
    map.tiles[wxTile1][wyTile1].item_var++;
    if(map.tiles[wxTile1][wyTile1].item==ITEM_CHEST && map.tiles[wxTile1][wyTile1].item_var>=CHEST_NUM)
      map.tiles[wxTile1][wyTile1].item_var=0;
    }
  else if(LMB)
    {
    while(LMB)
      {
      wxTile2=(mouse_x+map.left-32)>>TILE_SIDE_SHIFT;
      wyTile2=(mouse_y+map.top-32)>>TILE_SIDE_SHIFT;
      drawGameFrame(0);
      }

    if(wxTile1<0)wxTile1=0;
    if(wxTile1>=MAP_W)wxTile1=MAP_W-1;
    if(wyTile1<0)wyTile1=0;
    if(wyTile1>=MAP_H)wyTile1=MAP_H-1;

    if(wxTile2<0)wxTile2=0;
    if(wxTile2>=MAP_W)wxTile2=MAP_W-1;
    if(wyTile2<0)wyTile2=0;
    if(wyTile2>=MAP_H)wyTile2=MAP_H-1;


    if(!key[KEY_N])
      {
      dragGraphicOrItem=map.tiles[wxTile1][wyTile1].graphic; // take from 1st, before swapping

      if(wxTile2<wxTile1)
        {
        swapVar=wxTile2;
        wxTile2=wxTile1;
        wxTile1=swapVar;
        }
      if(wyTile2<wyTile1)
        {
        swapVar=wyTile2;
        wyTile2=wyTile1;
        wyTile1=swapVar;
        }

      if(wxTile1==wxTile2 && wyTile1==wyTile2) // no drag
        {
        if(!key[KEY_LSHIFT])
          {
          map.tiles[wxTile1][wyTile1].graphic++;
          if(map.tiles[wxTile1][wyTile1].graphic>=TILE_TYPES)map.tiles[wxTile1][wyTile1].graphic=0;
          }
        else
          {
          map.tiles[wxTile1][wyTile1].graphic--;
          if(map.tiles[wxTile1][wyTile1].graphic<0)map.tiles[wxTile1][wyTile1].graphic=TILE_TYPES-1;
          }
        map.tiles[wxTile1][wyTile1].refreshType();
        }
      else
        {
        wxTile2++;
        wyTile2++;
        for(int wx=wxTile1;wx<wxTile2;wx++)
          for(int wy=wyTile1;wy<wyTile2;wy++)
            {
            map.tiles[wx][wy].updateType(dragGraphicOrItem);
            }
        }
      }
    else // holding N - edit NPCS
      {
      if(wxTile1==wxTile2 && wyTile1==wyTile2) // no drag
        {
        NPCfound=0;
        for(int i=0;i<map.active_npcs;i++)
          {
          if((npc[i].x>>TILE_SIDE_SHIFT)==wxTile1 &&
             (npc[i].y>>TILE_SIDE_SHIFT)==wyTile1)
             {
             if(++npc[i].mySprite>=sprites_num)npc[i].mySprite=0;
             NPCfound++;
             }
          }
        if(NPCfound==0 && map.active_npcs<(MAX_NPCS-1))
          {
          npc[map.active_npcs].x=wxTile1<<TILE_SIDE_SHIFT;
          npc[map.active_npcs].y=wyTile1<<TILE_SIDE_SHIFT;
          npc[map.active_npcs].mySprite=rand()%sprites_num;
          npc[map.active_npcs].lockToGrid();
          map.active_npcs++;
          }
        }
      else
        {
        for(int i=0;i<map.active_npcs;i++)
          {
          for(int i=0;i<map.active_npcs;i++)
            {
            if((npc[i].x>>TILE_SIDE_SHIFT)==wxTile1 &&
               (npc[i].y>>TILE_SIDE_SHIFT)==wyTile1)
               {
               npc[i].x=wxTile2<<TILE_SIDE_SHIFT;
               npc[i].y=wyTile2<<TILE_SIDE_SHIFT;
               npc[i].lockToGrid();
               }
            }
          }
        }
      }
    }
  if(RMB)
    {
    while(RMB)
      {
      wxTile2=(mouse_x+map.left-32)>>TILE_SIDE_SHIFT;
      wyTile2=(mouse_y+map.top-32)>>TILE_SIDE_SHIFT;
      drawGameFrame(0);
      }

    if(wxTile1<0)wxTile1=0;
    if(wxTile1>=MAP_W)wxTile1=MAP_W-1;
    if(wyTile1<0)wyTile1=0;
    if(wyTile1>=MAP_H)wyTile1=MAP_H-1;

    if(wxTile2<0)wxTile2=0;
    if(wxTile2>=MAP_W)wxTile2=MAP_W-1;
    if(wyTile2<0)wyTile2=0;
    if(wyTile2>=MAP_H)wyTile2=MAP_H-1;

    if(!key[KEY_N])
      {
      dragGraphicOrItem=map.tiles[wxTile1][wyTile1].item; // take from 1st, before swapping

      if(wxTile2<wxTile1)
        {
        swapVar=wxTile2;
        wxTile2=wxTile1;
        wxTile1=swapVar;
        }
      if(wyTile2<wyTile1)
        {
        swapVar=wyTile2;
        wyTile2=wyTile1;
        wyTile1=swapVar;
        }

      if(wxTile1==wxTile2 && wyTile1==wyTile2) // no drag
        {
        if(!key[KEY_LSHIFT])
          {
          map.tiles[wxTile1][wyTile1].item++;
          if(map.tiles[wxTile1][wyTile1].item>=ITEM_TYPES)map.tiles[wxTile1][wyTile1].item=0;
          }
        else
          {
          map.tiles[wxTile1][wyTile1].item--;
          if(map.tiles[wxTile1][wyTile1].item<0)map.tiles[wxTile1][wyTile1].item=ITEM_TYPES-1;
          }
        map.tiles[wxTile1][wyTile1].refreshType();
        }
      else
        {
        wxTile2++;
        wyTile2++;
        for(int wx=wxTile1;wx<wxTile2;wx++)
          for(int wy=wyTile1;wy<wyTile2;wy++)
            {
            map.tiles[wx][wy].item=dragGraphicOrItem;
            map.tiles[wx][wy].refreshType();
            }
        }
      }
    else // holding N - edit NPCS
      {
      if(wxTile1==wxTile2 && wyTile1==wyTile2) // no drag
        {
        for(int i=0;i<map.active_npcs;i++)
          {
          if((npc[i].x>>TILE_SIDE_SHIFT)==wxTile1 &&
             (npc[i].y>>TILE_SIDE_SHIFT)==wyTile1)
            npc[i]=npc[--map.active_npcs];
          }
        }
      else
        {
        if(wxTile2<wxTile1)
          {
          swapVar=wxTile2;
          wxTile2=wxTile1;
          wxTile1=swapVar;
          }
        if(wyTile2<wyTile1)
          {
          swapVar=wyTile2;
          wyTile2=wyTile1;
          wyTile1=swapVar;
          }

        for(int i=0;i<map.active_npcs;i++)
          {
          if((npc[i].x>>TILE_SIDE_SHIFT)>wxTile1 &&
             (npc[i].x>>TILE_SIDE_SHIFT)<wxTile2 &&
             (npc[i].y>>TILE_SIDE_SHIFT)>wyTile1 &&
             (npc[i].y>>TILE_SIDE_SHIFT)<wyTile2)
            npc[i]=npc[--map.active_npcs];
          }
        }
      }
    }
  }

void mapEditDraw()
  {
  char stringTrap[30];
  char stringToCat[10];

  textout_centre(DB,font,"MAP_EDIT_MODE_ON - PRESS F1 TO TOGGLE",(SCREEN_W>>1)+1,6,0);
  textout_centre(DB,font,"MAP_EDIT_MODE_ON - PRESS F1 TO TOGGLE",(SCREEN_W>>1),5,0XFFFF);

  if(!key[KEY_N])
    {
    textout_centre(DB,font,"(HOLD N TO EDIT NPCS)",(SCREEN_W>>1)+1,16,0);
    textout_centre(DB,font,"(HOLD N TO EDIT NPCS)",(SCREEN_W>>1),15,0XFFFF);
    textout_centre(DB,font,"MOUSE LEFT: (SHIFT)CLICK TO CHANGE TILE, DRAG TO SPREAD TILES",(SCREEN_W>>1)+1,26,0);
    textout_centre(DB,font,"MOUSE LEFT: (SHIFT)CLICK TO CHANGE TILE, DRAG TO SPREAD TILES",(SCREEN_W>>1),25,0XFFFF);
    textout_centre(DB,font,"MOUSE RIGHT: (SHIFT)CLICK TO CHANGE ITEM, DRAG TO SPREAD ITEMS",(SCREEN_W>>1)+1,36,0);
    textout_centre(DB,font,"MOUSE RIGHT: (SHIFT)CLICK TO CHANGE ITEM, DRAG TO SPREAD ITEMS",(SCREEN_W>>1),35,0XFFFF);
    textout_centre(DB,font,"F5/F6: CHANGE TILESETS ; F7/F8: CHANGE ITEM VALUE ; F9/F10: CHANGE LEVEL #; F11/F12: SAVE/LOAD LEVEL",(SCREEN_W>>1)+1,SCREEN_H-10,0);
    textout_centre(DB,font,"F5/F6: CHANGE TILESETS ; F7/F8: CHANGE ITEM VALUE ; F9/F10: CHANGE LEVEL #; F11/F12: SAVE/LOAD LEVEL",(SCREEN_W>>1),SCREEN_H-11,0XFFFF);
    }
  else // NPC editing mode
    {
    textout_centre(DB,font,"(RELEASE N TO EDIT MAP)",(SCREEN_W>>1)+1,16,0);
    textout_centre(DB,font,"(RELEASE N TO EDIT MAP)",(SCREEN_W>>1),15,0XFFFF);
    textout_centre(DB,font,"MOUSE LEFT: CLICK TO CHANGE NPC, DRAG TO RELOCATE",(SCREEN_W>>1)+1,26,0);
    textout_centre(DB,font,"MOUSE LEFT: CLICK TO CHANGE NPC, DRAG TO RELOCATE",(SCREEN_W>>1),25,0XFFFF);
    textout_centre(DB,font,"MOUSE RIGHT: CLICK TO KILL NPC, DRAG TO KILL AREA",(SCREEN_W>>1)+1,36,0);
    textout_centre(DB,font,"MOUSE RIGHT: CLICK TO KILL NPC, DRAG TO KILL AREA",(SCREEN_W>>1),35,0XFFFF);
    }

  strcpy(stringTrap,"Level:");
  itoa(map.world_level,stringToCat,10);
  strcat(stringTrap,stringToCat);
  textout(DB,font,stringTrap,6,6,0);
  textout(DB,font,stringTrap,5,5,0xFFFF);

  strcpy(stringTrap,"Loc:(");
  itoa((player.x-(TILE_SIDE>>1))>>TILE_SIDE_SHIFT,stringToCat,10);
  strcat(stringTrap,stringToCat);
  strcat(stringTrap,",");
  itoa((player.y-(TILE_SIDE>>1))>>TILE_SIDE_SHIFT,stringToCat,10);
  strcat(stringTrap,stringToCat);
  strcat(stringTrap,")");
  textout(DB,font,stringTrap,6,16,0);
  textout(DB,font,stringTrap,5,15,0xFFFF);

  int wxTile=(mouse_x+map.left-32)>>TILE_SIDE_SHIFT;
  int wyTile=(mouse_y+map.top-32)>>TILE_SIDE_SHIFT;

  if(wxTile<0)wxTile=0;
  if(wxTile>=MAP_W)wxTile=MAP_W-1;
  if(wyTile<0)wyTile=0;
  if(wyTile>=MAP_H)wyTile=MAP_H-1;

  if(map.tiles[wxTile][wyTile].item!=ITEM_NONE)
    {
    switch(map.tiles[wxTile][wyTile].item)
      {
      case ITEM_CHEST:
        switch(map.tiles[wxTile][wyTile].item_var)
          {
          case CHEST_GOLD:
            strcpy(stringTrap,"IVChest: 120 Gold");
            break;
          case CHEST_KEY:
            strcpy(stringTrap,"IVChest: Magic Key");
            break;
          case CHEST_WAND:
            strcpy(stringTrap,"IVChest: Rudich Wand");
            break;
          default: // not an item type, so force it in range
            map.tiles[wxTile][wyTile].item_var=CHEST_GOLD;
            strcpy(stringTrap,"IVChest: 120 Gold"); // give it something to print so it won't crash this cycle
            break;
          }
        textout(DB,font,stringTrap,26,26,0);
        textout(DB,font,stringTrap,25,25,0xFFFF);
        break;
      case ITEM_STAIRS_DOWN:
      case ITEM_STAIRS_UP:
      case ITEM_CASTLE:
      case ITEM_TOWN:
      case ITEM_DARKPIT:
        strcpy(stringTrap,"IVTeleport to Level ");
        itoa(map.tiles[wxTile][wyTile].item_var,stringToCat,10);
        strcat(stringTrap,stringToCat);
        textout(DB,font,stringTrap,16,16,0);
        textout(DB,font,stringTrap,15,15,0xFFFF);
        break;
      default:
        break;
      }
    }
  }
