#include "globaldecsshare.h"

void fadeBMP(BITMAP *BMP)
  {
  int w,h,ws,hs,opp;
  int col1,col2;
  BITMAP *FADE;
  FADE=create_bitmap(DB->w,DB->h);
  BMP2BMP(screen,FADE)
  for(int i=1;i<15/*17*/;i++) // stop 2 frames short, so game won't pause when nearly done
    {
    opp=16-i;
    hs=i&3;
    ws=hs&1;
    hs=hs>>1;
    for(w=ws;w<BMP->w;w+=2)
      for(h=hs;h<BMP->h;h+=2)
        {
        col1=_getpixel16(BMP,w,h);
        col2=_getpixel16(DB,w,h);
        _putpixel16(FADE,w,h,makecol16((i*getr16(col1)+(opp)*getr16(col2))>>4,
                                       (i*getg16(col1)+(opp)*getg16(col2))>>4,
                                       (i*getb16(col1)+(opp)*getb16(col2))>>4));
        }
    BMP2SCREENnoMOUSEnoVSYNC(FADE)
    }
  // BMP2DB(BMP)
  destroy_bitmap(FADE);
  }

void resetGame()
  {
  char filename[30],fullname[30];
  char filenum[10];

  set_config_file("data//data.prg");

  if(get_config_int("player","newGame", 1))
    {
    map.copyNewMaps();
    human_inventory.reset();
    script.script_num=1; // hack to avoid screen from drawing prematurely
    map.loadLevelUseCoord(5);
    script.openScript(1);
    rectfill(screen,0,0,SCREEN_W,SCREEN_H,0);
    drawGameFrame(1);
    }
  else
    {
    human_inventory.wand=get_config_int("player","wd", 0);
    human_inventory.gold=get_config_int("player","gd", 0);
    human_inventory.keys=get_config_int("player","ky", 0);
    map.map_edit_mode=get_config_int("player","mem", 0);
    map.world_level=get_config_int("player","ll", 0);
    map.prev_level=get_config_int("player","pl", 0);
    player.facing=get_config_int("player","fg", 0);
    for(int i=0;i<QUEST_NUM;i++)
      {
      strcpy(fullname,"qr");
      itoa(i,filenum,10);
      strcat(fullname,filenum);
      human_inventory.qr[i]=get_config_int("player",fullname, 0);
      }
    map.loadLevelUseCoord(map.world_level);
    }
  }

void saveGame()
  {
  char filename[30],fullname[30];
  char filenum[10];

  if(script.script_num>0) return; // no saving/reloading mid-cinema!!!

  mapSave(map.world_level);

  set_config_file("data//data.prg");
  set_config_int("player","newGame", 0);
  set_config_int("player","wd", human_inventory.wand);
  set_config_int("player","gd", human_inventory.gold);
  set_config_int("player","ky", human_inventory.keys);
  /*set_config_int("player","xcoord", player.x);
  set_config_int("player","ycoord", player.y);*/
  set_config_int("player","mem", map.map_edit_mode);
  set_config_int("player","ll", map.world_level);
  set_config_int("player","pl", map.prev_level);
  set_config_int("player","fg", player.facing);
  for(int i=0;i<QUEST_NUM;i++)
    {
    strcpy(fullname,"qr");
    itoa(i,filenum,10);
    strcat(fullname,filenum);
    set_config_int("player",fullname, human_inventory.qr[i]);
    }
  }

void playGameFrame()
  {
  if(num_joysticks) poll_joystick();
  player.takeInput();

  dialog.Handle(); // process between player input and move, in case it canceled

  if(script.script_num<=0 /*dialog.isAlive()==0*/) // don't move if in conversation
    player.moveMe(1); // passing 1 for human_player, so we can walk on spikes, open doors, etc.

  if(map.map_edit_mode)
    mapEdit();

  if(script.script_num)
    script.nextEvent();

  if(!map.map_edit_mode || !key[KEY_N])
    {
    for(int i=0;i<map.active_npcs-script.scriptNPCs;i++)
      {
       // the following if statement just forces people to stand still when talked to
      if(dialog.isAlive()==0 || i!=dialog.dialog_with) npc[i].AIInput();
      npc[i].moveMe(0);
      }
    }
  }

void drawGameFrame(int fade)
  {
  if(!script.script_num)
    map.drawMe(player.x,player.y);
  else
    map.drawMe(script.camera_x,script.camera_y);

  for(int i=0;i<map.active_npcs;i++)
    npc[i].drawMe();

  if(script.script_num<=0)
    player.drawMe();

  if(dialog.isAlive())
    dialog.drawMe();

  if(map.map_edit_mode)
    mapEditDraw();
  else if(script.script_num<=0)
    human_inventory.drawMe();

  if(!fade)
    {
    if(!map.map_edit_mode)
      {BMP2SCREENnoMOUSE(DB)}
    else
      {BMP2SCREEN(DB)}
    rest(PROG_DELAY);
    }
  else
    fadeBMP(DB);
  }

void titleScreen()
  {
  PALETTE the_palette;

  destroy_midi(LEVEL_SONG);
  LEVEL_SONG=load_midi("data//king.mid");
  play_midi(LEVEL_SONG,1); // play whatever song we've loaded
  BITMAP *scrap;
  scrap=load_pcx("data//titleScreen.pcx",the_palette);
  BMP2SCREENnoMOUSE(scrap);
  while(!key[KEY_SPACE])
    {
    if(num_joysticks)
      {
      poll_joystick();
      if(joy[0].button[0].b || joy[0].button[1].b || joy[0].button[2].b || joy[0].button[3].b)
        break;
      }
    if(key[KEY_ENTER])
      {
      delete_file("data//data.prg");
      break;
      }
    if(key[KEY_ESC])
      break;
    BMP2SCREENnoMOUSE(scrap); // ensures that the program didn't miff and fail to draw before this loop
    // it's the only thing happening in this loop, so it's no trouble to do this
    rest(10);
    }
  destroy_bitmap(scrap);
  }

////////////////////////////////////////////////////////////////////
int main(int argc, char *argv[])////////////////////////////////////
  {
  int programon=1, ingame=1;

  if(StartAll()) {EndAll(); return(6);}

  InitAll(); // graphics etc.

  while(programon)
    {
    titleScreen();
    resetGame();
    if(!key[KEY_ESC]) // allow a quick break through start screen
      {
      while(ingame)
        {
        if(key[KEY_ESC])
          ingame=programon=0;

        playGameFrame();
        drawGameFrame(0);
        }
      }
    else
      programon=0;
    }
  saveGame();
  CloseAll();
  EndAll();
  }
  END_OF_MAIN();
