#include "globaldecsshare.h"

human_inventory_typ::human_inventory_typ()
  {
  reset();
  }

void human_inventory_typ::reset()
  {
  keys=0;
  gold=0;
  wand=0;
  for(int i=0;i<QUEST_NUM;i++)
    qr[i]=0;
  }

void human_inventory_typ::drawMe()
  {
  char stringTrap[30];
  char stringToCat[10];

  strcpy(stringTrap,"Keys:");
  itoa(keys,stringToCat,10);
  strcat(stringTrap,stringToCat);
  textout_right(DB,((FONT *)(dwFontData[DWF_dwFont].dat)),stringTrap,SCREEN_W-5,6,0);
  textout_right(DB,((FONT *)(dwFontData[DWF_dwFont].dat)),stringTrap,SCREEN_W-6,5,0xFFFF);

  strcpy(stringTrap,"Gold:$");
  itoa(gold,stringToCat,10);
  strcat(stringTrap,stringToCat);
  strcat(stringTrap,".00");
  textout_centre(DB,((FONT *)(dwFontData[DWF_dwFont].dat)),stringTrap,(SCREEN_W>>1),6,0);
  textout_centre(DB,((FONT *)(dwFontData[DWF_dwFont].dat)),stringTrap,(SCREEN_W>>1)-2,5,0xFFFF);

  strcpy(stringTrap,"Magic:");
  itoa(wand*50,stringToCat,10);
  strcat(stringTrap,stringToCat);
  strcat(stringTrap,"%");
  textout(DB,((FONT *)(dwFontData[DWF_dwFont].dat)),stringTrap,5,6,0);
  textout(DB,((FONT *)(dwFontData[DWF_dwFont].dat)),stringTrap,4,5,0xFFFF);
  }

player_typ::player_typ()
  {
  x=((rand()%MAP_W)<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
  y=((rand()%MAP_H)<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
  toWalk=framewait=frame=0;
  facing=DOWN;
  mySprite=0;
  for(int i=0;i<DIALOG_LINES;i++)
    strcpy(line[i],"!");
  }

player_typ::player_typ(player_typ &copybj) // copy constructor
  {
  x=copybj.x;
  y=copybj.y;
  facing=copybj.facing;
  toWalk=copybj.toWalk;
  framewait=copybj.framewait;
  frame=copybj.frame;
  mySprite=copybj.mySprite;
  }

void player_typ::lockToGrid()
  {
  x=((x>>TILE_SIDE_SHIFT)<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
  y=((y>>TILE_SIDE_SHIFT)<<TILE_SIDE_SHIFT)+(TILE_SIDE>>1);
  toWalk=0;
  }

void player_typ::drawMe()
  {
  int tx=(x)-(TILE_SIDE>>1);
  int ty=(y)-(TILE_SIDE>>1);
  tx>>=TILE_SIDE_SHIFT;
  ty>>=TILE_SIDE_SHIFT;

  if(ty<map.startH || ty>map.endH || tx<map.startW || tx>map.endW)
    return; // more often offscreen than on, and this allows allows short-circuiting
  masked_blit(SPRITE_SET[mySprite],DB,facing<<TILE_SIDE_SHIFT,frame<<TILE_SIDE_SHIFT,
       x-map.left,y-map.top,
       TILE_SIDE,TILE_SIDE);
  }

void player_typ::moveMe(int human_player)
  { // if !human_player, can't walk on spikes, through doors, open chests, etc.
  int tx,ty;

  if(framewait<=0)
    {
    framewait=WALK_FRAME_PAUSE;
    if(frame)frame=0;
    else frame=1;
    }
  else framewait--;

  if(toWalk>0)
    {
    switch(facing)
      {
      case UP:
        tx=(x)-(TILE_SIDE>>1);
        ty=(y-toWalk)-(TILE_SIDE>>1);
        break;
      case RIGHT:
        tx=(x+toWalk)-(TILE_SIDE>>1);
        ty=(y)-(TILE_SIDE>>1);
        break;
      case DOWN:
        tx=(x)-(TILE_SIDE>>1);
        ty=(y+toWalk)-(TILE_SIDE>>1);
        break;
      case LEFT:
        tx=(x-toWalk)-(TILE_SIDE>>1);
        ty=(y)-(TILE_SIDE>>1);
        break;
      }
    tx>>=TILE_SIDE_SHIFT;
    ty>>=TILE_SIDE_SHIFT;

    if(tx<0 || ty<0 || tx>=MAP_W || ty>=MAP_H ||
       ((!human_player || script.script_num>0) && map.tiles[tx][ty].behavior!=WALKABLE) // no exit for npcs or during cinema
       || map.tiles[tx][ty].behavior==IMPASSABLE)
      {
      lockToGrid(); // ensure the player doesn't start shifting off our tile sized increments
      if(human_player)
        sound.playSound(SFX_WRONG);
      }
    else if(facing==LEFT)
      x-=WALK_SPEED;
    else if(facing==UP)
      y-=WALK_SPEED;
    else if(facing==RIGHT)
      x+=WALK_SPEED;
    else if(facing==DOWN)
      y+=WALK_SPEED;

    toWalk-=WALK_SPEED;
    }
  if(human_player)
    questChecks();
  }

void player_typ::questChecks()
  {
  int tx=(x)-(TILE_SIDE>>1);
  int ty=(y)-(TILE_SIDE>>1);
  tx>>=TILE_SIDE_SHIFT;
  ty>>=TILE_SIDE_SHIFT;
  switch(map.world_level)
    {
    case 4:
      if(tx==13 && ty==13 && human_inventory.qr[QUEST_EXPOSE_BOSS]>0)
        {
        destroy_midi(LEVEL_SONG);
        LEVEL_SONG=load_midi("data//battle.mid");
        play_midi(LEVEL_SONG,1); // play whatever song we've loaded
        switch(rps.main_rps(RPS_WIZARD))
          { // battle results:
          case -1: map.loadLevelUseCoord(0); break; // just eject, don't send home
          case 1:
            dialog.Terminate(); // remove previous dialog box
            dialog.xsize=0;
            drawGameFrame(0);
            switch(rps.main_rps(RPS_DRAGON))
              {
              case -1: map.loadLevelUseCoord(1); break;
              case 1: map.loadLevelUseCoord(5); break;  // total victory!
              case 0: dialog.Terminate(); map.changeSong(); return;
              }
            break;
          case 0: dialog.Terminate(); map.changeSong(); return;
          }
        dialog.Terminate();
        map.changeSong();
        }
      break;
    case 6:
      if(tx==8 && ty==16 && !human_inventory.qr[QUEST_EXPOSE_BOSS])
        {
        human_inventory.qr[QUEST_EXPOSE_BOSS]=1;
        script.openScript(2);
        }
    }
  }

void player_typ::AIInput()
  {
  if(toWalk<=0)
    {
    switch(rand()&31)
      {
      case 0:
        facing=UP; toWalk=STEP_SIZE;
        break;
      case 1:
        facing=LEFT; toWalk=STEP_SIZE;
        break;
      case 2:
        facing=DOWN; toWalk=STEP_SIZE;
        break;
      case 3:
        facing=RIGHT; toWalk=STEP_SIZE;
        break;
      }
    }
  }

void player_typ::takeInput() // rem: this is for player only.  NPCs get AIInput()
  {
  if(num_joysticks)
    poll_joystick();
  /*if(joy[joynum].button[1].b)
	if(joy[joynum].button[3].b)*/

  if(key[KEY_F1])
    {
    while(key[KEY_F1]);
    if(map.map_edit_mode)map.map_edit_mode=0;
    else map.map_edit_mode=1;
    }

  if((key[KEY_SPACE] || (num_joysticks && joy[0].button[0].b)) && script.script_num<=0)
    {
    int speakingTo=map.whoTalkingTo();
    if(speakingTo!=-1)
      {
      sound.playSound(SFX_CAT);
      if(dialog.life>=0)
        dialog.Spawn(600,speakingTo);
      else
        dialog.Terminate();
      }
    else
      dialog.Terminate();
    }

  if(toWalk<=0 && !(key[KEY_SPACE] || (num_joysticks && joy[0].button[0].b))) // the !key[KEY_SPACE] prevents "dialog riding" high speed glitch trick
    {
    if(key[KEY_UP] || key[KEY_W] || (num_joysticks && joy[0].stick[0].axis[1].d1))
      { facing=UP; toWalk=STEP_SIZE; }
    if(key[KEY_LEFT] || key[KEY_A] || (num_joysticks && joy[0].stick[0].axis[0].d1))
      { facing=LEFT; toWalk=STEP_SIZE; }
    if(key[KEY_DOWN] || key[KEY_S] || (num_joysticks && joy[0].stick[0].axis[1].d2))
      { facing=DOWN; toWalk=STEP_SIZE; }
    if(key[KEY_RIGHT] || key[KEY_D] || (num_joysticks && joy[0].stick[0].axis[0].d2))
      { facing=RIGHT; toWalk=STEP_SIZE; }
    }
  else
    {
    int tx,ty;
    switch(facing)
      {
      case UP:
        tx=(x)-(TILE_SIDE>>1);
        ty=(y-toWalk)-(TILE_SIDE>>1);
        break;
      case RIGHT:
        tx=(x+toWalk)-(TILE_SIDE>>1);
        ty=(y)-(TILE_SIDE>>1);
        break;
      case DOWN:
        tx=(x)-(TILE_SIDE>>1);
        ty=(y+toWalk)-(TILE_SIDE>>1);
        break;
      case LEFT:
        tx=(x-toWalk)-(TILE_SIDE>>1);
        ty=(y)-(TILE_SIDE>>1);
        break;
      }
    tx>>=TILE_SIDE_SHIFT;
    ty>>=TILE_SIDE_SHIFT;
    switch(map.tiles[tx][ty].behavior) // teleport to other maps, open chests, do doors, etc.
      {
      case CLOSED_DOOR: // open it
        if(human_inventory.keys>0)
          {
          human_inventory.keys--;
          map.tiles[tx][ty].item=ITEM_NONE;
          map.tiles[tx][ty].refreshType();
          sound.playSound(SFX_DOOROPEN);
          }
        else // locked noise
          {
          toWalk=0;
          lockToGrid();
          sound.playSound(SFX_DOORLOCK);
          }
        break;
      case CLOSED_CHEST:
        sound.playSound(SFX_CHEST);
        switch(map.tiles[tx][ty].item_var)
          {
          case CHEST_GOLD:
            human_inventory.gold+=120;
            break;
          case CHEST_KEY:
            human_inventory.keys++;
            break;
          case CHEST_WAND:
            human_inventory.wand++;
            break;
          default: // empty chest?
            break;
          }
        map.tiles[tx][ty].item=ITEM_NONE;
        map.tiles[tx][ty].refreshType();
        break;
      case OPEN_TELEPORT:
        sound.playSound(SFX_STAIRS);
        mapLoad(map.tiles[tx][ty].item_var,0);
        break;
      }
    }
  }

