#include "globaldecsshare.h"

int StartAll()
  {
  int fullscreen;
  int screenW, screenH;

  allegro_init();
  install_keyboard();
  install_mouse();
  install_timer();
  srand(time(NULL)); // seed random #

  AL_CONST char *msg;
  if(install_joystick(JOY_TYPE_AUTODETECT) != 0)
    {
    // don't throw a fit just because there's no joystick plugged in
    } // just using buttons, so we'll skip the calibration B.S. and analog/digital concerns


  set_config_file("data//settings.ini");
	screenW=get_config_int("screen","width",1024);
  screenH=get_config_int("screen","height", 768);
  fullscreen=get_config_int("screen","fullscreen", 1);
  PROG_DELAY=get_config_int("game","framerest", 10);
  WINLOSS_DELAY=get_config_int("game","winlossdisplaytime", 2000);
  SAVER_DELAY=get_config_int("game","saverimagedisplaytime", 3000);
  SCREENSAVER_WAIT=get_config_int("game","screensaverwaitframes", 60);
  SCREENSAVER_WAIT*=((long)PROG_DELAY*(long)3);
  g_soundon=get_config_int("game","soundvolume", 255);
  g_midion=get_config_int("game","musicvolume", 255);

  set_color_depth(colorDepth);
  if(set_gfx_mode((fullscreen ? GFX_DIRECTX_ACCEL : GFX_DIRECTX_WIN), screenW, screenH, 0, 0) != 0)
    {
    screenW=800;screenH=600;
    if(set_gfx_mode((fullscreen ? GFX_DIRECTX_ACCEL : GFX_DIRECTX_WIN), screenW, screenH, 0, 0) != 0)
      {
      screenW=640;screenH=480;
      if(set_gfx_mode(GFX_AUTODETECT, screenW,screenH, 0, 0) != 0)
        {
        if(set_gfx_mode(GFX_DIRECTX_WIN, screenW,screenH, 0, 0) != 0) // didn't fit in any screen doable res, so window
          {
          allegro_message("Error setting graphics mode\n%s\n", allegro_error);
          return 1;
          }
        }
      }
    }

  TRANSPARENCY_COLOR=makecol(255,0,255);
  RED_COLOR=makecol(255,0,0);

  if(!fullscreen)
    {
    set_window_title("GCS DWarrior");
    set_display_switch_mode(SWITCH_BACKGROUND);
    }

  if(install_sound(DIGI_DIRECTX(1),MIDI_AUTODETECT,"data//bump.wav")!=0)
    {
    g_soundon=0;
    g_midion=0;
    }
  set_volume(-1, g_midion); // g_soundon is handled inside the SoundMe Macro

  text_mode(-1); // transparent Allegro text
  return(0);
  }

int InitAll()
  {
  PALETTE the_palette;
  BITMAP *scrap;
  DB = create_bitmap(SCREEN_W,SCREEN_H); // full scene DB

  char filename[25];
  char filenum[10];
  for(tileset_num=0;tileset_num<MAX_SETS;tileset_num++)
    {
    strcpy(filename,"data//tileset");
    itoa(tileset_num+1,filenum,10);
    strcat(filename,filenum);
    strcat(filename,".pcx");
    scrap = load_pcx(filename,the_palette);
    if(scrap==NULL)
      break;

    for(int i=0;i<TILE_TYPES;i++)
      {
      TILE_SET[tileset_num][i] = create_bitmap(TILE_SIDE,TILE_SIDE);
      blit(scrap,TILE_SET[tileset_num][i],i<<TILE_SIDE_SHIFT,0,0,0,TILE_SIDE,TILE_SIDE);
      }
    destroy_bitmap(scrap);
    }

  scrap = load_pcx("data//items.pcx",the_palette);
  for(int i=0;i<ITEM_TYPES;i++)
    {
    ITEM_SET[i] = create_bitmap(TILE_SIDE,TILE_SIDE);
    blit(scrap,ITEM_SET[i],i<<TILE_SIDE_SHIFT,0,0,0,TILE_SIDE,TILE_SIDE);
    }
  destroy_bitmap(scrap);

  for(sprites_num=0;sprites_num<MAX_SPRITES;sprites_num++)
    {
    strcpy(filename,"data//sprite");
    itoa(sprites_num+1,filenum,10);
    strcat(filename,filenum);
    strcat(filename,".pcx");
    SPRITE_SET[sprites_num] = load_pcx(filename,the_palette);
    if(SPRITE_SET[sprites_num]==NULL)
      break;
    }
  cursor.initialize();

  LEVEL_SONG = load_midi("data//overworld.mid");
  sound.loadSounds();

  play_midi(LEVEL_SONG,1); // play whatever song we've loaded

  dwFontData = load_datafile("data//dwFont.dat");

  return(0);
  }

int CloseAll()
  {
  destroy_bitmap(DB); // free all image memory
  cursor.destroyCursorBitmap();
  sound.destroySounds();
  for(int i=0;i<tileset_num;i++)
    {
    for(int ii=0;ii<TILE_TYPES;ii++)
      destroy_bitmap(TILE_SET[i][ii]);
    }
  for(int i=0;i<sprites_num;i++)
    destroy_bitmap(SPRITE_SET[i]);

  destroy_midi(LEVEL_SONG);
  unload_datafile(dwFontData);
  return(0);
  }

int EndAll()
  {
  remove_timer();
  remove_keyboard();
  remove_mouse();
  allegro_exit();
  return(0);
  }
