#include "allegro.h"
#include "winalleg.h"
#include "dwFont.h"

#define SoundMe(pSFXsample) play_sample(pSFXsample, g_soundon, 128, 1000, FALSE);
#define colorDepth 16
#define FAST_PIXEL(BITMAP,X,Y,COLOR) if(X>=0 && Y>=0 && X<BITMAP->w && Y<BITMAP->h) _putpixel16(BITMAP,X,Y,COLOR)
#define col16(r,g,b) ( ((r)<<11)|((g)<<6)| (b) )
#define col16getR(c) ( ((c)>>11) )
#define col16getG(c) ( ((c)>>6)&31 )
#define col16getB(c) ( ((c)&31) )
#define gray16(s) col16(s,s,s)
#define BMP2DB(BMP) {blit(BMP,DB,0,0,0,0,SCREEN_W,SCREEN_H);}
#define BMP2BMP(BMP1,BMP2) {blit(BMP1,BMP2,0,0,0,0,SCREEN_W,SCREEN_H);}
#define BMP2SCREEN(BMP) {vsync(); show_mouse(DB); blit(BMP,screen,0,0,0,0,SCREEN_W,SCREEN_H); show_mouse(NULL);}
#define BMP2SCREENnoMOUSE(BMP) {vsync(); blit(BMP,screen,0,0,0,0,SCREEN_W,SCREEN_H);}
#define BMP2SCREENnoMOUSEnoVSYNC(BMP) {blit(BMP,screen,0,0,0,0,SCREEN_W,SCREEN_H);}
#define BMP2DB(BMP) {blit(BMP,DB,0,0,0,0,SCREEN_W,SCREEN_H);}
#define INPUT_1 (key[KEY_Q] | (num_joysticks ? !poll_joystick() & joy[0].button[0].b : 0))
#define INPUT_2 (key[KEY_W] | (num_joysticks ? !poll_joystick() & joy[0].button[1].b : 0))
#define INPUT_3 (key[KEY_A] | (num_joysticks ? !poll_joystick() & joy[0].button[2].b : 0))
#define INPUT_4 (key[KEY_S] | (num_joysticks ? !poll_joystick() & joy[0].button[3].b : 0))
#define TILE_SIDE 64
#define TILE_SIDE_SHIFT 6 // 2^TILE_SIDE_SHIFT = TILE_SIDE
#define MAX_SPRITES 30 // using straightforward arrays to avoid overhead and minimize possibilities for memory leaks
#define MAX_NPCS 35
#define MAX_SETS 10
#define MAX_SCRIPT_LENGTH 25
#define MAP_W 30 // # of tiles
#define MAP_H 30 // # of tiles

#define STEP_SIZE TILE_SIDE

#define LMB (mouse_b & 1)
#define RMB (mouse_b & 2)

#define WALK_SPEED 2 // should evenly divide 64
#define WALK_FRAME_PAUSE 15 // controls how rapidly frames switch back and forth

#define DIALOG_LETTERS 40
#define LETTER_HEIGHT 38
#define LETTER_WIDTH 36
#define DIALOG_LINES 5
#define DIALOG_NPC 0
#define DIALOG_BOSS 1
#define TALK_TO_RPS -1

enum {UP,RIGHT,DOWN,LEFT,DIR_NUM}; // for "facing" variable in player_typ
enum {IMPASSABLE,WALKABLE,CLOSED_DOOR,CLOSED_CHEST,OPEN_TELEPORT,HURTS,TILE_BEHAVIOR_NUM}; // tile "behaviors" for player_typ interactions
enum {ITEM_DOOR,ITEM_CHEST,ITEM_STAIRS_DOWN,ITEM_STAIRS_UP,ITEM_CASTLE,ITEM_TOWN,ITEM_DARKPIT,ITEM_NUM,ITEM_NONE}; // item enumerations; in tile_typ
enum {TILE_BG,TILE_WALK1,TILE_WALK2,TILE_WALK3,TILE_BLOCK1,TILE_BLOCK2,TILE_BLOCK3,TILE_HURTS,TILE_NUM}; // item enumerations; in tile_typ
enum {CHEST_GOLD,CHEST_KEY,CHEST_WAND,CHEST_NUM}; // chest type enumerations; in tile_typ, as IVar when item==CHEST
enum {THROW_ROCK,THROW_PAPER,THROW_SCISSORS,THROW_NUM};
#define RPS_WIZARD 1
#define RPS_DRAGON 0
enum {SE_MOVE_TALK_OR_RETILE,SE_REITEM,SE_LOADLEVEL}; // Script Entity

enum {QUEST_EXPOSE_BOSS,QUEST_NUM};

enum {SFX_BUMP, SFX_CAT, SFX_CHEST, SFX_CRITICALHIT, SFX_CURE1, SFX_CURE2, SFX_DOOR, SFX_DOORLOCK, SFX_DOOROPEN,
SFX_EARTH, SFX_EARTH2, SFX_FALL, SFX_FIRE1, SFX_FIRE2, SFX_HIT, SFX_LAUGH, SFX_LEVELUP, SFX_OUCH, SFX_STAIRS,
SFX_STRIKE, SFX_WATER, SFX_WINBATTLE, SFX_WRONG, SFX_NUM};

#define TILE_TYPES TILE_NUM // number of tile icons to be read for tiles
#define ITEM_TYPES ITEM_NUM // number of item icons to be read for items overlapping on tiles

/*#define SHOW_SPRITE(type,facing,frame,x,y)                                     \
              masked_blit(SPRITE_SET[type],DB,facing<<TILE_SIDE_SHIFT,         \
              frame<<TILE_SIDE_SHIFT, x,y, TILE_SIDE,TILE_SIDE);

#define SHOW_TILE(type,piece,x,y)                                              \
              blit(TILE_SET[tile_set],DB,piece<<TILE_SIDE_SHIFT,0,x,y,         \
              TILE_SIDE,TILE_SIDE);*/

class human_inventory_typ // see player.cpp
  {
  public:
  int keys;
  int gold;
  int wand;
  int qr[QUEST_NUM];
  human_inventory_typ();
  void reset();
  void drawMe();
  };

class player_typ // see player.cpp
  {
  public:
  int x,y,facing,toWalk,framewait,frame,mySprite;
  char line[DIALOG_LINES][DIALOG_LETTERS];
  player_typ();
  player_typ(player_typ &copybj); // copy constructor
  void lockToGrid();
  void drawMe();
  void moveMe(int human_player);
  void questChecks();
  void AIInput();
  void takeInput();
  };

struct script_event_typ // defined in map.cpp, since that's where it's primarily used
  {
  int target;
  int xTile,yTile;
  int type_flag;
  int cycles;
  script_event_typ();
  };

struct script_typ // defined in map.cpp, since that's where it's primarily used
  {
  public:
  int camera_y,camera_x; // real, current, used
  int camCenterX,camCenterY; // goal, target, to center on
  int scriptNPCs;

  script_event_typ se[MAX_SCRIPT_LENGTH];
  int script_num;
  script_typ();
  void nextEvent();
  void openScript(int scriptNum);
  };

class rps_typ
  {
  public:
  BITMAP *BOSSDRAGON;
  int playerScore,bossScore;
  char line[DIALOG_LINES][DIALOG_LETTERS];
  int lines_to_update;
  int mode; // wizard or dragon?
  SAMPLE *battle_wav;
  rps_typ();
  void rps_close();
  int play_rps();
  void draw_rps();
  void buildScreen();
  int main_rps(int mode);
  };

class sound_typ
  {
  public:
  void loadSounds();
  void destroySounds();
  void playSound(int sound);
  };

struct tile_typ // defined in map.cpp, since that's where it's primarily used
  {
  int graphic;
  int behavior;
  int item;
  int item_var;
  tile_typ();
  void refreshType();
  void updateType(int newGraphic);
  };

class map_typ // map.cpp, of course
  {
  public:
  int world_level;
  int prev_level;
  int map_edit_mode;
  int tile_set;
  int active_npcs;
  int left,top;
  int startW,endW,startH,endH;
  tile_typ tiles[MAP_W][MAP_H];
  map_typ();
  void copyNewMaps();
  void loadLevelUseCoord(int level);
  void changeSong();
  void drawMe(int cornerX,int cornerY);
  void generateMess();
  int whoTalkingTo();
  };

int mapLoad(int lev_num, int from_new); // in map.cpp
void mapSave(int lev_num); // in map.cpp
void mapEdit();            // in map.cpp
void mapEditDraw();        // in map.cpp

class cursor_typ  // mouse code, primarily for level editing.  In cursor.cpp
  {
  public:
  BITMAP *CURSOR;
  cursor_typ();
  void initialize();
  void destroyCursorBitmap();
  };

class dialog_typ
  {
  private:
  int lines,letters;
  int chartimer, charwait;
  int xsize_target, ysize_target;
  int buffer_skip;
  public:
  int life;
  int xsize, ysize;
  int scrolloffset;
  char line[DIALOG_LINES][DIALOG_LETTERS]; // for boss
  char bossopening1[DIALOG_LINES][DIALOG_LETTERS]; // for boss1
  char bossopening2[DIALOG_LINES][DIALOG_LETTERS]; // for boss2
  int dialog_with; // npc's index number

  void Spawn(int newLife, int withWho);
  void Reset();
  void Terminate();
  int isAlive(); // still drawn (even if just waiting or shrinking)
  int isEmpty(); // no longer needs text updating
  void Handle();
  void drawMe();
  void import_boss_dialog();
  dialog_typ();
  };

int StartAll(); // init.cpp
int InitAll();  // init.cpp
int CloseAll(); // init.cpp
int EndAll();   // init.cpp

void fadeBMP(BITMAP *BMP);
void resetGame();     // gcsdwarriorxp.cpp
void playGameFrame(); // gcsdwarriorxp.cpp
void drawGameFrame(int fade); // gcsdwarriorxp.cpp

