#include "allegro.h"
#include "winalleg.h"

#define FAST_PIXEL(BITMAP,X,Y,COLOR) _putpixel16(BITMAP,X,Y,COLOR)
#define SLOW_PIXEL(BITMAP,X,Y,COLOR) putpixel(BITMAP,X,Y,COLOR)

#define col16(r,g,b) ((r<<11)|(g<<6)|b)

#define DB2SCREEN blit(DB,screen,0,0,0,0,screenW,screenH);

#define LMB (mouse_b & 1)
#define RMB (mouse_b & 2)
#define MMB (mouse_b & 4)

#define JACK_MAX 10
#define JACK_PLACEMENT_MARGIN 20 // jacks can't get within this # of units from the edges
#define MIN_JACK_DIST (JACK_RADIUS<<1) // don't let them overlap
#define JACK_RADIUS 20 // how close can the hand center get to grab it?

#define BALL_RADIUS 30 // how close the ball gets to ground before bouncing, & hand before being caught
#define BALL_BOUNCE_CONSTANT 0.75
#define BALL_BOUNCE_CONSTANT_X_WHEN_VERT_BOUNCE 0.95 // X decay on Y bounce, so it will roll to a stop
#define BALL_THROW_DAMPEN 0.8

#define HAND_WIDTH 60
#define HAND_WIDTH_HALF 30
#define HAND_HEIGHT 40
#define HAND_HEIGHT_HALF 20

// these same defines are used, whenever possible, for the PassTarget for consistency

#define HOOP_X (JACK_PLACEMENT_MARGIN+HOOP_RADIUS)
#define HOOP_Y (JACK_PLACEMENT_MARGIN<<3)+(JACK_PLACEMENT_MARGIN<<2)
#define HOOP_RADIUS BALL_RADIUS
#define HOOP_HEIGHT 8
#define HOOP_BACKBOARD_DRAW_WIDTH 5
#define HOOP_BACKBOARD_DRAW_HEIGHT 100
#define HOOP_NET_LENGTH 40
#define HOOP_NET_PULLIN 8 // horizontal "tuck" when loose
#define HOOP_SWOOSH_STRETCH 18 // amount to tuck net after shot is made
#define HOOP_RANGE_X (JACK_PLACEMENT_MARGIN<<4)

// PassTarget is just a basketball hoop tilted at 90 degrees that tracks up and down.  It's a throwing target.

#define PASSTARGET_X (SCREEN_W-BALL_RADIUS-HOOP_HEIGHT)
#define PASSTARGET_Y (SCREEN_H>>1) // starting position; oscillated

#define GRAVITY_CONSTANT 0.5
#define STOP_MIN_V 0.5 // if it decays below this speed, it will stop
#define CUMULATIVE_MICKEY_DECAY 0.87
#define MAX_CUMULATIVE_MICKEY 27.0

