#include "jacks.h"

int colorDepth=16;
int screenW=1024;
int screenH=768;
int CX=screenW>>1;
int CY=screenH>>1;
int PROG_REST=15; // defaults; replaced by values in settings.ini if it's present

int COLOR_WHITE;

BITMAP *DB; // DoubleBuffer.  Avoid object's flashing while being redrawn

void RecalcColors()
  {
  COLOR_WHITE=makecol(255,255,255);
  }

void ScreenShot() // an example of a general purpose screenshot function
  {
  PALETTE pal;
  get_palette(pal);
  save_pcx("screenshot.pcx", DB, pal); // save DoubleBuffer to file
  }

int InitAll()
  {
  int fullscreen=1;
  
  allegro_init();
  install_keyboard();
  install_mouse();
  install_timer();
  srand(time(NULL)); // seed random #

  set_config_file("settings.ini");
	screenW=get_config_int("screen","width",1024);
  screenH=get_config_int("screen","height", 768);
  fullscreen=get_config_int("screen","fullscreen", 1);
  colorDepth=get_config_int("screen","colordepth", 16);
  PROG_REST=get_config_int("game","framerest", 15);

  // if the settings.ini file is missing, these following lines will create it:
  set_config_int("screen","width", screenW);
  set_config_int("screen","height", screenH);
  set_config_int("screen","fullscreen", fullscreen);
  set_config_int("screen","colordepth", colorDepth);
  set_config_int("game","framerest", PROG_REST);

  set_color_depth(colorDepth);
  if(set_gfx_mode((fullscreen ? GFX_DIRECTX_ACCEL : GFX_DIRECTX_WIN), screenW, screenH, 0, 0) != 0)
    {
    screenW=800;screenH=600;
    if(set_gfx_mode((fullscreen ? GFX_DIRECTX_ACCEL : GFX_DIRECTX_WIN), screenW, screenH, 0, 0) != 0)
      {
      screenW=640;screenH=480;
      if(set_gfx_mode((fullscreen ? GFX_DIRECTX_ACCEL : GFX_DIRECTX_WIN), screenW, screenH, 0, 0) != 0)
        {
        if(set_gfx_mode(GFX_AUTODETECT, screenW,screenH, 0, 0) != 0) // safe mode
          {
          allegro_message("Error setting graphics mode\n%s\n", allegro_error);
          return 1;
          }
        }
      }
    }
  RecalcColors(); // will define white properly for the colorDepth of choice
  CX=SCREEN_W>>1; // Center
  CY=SCREEN_H>>1; // Center

  if(!fullscreen) set_display_switch_mode(SWITCH_BACKGROUND);
  if(!fullscreen) // if it's windowed, title it properly
    {
    set_window_title("Mouse Playhouse");
    set_display_switch_mode(SWITCH_BACKGROUND); // play nicely with windows
    }

  text_mode(-1); // transparent Allegro text

  DB = create_bitmap(screenW, screenH); // DoubleBuffer the size of the screen
  clear(DB);
  return(0);
  }

int CloseAll()
  {
  destroy_bitmap(DB); // free all image memory
  remove_timer(); // shutdown modules and allegro
  remove_keyboard();
  remove_mouse();
  allegro_exit();
  return(0);
  }

int MenuScreens()
  {
  int inmenu=1;
  int text_y;

  while(inmenu)
    {
    // Draw Menu screens:
    clear(DB); // render background instead
    rect(DB,25,25,screenW-25,screenH-25,COLOR_WHITE);
    text_y=20;
    textout_centre(DB, font, "Mouse Playhouse v0.4",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);
    textout_centre(DB, font, "By Chris DeLeon",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);
    text_y+=20;
    textout_centre(DB, font, "No blood baths, car theft, crazy graphics, or humiliating your friends.",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);
    textout_centre(DB, font, "Mouse Playhouse is a chance to practice skills besides jumping and shooting.",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);
    textout_centre(DB, font, "Featuring MouseJacks, MouseHoops, and MouseTouchDownPass.",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);
    textout_centre(DB, font, "This is a one day project to demonstrate basic gameplay prototyping.",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);
    textout_centre(DB, font, "The simplified 2-D game physics employed here are very common in action games.",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);
    text_y+=20;
    textout_centre(DB, font, "Use your mouse to control the robotic arm.",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);
    textout_centre(DB, font, "Robotic hand is OPEN when the LEFT MOUSE BUTTON is held.",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);
    textout_centre(DB, font, "Press P to toggle pause, and F11 to take a screenshot.",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);
    textout_centre(DB, font, "Press R to reset all scores.",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);
    text_y+=20;
    textout_centre(DB, font, "PRESS SPACEBAR TO BEGIN!!!",
                    SCREEN_W>>1, text_y+=20, COLOR_WHITE);

    DB2SCREEN

    if(key[KEY_ESC])
      {
      return(0);
      }
    if(key[KEY_SPACE])
      {
      while(key[KEY_SPACE]) ;
      inmenu=0;
      }

    rest(PROG_REST);
    }
  return(1);
  }

