/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _VIDEO_H_
#define _VIDEO_H_


#include <allegro.h>

#include "ftext.h"
#include "menu.h"
#include "tbaddie.h"
#include "tentity.h"
#include "tfeature.h"
#include "tmap.h"
#include "tplayer.h"
#include "tprojctl.h"


#define SCREENSHOT_KEY      KEY_F9


void animate_baddie(Baddie *const baddie, Map *const map);


void animate_feature(Feature *const feature, Map *const map);


void animate_goodie(Goodie *const goodie);


void animate_map(Map *const map);


void animate_player(Player *const player);


void animate_projectile(Projectile *const projectile);


void animate_tile(Tile *const tile);


/**
 * Attempts to set the graphics mode to the primary mode specified in the
 * manager.  Failing that, attempts to set the mode to the secondary mode
 * specified in the manager.  Failing that, attempts to set the mode to a
 * known safe mode (GFX_SAFE).  Failing that, returns a positive number.
 * Returns 0 on successful switch to any mode.
 */
unsigned char attempt_gfx_mode(void);


void clear_offscreen(int color);


void do_box_in(const unsigned short iteration);


void draw_baddie(const Baddie *const baddie);


void draw_feature(const Feature *const feature);


void draw_floating_text(const Floating_text *const ftext);


void draw_goodie(const Goodie *const goodie);


void draw_map(const Map *const map);


void draw_menu(const Menu *const menu, const unsigned char draw_border);


void draw_outlined_text(BITMAP *bmp, const FONT *f, const char *s, int x, int y,
                        int outline_color, int fill_color);


void draw_player(const Player *const player);


void draw_projectile(const Projectile *const projectile);


void draw_status_bar(const Map *const map);


void draw_text(int x, int y, int color, unsigned char center, const char *str);


void draw_tile(const Tile *const tile);


void draw_to_screen(const unsigned char draw_mouse);

//void draw_to_screen_me(const unsigned char draw_mouse, DIALOG *d1, DIALOG *d2);

unsigned char init_video(const unsigned short offscreen_w,
                         const unsigned short offscreen_h);


void show_game_over(const unsigned int player_score);


void show_help1(void);


void show_help2(void);


void show_help3(void);


void show_help4(void);


void show_won1(void);


void show_won2(const unsigned int player_score);


void take_screenshot(void);


void uninit_video(void);


#endif
