/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h> // remove this when all anim methods have been updated

#include "baddie.h"
#include "common.h"
//#include "config.h"
#include "feature.h"
#include "goodie.h"
#include "list.h"
#include "log.h"
#include "manager.h"
#include "player.h"
#include "projctl.h"
#include "spritdat.h"
#include "manager.h"
#include "video.h"




/* screenshots are saved to files beginning with this string */
#define SCREENSHOT_BASE         "screens/kickle_"

/* screenshots are saved to files with this extension -- valid extensions are
   "bmp", "tga", and "pcx" */
#define SCREENSHOT_EXT          "bmp"


#define SPRITE_DAT_FILENAME     "sprites7.dat"

/* EXTERNAL GLOBALS */


extern Manager manager;


/* VIDEO GLOBALS */


BITMAP *offscreen;


FONT *font_ingame;
static FONT *font_menu;

static PALETTE *kickle_pal;


/* METHOD DEFINITIONS */


#if 0
void animate_baddie(type_baddie *const baddie)
{

    //printf("animate_player enter\n");

    DATAFILE *baddie_type_datafile;
    DATAFILE *status_datafile;
    DATAFILE *heading_x_datafile;
    DATAFILE *heading_y_datafile;
    DATAFILE *bitmaps_datafile;

    unsigned char num_frames;
    const char *num_ticks_per_frame_str;
    unsigned short num_ticks_per_frame;
    unsigned char anim_frame_offset= 0;

    /* the size of this array should be large enough to hold all the digits
       (base 10) of the largest number representable by the type of
       type_entity.anim_status or type_baddie.type, which ever type is
       larger */
    char str_from_num[4];

    int name_prop= DAT_ID('N', 'A', 'M', 'E');
    int num_frames_prop= DAT_ID('N', 'F', 'R', 'A');
    int num_ticks_per_frame_prop= DAT_ID('N', 'T', 'I', 'C');

    /* get the datafile which contains the baddie types */
    sprintf(str_from_num, "%i", baddie->type);

    baddie_type_datafile=
        find_datafile_object((DATAFILE *)
                             manager.sprite_datafile[SPRITE_DATA_BADDIE].dat,
                             str_from_num);

    /* get the datafile which contains the baddie's statuses */
    sprintf(str_from_num, "%i", baddie->entity->status);

    status_datafile=
        find_datafile_object((DATAFILE *) baddie_type_datafile->dat,
                             str_from_num);

    if (status_datafile == 0) return;

    //printf("found anim_status_datafile\n");

    //printf("anim_status_datafile name == %s\n",
    //  get_datafile_property(anim_status_datafile, name_prop));

    /* get the datafile which holds the baddie's heading x */
    heading_x_datafile= (DATAFILE *) status_datafile->dat;

    /* if heading x is not a don't-care, find appropriate heading x datafile */
    if (get_datafile_property(heading_x_datafile, name_prop)[0] != 'd')
    {
        if (baddie->entity->heading_x == 0)
            heading_x_datafile= find_datafile_object(heading_x_datafile, "==");
        else
            heading_x_datafile= find_datafile_object(heading_x_datafile, "!=");
    }

    //printf("found heading_x_datafile\n");

    //printf("heading_x_datafile name == %s\n",
    //  get_datafile_property(heading_x_datafile, name_prop));

    /* get the datafile which holds the baddie's heading y */
    heading_y_datafile= (DATAFILE *) heading_x_datafile->dat;

    /* if heading y is not a don't-care, find appropriate heading y datafile */
    if (get_datafile_property(heading_y_datafile, name_prop)[0] != 'd')
    {
        if (baddie->entity->heading_y > 0)
            heading_y_datafile= find_datafile_object(heading_y_datafile, "+");
        else
            heading_y_datafile= find_datafile_object(heading_y_datafile, "-");
    }

    //printf("found heading_y_datafile\n");

    //printf("heading_y_datafile name == %s\n",
    //  get_datafile_property(heading_y_datafile, name_prop));

    //printf("count == %s\n",
    //  get_datafile_property(heading_y_datafile, count_prop));

    /* get the number of ticks per frame of animation, as a string */
    num_ticks_per_frame_str=
        get_datafile_property(heading_y_datafile, num_ticks_per_frame_prop);

    /* if the number of ticks is not a don't-care */
    if (num_ticks_per_frame_str[0] != 'd')
    {

        /* get the number of ticks per frame of the animation */
        num_ticks_per_frame= (unsigned short) atoi(num_ticks_per_frame_str);

        /* determine the offset of the current frame of animation among all the
           frames of animation */
        anim_frame_offset=
            baddie->entity->anim_counter / num_ticks_per_frame;

        /* get the number of frames of the animation */
        num_frames=
            (unsigned char)
            atoi(get_datafile_property(heading_y_datafile, num_frames_prop));

        //printf("found num_bitmaps == %i\n", num_bitmaps);

        /* it's possible that the baddie's animation counter gets ahead of the
           value num_ticks_per_frame * num_frames if the animation counter is
           not reset before a different bitmap leaf is traversed to from the one
           which was traversed to in the previous animation tick, and the
           different bitmap leaf has either a different number of ticks per
           frame or a different number of frames, or both, from the previous
           leaf -- this may occur if the animation, such as a walking animation,
           can be interrupted by a different animation */
        if (anim_frame_offset >= num_frames)
        {
            anim_frame_offset= 0;
            baddie->entity->anim_counter= 0;
        }

        //printf("baddie anim_status == %i\n", baddie->entity->anim_status);
        //printf("baddie anim_counter == %i\n", baddie->entity->anim_counter);
        //printf("baddie num_frames == %i\n", num_frames);
        //printf("baddie num ticks == %i\n", num_ticks_per_frame);
        //printf("baddie anim_frame_offset == %i\n", anim_frame_offset);

        ++baddie->entity->anim_counter;

        /* if the baddie's animation counter is ahead of the value
           num_ticks_per_frame * num_frames here, then the animation has
           completed naturally (i.e., the only instance when the animation is
           interrupted occurs when the animation completes, and here it has) */
        if (baddie->entity->anim_counter >= num_ticks_per_frame * num_frames)
        {
            baddie->entity->anim_counter= 0;
            baddie_anim_done(baddie);
        }

    } /* end if number of ticks is not a don't-care */

    /* else, if the number of ticks is a don't-care, zero the frame offset
       AND the baddie's animation counter */
    else
    {
        anim_frame_offset= 0;
        baddie->entity->anim_counter= 0;
    }

    /* get the datafile which holds the bitmaps of the animation */
    bitmaps_datafile= (DATAFILE *) heading_y_datafile->dat;

    //printf("found bitmaps_datafile\n");

    //printf("object at bitmap location: name == %s\n",
    //  get_datafile_property(&bitmaps_datafile[anim_counter % num_bitmaps],
    //      name_prop));

    baddie->entity->anim_frame=
        (BITMAP *) bitmaps_datafile[anim_frame_offset].dat;

    /* set the baddie's size! */
    baddie->entity->p_width= baddie->entity->anim_frame->w;
    baddie->entity->p_height= baddie->entity->anim_frame->h;

    //printf("player anim counter == %i\n", player->entity->anim_counter);


    //printf("animate_player exit\n");

} /* end animate_baddie */
#endif



void animate_baddie(Baddie *const baddie, Map *const map)
{

    //printf("baddie status = %i %s\n", baddie->entity->status, __FUNCTION__);

    DATAFILE *baddie_type_datafile;
    DATAFILE *status_datafile;
    DATAFILE *heading_x_datafile;
    DATAFILE *heading_y_datafile;
    DATAFILE *bitmaps_datafile;

    unsigned char num_frames;
    unsigned short num_ticks_per_frame;
    unsigned short num_plays;

    const char *prop_str;

    char str_from_num[4];

    int name_prop;
    int num_frames_prop;
    int num_ticks_per_frame_prop;
    int num_plays_prop;

    if (baddie->status == BADDIE_S_KAPUT) return;

    name_prop= DAT_ID('N', 'A', 'M', 'E');
    num_frames_prop= DAT_ID('N', 'F', 'R', 'A');
    num_ticks_per_frame_prop= DAT_ID('N', 'T', 'I', 'C');
    num_plays_prop= DAT_ID('N', 'P', 'L', 'A');

    /* get the datafile which contains the baddie types */
    sprintf(str_from_num, "%i", baddie->type);

    baddie_type_datafile=
        find_datafile_object((DATAFILE *)
                             manager.sprite_datafile[SPRITE_DATA_BADDIE].dat,
                             str_from_num);

    /* get the datafile which contains the baddie's statuses */
    sprintf(str_from_num, "%i", baddie->status);

    status_datafile=
        find_datafile_object((DATAFILE *) baddie_type_datafile->dat,
                             str_from_num);

    /* get the datafile which holds the baddie's heading x */
    heading_x_datafile= (DATAFILE *) status_datafile->dat;

    /* if heading x is not a don't-care, find appropriate heading x datafile */
    if (get_datafile_property(heading_x_datafile, name_prop)[0] != 'd')
    {
        if (baddie->entity->heading_x == 0)
            heading_x_datafile= find_datafile_object(heading_x_datafile, "=");
        else
            heading_x_datafile= find_datafile_object(heading_x_datafile, "!");
    }

    /* get the datafile which holds the baddie's heading y */
    heading_y_datafile= (DATAFILE *) heading_x_datafile->dat;

    /* if heading y is not a don't-care, find appropriate heading y datafile */
    if (get_datafile_property(heading_y_datafile, name_prop)[0] != 'd')
    {
        if (baddie->entity->heading_y > 0)
            heading_y_datafile= find_datafile_object(heading_y_datafile, "+");
        else
            heading_y_datafile= find_datafile_object(heading_y_datafile, "-");
    }

    /* get the datafile which holds the bitmaps of the animation */
    bitmaps_datafile= (DATAFILE *) heading_y_datafile->dat;

    /* set the animation frame */
    baddie->entity->anim_frame=
        (BITMAP *) bitmaps_datafile[baddie->entity->anim_frame_counter].dat;

    /* set the baddie's size! */
    baddie->entity->p_width= baddie->entity->anim_frame->w;
    baddie->entity->p_height= baddie->entity->anim_frame->h;

    /* get the number of ticks per frame from the bitmap leaf */
    prop_str=
        get_datafile_property(
            &bitmaps_datafile[baddie->entity->anim_frame_counter],
            num_ticks_per_frame_prop);

    //printf("prop_str = %s %s\n", prop_str, __FUNCTION__);

    /* proceed only if the number of ticks is not infinite */
    if (prop_str[0] == 'i') return;

    num_ticks_per_frame= (unsigned short) atoi(prop_str);

    /* if the number of ticks property doesn't exist in the bitmap leaf, get it
       from the heading y node */
    if (num_ticks_per_frame == 0)
    {
        num_ticks_per_frame=
            (unsigned short)
            atoi(get_datafile_property(heading_y_datafile,
                                       num_ticks_per_frame_prop));
    }

    //printf("num_ticks_per_frame %i %s\n", num_ticks_per_frame, __FUNCTION__);

    /* if the number of ticks property exists */
    if (num_ticks_per_frame > 0)
    {

        ++baddie->entity->anim_counter;

        //printf("anim_counter %i %s\n", baddie->entity->anim_counter, __FUNCTION__);

        //printf("num_ticks_per_frame %i %s\n", num_ticks_per_frame, __FUNCTION__);

        //printf("anim_frame_counter %i %s\n", baddie->entity->anim_frame_counter, __FUNCTION__);

        /* if we've finished the frame */
        if (baddie->entity->anim_counter >= num_ticks_per_frame)
        {

            ++baddie->entity->anim_frame_counter;
            baddie->entity->anim_counter= 0;

            prop_str=
                get_datafile_property(heading_y_datafile, num_frames_prop);

            /* proceed only if the number of frames property exists */
            if (prop_str[0] != '\0')
            {

                num_frames= (unsigned char) atoi(prop_str);

                /* if we've finished the animation once */
                if (baddie->entity->anim_frame_counter >= num_frames)
                {

                    baddie->entity->anim_frame_counter= 0;

                    prop_str=
                        get_datafile_property(heading_y_datafile,
                                              num_plays_prop);

                    /* if the animation completes */
                    if (prop_str[0] != 'i')
                    {

                        //printf("anim_play_counter %i %s\n",
                        //  player->entity->anim_play_counter, __FUNCTION__);

                        ++baddie->entity->anim_play_counter;

                        num_plays= (unsigned short) atoi(prop_str);

                        //printf("num_plays %i %s\n", num_plays, __FUNCTION__);

                        /* if we've finished playing the animation all the
                           times, complete it */
                        if (baddie->entity->anim_play_counter >= num_plays)
                        {
                            baddie_anim_done(baddie, map);
                            baddie->entity->anim_play_counter= 0;
                        }

                    }

                } /* end if we've finished the animation once */

            } /* end if the number of frames property exists */

        } /* end if we've finished the frame */

    } /* end if the number of ticks property exists */

} /* end animate_baddie */



#if 0
void animate_feature(type_feature *const feature)
{

    DATAFILE *type_datafile;
    DATAFILE *status_datafile;
    DATAFILE *heading_x_datafile;
    DATAFILE *heading_y_datafile;
    DATAFILE *bitmaps_datafile;

    unsigned char num_frames;
    const char *num_ticks_per_frame_str;
    unsigned short num_ticks_per_frame;
    unsigned char anim_frame_offset= 0;

    /* the size of this array should be large enough to hold all the digits
       (base 10) of the largest number representable by the type of
       type_entity.anim_status or type_feature.type, which ever type is
       larger */
    char str_from_num[4];

    int name_prop= DAT_ID('N', 'A', 'M', 'E');
    int num_frames_prop= DAT_ID('N', 'F', 'R', 'A');
    int num_ticks_per_frame_prop= DAT_ID('N', 'T', 'I', 'C');

    /* get the datafile which contains the feature types */
    sprintf(str_from_num, "%i", feature->type);

    type_datafile=
        find_datafile_object((DATAFILE *)
                             manager.sprite_datafile[SPRITE_DATA_FEATURE].dat,
                             str_from_num);

    /* get the datafile which contains the feature's statuses */
    sprintf(str_from_num, "%i", feature->entity->status);

    status_datafile=
        find_datafile_object((DATAFILE *) type_datafile->dat, str_from_num);

    if (status_datafile == 0) return;

    //printf("found anim_status_datafile\n");

    //printf("anim_status_datafile name == %s\n",
    //  get_datafile_property(anim_status_datafile, name_prop));

    /* get the datafile which holds the feature's heading x */
    heading_x_datafile= (DATAFILE *) status_datafile->dat;

    /* if heading x is not a don't-care, find appropriate heading x datafile */
    if (get_datafile_property(heading_x_datafile, name_prop)[0] != 'd')
    {
        if (feature->entity->heading_x == 0)
            heading_x_datafile= find_datafile_object(heading_x_datafile, "==");
        else
            heading_x_datafile= find_datafile_object(heading_x_datafile, "!=");
    }

    //printf("found heading_x_datafile\n");

    //printf("heading_x_datafile name == %s\n",
    //  get_datafile_property(heading_x_datafile, name_prop));

    /* get the datafile which holds the feature's heading y */
    heading_y_datafile= (DATAFILE *) heading_x_datafile->dat;

    /* if heading y is not a don't-care, find appropriate heading y datafile */
    if (get_datafile_property(heading_y_datafile, name_prop)[0] != 'd')
    {
        if (feature->entity->heading_y > 0)
            heading_y_datafile= find_datafile_object(heading_y_datafile, "+");
        else
            heading_y_datafile= find_datafile_object(heading_y_datafile, "-");
    }

    //printf("found heading_y_datafile\n");

    //printf("heading_y_datafile name == %s\n",
    //  get_datafile_property(heading_y_datafile, name_prop));

    //printf("count == %s\n",
    //  get_datafile_property(heading_y_datafile, count_prop));

    /* get the number of ticks per frame of animation, as a string */
    num_ticks_per_frame_str=
        get_datafile_property(heading_y_datafile, num_ticks_per_frame_prop);

    /* if the number of ticks is not a don't-care */
    if (num_ticks_per_frame_str[0] != 'd')
    {

        /* get the number of ticks per frame of the animation */
        num_ticks_per_frame= (unsigned short) atoi(num_ticks_per_frame_str);

        /* determine the offset of the current frame of animation among all the
           frames of animation */
        anim_frame_offset=
            feature->entity->anim_counter / num_ticks_per_frame;

        /* get the number of frames of the animation */
        num_frames=
            (unsigned char)
            atoi(get_datafile_property(heading_y_datafile, num_frames_prop));

        //printf("found num_bitmaps == %i\n", num_bitmaps);

        /* it's possible that the feature's animation counter gets ahead of the
           value num_ticks_per_frame * num_frames if the animation counter is
           not reset before a different bitmap leaf is traversed to from the one
           which was traversed to in the previous animation tick, and the
           different bitmap leaf has either a different number of ticks per
           frame or a different number of frames, or both, from the previous
           leaf -- this may occur if the animation, such as a walking animation,
           can be interrupted by a different animation */
        if (anim_frame_offset >= num_frames)
        {
            anim_frame_offset= 0;
            feature->entity->anim_counter= 0;
        }

        //printf("baddie anim_status == %i\n", baddie->entity->anim_status);
        //printf("baddie anim_counter == %i\n", baddie->entity->anim_counter);
        //printf("baddie num_frames == %i\n", num_frames);
        //printf("baddie num ticks == %i\n", num_ticks_per_frame);
        //printf("baddie anim_frame_offset == %i\n", anim_frame_offset);

        ++feature->entity->anim_counter;

        /* if the feature's animation counter is ahead of the value
           num_ticks_per_frame * num_frames here, then the animation has
           completed naturally (i.e., the only instance when the animation is
           interrupted occurs when the animation completes, and here it has) */
        if (feature->entity->anim_counter >= num_ticks_per_frame * num_frames)
        {
            feature->entity->anim_counter= 0;
            feature_anim_done(feature);
        }

    } /* end if number of ticks is not a don't-care */

    /* else, if the number of ticks is a don't-care, zero the frame offset
       AND the feature's animation counter */
    else
    {
        anim_frame_offset= 0;
        feature->entity->anim_counter= 0;
    }

    /* get the datafile which holds the bitmaps of the animation */
    bitmaps_datafile= (DATAFILE *) heading_y_datafile->dat;

    //printf("found bitmaps_datafile\n");

    //printf("object at bitmap location: name == %s\n",
    //  get_datafile_property(&bitmaps_datafile[anim_counter % num_bitmaps],
    //      name_prop));

    feature->entity->anim_frame=
        (BITMAP *) bitmaps_datafile[anim_frame_offset].dat;

    /* set the feature's size! */
    feature->entity->p_width= feature->entity->anim_frame->w;
    feature->entity->p_height= feature->entity->anim_frame->h;

    //printf("player anim counter == %i\n", player->entity->anim_counter);

} /* end animate_feature */
#endif


void animate_feature(Feature *const feature, Map *const map)
{

    DATAFILE *type_datafile;
    DATAFILE *status_datafile;
    DATAFILE *heading_x_datafile;
    DATAFILE *heading_y_datafile;
    DATAFILE *bitmaps_datafile;

    unsigned char num_frames;
    unsigned short num_ticks_per_frame;
    unsigned short num_plays;

    const char *prop_str;

    char str_from_num[4];

    int name_prop;
    int num_frames_prop;
    int num_ticks_per_frame_prop;
    int num_plays_prop;

    if (feature->status == FEATURE_S_KAPUT) return;

    name_prop= DAT_ID('N', 'A', 'M', 'E');
    num_frames_prop= DAT_ID('N', 'F', 'R', 'A');
    num_ticks_per_frame_prop= DAT_ID('N', 'T', 'I', 'C');
    num_plays_prop= DAT_ID('N', 'P', 'L', 'A');

    /* get the datafile which contains the feature types */
    sprintf(str_from_num, "%i", feature->type);

    type_datafile=
        find_datafile_object((DATAFILE *)
                             manager.sprite_datafile[SPRITE_DATA_FEATURE].dat,
                             str_from_num);

    /* get the datafile which contains the feature's statuses */
    sprintf(str_from_num, "%i", feature->status);

    status_datafile=
        find_datafile_object((DATAFILE *) type_datafile->dat, str_from_num);

    /* get the datafile which holds the feature's heading x */
    heading_x_datafile= (DATAFILE *) status_datafile->dat;

    /* if heading x is not a don't-care, find appropriate heading x datafile */
    if (get_datafile_property(heading_x_datafile, name_prop)[0] != 'd')
    {
        if (feature->entity->heading_x == 0)
            heading_x_datafile= find_datafile_object(heading_x_datafile, "=");
        else
            heading_x_datafile= find_datafile_object(heading_x_datafile, "!");
    }

    /* get the datafile which holds the feature's heading y */
    heading_y_datafile= (DATAFILE *) heading_x_datafile->dat;

    /* if heading y is not a don't-care, find appropriate heading y datafile */
    if (get_datafile_property(heading_y_datafile, name_prop)[0] != 'd')
    {
        if (feature->entity->heading_y > 0)
            heading_y_datafile= find_datafile_object(heading_y_datafile, "+");
        else
            heading_y_datafile= find_datafile_object(heading_y_datafile, "-");
    }

    /* get the datafile which holds the bitmaps of the animation */
    bitmaps_datafile= (DATAFILE *) heading_y_datafile->dat;

    /* set the animation frame */
    feature->entity->anim_frame=
        (BITMAP *) bitmaps_datafile[feature->entity->anim_frame_counter].dat;

    /* set the feature's size! */
    feature->entity->p_width= feature->entity->anim_frame->w;
    feature->entity->p_height= feature->entity->anim_frame->h;

    /* get the number of ticks per frame from the bitmap leaf */
    prop_str=
        get_datafile_property(
            &bitmaps_datafile[feature->entity->anim_frame_counter],
            num_ticks_per_frame_prop);

    //printf("prop_str = %s %s\n", prop_str, __FUNCTION__);

    /* proceed only if the number of ticks is not infinite */
    if (prop_str[0] == 'i') return;

    num_ticks_per_frame= (unsigned short) atoi(prop_str);

    /* if the number of ticks property doesn't exist in the bitmap leaf, get it
       from the heading y node */
    if (num_ticks_per_frame == 0)
    {
        num_ticks_per_frame=
            (unsigned short)
            atoi(get_datafile_property(heading_y_datafile,
                                       num_ticks_per_frame_prop));
    }

    //printf("num_ticks_per_frame %i %s\n", num_ticks_per_frame, __FUNCTION__);

    /* if the number of ticks property exists */
    if (num_ticks_per_frame > 0)
    {

        ++feature->entity->anim_counter;

        //printf("anim_counter %i %s\n", baddie->entity->anim_counter, __FUNCTION__);

        //printf("num_ticks_per_frame %i %s\n", num_ticks_per_frame, __FUNCTION__);

        //printf("anim_frame_counter %i %s\n", baddie->entity->anim_frame_counter, __FUNCTION__);

        /* if we've finished the frame */
        if (feature->entity->anim_counter >= num_ticks_per_frame)
        {

            ++feature->entity->anim_frame_counter;
            feature->entity->anim_counter= 0;

            prop_str=
                get_datafile_property(heading_y_datafile, num_frames_prop);

            /* proceed only if the number of frames property exists */
            if (prop_str[0] != '\0')
            {

                num_frames= (unsigned char) atoi(prop_str);

                /* if we've finished the animation once */
                if (feature->entity->anim_frame_counter >= num_frames)
                {

                    feature->entity->anim_frame_counter= 0;

                    prop_str=
                        get_datafile_property(heading_y_datafile,
                                              num_plays_prop);

                    /* if the animation completes */
                    if (prop_str[0] != 'i')
                    {

                        //printf("anim_play_counter %i %s\n",
                        //  player->entity->anim_play_counter, __FUNCTION__);

                        ++feature->entity->anim_play_counter;

                        num_plays= (unsigned short) atoi(prop_str);

                        //printf("num_plays %i %s\n", num_plays, __FUNCTION__);

                        /* if we've finished playing the animation all the
                           times, complete it */
                        if (feature->entity->anim_play_counter >= num_plays)
                        {
                            feature_anim_done(feature, map);
                            feature->entity->anim_play_counter= 0;
                        }

                    }

                } /* end if we've finished the animation once */

            } /* end if the number of frames property exists */

        } /* end if we've finished the frame */

    } /* end if the number of ticks property exists */

} /* end animate_feature */



#if 0
void animate_goodie(type_goodie *const goodie)
{

    DATAFILE *type_datafile;
    DATAFILE *status_datafile;
    DATAFILE *heading_x_datafile;
    DATAFILE *heading_y_datafile;
    DATAFILE *bitmaps_datafile;

    unsigned char num_frames;
    const char *num_ticks_per_frame_str;
    unsigned short num_ticks_per_frame;
    unsigned char anim_frame_offset= 0;

    /* the size of this array should be large enough to hold all the digits
       (base 10) of the largest number representable by the type of
       type_entity.anim_status or type_goodie.type, which ever type is
       larger */
    char str_from_num[4];

    int name_prop= DAT_ID('N', 'A', 'M', 'E');
    int num_frames_prop= DAT_ID('N', 'F', 'R', 'A');
    int num_ticks_per_frame_prop= DAT_ID('N', 'T', 'I', 'C');

    /* get the datafile which contains the goodie types */
    sprintf(str_from_num, "%i", goodie->type);

    type_datafile=
        find_datafile_object((DATAFILE *)
                             manager.sprite_datafile[SPRITE_DATA_GOODIE].dat,
                             str_from_num);

    /* get the datafile which contains the goodie's statuses */
    sprintf(str_from_num, "%i", goodie->entity->status);

    status_datafile=
        find_datafile_object((DATAFILE *) type_datafile->dat, str_from_num);

    if (status_datafile == 0) return;

    //printf("found anim_status_datafile\n");

    //printf("anim_status_datafile name == %s\n",
    //  get_datafile_property(anim_status_datafile, name_prop));

    /* get the datafile which holds the goodie's heading x */
    heading_x_datafile= (DATAFILE *) status_datafile->dat;

    /* if heading x is not a don't-care, find appropriate heading x datafile */
    if (get_datafile_property(heading_x_datafile, name_prop)[0] != 'd')
    {
        if (goodie->entity->heading_x == 0)
            heading_x_datafile= find_datafile_object(heading_x_datafile, "==");
        else
            heading_x_datafile= find_datafile_object(heading_x_datafile, "!=");
    }

    //printf("found heading_x_datafile\n");

    //printf("heading_x_datafile name == %s\n",
    //  get_datafile_property(heading_x_datafile, name_prop));

    /* get the datafile which holds the goodie's heading y */
    heading_y_datafile= (DATAFILE *) heading_x_datafile->dat;

    /* if heading y is not a don't-care, find appropriate heading y datafile */
    if (get_datafile_property(heading_y_datafile, name_prop)[0] != 'd')
    {
        if (goodie->entity->heading_y > 0)
            heading_y_datafile= find_datafile_object(heading_y_datafile, "+");
        else
            heading_y_datafile= find_datafile_object(heading_y_datafile, "-");
    }

    //printf("found heading_y_datafile\n");

    //printf("heading_y_datafile name == %s\n",
    //  get_datafile_property(heading_y_datafile, name_prop));

    //printf("count == %s\n",
    //  get_datafile_property(heading_y_datafile, count_prop));

    /* get the number of ticks per frame of animation, as a string */
    num_ticks_per_frame_str=
        get_datafile_property(heading_y_datafile, num_ticks_per_frame_prop);

    /* if the number of ticks is not a don't-care */
    if (num_ticks_per_frame_str[0] != 'd')
    {

        /* get the number of ticks per frame of the animation */
        num_ticks_per_frame= (unsigned short) atoi(num_ticks_per_frame_str);

        /* determine the offset of the current frame of animation among all the
           frames of animation */
        anim_frame_offset=
            goodie->entity->anim_counter / num_ticks_per_frame;

        /* get the number of frames of the animation */
        num_frames=
            (unsigned char)
            atoi(get_datafile_property(heading_y_datafile, num_frames_prop));

        //printf("found num_bitmaps == %i\n", num_bitmaps);

        /* it's possible that the goodie's animation counter gets ahead of the
           value num_ticks_per_frame * num_frames if the animation counter is
           not reset before a different bitmap leaf is traversed to from the one
           which was traversed to in the previous animation tick, and the
           different bitmap leaf has either a different number of ticks per
           frame or a different number of frames, or both, from the previous
           leaf -- this may occur if the animation, such as a walking animation,
           can be interrupted by a different animation */
        if (anim_frame_offset >= num_frames)
        {
            anim_frame_offset= 0;
            goodie->entity->anim_counter= 0;
        }

        //printf("baddie anim_status == %i\n", baddie->entity->anim_status);
        //printf("baddie anim_counter == %i\n", baddie->entity->anim_counter);
        //printf("baddie num_frames == %i\n", num_frames);
        //printf("baddie num ticks == %i\n", num_ticks_per_frame);
        //printf("baddie anim_frame_offset == %i\n", anim_frame_offset);

        ++goodie->entity->anim_counter;

        /* if the goodie's animation counter is ahead of the value
           num_ticks_per_frame * num_frames here, then the animation has
           completed naturally (i.e., the only instance when the animation is
           interrupted occurs when the animation completes, and here it has) */
        if (goodie->entity->anim_counter >= num_ticks_per_frame * num_frames)
        {
            goodie->entity->anim_counter= 0;
            goodie_anim_done(goodie);
        }

    } /* end if number of ticks is not a don't-care */

    /* else, if the number of ticks is a don't-care, zero the frame offset
       AND the goodie's animation counter */
    else
    {
        anim_frame_offset= 0;
        goodie->entity->anim_counter= 0;
    }

    /* get the datafile which holds the bitmaps of the animation */
    bitmaps_datafile= (DATAFILE *) heading_y_datafile->dat;

    //printf("found bitmaps_datafile\n");

    //printf("object at bitmap location: name == %s\n",
    //  get_datafile_property(&bitmaps_datafile[anim_counter % num_bitmaps],
    //      name_prop));

    goodie->entity->anim_frame=
        (BITMAP *) bitmaps_datafile[anim_frame_offset].dat;

    /* set the goodie's size! */
    goodie->entity->p_width= goodie->entity->anim_frame->w;
    goodie->entity->p_height= goodie->entity->anim_frame->h;

    //printf("player anim counter == %i\n", player->entity->anim_counter);

} /* end animate_goodie */
#endif



void animate_goodie(Goodie *const goodie)
{

    DATAFILE *type_datafile;
    DATAFILE *status_datafile;
    DATAFILE *heading_x_datafile;
    DATAFILE *heading_y_datafile;
    DATAFILE *bitmaps_datafile;

    unsigned char num_frames;
    unsigned short num_ticks_per_frame;
    unsigned short num_plays;

    const char *prop_str;

    char str_from_num[4];

    int name_prop;
    int num_frames_prop;
    int num_ticks_per_frame_prop;
    int num_plays_prop;

    if (goodie->status == GOODIE_S_KAPUT) return;

    name_prop= DAT_ID('N', 'A', 'M', 'E');
    num_frames_prop= DAT_ID('N', 'F', 'R', 'A');
    num_ticks_per_frame_prop= DAT_ID('N', 'T', 'I', 'C');
    num_plays_prop= DAT_ID('N', 'P', 'L', 'A');

    /* get the datafile which contains the goodie types */
    sprintf(str_from_num, "%i", goodie->type);

    type_datafile=
        find_datafile_object((DATAFILE *)
                             manager.sprite_datafile[SPRITE_DATA_GOODIE].dat,
                             str_from_num);

    /* get the datafile which contains the goodie's statuses */
    sprintf(str_from_num, "%i", goodie->status);

    status_datafile=
        find_datafile_object((DATAFILE *) type_datafile->dat, str_from_num);

    /* get the datafile which holds the goodie's heading x */
    heading_x_datafile= (DATAFILE *) status_datafile->dat;

    /* if heading x is not a don't-care, find appropriate heading x datafile */
    if (get_datafile_property(heading_x_datafile, name_prop)[0] != 'd')
    {
        if (goodie->entity->heading_x == 0)
            heading_x_datafile= find_datafile_object(heading_x_datafile, "=");
        else
            heading_x_datafile= find_datafile_object(heading_x_datafile, "!");
    }

    /* get the datafile which holds the goodie's heading y */
    heading_y_datafile= (DATAFILE *) heading_x_datafile->dat;

    /* if heading y is not a don't-care, find appropriate heading y datafile */
    if (get_datafile_property(heading_y_datafile, name_prop)[0] != 'd')
    {
        if (goodie->entity->heading_y > 0)
            heading_y_datafile= find_datafile_object(heading_y_datafile, "+");
        else
            heading_y_datafile= find_datafile_object(heading_y_datafile, "-");
    }

    /* get the datafile which holds the bitmaps of the animation */
    bitmaps_datafile= (DATAFILE *) heading_y_datafile->dat;

    /* set the animation frame */
    goodie->entity->anim_frame=
        (BITMAP *) bitmaps_datafile[goodie->entity->anim_frame_counter].dat;

    /* set the goodie's size! */
    goodie->entity->p_width= goodie->entity->anim_frame->w;
    goodie->entity->p_height= goodie->entity->anim_frame->h;

    /* get the number of ticks per frame from the bitmap leaf */
    prop_str=
        get_datafile_property(
            &bitmaps_datafile[goodie->entity->anim_frame_counter],
            num_ticks_per_frame_prop);

    //printf("prop_str = %s %s\n", prop_str, __FUNCTION__);

    /* proceed only if the number of ticks is not infinite */
    if (prop_str[0] == 'i') return;

    num_ticks_per_frame= (unsigned short) atoi(prop_str);

    /* if the number of ticks property doesn't exist in the bitmap leaf, get it
       from the heading y node */
    if (num_ticks_per_frame == 0)
    {
        num_ticks_per_frame=
            (unsigned short)
            atoi(get_datafile_property(heading_y_datafile,
                                       num_ticks_per_frame_prop));
    }

    //printf("num_ticks_per_frame %i %s\n", num_ticks_per_frame, __FUNCTION__);

    /* if the number of ticks property exists */
    if (num_ticks_per_frame > 0)
    {

        ++goodie->entity->anim_counter;

        //printf("anim_counter %i %s\n", baddie->entity->anim_counter, __FUNCTION__);

        //printf("num_ticks_per_frame %i %s\n", num_ticks_per_frame, __FUNCTION__);

        //printf("anim_frame_counter %i %s\n", baddie->entity->anim_frame_counter, __FUNCTION__);

        /* if we've finished the frame */
        if (goodie->entity->anim_counter >= num_ticks_per_frame)
        {

            ++goodie->entity->anim_frame_counter;
            goodie->entity->anim_counter= 0;

            prop_str=
                get_datafile_property(heading_y_datafile, num_frames_prop);

            /* proceed only if the number of frames property exists */
            if (prop_str[0] != '\0')
            {

                num_frames= (unsigned char) atoi(prop_str);

                /* if we've finished the animation once */
                if (goodie->entity->anim_frame_counter >= num_frames)
                {

                    goodie->entity->anim_frame_counter= 0;

                    prop_str=
                        get_datafile_property(heading_y_datafile,
                                              num_plays_prop);

                    /* if the animation completes */
                    if (prop_str[0] != 'i')
                    {

                        //printf("anim_play_counter %i %s\n",
                        //  player->entity->anim_play_counter, __FUNCTION__);

                        ++goodie->entity->anim_play_counter;

                        num_plays= (unsigned short) atoi(prop_str);

                        //printf("num_plays %i %s\n", num_plays, __FUNCTION__);

                        /* if we've finished playing the animation all the
                           times, complete it */
                        if (goodie->entity->anim_play_counter >= num_plays)
                        {
                            goodie_anim_done(goodie);
                            goodie->entity->anim_play_counter= 0;
                        }

                    }

                } /* end if we've finished the animation once */

            } /* end if the number of frames property exists */

        } /* end if we've finished the frame */

    } /* end if the number of ticks property exists */

} /* end animate_goodie */




void animate_map(Map *const map)
{

    //printf("animate map enter\n");

    unsigned char row;
    unsigned char col;

    //unsigned short i;

    List_iterator *iterator;

    /* map tiles */
    for (row= 0; row < map->m_height; row++)
    {
        for (col= 0; col < map->m_width; col++)
        {
            animate_tile(&(map->tiles[row][col]));
        }
    }

    /* player */
    if (map->player != 0) animate_player(map->player);

    /* baddies */
    #if 0
    for (i= 0; i < map->max_num_baddies; i++)
    {
        if (map->baddies[i] != 0) animate_baddie(map->baddies[i]);
    }
    #endif

    iterator= get_iterator(map->baddie_list);
    while (iterator != 0)
    {
        animate_baddie((Baddie *) iterator->dat, map);
        iterator= next_iterator(iterator);
    }

    /* goodies */


    /* features */
    #if 0
    for (i= 0; i < map->max_num_features; i++)
    {
        if (map->features[i] != 0) animate_feature(map->features[i]);
    }
    #endif

    iterator= get_iterator(map->feature_list);
    while (iterator != 0)
    {
        animate_feature((Feature *) iterator->dat, map);
        iterator= next_iterator(iterator);
    }

    /* projectiles */
    #if 0
    for (i= 0; i < map->max_num_projectiles; i++)
    {
        if (map->projectiles[i] != 0) animate_projectile(map->projectiles[i]);
    }
    #endif

    iterator= get_iterator(map->projectile_list);
    while (iterator != 0)
    {
        animate_projectile((Projectile *) iterator->dat);
        iterator= next_iterator(iterator);
    }

    //printf("animate map exit\n");

} /* end animate map */



#if 0
void animate_player(type_player *const player)
{

    //printf("animate_player enter\n");

    DATAFILE *status_datafile;
    DATAFILE *heading_x_datafile;
    DATAFILE *heading_y_datafile;
    DATAFILE *bitmaps_datafile;

    unsigned char num_frames;
    const char *num_ticks_per_frame_str;
    unsigned short num_ticks_per_frame;
    unsigned char anim_frame_offset= 0;

    /* the size of this array should be large enough to hold all the digits
       (base 10) of the largest number representable by the type of
       type_entity.status */
    char str_from_num[4];

    int name_prop= DAT_ID('N', 'A', 'M', 'E');
    int num_frames_prop= DAT_ID('N', 'F', 'R', 'A');
    int num_ticks_per_frame_prop= DAT_ID('N', 'T', 'I', 'C');

    /* get the datafile which contains the player's statuses */
    sprintf(str_from_num, "%i", player->entity->status);

    status_datafile=
        find_datafile_object((DATAFILE *)
                             manager.sprite_datafile[SPRITE_DATA_PLAYER].dat,
                             str_from_num);

    //printf("found anim_status_datafile\n");

    //printf("anim_status_datafile name == %s\n",
    //  get_datafile_property(anim_status_datafile, name_prop));

    /* get the datafile which holds the player's heading x */
    heading_x_datafile= (DATAFILE *) status_datafile->dat;

    /* if heading x is not a don't-care, find appropriate heading x datafile */
    if (get_datafile_property(heading_x_datafile, name_prop)[0] != 'd')
    {
        if (player->entity->heading_x == 0)
            heading_x_datafile= find_datafile_object(heading_x_datafile, "==");
        else
            heading_x_datafile= find_datafile_object(heading_x_datafile, "!=");
    }

    //printf("found heading_x_datafile\n");

    //printf("heading_x_datafile name == %s\n",
    //  get_datafile_property(heading_x_datafile, name_prop));

    /* get the datafile which holds the player's heading y */
    heading_y_datafile= (DATAFILE *) heading_x_datafile->dat;

    /* if heading y is not a don't-care, find appropriate heading y datafile */
    if (get_datafile_property(heading_y_datafile, name_prop)[0] != 'd')
    {
        if (player->entity->heading_y > 0)
            heading_y_datafile= find_datafile_object(heading_y_datafile, "+");
        else
            heading_y_datafile= find_datafile_object(heading_y_datafile, "-");
    }

    //printf("found heading_y_datafile\n");

    //printf("heading_y_datafile name == %s\n",
    //  get_datafile_property(heading_y_datafile, name_prop));

    //printf("count == %s\n",
    //  get_datafile_property(heading_y_datafile, count_prop));

    /* get the number of ticks per frame of animation, as a string */
    num_ticks_per_frame_str=
        get_datafile_property(heading_y_datafile, num_ticks_per_frame_prop);

    /* if the number of ticks is not a don't-care, then compute the proper
       frame offset of the animation */
    if (num_ticks_per_frame_str[0] != 'd')
    {

        /* get the number of ticks per frame of the animation */
        num_ticks_per_frame= (unsigned short) atoi(num_ticks_per_frame_str);

        /* determine the offset of the current frame of animation among all the
           frames of animation */
        anim_frame_offset=
            player->entity->anim_counter / num_ticks_per_frame;

        /* get the number of frames of the animation */
        num_frames=
            (unsigned char)
            atoi(get_datafile_property(heading_y_datafile, num_frames_prop));

        //printf("found num_bitmaps == %i\n", num_bitmaps);

        /* it's possible that the player's animation counter gets ahead of the
           value num_ticks_per_frame * num_frames if the animation counter is
           not reset before a different bitmap leaf is traversed to from the one
           which was traversed to in the previous animation tick, and the
           different bitmap leaf has either a different number of ticks per
           frame or a different number of frames, or both, from the previous
           leaf -- this may occur if the animation, such as a walking animation,
           can be interrupted by a different animation */
        if (anim_frame_offset >= num_frames)
        {
            anim_frame_offset= 0;
            player->entity->anim_counter= 0;
        }

        //printf("player anim_status == %i\n", player->entity->anim_status);
        //printf("player anim_counter == %i\n", player->entity->anim_counter);
        //printf("player num_frames == %i\n", num_frames);
        //printf("player num ticks == %i\n", num_ticks_per_frame);
        //printf("player anim_frame_offset == %i\n", anim_frame_offset);

        ++player->entity->anim_counter;

        /* if the player's animation counter is ahead of the value
           num_ticks_per_frame * num_frames here, then the animation has
           completed naturally (i.e., the only instance when the animation is
           interrupted occurs when the animation completes, and here it has) */
        if (player->entity->anim_counter >= num_ticks_per_frame * num_frames)
        {
            player->entity->anim_counter= 0;
            player_anim_done(player);
        }

    } /* end if number of ticks is not a don't-care */

    /* else, if the number of ticks is a don't care, zero the frame offset AND
       the player's animation counter */
    else
    {
        anim_frame_offset= 0;
        player->entity->anim_counter= 0;
    }

    /* get the datafile which holds the bitmaps of the animation */
    bitmaps_datafile= (DATAFILE *) heading_y_datafile->dat;

    //printf("found bitmaps_datafile\n");

    //printf("object at bitmap location: name == %s\n",
    //  get_datafile_property(&bitmaps_datafile[anim_counter % num_bitmaps],
    //      name_prop));

    player->entity->anim_frame=
        (BITMAP *) bitmaps_datafile[anim_frame_offset].dat;

    /* set the player's size! */
    player->entity->p_width= player->entity->anim_frame->w;
    player->entity->p_height= player->entity->anim_frame->h;

    //printf("player anim counter == %i\n", player->entity->anim_counter);


    //printf("animate_player exit\n");

} /* end animate_player */
#endif



void animate_player(Player *const player)
{

    //printf("%s player status == %i\n", __FUNCTION__, player->status);
    //printf("%s anim_counter %i anim_frame_counter %i anim_play_counter %i\n",
    //      __FUNCTION__, player->entity->anim_counter,
    //      player->entity->anim_frame_counter,
    //      player->entity->anim_play_counter);

    DATAFILE *status_datafile;
    DATAFILE *heading_x_datafile;
    DATAFILE *heading_y_datafile;
    DATAFILE *bitmaps_datafile;

    unsigned char num_frames;
    unsigned short num_ticks_per_frame;
    unsigned short num_plays;

    const char *prop_str;

    char str_from_num[4];

    int name_prop;
    int num_frames_prop;
    int num_ticks_per_frame_prop;
    int num_plays_prop;

    if (player->status == PLAYER_S_KAPUT) return;

    name_prop= DAT_ID('N', 'A', 'M', 'E');
    num_frames_prop= DAT_ID('N', 'F', 'R', 'A');
    num_ticks_per_frame_prop= DAT_ID('N', 'T', 'I', 'C');
    num_plays_prop= DAT_ID('N', 'P', 'L', 'A');

    /* get the datafile which contains the player's statuses */
    sprintf(str_from_num, "%i", player->status);

    status_datafile=
        find_datafile_object((DATAFILE *)
                             manager.sprite_datafile[SPRITE_DATA_PLAYER].dat,
                             str_from_num);

    /* get the datafile which holds the player's heading x */
    heading_x_datafile= (DATAFILE *) status_datafile->dat;

    /* if heading x is not a don't-care, find appropriate heading x datafile */
    if (get_datafile_property(heading_x_datafile, name_prop)[0] != 'd')
    {
        if (player->entity->heading_x == 0)
            heading_x_datafile= find_datafile_object(heading_x_datafile, "=");
        else
            heading_x_datafile= find_datafile_object(heading_x_datafile, "!");
    }

    /* get the datafile which holds the player's heading y */
    heading_y_datafile= (DATAFILE *) heading_x_datafile->dat;

    /* if heading y is not a don't-care, find appropriate heading y datafile */
    if (get_datafile_property(heading_y_datafile, name_prop)[0] != 'd')
    {
        if (player->entity->heading_y > 0)
            heading_y_datafile= find_datafile_object(heading_y_datafile, "+");
        else
            heading_y_datafile= find_datafile_object(heading_y_datafile, "-");
    }

    /* get the datafile which holds the bitmaps of the animation */
    bitmaps_datafile= (DATAFILE *) heading_y_datafile->dat;

    /* set the animation frame */
    player->entity->anim_frame=
        (BITMAP *) bitmaps_datafile[player->entity->anim_frame_counter].dat;

    /* set the player's size! */
    player->entity->p_width= player->entity->anim_frame->w;
    player->entity->p_height= player->entity->anim_frame->h;

    /* get the number of ticks per frame from the bitmap leaf */
    prop_str=
        get_datafile_property(
            &bitmaps_datafile[player->entity->anim_frame_counter],
            num_ticks_per_frame_prop);

    /* proceed only if the number of ticks is not infinite */
    if (prop_str[0] == 'i') return;

    num_ticks_per_frame= (unsigned short) atoi(prop_str);

    /* if the number of ticks property doesn't exist in the bitmap leaf, get it
       from the heading y node */
    if (num_ticks_per_frame == 0)
    {
        num_ticks_per_frame=
            (unsigned short)
            atoi(get_datafile_property(heading_y_datafile,
                                       num_ticks_per_frame_prop));
    }

    //printf("num_ticks_per_frame %i %s\n", num_ticks_per_frame, __FUNCTION__);

    /* if the number of ticks property exists */
    if (num_ticks_per_frame > 0)
    {

        ++player->entity->anim_counter;

        //printf("anim_counter %i %s\n", player->entity->anim_counter, __FUNCTION__);

        /* if we've finished the frame */
        if (player->entity->anim_counter >= num_ticks_per_frame)
        {

            ++player->entity->anim_frame_counter;
            player->entity->anim_counter= 0;

            prop_str=
                get_datafile_property(heading_y_datafile, num_frames_prop);

            /* proceed only if the number of frames property exists */
            if (prop_str[0] != '\0')
            {

                num_frames= (unsigned char) atoi(prop_str);

                /* if we've finished the animation once */
                if (player->entity->anim_frame_counter >= num_frames)
                {

                    player->entity->anim_frame_counter= 0;

                    prop_str=
                        get_datafile_property(heading_y_datafile,
                                              num_plays_prop);

                    /* if the animation completes */
                    if (prop_str[0] != 'i')
                    {

                        //printf("anim_play_counter %i %s\n",
                        //  player->entity->anim_play_counter, __FUNCTION__);

                        ++player->entity->anim_play_counter;

                        num_plays= (unsigned short) atoi(prop_str);

                        //printf("num_plays %i %s\n", num_plays, __FUNCTION__);

                        /* if we've finished playing the animation all the
                           times, complete it */
                        if (player->entity->anim_play_counter >= num_plays)
                        {
                            player->entity->anim_play_counter= 0;
                            player_anim_done(player);
                        }

                    }

                } /* end if we've finished the animation once */

            } /* end if the number of frames property exists */

        } /* end if we've finished the frame */

    } /* end if the number of ticks property exists */

} /* end animate_player */




void animate_projectile(Projectile *const projectile)
{

    DATAFILE *projectile_type_datafile;
    DATAFILE *anim_status_datafile;
    DATAFILE *heading_x_datafile;
    DATAFILE *heading_y_datafile;
    DATAFILE *bitmaps_datafile;

    unsigned char num_frames;
    const char *num_ticks_per_frame_str;
    unsigned short num_ticks_per_frame;
    unsigned char anim_frame_offset= 0;

    /* the size of this array should be large enough to hold all the digits
       (base 10) of the largest number representable by the type of
       Entity.anim_status or Projectile.type, which ever type is
       larger */
    char str_from_num[4];

    int name_prop= DAT_ID('N', 'A', 'M', 'E');
    int num_frames_prop= DAT_ID('N', 'F', 'R', 'A');
    int num_ticks_per_frame_prop= DAT_ID('N', 'T', 'I', 'C');

    if (projectile->status == PROJECTILE_S_KAPUT) return;

    /* get the datafile which contains the projectile types */
    sprintf(str_from_num, "%i", projectile->type);

    projectile_type_datafile=
        find_datafile_object(
            (DATAFILE *) manager.sprite_datafile[SPRITE_DATA_PROJECTILE].dat,
            str_from_num);

    /* get the datafile which contains the projectile's statuses */
    sprintf(str_from_num, "%i", projectile->status);

    anim_status_datafile=
        find_datafile_object((DATAFILE *) projectile_type_datafile->dat,
                             str_from_num);

    /* get the datafile which holds the projectile's heading x */
    heading_x_datafile= (DATAFILE *) anim_status_datafile->dat;

    /* if heading x is not a don't-care, find appropriate heading x datafile */
    if (get_datafile_property(heading_x_datafile, name_prop)[0] != 'd')
    {
        if (projectile->entity->heading_x == 0)
            heading_x_datafile= find_datafile_object(heading_x_datafile, "==");
        else
            heading_x_datafile= find_datafile_object(heading_x_datafile, "!=");
    }

    /* get the datafile which holds the projectile's heading y */
    heading_y_datafile= (DATAFILE *) heading_x_datafile->dat;

    /* if heading y is not a don't-care, find appropriate heading y datafile */
    if (get_datafile_property(heading_y_datafile, name_prop)[0] != 'd')
    {
        if (projectile->entity->heading_y > 0)
            heading_y_datafile= find_datafile_object(heading_y_datafile, "+");
        else
            heading_y_datafile= find_datafile_object(heading_y_datafile, "-");
    }

    /* get the number of ticks per frame of animation, as a string */
    num_ticks_per_frame_str=
        get_datafile_property(heading_y_datafile, num_ticks_per_frame_prop);

    /* if the number of ticks is not a don't-care */
    if (num_ticks_per_frame_str[0] != 'd')
    {

        /* get the number of ticks per frame of the animation */
        num_ticks_per_frame= (unsigned short) atoi(num_ticks_per_frame_str);

        /* determine the offset of the current frame of animation among all the
           frames of animation */
        anim_frame_offset=
            projectile->entity->anim_counter / num_ticks_per_frame;

        /* get the number of frames of the animation */
        num_frames=
            (unsigned char)
            atoi(get_datafile_property(heading_y_datafile, num_frames_prop));

        /* it's possible that the projectile's animation counter gets ahead of
           the value num_ticks_per_frame * num_frames if the animation counter
           is not reset before a different bitmap leaf is traversed to from the
           one which was traversed to in the previous animation tick, and the
           different bitmap leaf has either a different number of ticks per
           frame or a different number of frames, or both, from the previous
           leaf -- this may occur if the animation can be interrupted by a
           different animation */
        if (anim_frame_offset >= num_frames)
        {
            anim_frame_offset= 0;
            projectile->entity->anim_counter= 0;
        }

        ++projectile->entity->anim_counter;

        /* if the projectile's animation counter is ahead of the value
           num_ticks_per_frame * num_frames here, then the animation has
           completed naturally (i.e., the only instance when the animation is
           interrupted occurs when the animation completes, and here it has) */
        if (projectile->entity->anim_counter
            >= num_ticks_per_frame * num_frames)
        {
            projectile->entity->anim_counter= 0;
            projectile_anim_done(projectile);
        }

    } /* end if number of ticks is not a don't-care */

    /* else, if the number of ticks is a don't-care, zero the frame offset
       AND the projectile's animation counter */
    else
    {
        anim_frame_offset= 0;
        projectile->entity->anim_counter= 0;
    }

    /* get the datafile which holds the bitmaps of the animation */
    bitmaps_datafile= (DATAFILE *) heading_y_datafile->dat;

    projectile->entity->anim_frame=
        (BITMAP *) bitmaps_datafile[anim_frame_offset].dat;

    /* set the projectile's size! */
    projectile->entity->p_width= projectile->entity->anim_frame->w;
    projectile->entity->p_height= projectile->entity->anim_frame->h;

} /* end animate_projectile */




void animate_tile(Tile *const tile)
{

    //printf("animate map tile enter\n");

    DATAFILE *anim_index_datafile;
    DATAFILE *bitmaps_datafile;

    unsigned char num_frames;
    const char *num_ticks_per_frame_str;
    unsigned short num_ticks_per_frame;
    unsigned char anim_frame_offset;

    /* the size of this array should be large enough to hold all the digits
       (decimal) of the largest number representable by the type of
       Map_tile.type */
    char str_from_num[4];

    int num_frames_prop= DAT_ID('N', 'F', 'R', 'A');
    int num_ticks_per_frame_prop= DAT_ID('N', 'T', 'I', 'C');

    /* get the datafile that contains animation indices */
    sprintf(str_from_num, "%i", tile->anim_index);

    anim_index_datafile=
        find_datafile_object(
            (DATAFILE *) manager.sprite_datafile[SPRITE_DATA_MAP].dat,
            str_from_num);

    //printf("tile_type_datafile found\n");

    /* get the number of ticks per frame of animation, as a string */
    num_ticks_per_frame_str=
        get_datafile_property(anim_index_datafile, num_ticks_per_frame_prop);

    /* if the number of ticks is not a don't-care, compute proper frame
       offset */
    if (num_ticks_per_frame_str[0] != 'd')
    {

        num_ticks_per_frame= (unsigned short) atoi(num_ticks_per_frame_str);
        anim_frame_offset= tile->anim_counter / num_ticks_per_frame;

        ++tile->anim_counter;

        /* get the number of frames in the animation */
        num_frames=
            (unsigned char)
            atoi(get_datafile_property(anim_index_datafile, num_frames_prop));

        //printf("num_bitmaps found\n");

        if (tile->anim_counter >= num_ticks_per_frame * num_frames)
            tile->anim_counter= 0;

    }

    /* else, if the number of ticks is a don't-care, zero the offset */
    else anim_frame_offset= 0;

    /* get the datafile which contains the bitmaps in the animation */
    bitmaps_datafile= (DATAFILE *) anim_index_datafile->dat;

    //printf("bitmaps_datafile found\n");

    tile->anim_frame=
        (BITMAP *) bitmaps_datafile[anim_frame_offset].dat;

    //printf("animate map tile exit\n");

} /* end animate_tile */




unsigned char attempt_gfx_mode(void)
{


    write_to_log(manager.log, 0,
                 "Setting graphics mode to %i x %i x 256 %s.\n",
                 manager.screen_w, manager.screen_h,
                 (manager.fullscreen ? "fullscreen" : "windowed"));

    /* try to change into requested mode */
    if (set_gfx_mode((manager.fullscreen ? GFX_AUTODETECT_FULLSCREEN
                     : GFX_AUTODETECT_WINDOWED), manager.screen_w,
                     manager.screen_h, 0, 0) != 0)
    {

        write_to_log(manager.log, 1,
                     "Unable to change graphics mode:  %s\nAttempting to change back into previous mode, %i x %i x 256 %s.\n",
                     allegro_error, manager.old_screen_w,
                     manager.old_screen_h,
                     (manager.old_fullscreen ? "fullscreen" : "windowed"));
        allegro_message(
            "%s %s:  unable to change graphics mode to %i x %i x 256 %s.\n%s\nAttempting to change back into previous mode, %i x %i x 256 %s.\n",
            PROG_NAME, PROG_VER, manager.screen_w, manager.screen_h,
            (manager.fullscreen ? "fullscreen" : "windowed"),
            allegro_error, manager.old_screen_w, manager.old_screen_h,
            (manager.old_fullscreen ? "fullscreen" : "windowed"));

        manager.fullscreen= manager.old_fullscreen;
        manager.screen_w= manager.old_screen_w;
        manager.screen_h= manager.old_screen_h;

        /* try to change into previous mode */
        if (set_gfx_mode((manager.old_fullscreen
                         ? GFX_AUTODETECT_FULLSCREEN
                         : GFX_AUTODETECT_WINDOWED), manager.old_screen_w,
                         manager.old_screen_h, 0, 0) != 0)
        {

            write_to_log(manager.log, 1,
                         "Unable to change into previous graphics mode:  %s\nAttempting to change into safe mode.\n",
                         allegro_error);
            allegro_message(
                "%s %s:  unable to change into previous graphics mode.\n%s\nAttempting to change into safe mode.\n",
                PROG_NAME, PROG_VER, allegro_error);

            /* try to change into safe mode */
            if (set_gfx_mode(GFX_SAFE, manager.old_screen_w,
                             manager.old_screen_h, 0, 0) != 0)
            {
                write_to_log(manager.log, 1,
                             "Unable to change into safe mode: %s\n",
                             allegro_error);
                allegro_message(
                    "%s %s:  unable to change into safe mode.\n%s\n",
                    PROG_NAME, PROG_VER, allegro_error);
                return 1;
            }

            manager.screen_w= SCREEN_W;
            manager.screen_h= SCREEN_H;

        } /* end change into previous mode */

    } /* end change into requested mode */

    kickle_pal= (PALETTE *) manager.sprite_datafile[SPRITE_DATA_PAL].dat;
    set_palette(*kickle_pal);

    return 0;

} /* end attempt_gfx_mode */



#if 0
unsigned char do_box_in(const unsigned short iteration)
{

    if (iteration >= offscreen->h / 2) return 1;

    /* top */
    rectfill(offscreen, 0, 0, offscreen->w - 1, iteration + 1, 254);
    /* bottom */
    rectfill(offscreen, 0, offscreen->h - iteration - 1, offscreen->w - 1,
             offscreen->h - 1, 254);

    return 0;

}
#endif


void clear_offscreen(int color)
{
    clear_to_color(offscreen, color);
}




void do_box_in(const unsigned short dy)
{

    unsigned char draw_needed;

    unsigned short i;


    draw_needed= 1;

    manager.fps_aggregate= 0;
    manager.fps_counter= 0;
    manager.fps_average= 0.0;
    manager.logic_counter= 1;
    manager.beats_counter= 0;

    i= 0;
    while (i < offscreen->h / 2)
    {

        while (manager.logic_counter > 0)
        {
            draw_needed= 1;
            i+= dy;
            --manager.logic_counter;
        }

        yield_timeslice();

        if (draw_needed)
        {

            /* top */
            rectfill(offscreen, 0, 0, offscreen->w - 1, i + 1, 254);

            /* bottom */
            rectfill(offscreen, 0, offscreen->h - i - 1,
                     offscreen->w - 1, offscreen->h - 1, 254);

        }
        if (draw_needed || manager.draw_always)
        {
            draw_to_screen(0);
            draw_needed= 0;
        }

    }

} /* end do_box_in */



void draw_baddie(const Baddie *const baddie)
{

    //printf("draw_baddie enter\n");

    //printf("baddie->entity->current_anim_frame == %p\n",
    //  baddie->entity->current_anim_frame);

    /* if the baddie's heading left, flip his image */
    if (baddie->entity->heading_x < 0)
    {
        draw_sprite_h_flip(offscreen, baddie->entity->anim_frame,
                           baddie->entity->x, baddie->entity->y);
    }

    /* else draw as normal */
    else
    {
        draw_sprite(offscreen, baddie->entity->anim_frame,
                    baddie->entity->x, baddie->entity->y);
    }

    //printf("draw_baddie exit\n");

} /* end draw_baddie */




void draw_feature(const Feature *const feature)
{

    if (feature->entity->heading_x < 0)
    {
        draw_sprite_h_flip(offscreen, feature->entity->anim_frame,
                           feature->entity->x, feature->entity->y);
    }

    /* else draw as normal */
    else
    {
        draw_sprite(offscreen, feature->entity->anim_frame,
                    feature->entity->x, feature->entity->y);
    }

} /* end draw_feature */




void draw_floating_text(const Floating_text *const ftext)
{

    /* red 22 */

    draw_outlined_text(offscreen, font_ingame, ftext->str, ftext->x, ftext->y,
                       254, (ftext->y % 4 < 2 ? 22 : 255));

}




void draw_goodie(const Goodie *const goodie)
{

    if (goodie->entity->heading_x < 0)
    {
        draw_sprite_h_flip(offscreen, goodie->entity->anim_frame,
                           goodie->entity->x, goodie->entity->y);
    }

    /* else draw as normal */
    else
    {
        draw_sprite(offscreen, goodie->entity->anim_frame,
                    goodie->entity->x, goodie->entity->y);
    }

} /* end draw_goodie */




void draw_map(const Map *const map)
{

    unsigned char row;
    unsigned char col;
    //unsigned short i;

    List_iterator *iterator;

    /* clear the buffer */
    //clear_bitmap(offscreen);

    /* the status display */
    draw_status_bar(map);

    /* draw the map tiles */
    for (row= 0; row < map->m_height; row++)
    {
        for (col= 0; col < map->m_width; col++)
        {
            draw_tile(&(map->tiles[row][col]));
        }
    }

    /* the features */
    #if 0
    for (i= 0; i < map->max_num_features; i++)
    {
        if (map->features[i] != 0) draw_feature(map->features[i]);
    }
    #endif

    iterator= get_iterator(map->feature_list);
    while (iterator != 0)
    {
        draw_feature((Feature *) iterator->dat);
        iterator= next_iterator(iterator);
    }

    /* the goodies */
    #if 0
    for (i= 0; i < map->max_num_goodies; i++)
    {
        if (map->goodies[i] != 0) draw_goodie(map->goodies[i]);
    }
    #endif

    iterator= get_iterator(map->goodie_list);
    while (iterator != 0)
    {
        draw_goodie((Goodie *) iterator->dat);
        iterator= next_iterator(iterator);
    }

    /* the baddies */
    #if 0
    for (i= 0; i < map->max_num_baddies; i++)
    {
        if (map->baddies[i] != 0) draw_baddie(map->baddies[i]);
    }
    #endif

    iterator= get_iterator(map->baddie_list);
    while (iterator != 0)
    {
        draw_baddie((Baddie *) iterator->dat);
        iterator= next_iterator(iterator);
    }

    /* the projectiles */
    #if 0
    for (i= 0; i < map->max_num_projectiles; i++)
    {
        if (map->projectiles[i] != 0) draw_projectile(map->projectiles[i]);
    }
    #endif

    iterator= get_iterator(map->projectile_list);
    while (iterator != 0)
    {
        draw_projectile((Projectile *) iterator->dat);
        iterator= next_iterator(iterator);
    }

    /* the player */
    if (map->player != 0) draw_player(map->player);

    /* the point displays */
    iterator= get_iterator(map->point_list);
    while (iterator != 0)
    {
        draw_floating_text((Floating_text *) iterator->dat);
        iterator= next_iterator(iterator);
    }

    /* FPS display */
    if (manager.show_fps)
    {
        textprintf(offscreen, font, 0, 20, makecol(255, 255, 255),
                   "%i fps   ", manager.fps_aggregate);
        textprintf(offscreen, font, 0, 30, makecol(255, 255, 255),
                   "%f fps (average)  ", manager.fps_average);
    }

    #if 0

    // DEBUG TEXT

    if (map->player != 0)
    {
        textprintf(offscreen, font, 0, 0, makecol(255, 255, 255),
                   "player->row %i   ", map->player->entity->row);
        textprintf(offscreen, font, 0, 10, makecol(255, 255, 255),
                   "player->col %i   ", map->player->entity->col);
    }

    if (map->name != 0 && map->author != 0)
    {
        textprintf(offscreen, font, 0, 40, makecol(255, 255, 255),
                   "\"%s\" by \"%s\"", map->name, map->author);
    }
    #endif

} /* end draw_map */




void draw_menu(const Menu *const menu, const unsigned char draw_border)
{

    unsigned short i;
    unsigned char text_h;

    unsigned short max_length;
    unsigned short tmp_length;

    unsigned short rect_w;
    unsigned short rect_h;

    text_h= (unsigned char) text_height(font_menu) + 4;

    text_mode(-1);

    if (draw_border == 0) clear_to_color(offscreen, 254);
    else
    {

        /* calculate maximum string length in pixels */
        if (menu->title != 0) max_length= text_length(font_menu, menu->title);
        else max_length= 0;

        for (i= 0; i < menu->num_items; i++)
        {

            tmp_length=
                (unsigned short) text_length(font_menu, menu->items[i].label);

            if (tmp_length > max_length) max_length= tmp_length;

        }

        rect_w= max_length + 40;
        rect_h= 20 + (text_h * 2) + (text_h * menu->num_items) + 10;

        //rectfill(offscreen, 8, 8, rect_w + 2, rect_h + 2, 254);
        hline(offscreen, 9, 8, rect_w + 1, 254);
        hline(offscreen, 9, rect_h + 2, rect_w + 1, 254);
        vline(offscreen, 8, 9, rect_h + 1, 254);
        vline(offscreen, rect_w + 2, 9, rect_h + 1, 254);
        rectfill(offscreen, 9, 9, rect_w + 1, rect_h + 1, 255);
        rectfill(offscreen, 10, 10, rect_w, rect_h, 254);

    } /* end if drawing border */

    if (menu->title != 0)
        //textprintf(offscreen, font_menu, 20, 20, 17, "%s", menu->title);
        draw_outlined_text(offscreen, font_menu, menu->title, 20, 20, 2, 33);

    for (i= 0; i < menu->num_items; i++)
    {
        if (i == menu->hilite_index)
        {
            //text_mode(22);
            //textprintf(offscreen, font_menu, 20,
            //         20 + (height * 2) + (i * height), 32, "%s",
            //         menu->items[i].label);
            draw_outlined_text(offscreen, font_menu, menu->items[i].label, 20,
                               20 + (text_h * 2) + (i * text_h), 7, 39);
        }
        else
        {
            //text_mode(254);
            //textprintf(offscreen, font_menu, 20,
            //         20 + (height * 2) + (i * height), 32, "%s",
            //         menu->items[i].label);
            draw_outlined_text(offscreen, font_menu, menu->items[i].label, 20,
                               20 + (text_h * 2) + (i * text_h), 12, 255);
        }
    }

    //vline(offscreen, 15, 20, 40 + (menu->num_items * 10) - 3, 32);

    #if 0
    //for (i= 20; i < (height * 2) + (menu->num_items * height) - 3; i++)
    for (i= 20; i < 20 + (height * 2) + (menu->num_items * height); i++)
    {
        if (i % 2 == 0) putpixel(offscreen, 15, i, 40);
    }
    #endif

} /* end draw_menu */




void draw_outlined_text(BITMAP *bmp, const FONT *f, const char *s, int x, int y,
                        int outline_color, int fill_color)
{

    /* outline */
    textout(bmp, f, s, x - 1, y, outline_color);
    textout(bmp, f, s, x + 1, y, outline_color);
    textout(bmp, f, s, x, y - 1, outline_color);
    textout(bmp, f, s, x, y + 1, outline_color);
    /* fill */
    textout(bmp, f, s, x, y, fill_color);
}




void draw_player(const Player *const player)
{

    //printf("draw_player enter\n");

    #if 0
    /* determine appropriate sprite */
    BITMAP *sprite= (BITMAP *)
                    ((DATAFILE *)
                        ((DATAFILE *)
                            ((DATAFILE *)
                                manager.sprite_datafile[SPR_PLA].dat)
                                [player->anim_index_1].dat)
                                [player->anim_index_2].dat)
                                [player->anim_index_3].dat;

    /* if the player's heading left, flip his image */
    if (player->entity->heading_x < 0)
    {
        draw_sprite_h_flip(buffer, sprite, player->entity->screen_x,
                           player->entity->screen_y);
    }

    /* else draw as normal */
    else
    {
        draw_sprite(buffer, sprite, player->entity->screen_x,
                    player->entity->screen_y);
    }
    #endif

    //printf("player->current_anim_frame == %p\n",
    //  player->entity->current_anim_frame);

    //printf("player sprite == %p\n",
    //  player->entity->current_anim_frame.bitmap);

    /* if the player's heading left, flip his image */
    if (player->entity->heading_x < 0)
    {
        draw_sprite_h_flip(offscreen, player->entity->anim_frame,
                           player->entity->x, player->entity->y);
    }

    /* else draw as normal */
    else
    {
        draw_sprite(offscreen, player->entity->anim_frame,
                    player->entity->x, player->entity->y);
    }

    //printf("draw_player exit\n");

} /* end draw_player */




void draw_projectile(const Projectile *const projectile)
{

    /* if the projectile's heading left, flip its image */
    if (projectile->entity->heading_x < 0)
    {
        draw_sprite_h_flip(offscreen, projectile->entity->anim_frame,
                           projectile->entity->x, projectile->entity->y);
    }

    /* else draw as normal */
    else
    {
        draw_sprite(offscreen, projectile->entity->anim_frame,
                    projectile->entity->x, projectile->entity->y);
    }

} /* end draw_projectile */




void draw_status_bar(const Map *const map)
{

    unsigned char i;
    BITMAP *bmp;

    rectfill(offscreen, 0, 0, offscreen->w - 1, 15, 1);
    text_mode(-1);

    /* player score and lives */
    if (map->player != 0)
    {

        textprintf(offscreen, font_ingame, 20,
                   (map->t_height / 2) - (text_height(font_ingame) / 2), 32,
                   "score %010u", map->player->score);

        bmp=
            (BITMAP *)
            ((DATAFILE *) manager.sprite_datafile[SPRITE_DATA_MISC].dat)
                          [SPRITE_DATA_MISC_LIFE].dat;

        for (i= 0; i < map->player->num_lives; i++)
        {
            blit(bmp, offscreen, 0, 0, 275 + (i * bmp->w),
                 (map->t_height / 2) - (bmp->h / 2), bmp->w, bmp->h);
        }

    }

    /* time limit */
    if (map->time_limit > 1000 || map->time_limit % 10 < 5)
    {
        textprintf(offscreen, font_ingame, 170,
                   (map->t_height / 2) - (text_height(font_ingame) / 2), 32,
                   "time %05u", map->time_limit - (map->time_limit % 10));
    }

} /* end draw_status_bar */




void draw_text(int x, int y, int color, unsigned char center, const char *str)
{
    if (center) textout_centre(offscreen, font, str, x, y, color);
    else textout(offscreen, font, str, x, y, color);
}




void draw_tile(const Tile *const tile)
{

    #if 0
    /* determine appropriate sprite */
    BITMAP *sprite= (BITMAP *)
                    ((DATAFILE *)
                        ((DATAFILE *)
                            manager.sprite_datafile[SPR_MAP].dat)[
                            tile->anim_index_1].dat)[
                            tile->anim_index_2].dat;

    draw_sprite(buffer, sprite, screen_x, screen_y);
    #endif

    //draw_sprite(offscreen, tile->anim_frame, tile->x, tile->y);
    blit(tile->anim_frame, offscreen, 0, 0, tile->x, tile->y,
         tile->anim_frame->w, tile->anim_frame->h);

}




void draw_to_screen(const unsigned char draw_mouse)
{

    if (manager.fps_counter == 0)
    {
        if (manager.fps_average == 0.0)
        {
            manager.fps_average= manager.fps_aggregate;
        }
        else
        {
            manager.fps_average=
                (manager.fps_average + manager.fps_aggregate) / 2;
        }
    }
    ++manager.fps_counter;

    acquire_screen();
    if (manager.use_vsync) vsync();
    show_mouse(0);
    //if (draw_mouse)
    //{
    //  draw_sprite(offscreen, mouse_sprite, mouse_x - mouse_x_focus,
    //              mouse_y - mouse_y_focus);
    //}
    //blit(offscreen, screen, 0, 0, 0, 0, offscreen->w, offscreen->h);
    stretch_blit(offscreen, screen, 0, 0, offscreen->w, offscreen->h, 0, 0,
                 screen->w, screen->h);
    if (draw_mouse) show_mouse(screen);
    release_screen();

} /* end draw_to_screen */



#if 0
void draw_to_screen_me(const unsigned char draw_mouse, DIALOG *d1, DIALOG *d2)
{

    int obj;

    if (manager.fps_counter == 0)
    {
        if (fps_average == 0.0) fps_average= fps_aggregate;
        else fps_average= (fps_average + fps_aggregate) / 2;
    }
    ++fps_counter;

    acquire_screen();
    //vsync();
    //show_mouse(0);
    //if (draw_mouse)
    //{
    //  draw_sprite(offscreen, mouse_sprite, mouse_x - mouse_x_focus,
    //              mouse_y - mouse_y_focus);
    //}
    blit(offscreen, screen, 0, 0, 0, 0, offscreen->w, offscreen->h);
    //stretch_blit(offscreen, screen, 0, 0, 0, 0, offscreen->w, offscreen->h);
    if (draw_mouse) show_mouse(screen);

    //dialog_message(d1, MSG_DRAW, 0, &obj);
    //dialog_message(d2, MSG_DRAW, 0, &obj);

    //release_screen();
//vsync();
    dialog_message(d1, MSG_DRAW, 0, &obj);
//vsync();
    dialog_message(d2, MSG_DRAW, 0, &obj);

    release_screen();

} /* end draw_to_screen */
#endif



unsigned char init_video(const unsigned short offscreen_w,
                         const unsigned short offscreen_h)
{

    write_to_log(manager.log, 0, "Initializing video.\n");

    offscreen= create_bitmap(offscreen_w, offscreen_h);
    if (offscreen == 0)
    {
        write_to_log(manager.log, 1, "Could not create offscreen buffer.\n");
        return 1;
    }
    clear_to_color(offscreen, 254);

    manager.sprite_datafile= load_datafile(SPRITE_DAT_FILENAME);
    if (manager.sprite_datafile == 0)
    {
        write_to_log(manager.log, 1,
                     "Could not load graphics data, \"%s\".\n",
                     SPRITE_DAT_FILENAME);
        return 1;
    }

    if (attempt_gfx_mode() > 0) return 1;

    //kickle_pal= (PALETTE *) manager.sprite_datafile[SPRITE_DATA_PAL].dat;
    //set_palette(*kickle_pal);

    #if 0
    font_ingame=
        (FONT *)
        ((DATAFILE *) manager.sprite_datafile[SPRITE_DATA_FONTS].dat)
        [SPRITE_DATA_FONTS_INGAME].dat;
    #endif

    font_ingame= font;

    #if 0
    font_menu=
        (FONT *)
        ((DATAFILE *) manager.sprite_datafile[SPRITE_DATA_FONTS].dat)
        [SPRITE_DATA_FONTS_MENU].dat;
    #endif

    font_menu= font;

    return 0;

} /* end init_video */




void show_game_over(const unsigned int player_score)
{

    unsigned short str1_center;
    unsigned short str2_center;
    unsigned short str3_center;

    char *str1;
    char *str2;
    char str3[17];

    str1= "You are beaten, sob, sob.";
    str2= "GAME OVER";
    sprintf(str3, "score %010u", player_score);

    str1_center= (offscreen->w / 2) - (text_length(font_ingame, str1) / 2);
    str2_center= (offscreen->w / 2) - (text_length(font_ingame, str2) / 2);
    str3_center= (offscreen->w / 2) - (text_length(font_ingame, str3) / 2);

    clear_to_color(offscreen, 12);
    text_mode(-1);

    /* sob, sob */
    draw_outlined_text(offscreen, font_ingame, str1, str1_center,
                       (offscreen->h / 2) - 40, 2, 33);

    /* game over */
    draw_outlined_text(offscreen, font_ingame, str2, str2_center,
                       offscreen->h / 2, 7, 39);

    /* score */
    draw_outlined_text(offscreen, font_ingame, str3, str3_center,
                       (offscreen->h / 2) + 40, 2, 33);

    draw_to_screen(0);

} /* end show_game_over */




void show_help1(void)
{

    char *str[]= { "Help Kickle rescue the Somethings-or",
                   "Others stuck in red bags. Collect all",
                   "on each level to proceed to the next",
                   "one.",
                   "These bags are often located across",
                   "gaps in the ice.",
                   "Kickle has two powers to help him cross",
                   "these gaps." };

    unsigned char height;

    unsigned char i;

    clear_to_color(offscreen, 11);
    text_mode(-1);

    height= text_height(font_ingame) + 4;

    for (i= 0; i < 8; i++)
    {
        draw_outlined_text(offscreen, font_ingame, str[i], 5, 5 + (i * height),
                           1, 17);
    }

    draw_to_screen(0);

} /* end show_help1 */




void show_help2(void)
{

    char *str[]= { "He can freeze the round, blue baddies",
                   "with his ice breath (left Alt by",
                   "default), turning the baddies into ice",
                   "cubes.  Kickle can then kick these",
                   "cubes into the water (left Alt again",
                   "while standing next to the ice cube).",
                   "When a cube lands in the water, it",
                   "becomes ice." };

    unsigned char height;

    unsigned char i;

    clear_to_color(offscreen, 11);
    text_mode(-1);

    height= text_height(font_ingame) + 4;

    for (i= 0; i < 8; i++)
    {
        draw_outlined_text(offscreen, font_ingame, str[i], 5, 5 + (i * height),
                           1, 17);
    }

    draw_to_screen(0);

} /* end show_help2 */




void show_help3(void)
{

    char *str[]= { "Kickle can also create ice pillars",
                   "(left Ctrl by default).  He can use",
                   "these to stop kicked ice cubes.  Using",
                   "pillars Kickle can then control the",
                   "movement of a kicked cube.",
                   "But kickle can only create a pillar",
                   "on ice." };

    unsigned char height;

    unsigned char i;

    clear_to_color(offscreen, 11);
    text_mode(-1);

    height= text_height(font_ingame) + 4;

    for (i= 0; i < 7; i++)
    {
        draw_outlined_text(offscreen, font_ingame, str[i], 5, 5 + (i * height),
                           1, 17);
    }

    draw_to_screen(0);

} /* end show_help3 */




void show_help4(void)
{

    char *str[]= { "Kickle can freeze other baddies, too,",
                   "but when he kicks them, they will",
                   "shatter.",
                   "Written by Drew Willcoxon in 2004.",
                   "http://www.cs.uga.edu/~adw/",
                   "dripfeed@uga.edu",
                   "Graphics and level designs are taken",
                   "from Kickle Cubicle",
                   "by Irem." };

    unsigned char height;

    unsigned char i;

    clear_to_color(offscreen, 11);
    text_mode(-1);

    height= text_height(font_ingame) + 4;

    for (i= 0; i < 3; i++)
    {
        draw_outlined_text(offscreen, font_ingame, str[i], 5, 5 + (i * height),
                           1, 17);
    }

    for (i= 3; i < 6; i++)
    {
        draw_outlined_text(offscreen, font_ingame, str[i], 5, 25 + (i * height),
                           1, 17);
    }

    for (i= 6; i < 9; i++)
    {
        draw_outlined_text(offscreen, font_ingame, str[i], 5, 40 + (i * height),
                           1, 17);
    }

    draw_to_screen(0);

} /* end show_help4 */




void show_won1(void)
{

    char *str[]= { "Good job.",
                   "You've beaten the game,",
                   "what little there is of it so far.",
                   "I wish there were a cutscene",
                   "or something here.",
                   "So do you, probably.",
                   "Sorry.",
                   "Maybe next time.",
                   "But at least you get a fancy",
                   "background color change from the",
                   "Game Over screen."};

    unsigned char i;

    unsigned char height;

    clear_to_color(offscreen, 8);
    text_mode(-1);

    height= text_height(font_ingame) + 8;

    for (i= 0; i < 11; i++)
    {
        draw_outlined_text(offscreen, font_ingame, str[i],
                           (offscreen->w / 2)
                           - (text_length(font_ingame, str[i]) / 2),
                           (i * height) + 20, 7, 39);
    }

    draw_to_screen(0);

} /* end show_won1 */




void show_won2(const unsigned int player_score)
{

    char *str[]= { "Visit the game's homepage at",
                   "http://www.cs.uga.edu/~adw/",
                   "for (possible) updates and info.",
                   "Written by",
                   "Drew Willcoxon in 2004.",
                   "Kickle Cubicle by Irem.",
                   "Thanks for playing." };

    char str2[17];

    unsigned char i;

    unsigned char height;

    sprintf(str2, "score %010u", player_score);

    clear_to_color(offscreen, 8);
    text_mode(-1);

    height= text_height(font_ingame) + 8;

    for (i= 0; i < 3; i++)
    {
        draw_outlined_text(offscreen, font_ingame, str[i],
                           (offscreen->w / 2)
                           - (text_length(font_ingame, str[i]) / 2),
                           (i * height) + 20, 7, 39);
    }

    for (i= 3; i < 6; i++)
    {
        draw_outlined_text(offscreen, font_ingame, str[i],
                           (offscreen->w / 2)
                           - (text_length(font_ingame, str[i]) / 2),
                           (i * height) + 40, 7, 39);
    }

    draw_outlined_text(offscreen, font_ingame, str[6],
                       (offscreen->w / 2)
                       - (text_length(font_ingame, str[6]) / 2),
                       (i * height) + 60, 7, 39);

    draw_outlined_text(offscreen, font_ingame, str2,
                       (offscreen->w / 2)
                       - (text_length(font_ingame, str2) / 2),
                       offscreen->h - height - 20, 2, 33);

    draw_to_screen(0);

} /* end show_won2 */




void take_screenshot(void)
{

    unsigned short i;

    char *filename=
        (char *) malloc(sizeof(char) * (strlen(SCREENSHOT_BASE) + 10));

    if (filename == 0)
    {
        write_to_log(manager.log, 1,
                     "Screenshot attempted but could not be saved because filename string could not be allocated.\n");
        return;
    }

    i= 0;
    sprintf(filename, "%s%i.%s", SCREENSHOT_BASE, i, SCREENSHOT_EXT);

    while (exists(filename))
    {
        ++i;
        sprintf(filename, "%s%i.%s", SCREENSHOT_BASE, i, SCREENSHOT_EXT);
    }

    if (save_bitmap(filename, offscreen, *kickle_pal) == 0)
    {
        write_to_log(manager.log, 0, "Screenshot saved to \"%s\".\n", filename);
    }
    else
    {
        write_to_log(manager.log, 1,
                     "Screenshot attempted but could not be saved.  Attempted to save to \"%s\".\n",
                     filename);
    }

    free(filename);

} /* end take_screenshot */




void uninit_video(void)
{

    write_to_log(manager.log, 0, "Uninitializing video components.\n");

    if (offscreen != 0) destroy_bitmap(offscreen);
    if (manager.sprite_datafile != 0) unload_datafile(manager.sprite_datafile);

}
