/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _TPROJCTL_H_
#define _TPROJCTL_H_


#include "tentity.h"


typedef enum                                /* PROJECTILE TYPES */
{

    PROJECTILE_T_ICE_BREATH                 /* player's ice breath */

} projectile_type;


typedef enum                                /* PROJECTILE STATUSES */
{

    PROJECTILE_S_STOPPED,
    PROJECTILE_S_MOVING,
    PROJECTILE_S_KAPUT

} projectile_status;


typedef struct                              /* PROJECTILE DEFINITION */
{

    Entity *entity;

    projectile_type type;                   /* type of projectile */

    projectile_status status;

    unsigned char life;                     /* number of tiles projectile can
                                               cross before it dies a natural
                                               death */

    unsigned char *player_num_breaths_ptr;  /* pointer to the char which holds
                                               the number of ice breaths the
                                               player is currently using; used
                                               for ice breath projectiles */

} Projectile;


#endif
