/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _TPLAYER_H_
#define _TPLAYER_H_


#include "tentity.h"


typedef enum                            /* PLAYER STATUSES */
{

    PLAYER_S_STOPPED,
    PLAYER_S_MOVING,
    PLAYER_S_BREATHING,
    PLAYER_S_KICKING,
    PLAYER_S_PILLARING,
    PLAYER_S_DYING,
    PLAYER_S_WON,
    PLAYER_S_IDLE,
    PLAYER_S_KAPUT

} player_status;


typedef struct                          /* PLAYER DEFINITION */
{

    Entity *entity;                     /* a player is an entity */

    player_status status;

    unsigned char num_breaths;          /* number of ice breaths player is
                                           currently using */

    unsigned char max_num_breaths;      /* maximum number of ice breaths the
                                           player can use simultaneously */

    unsigned char breath_speed;         /* the speed at which the player's ice
                                           breath moves */

    unsigned char breath_life;          /* the projectile life of the player's
                                           ice breaths */

    unsigned char kick_speed;           /* the speed at which an ice block moves
                                           when the player kicks it */

    unsigned char num_lives;            /* number of lives the player has
                                           remaining */

    unsigned int score;                 /* player's points */

} Player;


#endif
