/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _TMAP_H_
#define _TMAP_H_


#include <limits.h>

#include <allegro.h>

#include "list.h"
#include "tbaddie.h"
#include "tfeature.h"
#include "tgoodie.h"
#include "tplayer.h"
#include "tprojctl.h"


typedef enum                                /* MAP TILE TYPES */
{

    TILE_T_WATER,                           /* water */
    TILE_T_ICE                              /* ice */

} tile_type;


typedef struct                              /* MAP TILE DEFINITION */
{

    tile_type type;                         /* the tile's type */

    signed short x;                         /* horizontal screen location */
    signed short y;                         /* vertical screen location */

    unsigned char anim_index;               /* indicates the sprite/animation
                                               within the map sprite/animation
                                               datafile to use for the tile */

    BITMAP *anim_frame;
    unsigned short anim_counter;

} Tile;


typedef struct                              /* MAP DEFINITION */
{

    char *name;                             /* the map's name -- MAY BE NULL */
    char *author;                           /* the map's designer -- MAY BE
                                               NULL */

    Tile **tiles;                           /* the tiles of the map */

    Player *player;                         /* the map's player */
    List *baddie_list;
    List *goodie_list;
    List *feature_list;
    List *projectile_list;

    List *point_list;

    unsigned char m_height;                 /* number of rows in the map */
    unsigned char m_width;                  /* number of columns in the map */

    unsigned char t_height;                 /* height of map's tiles in
                                               pixels */

    unsigned char t_width;                  /* width of map's tiles in pixels */

    unsigned short time_limit;              /* map's time limit, in seconds */

    unsigned char cornering_grace_w;        /* the width of a tile (in pixels)
                                               the player must step before he
                                               is allowed to move up or down
                                               beyond the tile --
                                               0 <= cornering_grace_w
                                                 <  tile_width */

    unsigned char cornering_grace_h;        /* analogous to
                                               cornering_grace_w */

} Map;


#endif
