/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _TFEATURE_H_
#define _TFEATURE_H_


#include "list.h"
#include "tentity.h"


typedef enum                            /* MAP FEATURE TYPES */
{

    FEATURE_T_PILLAR,
    FEATURE_T_BUMPER,
    FEATURE_T_HIVE,
    FEATURE_T_POW,
    FEATURE_T_SPRING,
    FEATURE_T_HOLE,
    FEATURE_T_BLACK_ICE

} feature_type;


typedef enum                            /* MAP FEATURE STATUSES */
{

    FEATURE_S_NORMAL,
    FEATURE_S_SPAWNING,
    FEATURE_S_SPRINGING,
    FEATURE_S_KAPUT

} feature_status;


typedef struct                          /* MAP FEATURE DEFINITION */
{

    Entity *entity;                     /* feature's entity */

    feature_type type;                  /* feature's type */

    feature_status status;

    #if 0
    unsigned char *baddie_types;        /* for hives, the types of baddies
                                           which need to be spawned */

    unsigned short max_num_baddies;     /* for hives, the maximim number of
                                           baddies which may wait at one time
                                           to be spawned */
    #endif

    List *baddie_types;

} Feature;


#endif
