/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _TENTITY_H_
#define _TENTITY_H_


#include <allegro.h>


typedef struct                          /* ENTITY DEFINITION */
{

    //unsigned char status;             /* logic status */

    unsigned short p_width;             /* the entity's width in pixels */
    unsigned short p_height;            /* the entity's height in pixels */

    //unsigned char t_width;                /* the entity's width in tiles */
    //unsigned char t_height;               /* the entity's height in tiles */

    signed short bb_x;                  /* the horizontal location of the
                                           leftmost pixel of the entity's
                                           bounding box */

    signed short bb_y;                  /* the vertical location of the
                                           topmost pixel of the entity's
                                           bounding box */

    unsigned short bb_p_width;          /* entity's bounding box width in
                                           pixels */

    unsigned short bb_p_height;         /* entity's bounding box height in
                                           pixels */

    unsigned short bb_t_width;          /* entity's bounding box width in
                                           map tiles */

    unsigned short bb_t_height;         /* entity's bounding box height in
                                           map tiles */

    unsigned char row;                  /* the topmost map row which the entity
                                           *completely* occupies */

    unsigned char col;                  /* the leftmost map column which the
                                           entity *completely* occupies */

    signed short x;                     /* the horizontal location of the
                                           leftmost pixel of the entity's
                                           sprite */

    signed short y;                     /* the vertical location of the topmost
                                           pixel of the entity's sprite */

    unsigned char dx;                   /* horizontal change in screen location
                                           (in pixels) */

    unsigned char dy;                   /* vertical change in screen location
                                           (in pixels) */

    signed char heading_x;              /* horizontal component of the heading
                                           unit vector; -1 indicates facing
                                           left, 1 facing right */

    signed char heading_y;              /* vertical component of the heading
                                           unit vector; -1 indicates facing up,
                                           1 facing down */

    signed char l_heading_x;
    signed char l_heading_y;

    unsigned char c_speed;              /* number of pixels entity currently
                                           moves with each step */

    unsigned char n_speed;              /* number of pixels entity normally
                                           moves with each step */

    unsigned short logic_counter;       /* counter available for logic use */

    unsigned short anim_counter;        /* counter available for animation
                                           use */


    unsigned char anim_frame_counter;
    unsigned short anim_play_counter;


    BITMAP *anim_frame;                 /* current frame of animation */

    //unsigned char status_row;
    //unsigned char status_col;

} Entity;


#endif
