/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _TBADDIE_H_
#define _TBADDIE_H_


#include "tentity.h"
#include "tfeature.h"


typedef enum                            /* BADDIE TYPES */
{

    BADDIE_T_BADDIE1,                   /* Noggles */
    BADDIE_T_BADDIE2,                   /* Max */
    BADDIE_T_BADDIE3,                   /* Mr. Hoople */
    BADDIE_T_BADDIE4,                   /* Rocky */
    BADDIE_T_BADDIE5                    /* Spiny */

} baddie_type;


typedef enum                            /* BADDIE STATUSES */
{

    BADDIE_S_STOPPED,
    BADDIE_S_FROZEN,
    BADDIE_S_MELTING,
    BADDIE_S_KICKED,
    BADDIE_S_KICKED_MELTING,
    BADDIE_S_MOVING,
    BADDIE_S_SINKING,
    BADDIE_S_SHATTERING,
    BADDIE_S_STEAMROLLED,
    BADDIE_S_NEW_ICE,
    BADDIE_S_SPAWNING,
    BADDIE_S_KICKING,
    BADDIE_S_KAPUT

} baddie_status;


typedef struct                          /* BADDIE DEFINITION */
{

    Entity *entity;                     /* a baddie is an entity */

    baddie_type type;                   /* type of baddie */

    baddie_status status;

    unsigned short frozen_time;         /* number of logic ticks for which
                                           baddie remains frozen */

    unsigned short frozen_counter;      /* number of logic ticks which have
                                           elapsed since baddie was frozen */

    unsigned short steamroll_points;    /* points awarded to the player for
                                           steamrolling the baddie */

    unsigned short shatter_points;      /* points awarded to the player for
                                           shattering the baddie */

    Feature *hive;                      /* points to the hive which spawned
                                           baddie; null if none */

    unsigned char num_goodies_hit;      /* used if the baddie is a kicked ice
                                           block; keeps track of the number of
                                           non-bag goodies collided with, for
                                           points purposes */

    unsigned char kicked_by_player;     /* positive if the baddie (baddie1) was
                                           kicked by the player */


} Baddie;


#endif
