/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _PROJCTL_H_
#define _PROJCTL_H_


#include "tbaddie.h"
#include "tfeature.h"
#include "tmap.h"
#include "tprojctl.h"


Projectile *construct_projectile(const projectile_type type,
                                 const unsigned char row,
                                 const unsigned char col,
                                 const signed char heading_x,
                                 const signed char heading_y,
                                 Map *const map);


void destruct_projectile(Projectile *projectile);


void do_projectile_logic(Projectile *const projectile, Map *const map,
                         const signed short target_row,
                         const signed short target_col);


void do_projectile_square_logic(Projectile *const projectile,
                                Map *const map,
                                const signed short target_row,
                                const signed short target_col);


void do_projectile_to_baddie(Projectile *const projectile, const Map *const map,
                             Baddie *const baddie);


void do_projectile_to_feature(Projectile *const projectile,
                              const Map *const map, Feature *const feature);


void do_projectile_to_tile(Projectile *const projectile, const Map *const map,
                           const unsigned char row, const unsigned char col);


void find_projectile_to_baddie(Projectile *const projectile,
                               const Map *const map);


void find_projectile_to_feature(Projectile *const projectile,
                                const Map *const map);


void find_projectile_to_tile(Projectile *const projectile,
                             const Map *const map);


void projectile_anim_done(Projectile *const projectile);


unsigned char projectile_baddie_coll(const projectile_type p_type,
                                     const projectile_status p_status,
                                     const baddie_type b_type,
                                     const baddie_status b_status);


unsigned char projectile_feature_coll(const projectile_type p_type,
                                      const projectile_status p_status,
                                      const feature_type f_type,
                                      const feature_status f_status);


unsigned char projectile_tile_coll(const projectile_type p_type,
                                   const projectile_status p_status,
                                   const tile_type t_type);


#endif
