/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _PLAYER_H_
#define _PLAYER_H_


#include "tbaddie.h"
#include "tfeature.h"
#include "tgoodie.h"
#include "tmap.h"
#include "tplayer.h"


Player *clone_player(const Player *const player, Map *const map,
                     const unsigned char row, const unsigned char col);


Player *construct_player(const unsigned char row, const unsigned char col,
                         const signed char heading_x,
                         const signed char heading_y,
                         const player_status status, Map *const map);


void destruct_player(Player *player);


void do_breath(Player *const player, Map *const map);


void do_pillar(Player *const player, Map *const map);


void do_player_logic(Player *const player, Map *const map);


void do_player_to_baddie(Player *const player, const Map *const map,
                         const Baddie *const baddie);


void do_player_to_feature(Player *const player, const Map *const map,
                          const Feature *const feature);


void do_player_to_goodie(Player *const player, const Map *const map,
                         Goodie *const goodie);


void do_player_to_tile(Player *const player, const Map *const map,
                       const unsigned char row, const unsigned char col);


void find_player_to_baddie(Player *const player, const Map *const map);


void find_player_to_feature(Player *const player, const Map *const map);


void find_player_to_goodie(Player *const player, const Map *const map);


void find_player_to_tile(Player *const player, const Map *const map);


void move_player_down(Player *const player, const Map *const map);


void move_player_left(Player *const player, const Map *const map);


void move_player_right(Player *const player, const Map *const map);


void move_player_up(Player *const player, const Map *const map);


void player_anim_done(Player *const player);


unsigned char player_baddie_coll(const player_status p_status,
                                 const baddie_type b_type,
                                 const baddie_status b_status);


/**
 * Returns a positive number if a player with status player_status collides
 * with a feature of the specified type and status.  Returns 0 otherwise.
 */
unsigned char player_feature_coll(const player_status p_status,
                                  const feature_type f_type,
                                  const feature_status f_status);


unsigned char player_goodie_coll(const player_status p_status,
                                 const goodie_type g_type,
                                 const goodie_status g_status);


unsigned char player_tile_coll(const player_status p_status,
                               const tile_type t_type);


void set_player_status(Player *const player, player_status status,
                       const Map *const map);


#endif
