/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _MENU_H_
#define _MENU_H_


typedef struct
{

    char *label;                        /* the item's label */

} Menu_item;


struct Menu
{

    unsigned short num_items;           /* number of items in the menu */

    unsigned short hilite_index;        /* index in the items array of the
                                           currently hilighted item */

    Menu_item *items;                   /* array of menu items */

    char *title;                        /* menu's title */

    /* the function handling the menu's events */
    //void(*menu_handler)(const struct type_menu *const menu);

};


typedef struct Menu Menu;


#if 0
type_menu *construct_menu(char *const title, unsigned short num_items,
                          char *labels[],
                          void (*menu_handler)(const type_menu *const menu));
#endif

Menu *construct_menu(char *const title, unsigned short num_items,
                     char *labels[]);


/**
 * Decrements the index of the currently hilighted item, wrapping around to the
 * last item if necessary.
 */
void dec_hilite_index(Menu *const menu);


void destruct_menu(Menu *menu);


/**
 * Increments the index of the currently hilighted item, wrapping around to the
 * first item if necessary.
 */
void inc_hilite_index(Menu *const menu);


void set_item_label(Menu *const menu, unsigned short item_index,
                    char *const label);


#endif
