/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "menu.h"



#if 0
type_menu *construct_menu(char *const title, unsigned short num_items,
                          char *labels[],
                          void (*menu_handler)(const type_menu *const menu))
{

    unsigned short i;

    /* allocate menu memory */
    type_menu *menu= (type_menu *) malloc(sizeof(type_menu));
    if (menu == 0) return 0;

    /* title */
    if (title != 0)
    {

        menu->title= (char *) malloc(sizeof(char) * (strlen(title) + 1));
        if (menu->title == 0)
        {
            destruct_menu(menu);
            return 0;
        }

        strcpy(menu->title, title);

    }
    else menu->title= 0;

    /* allocate items array memory */
    menu->items= (type_menu_item *) malloc(sizeof(type_menu_item) * num_items);
    if (menu->items == 0)
    {
        destruct_menu(menu);
        return 0;
    }

    /* setup the items */
    for (i= 0; i < num_items; i++)
    {

        menu->items[i].label=
            (char *) malloc(sizeof(char) * (strlen(labels[i]) + 1));

        if (menu->items[i].label == 0)
        {
            destruct_menu(menu);
            return 0;
        }

        strcpy(menu->items[i].label, labels[i]);

    }

    /* other members */
    menu->menu_handler= menu_handler;
    menu->num_items= num_items;
    menu->hilite_index= 0;

    return menu;

} /* end construct_menu */
#endif



Menu *construct_menu(char *const title, unsigned short num_items,
                     char *labels[])
{

    unsigned short i;

    /* allocate menu memory */
    Menu *menu= (Menu *) malloc(sizeof(Menu));
    if (menu == 0) return 0;

    /* title */
    if (title != 0)
    {

        menu->title= (char *) malloc(sizeof(char) * (strlen(title) + 1));
        if (menu->title == 0)
        {
            destruct_menu(menu);
            return 0;
        }

        strcpy(menu->title, title);

    }
    else menu->title= 0;

    /* allocate items array memory */
    menu->items= (Menu_item *) malloc(sizeof(Menu_item) * num_items);
    if (menu->items == 0)
    {
        destruct_menu(menu);
        return 0;
    }

    /* setup the items */
    for (i= 0; i < num_items; i++)
    {

        menu->items[i].label=
            (char *) malloc(sizeof(char) * (strlen(labels[i]) + 1));

        if (menu->items[i].label == 0)
        {
            destruct_menu(menu);
            return 0;
        }

        strcpy(menu->items[i].label, labels[i]);

    }

    /* other members */
    menu->num_items= num_items;
    menu->hilite_index= 0;

    return menu;

} /* end construct_menu */




void dec_hilite_index(Menu *const menu)
{
    if (menu->hilite_index == 0) menu->hilite_index= menu->num_items - 1;
    else --menu->hilite_index;
}




void destruct_menu(Menu *menu)
{

    unsigned short i;

    if (menu->items != 0)
    {

        for (i= 0; i < menu->num_items; i++)
        {
            free(menu->items[i].label);
        }

        free(menu->items);

    }

    free(menu->title);
    free(menu);

}




void inc_hilite_index(Menu *const menu)
{
    if (menu->hilite_index == menu->num_items - 1) menu->hilite_index= 0;
    else ++menu->hilite_index;
}




void set_item_label(Menu *const menu, unsigned short item_index,
                    char *const label)
{

    free(menu->items[item_index].label);

    menu->items[item_index].label=
        (char *) malloc(sizeof(char) * (strlen(label) + 1));

    if (menu->items[item_index].label != 0)
        strcpy(menu->items[item_index].label, label);

}
