/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _MAP_H_
#define _MAP_H_

#include <allegro.h>

#include "baddie.h"


#define MAP_DAT_FILENAME    "maps.dat"
#define NUM_MAPS            17


#define X_TO_COL(x, map)    (x / (map)->t_width)
#define Y_TO_ROW(y, map)    ((y / (map)->t_height) - 1)

#define COL_TO_X(col, map)  (col * (map)->t_width)
#define ROW_TO_Y(row, map)  ((row + 1) * (map)->t_height)


/* map-playing statuses */
typedef enum
{
    MAP_S_PLAYING,
    MAP_S_QUIT,
    MAP_S_WON,
    MAP_S_TIME_UP,
    MAP_S_KILLED            /* player collides with baddie */
} map_status;


unsigned char add_baddie_to_map(Baddie *const baddie, Map *const map,
                                const unsigned char row,
                                const unsigned char col);


unsigned char add_feature_to_map(Feature *const feature,  Map *const map,
                                 const unsigned char row,
                                 const unsigned char col);


unsigned char add_goodie_to_map(Goodie *const goodie, Map *const map,
                                const unsigned char row,
                                const unsigned char col);


void add_player_to_map(Player *const player, Map *const map,
                       const unsigned char row, const unsigned char col);


unsigned char add_projectile_to_map(Projectile *const projectile,
                                    Map *const map,
                                    const unsigned char row,
                                    const unsigned char col);


Baddie *baddie_on_tile(const Map *const map, const unsigned char row,
                       const unsigned char col, const unsigned char fudge_x,
                       const unsigned char fudge_y);


Map *clone_map(const Map *const map);


Tile *clone_tile(const Tile *const tile);


Map *construct_empty_map(const char *map_name, const char *author,
                         const unsigned char map_width,
                         const unsigned char map_height,
                         const unsigned char tile_width,
                         const unsigned char tile_height);


Map *construct_map_from_file(const char *filename,
                             const unsigned char compressed);


Tile *construct_tile(tile_type type, unsigned char anim_index);


void destruct_map(Map *map);


void destruct_tile(Tile *tile);


map_status do_map_logic(Map *const map);


Feature *feature_on_tile(const Map *const map, const unsigned char row,
                         const unsigned char col);


//void free_tile(Tile *tile);


Map *get_map(const unsigned short map_num);


Goodie *goodie_on_tile(const Map *const map, const unsigned char row,
                       const unsigned char col);


unsigned char is_tile_empty_baddie(const baddie_type type,
                                   const baddie_status status,
                                   const Map *const map,
                                   const unsigned char row,
                                   const unsigned char col);


unsigned char is_tile_empty_feature(const feature_type f_type,
                                    const Map *const map,
                                    const unsigned char row,
                                    const unsigned char col);


unsigned char is_tile_empty_goodie(const goodie_type g_type,
                                   const Map *const map,
                                   const unsigned char row,
                                   const unsigned char col);


unsigned char is_tile_empty_player(const player_status p_status,
                                   const Map *const map,
                                   const unsigned char row,
                                   const unsigned char col);


void make_new_ice(Map *const map, const unsigned char row,
                  const unsigned char col);


map_status play_map(Map *const map);


Player *player_on_tile(const Map *const map, const unsigned char row,
                       const unsigned char col, const unsigned char fudge_x,
                       const unsigned char fudge_y);


Projectile *projectile_on_tile(const Map *const map, const unsigned char row,
                               const unsigned char col,
                               const unsigned char fudge_x,
                               const unsigned char fudge_y);


void remove_baddie_from_map(Baddie *baddie, Map *const map);


void remove_feature_from_map(Feature *feature, Map *const map);


void remove_goodie_from_map(Goodie *goodie, Map *const map);


void remove_player_from_map(Map *const map);


void remove_projectile_from_map(Projectile *projectile, Map *const map);


void setup_tile(Tile *const tile, tile_type type, unsigned char anim_index);


unsigned char write_map_to_file(const Map *const map, const char *filename,
                                unsigned char compress);


#endif
