/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _MANAGER_H_
#define _MANAGER_H_


#include <allegro.h>

#include "controls.h"
#include "log.h"


typedef struct
{

    /* CONFIGURATIONS */

    unsigned char use_vsync;                    /* video configurations */
    unsigned char draw_always;
    unsigned char show_fps;
    unsigned char fullscreen;
    unsigned short screen_w;
    unsigned short screen_h;

    unsigned char use_balk;                     /* gameplay configurations */
    unsigned short balk_x;
    unsigned short balk_y;
    unsigned short bps;

    unsigned char old_fullscreen;
    unsigned short old_screen_w;
    unsigned short old_screen_h;

    /* TIMING */

    volatile signed int logic_counter;          /* controls logic cycle */
    volatile unsigned short beats_counter;      /* incremented each beat */
    volatile unsigned short fps_aggregate;      /* total number of frames drawn
                                                   in one second */
    volatile unsigned short fps_counter;        /* incremented each time a frame
                                                   is drawn */
    float fps_average;                          /* fps average */

    /* DEVELOPMENT/CHEATS */

    unsigned char ignore_time;
    unsigned char invincibility;


    DATAFILE *sprite_datafile;
    DATAFILE *map_datafile;

    Log *log;


    unsigned char editing;


    Controls controls;

} Manager;


#endif
