/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


/*
Wrappers for file routines needed to write a log.
*/


#ifndef LOG_H
#define LOG_H


#include <stdio.h>


/* a log is really just a file */
typedef FILE Log;


/**
 * Closes log.
 */
void close_log(Log *log);


/**
 * Opens the log at filename for writing and returns a pointer to it.  If
 * the file does not exist, it is created.  Otherwise, its contents are
 * cleared.
 */
Log *open_log(const char *filename);


/**
 * Writes the specified format string to log.  If is_error is postive, the log
 * will indicate that the string is an error message.  If is_error is 0, only
 * the string is written.
 */
void write_to_log(Log *log, unsigned char is_error, const char *format, ...);


#endif
