/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#include <stdarg.h>

#include "log.h"




void close_log(Log *log)
{
    if (log != 0) fclose(log);
}




Log *open_log(const char *filename)
{
    /* open the log for writing ("w") */
    return fopen(filename, "w");
}




void write_to_log(Log *log, unsigned char is_error, const char *format, ...)
{
    va_list args;
    if (is_error) fprintf(log, "\nERROR:  ");
    if (log != 0)
    {
        va_start(args, format);
        vfprintf(log, format, args);
        va_end(args);
        fflush(log);
    }
}
