/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _LIST_H_
#define _LIST_H_


struct List_node
{

    struct List_node *next;
    void *dat;
    unsigned char uc;

};


typedef struct List_node List_node;


typedef struct
{

    List_node *head;
    List_node *tail;

} List;


typedef List_node List_iterator;


List_node *append_to_list(List *const list, void *const dat, unsigned char uc);


List *construct_list(void);


List_node *construct_list_node(void *const dat, unsigned char uc);


void destruct_list(List *list);


void destruct_list_node(List_node *node);


List_iterator *get_iterator(const List *const list);


List_iterator *next_iterator(const List_iterator *const iterator);


void remove_from_list(List *const list, const void *const target_dat,
                      const unsigned char target_uc);


#endif
