/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#include <stdlib.h>

#include "list.h"




List_node *append_to_list(List *const list, void *const dat, unsigned char uc)
{

    if (list->head == 0)
    {
        list->head= construct_list_node(dat, uc);
        list->tail= list->head;
        return list->head;
    }

    else
    {
        list->tail->next= construct_list_node(dat, uc);
        list->tail= list->tail->next;
        return list->tail;
    }

}




List *construct_list(void)
{

    List *list= (List *) malloc(sizeof(List));
    if (list == 0) return 0;

    list->head= 0;
    list->tail= 0;

    return list;

}




List_node *construct_list_node(void *const dat, unsigned char uc)
{

    List_node *node= (List_node *) malloc(sizeof(List_node));
    if (node == 0) return 0;

    node->dat= dat;
    node->uc= uc;
    node->next= 0;

    return node;

}




void destruct_list(List *list)
{

    List_iterator *iterator1;
    List_iterator *iterator2;

    iterator1= get_iterator(list);

    while (iterator1 != 0)
    {
        iterator2= next_iterator(iterator1);
        destruct_list_node((List_node *) iterator1);
        iterator1= iterator2;
    }

}




void destruct_list_node(List_node *node)
{
    free(node);
}




List_iterator *get_iterator(const List *const list)
{
    return (List_iterator *) list->head;
}




List_iterator *next_iterator(const List_iterator *const iterator)
{
    return (List_iterator *) iterator->next;
}




void remove_from_list(List *const list, const void *const target_dat,
                      const unsigned char target_uc)
{

    List_iterator *iterator1;
    List_iterator *iterator2;

    iterator1= 0;
    iterator2= get_iterator(list);

    while (iterator2 != 0
           && (iterator2->dat != target_dat || iterator2->uc != target_uc))
    {
        iterator1= iterator2;
        iterator2= next_iterator(iterator2);
    }

    if (iterator2 != 0)
    {

        if (iterator1 == 0)
        {
            list->head= next_iterator(iterator2);
            if ((List_node *) iterator2 == list->tail) list->tail= 0;
        }
        else
        {
            iterator1->next= next_iterator(iterator2);
            if ((List_node *) iterator2 == list->tail)
                list->tail= (List_node *) iterator1;
        }

        destruct_list_node((List_node *) iterator2);

    }

} /* end remove */



#if 0
int main(void)
{

    int x1= 1;
    int x2= 2;
    int x3= 3;

    List_iterator *iterator;

    type_list *list= construct_list();

    append(list, &x1);
    append(list, &x2);
    append(list, &x3);

    iterator= get_iterator(list);
    while (iterator != 0)
    {
        printf("%i\n", *((int *) iterator->dat));
        iterator= next(iterator);
    }

    remove(list, &x2);

    iterator= get_iterator(list);
    while (iterator != 0)
    {
        printf("%i\n", *((int *) iterator->dat));
        iterator= next(iterator);
    }

    destruct_list(list);

    return 0;

}
#endif
