/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _GOODIE_H_
#define _GOODIE_H_


#include "tmap.h"
#include "tgoodie.h"
#include "tplayer.h"


Goodie *clone_goodie(const Goodie *const goodie, Map *const map,
                     const unsigned char row, const unsigned char col);


void collect_goodie(Goodie *const goodie, Player *const player,
                    const Map *const map, const unsigned char multiplier);


Goodie *construct_goodie(const goodie_type type, const unsigned char row,
                         const unsigned char col, const signed char heading_x,
                         const signed char heading_y,
                         const goodie_status status, Map *const map);


void destruct_goodie(Goodie *goodie);


void do_goodie_logic(Goodie *const goodie, Map *const map);


void do_goodie_to_player(Goodie *const goodie, const Map *const map,
                         Player *const player);


void find_goodie_to_player(Goodie *const goodie, const Map *const map);


void goodie_anim_done(Goodie *const goodie);


unsigned char goodie_baddie_coll(const goodie_type g_type,
                                 const baddie_type b_type,
                                 const baddie_status b_status);


unsigned char goodie_feature_coll(const goodie_type g_type,
                                  const feature_type f_type,
                                  const feature_status f_status);


unsigned char goodie_goodie_coll(const goodie_type active_type,
                                 const goodie_type passive_type);


unsigned char goodie_player_coll(const goodie_type g_type,
                                 const player_status p_status);


unsigned char goodie_tile_coll(const goodie_type g_type,
                               const tile_type t_type);


/**
 * Moves goodie one tile, trying first to move the goodie in the direction
 * specified.  If that's not possible, moves goodie to an another adjacent
 * tile.
 */
void move_goodie(Goodie *const goodie, const Map *const map,
                 unsigned char heading_x, unsigned char heading_y);


void set_goodie_status(Goodie *const goodie, goodie_status status);


#endif
