/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _FTEXT_H_
#define _FTEXT_H_


typedef struct                          /* FLOATING TEXT DEFINITION */
{

    char *str;                          /* the string displayed */

    unsigned short int x;               /* horizontal screen position */
    unsigned short int y;               /* vertical screen position */

    unsigned short int dx;              /* change in horizontal screen position
                                           per frame */

    unsigned short int dy;              /* change in vertical screen position
                                           per frame */

    unsigned short int ttl;             /* time to live */

    unsigned short int time;            /* number of frames for which the text
                                           has existed */

} Floating_text;


Floating_text *construct_floating_text(char *const str, unsigned short int x,
                                       unsigned short int y,
                                       unsigned short int dx,
                                       unsigned short int dy,
                                       unsigned short int ttl);


void destruct_floating_text(Floating_text *ftext);


unsigned char update_floating_text(Floating_text *const ftext);


#endif
