/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#include <stdlib.h>
#include <string.h>

#include "ftext.h"




Floating_text *construct_floating_text(char *const str, unsigned short int x,
                                       unsigned short int y,
                                       unsigned short int dx,
                                       unsigned short int dy,
                                       unsigned short int ttl)
{


    Floating_text *ftext=
        (Floating_text *) malloc(sizeof(Floating_text));

    if (ftext == 0) return 0;

    ftext->str= (char *) malloc(sizeof(char) * (strlen(str) + 1));
    if (ftext == 0) return 0;

    strcpy(ftext->str, str);

    ftext->x= x;
    ftext->y= y;
    ftext->dx= dx;
    ftext->dy= dy;
    ftext->ttl= ttl;

    ftext->time= 0;

    return ftext;

}




void destruct_floating_text(Floating_text *ftext)
{
    free(ftext->str);
    free(ftext);
    ftext= 0;
}




unsigned char update_floating_text(Floating_text *const ftext)
{

    ftext->x+= ftext->dx;
    ftext->y+= ftext->dy;

    ++ftext->time;

    if (ftext->time > ftext->ttl) return 1;

    return 0;

}
