/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _FEATURE_H_
#define _FEATURE_H_

#include "tfeature.h"
#include "tmap.h"


Feature *clone_feature(const Feature *const feature, Map *const map,
                       const unsigned char row, const unsigned char col);


Feature *construct_feature(const feature_type type, const unsigned char row,
                           const unsigned char col, const signed char heading_x,
                           const signed char heading_y,
                           const feature_status status, Map *const map);


void destruct_feature(Feature *feature);


void do_feature_logic(Feature *const feature, Map *const map);


void do_pow(Feature *const pow, Map *const map);


void feature_anim_done(Feature *const feature, Map *const map);


unsigned char feature_baddie_coll(const feature_type f_type,
                                  const baddie_type b_type,
                                  const baddie_status b_status);


unsigned char feature_feature_coll(const feature_type active_type,
                                   const feature_type passive_type);


unsigned char feature_goodie_coll(const feature_type f_type,
                                  const goodie_type g_type,
                                  const goodie_status g_status);


unsigned char feature_player_coll(const feature_type f_type,
                                  const player_status p_status);


unsigned char feature_tile_coll(const feature_type f_type,
                                const tile_type t_type);


/**
 * Notifies hive that it should spawn a baddie of type baddie_type.
 */
void notify_hive(Feature *const hive, const baddie_type b_type);


void set_feature_status(Feature *const feature, feature_status status);


#endif
