/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#include <limits.h>
#include <stdlib.h>

#include "baddie.h"
#include "entity.h"
#include "feature.h"
#include "list.h"
#include "log.h"
#include "manager.h"
#include "map.h"
#include "video.h"




/* the game's log file */
//extern type_log *manager.log;


extern Manager manager;



Feature *clone_feature(const Feature *const feature, Map *const map,
                       const unsigned char row, const unsigned char col)
{

    //unsigned short i;

    Feature *clone=
        construct_feature(feature->type, row, col, feature->entity->heading_x,
                          feature->entity->heading_y, feature->status,
                          map);

    if (clone == 0)
    {
        write_to_log(manager.log, 1, "Could not construct feature clone.\n");
        return 0;
    }

    // don't clone the baddie types array -- cloning it makes the hive spawn
    // baddies (when playing) which were removed from it during map editing
    //if (clone->type == FEATURE_T_HIVE && clone->baddie_types != 0
    //  && feature->baddie_types != 0)
    //{
    //  for (i= 0; i < clone->max_num_baddies; i++)
    //  {
    //      clone->baddie_types[i]= feature->baddie_types[i];
    //  }
    //}

    return clone;

} /* end clone_feature */




Feature *construct_feature(const feature_type type, const unsigned char row,
                           const unsigned char col, const signed char heading_x,
                           const signed char heading_y,
                           const feature_status status, Map *const map)
{

    //unsigned short i;

    /* allocate feature and entity memory */
    Feature *feature= (Feature *) malloc(sizeof(Feature));

    if (feature == 0)
    {
        write_to_log(manager.log, 1, "Could not allocate feature memory.\n");
        return 0;
    }

    feature->entity= construct_entity();
    if (feature->entity == 0)
    {
        write_to_log(manager.log, 1, "Could not construct feature's entity.\n");
        destruct_feature(feature);
        return 0;
    }

    /* set entity members */
    feature->entity->heading_x= heading_x;
    feature->entity->heading_y= heading_y;

    /* set feature members */
    feature->type= type;
    feature->status= status;

    /* if feature is a hive, set it up */
    if (type == FEATURE_T_HIVE && map != 0)
    {

        //feature->max_num_baddies= map->max_num_baddies;

        #if 0
        feature->max_num_baddies= 100;

        feature->baddie_types=
            (unsigned char *)
            malloc(sizeof(unsigned char) * feature->max_num_baddies);

        if (feature->baddie_types == 0)
        {
            write_to_log(manager.log, 1,
                         "Could not allocate hive's baddie types array.\n");
            destruct_feature(feature);
            return 0;
        }

        for (i= 0; i < feature->max_num_baddies; i++)
        {
            feature->baddie_types[i]= UCHAR_MAX;
        }
        #endif

        feature->baddie_types= construct_list();

        if (feature->baddie_types == 0)
        {
            write_to_log(manager.log, 1,
                         "Could not construct hive's baddie types list.\n");
            destruct_feature(feature);
            return 0;
        }

    }
    else feature->baddie_types= 0;

    /* animate feature one frame */
    animate_feature(feature, map);

    /* set feature's bounding box and add it to map */
    if (map != 0)
    {
        set_bb_size(feature->entity, map);
        if (add_feature_to_map(feature, map, row, col) > 0)
        {
            write_to_log(manager.log, 1, "Could not add feature to map.\n");
            destruct_feature(feature);
            return 0;
        }
    }

    return feature;

} /* end construct_feature */




void destruct_feature(Feature *feature)
{
    //if (feature->baddie_types != 0) free(feature->baddie_types);
    if (feature->baddie_types != 0) destruct_list(feature->baddie_types);
    if (feature->entity != 0) destruct_entity(feature->entity);
    free(feature);
    feature= 0;
}




void do_feature_logic(Feature *const feature, Map *const map)
{

    //unsigned short i;

    //type_list_iterator *iterator;

    switch (feature->type)
    {

        /* if feature is a hive */
        case FEATURE_T_HIVE:

            /* if hive is normal */
            if (feature->status == FEATURE_S_NORMAL)
            {

                /* search for a baddie which needs to be spawned */
                #if 0
                for (i= 0; i < feature->max_num_baddies
                           && feature->baddie_types[i] == UCHAR_MAX; i++);

                /* if a baddie needs to be spawned and can be, spawn him */
                if (i < feature->max_num_baddies
                    && baddie_on_tile(map, feature->entity->row,
                                      feature->entity->col, 1, 1) == 0)
                {
                    printf("spawning\n");
                    set_feature_status(feature, FEATURE_S_SPAWNING);
                    if (construct_baddie(feature->baddie_types[i],
                                         feature->entity->row,
                                         feature->entity->col, 0, 1,
                                         BADDIE_S_SPAWNING, feature, map) == 0)
                    {
                        write_to_log(manager.log, 1,
                                     "Could not spawn baddie.\n");
                    }
                    feature->baddie_types[i]= UCHAR_MAX;
                }
                #endif

                //iterator= get_iterator(feature->baddie_types);

                //if (iterator != 0
                //  && baddie_on_tile(map, feature->entity->row,
                //                    feature->entity->col, 1, 1) == 0)
                //{

                //  set_feature_status(feature, FEATURE_S_SPAWNING);

                    #if 0
                    if (construct_baddie(iterator->uc, feature->entity->row,
                                         feature->entity->col, 0, 1,
                                         BADDIE_S_SPAWNING, feature, map) == 0)
                    {
                        write_to_log(manager.log, 1,
                                     "Could not spawn baddie.\n");
                    }
                    remove_from_list(feature->baddie_types, 0, iterator->uc);
                    #endif

                //}

            } /* end if hive is normal */

            break;

        default:
            break;


    } /* end switch on feature type */

} /* end do_feature_logic */




void do_pow(Feature *const pow, Map *const map)
{

    List_iterator *iterator;
    Baddie *baddie;

    /* destroy pow block */
    set_feature_status(pow, FEATURE_S_KAPUT);

    /* freeze all baddies */
    iterator= get_iterator(map->baddie_list);
    while (iterator != 0)
    {

        baddie= (Baddie *) iterator->dat;

        if (baddie->status != BADDIE_S_KICKED
            && baddie->status != BADDIE_S_KICKED_MELTING
            && baddie->status != BADDIE_S_SINKING
            && baddie->status != BADDIE_S_SHATTERING
            && baddie->status != BADDIE_S_STEAMROLLED
            && baddie->status != BADDIE_S_NEW_ICE
            && baddie->status != BADDIE_S_SPAWNING
            && baddie->status != BADDIE_S_KAPUT)
        {
            set_baddie_status(baddie, BADDIE_S_FROZEN, map);
        }

        iterator= next_iterator(iterator);

    }

} /* end do_pow */




void feature_anim_done(Feature *const feature, Map *const map)
{

    List_iterator *iterator;
    Baddie *baddie;

    switch (feature->status)
    {

        case FEATURE_S_SPAWNING:

            iterator= get_iterator(feature->baddie_types);

            if (iterator != 0
                && baddie_on_tile(map, feature->entity->row,
                                  feature->entity->col, 1, 1) == 0)
            {

                if (construct_baddie(iterator->uc, feature->entity->row,
                                     feature->entity->col, 0, 1,
                                     BADDIE_S_SPAWNING, feature, map) == 0)
                {
                    write_to_log(manager.log, 1,
                                 "Could not spawn baddie.\n");
                }

                /* if there are still more baddies to be spawned, reset the
                   animation */
                if (next_iterator(iterator) != 0) reset_anim(feature->entity);

                /* otherwise, return to normal */
                else set_feature_status(feature, FEATURE_S_NORMAL);

                remove_from_list(feature->baddie_types, 0, iterator->uc);

            }

            else reset_anim(feature->entity);

            break;

        case FEATURE_S_SPRINGING:

            /* determine ice block to kick based on spring's heading */
            baddie=
                baddie_on_tile(map, adj_row(feature->entity),
                               adj_col(feature->entity), map->t_width,
                               map->t_height);

            /* if all is proper, kick the ice block */
            if (baddie != 0 && baddie->type == BADDIE_T_BADDIE1
                && (baddie->status == BADDIE_S_FROZEN
                    || baddie->status == BADDIE_S_MELTING))
            {
                /* set baddie status and heading; speed was set when the block
                   was first kicked */
                set_baddie_status(baddie,
                    (baddie->status == BADDIE_S_FROZEN
                     ? BADDIE_S_KICKED : BADDIE_S_KICKED_MELTING), map);
                //baddie->entity->n_speed= map->player->kick_speed;
                set_heading(baddie->entity, feature->entity->heading_x,
                            feature->entity->heading_y);
            }

            /* set the spring back to normal */
            set_feature_status(feature, FEATURE_S_NORMAL);

            break;

        default:
            break;

    } /* end switch on feature status */

} /* end feature_anim_done */




unsigned char feature_baddie_coll(const feature_type f_type,
                                  const baddie_type b_type,
                                  const baddie_status b_status)
{


    switch (b_status)
    {

        case BADDIE_S_KICKED:
        case BADDIE_S_KICKED_MELTING:
        case BADDIE_S_STEAMROLLED:

            if (f_type == FEATURE_T_HOLE || f_type == FEATURE_T_BLACK_ICE)
            {
                return 0;
            }

            break;

        case BADDIE_S_SPAWNING:
            if (f_type == FEATURE_T_HIVE) return 0;
            break;

        default:

            if (f_type == FEATURE_T_BLACK_ICE)
            {
                if (b_type != BADDIE_T_BADDIE1) return 0;
            }

            break;

    }

    /* collision */
    return 1;

} /* end feature_baddie_coll */




unsigned char feature_feature_coll(const feature_type active_type,
                                   const feature_type passive_type)
{
    /* collision */
    return 1;
}




unsigned char feature_goodie_coll(const feature_type f_type,
                                  const goodie_type g_type,
                                  const goodie_status g_status)
{

    if (f_type == FEATURE_T_BLACK_ICE) return 0;

    /* collision */
    return 1;

} /* end feature_goodie_coll */




unsigned char feature_player_coll(const feature_type f_type,
                                  const player_status p_status)
{

    if (f_type == FEATURE_T_BLACK_ICE) return 0;

    /* collision */
    return 1;

}




unsigned char feature_tile_coll(const feature_type f_type,
                                const tile_type t_type)
{

    if (t_type == TILE_T_ICE) return 0;

    /* collision */
    return 1;

}




void notify_hive(Feature *const hive, const baddie_type b_type)
{

    #if 0
    unsigned short i;

    for (i= 0; i < hive->max_num_baddies && hive->baddie_types[i] != UCHAR_MAX;
         i++);

    if (i < hive->max_num_baddies) hive->baddie_types[i]= baddie_type;
    #endif

    append_to_list(hive->baddie_types, 0, b_type);

    set_feature_status(hive, FEATURE_S_SPAWNING);

} /* end notify_hive */




void set_feature_status(Feature *const feature, feature_status status)
{
    feature->status= status;
}
