/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _CONTROLS_H_
#define _CONTROLS_H_


#include <allegro.h>


volatile int last_dir_key;


typedef struct                                  /* CONTROLS DEFINITION */
{

    unsigned char key_up;                       /* key assignments */
    unsigned char key_right;
    unsigned char key_down;
    unsigned char key_left;
    unsigned char key_spin;
    unsigned char key_breath;
    unsigned char key_pillar;

    #if 0
    JOYSTICK_BUTTON_INFO button_spin;           /* joypad button assignments */
    JOYSTICK_BUTTON_INFO button_ice_breath;
    JOYSTICK_BUTTON_INFO button_ice_pillar;
    #endif

    unsigned char breath_flag;                  /* flags to prevent, when the */
    unsigned char pillar_flag;                  /* user holds down the
                                                   respective keys, repeats of
                                                   ice breaths and ice
                                                   pillars; see controls_ice_
                                                   breath and controls_ice_
                                                   pillar */

} Controls;


/**
 * Creates and returns a default controls scheme.
 */
Controls *construct_controls(void);


/**
 * Returns 1 if the control for ice breath is held and 0 otherwise.
 */
unsigned char controls_breath(Controls *const controls);


/**
 * Returns 1 if the control for down is held and 0 otherwise.
 */
unsigned char controls_down(const Controls *const controls);


/**
 * Returns 1 if the control for left is held and 0 otherwise.
 */
unsigned char controls_left(const Controls *const controls);


/**
 * Returns 1 if the control for ice pillar is held and 0 otherwise.
 */
unsigned char controls_pillar(Controls *const controls);


/**
 * Returns 1 if the control for right is held and 0 otherwise.
 */
unsigned char controls_right(const Controls *const controls);


/**
 * Returns 1 if the control for spin is held and 0 otherwise.
 */
unsigned char controls_spin(const Controls *const controls);


/**
 * Returns 1 if the control for up is held and 0 otherwise.
 */
unsigned char controls_up(const Controls *const controls);


void dir_key_handler(int scancode);


/**
 * This method initializes globals declared in the header and registers
 * a key handler with Allegro.  It should be called before any control
 * is used.
 */
void init_controls(void);


/**
 * Polls controls.
 */
void poll_controls(void);


#endif
