/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#include <stdlib.h>

#include "controls.h"
#include "log.h"
#include "manager.h"



/* the game's log file */
//extern type_log *manager.log;


extern Manager manager;


Controls *construct_controls(void)
{

    Controls *controls= (Controls *) malloc(sizeof(Controls));
    if (controls == 0)
    {
        write_to_log(manager.log, 1, "Could not allocate controls memory.\n");
        return 0;
    }

    controls->breath_flag= 0;
    controls->pillar_flag= 0;

    /* key assignments */
    controls->key_up= KEY_UP;
    controls->key_down= KEY_DOWN;
    controls->key_left= KEY_LEFT;
    controls->key_right= KEY_RIGHT;
    controls->key_breath= KEY_ALT;
    controls->key_pillar= KEY_LCONTROL;
    controls->key_spin= KEY_Z;

    return controls;

}




unsigned char controls_breath(Controls *const controls)
{
    if (controls->breath_flag == 1) controls->breath_flag= 2;
    if (key[controls->key_breath])
    {
        if (controls->breath_flag == 0)
        {
            controls->breath_flag= 1;
            return 1;
        }
    }
    else if (controls->breath_flag == 2) controls->breath_flag= 0;
    return 0;
}




unsigned char controls_down(const Controls *const controls)
{
    if (key[controls->key_down]
        && (last_dir_key == controls->key_down || last_dir_key == 0))
    {
        return 1;
    }
    return 0;
}




unsigned char controls_left(const Controls *const controls)
{
    if (key[controls->key_left]
        && (last_dir_key == controls->key_left || last_dir_key == 0))
    {
        return 1;
    }
    return 0;
}




unsigned char controls_pillar(Controls *const controls)
{
    if (controls->pillar_flag == 1) controls->pillar_flag= 2;
    if (key[controls->key_pillar])
    {
        if (controls->pillar_flag == 0)
        {
            controls->pillar_flag= 1;
            return 1;
        }
    }
    else if (controls->pillar_flag == 2) controls->pillar_flag= 0;
    return 0;
}




unsigned char controls_right(const Controls *const controls)
{
    if (key[controls->key_right]
        && (last_dir_key == controls->key_right || last_dir_key == 0))
    {
        return 1;
    }
    return 0;
}




unsigned char controls_spin(const Controls *const controls)
{
    if (key[controls->key_spin]) return 1;
    return 0;
}




unsigned char controls_up(const Controls *const controls)
{
    if (key[controls->key_up]
        && (last_dir_key == controls->key_up || last_dir_key == 0))
    {
        return 1;
    }
    return 0;
}




void dir_key_handler(int scancode)
{

    #if 0
    int key= (scancode | 128) ^ 128;

    if (key == KEY_UP || key == KEY_DOWN
        || key == KEY_RIGHT || key == KEY_LEFT)
    {

        last_dir_key= key;
        last_dir_key_pressed= (scancode >> 7) ^ 1;

    }
    #endif

    unsigned char key= (scancode | 0x80) ^ 0x80;

    if (key == KEY_UP || key == KEY_DOWN || key == KEY_RIGHT || key == KEY_LEFT)
    {

        if ((scancode >> 7) ^ 0x1) last_dir_key= key;
        else last_dir_key= 0;

    }

}
END_OF_FUNCTION(key_handler);




void init_controls(void)
{

    write_to_log(manager.log, 0, "Initializing controls.\n");

    /* lock the keyboard callback memory and function */
    LOCK_VARIABLE(last_dir_key);
    LOCK_FUNCTION(key_handler);

    /* point Allegro's keyboard callback to the direction key handler */
    keyboard_lowlevel_callback= &dir_key_handler;

    /* init the last direction key pressed */
    last_dir_key= 0;

}


#if 0
int key_handler(int key)
{

    int scancode= key >> 8;
    switch (scancode)
    {

        case KEY_LEFT:
        case KEY_RIGHT:
        case KEY_UP:
        case KEY_DOWN:

            last_dir_pressed= scancode;

            break;

    }

    return key;

}
END_OF_FUNCTION(key_handler);
#endif





void poll_controls(void)
{

    #if 0
    unsigned char i= 0;
    unsigned char j;

    if (last_last_dir_key != last_dir_key
        || last_last_dir_key_pressed != last_dir_key_pressed)
    {

        while (i <= dir_key_queue_tail && dir_key_queue[i] != last_dir_key)
        {
            ++i;
        }

        printf("dir_key_queue_tail == %i\n", dir_key_queue_tail);
        printf("i == %i\n", i);

        /* if last_dir_key is not in the queue, add it */
        if (i > dir_key_queue_tail)
        {
            /* make sure everything's legal and as it should be -- if last_dir_key
               is not in the queue, then it should be pressed */
            if (i <= 4 && last_dir_key_pressed)
            {
                printf("setting dir_key_queue\n");
                dir_key_queue_tail= i;
                dir_key_queue[(unsigned) dir_key_queue_tail]= last_dir_key;
            }
        }

        /* else if last_dir_key is in the queue, remove it */
        else
        {
            /* if last_dir_key is in the queue, then it should be released */
            if (!last_dir_key_pressed)
            {
                /* if last_dir_key is at the tail, truncate the queue */
                if (i == dir_key_queue_tail) dir_key_queue[i]= 0;

                /* else, last_dir_key is in front of the tail -- move everything
                   down an index */
                else
                {
                    printf("setting dir_key_queue\n");
                    for (j= i; j < dir_key_queue_tail; j++)
                    {
                        dir_key_queue[j]= dir_key_queue[j + 1];
                    }
                    for (j= dir_key_queue_tail; j < 4; j++)
                    {
                        dir_key_queue[j]= 0;
                    }
                }

                --dir_key_queue_tail;

            }
        }

        last_last_dir_key= last_dir_key;
        last_last_dir_key_pressed= last_dir_key_pressed;

    }
    #endif

    poll_keyboard();
    poll_joystick();

}
