/************************************
 *
 * Kickle 0.81
 * 2004 Drew Willcoxon
 * http://www.cs.uga.edu/~adw/
 * dripfeed@uga.edu
 *
 ************************************/


#ifndef _BADDIE_H_
#define _BADDIE_H_


#include "tbaddie.h"
#include "tfeature.h"
#include "tgoodie.h"
#include "tmap.h"


#define COLL_FUDGE_X    8       /* the number of columns of pixels of the
                                   bounding boxes of two moving baddies which
                                   must overlap for a collision to occur between
                                   those baddies */

#define COLL_FUDGE_Y    8       /* the number of rows of pixels of the
                                   bounding boxes of two moving baddies which
                                   must overlap for a collision to occur between
                                   those baddies */


void baddie_anim_done(Baddie *const baddie, Map *const map);


unsigned char baddie_baddie_coll(const baddie_type active_type,
                                 const baddie_status active_status,
                                 const baddie_type passive_type,
                                 const baddie_status passive_status);


/**
 * Returns a positive number if a baddie of the specified type and status
 * collides with a feature of the specified type and status.  Returns 0
 * otherwise.
 */
unsigned char baddie_feature_coll(const baddie_type b_type,
                                  const baddie_status b_status,
                                  const feature_type f_type,
                                  const feature_status f_status);


unsigned char baddie_goodie_coll(const baddie_type b_type,
                                 const baddie_status b_status,
                                 const goodie_type g_type,
                                 const goodie_status g_status);


unsigned char baddie_player_coll(const baddie_type b_type,
                                 const baddie_status b_status,
                                 const player_status p_status);


unsigned char baddie_tile_coll(const baddie_type b_type,
                               const baddie_status b_status,
                               const Map *const map,
                               const unsigned char row,
                               const unsigned char col);


Baddie *clone_baddie(const Baddie *const baddie, Map *const map,
                     const unsigned char row, const unsigned char col,
                     Feature *const hive);


Baddie *construct_baddie(const baddie_type type, const unsigned char row,
                         const unsigned char col, const signed char heading_x,
                         const signed char heading_y,
                         const baddie_status status, Feature *const hive,
                         Map *const map);


void destruct_baddie(Baddie *baddie);


void do_baddie_logic(Baddie *const baddie, Map *const map,
                     const signed short target_row,
                     const signed short target_col);


void do_baddie_square(Baddie *const baddie, Map *const map,
                      const signed short target_row,
                      const signed short target_col);


void do_baddie_square_moving(Baddie *const baddie, Map *const map,
                             const signed short target_row,
                             const signed short target_col);


void do_baddie_square_stopped(Baddie *const baddie, Map *const map,
                              const signed short target_row,
                              const signed short target_col);


void do_baddie_to_baddie(Baddie *const active, const Map *const map,
                         Baddie *const passive);


void do_baddie_to_feature(Baddie *const baddie, const Map *const map,
                          Feature *const feature);


void do_baddie_to_goodie(Baddie *const baddie, const Map *const map,
                         Goodie *const goodie);


void do_baddie_to_player(Baddie *const baddie, const Map *const map,
                         Player *const player);


void do_baddie_to_tile(Baddie *const baddie, const Map *const map,
                       const unsigned char row, const unsigned char col);


void find_baddie_to_baddie(Baddie *const baddie, const Map *const map);


void find_baddie_to_feature(Baddie *const baddie, const Map *const map);


void find_baddie_to_goodie(Baddie *const baddie, const Map *const map);


void find_baddie_to_player(Baddie *const baddie, const Map *const map);


void find_baddie_to_tile(Baddie *const baddie, const Map *const map);


void set_baddie_status(Baddie *const baddie, baddie_status status,
                       const Map *const map);


/**
 * Possibly assigns a random heading to baddie.  Probability is an integer in
 * the range [0, 100] and specifies the probability that a new heading is
 * assigned.  For example, if 0 is passed as probability, a random heading
 * is necessarily not assigned, and if 100 is passed, a random heading is
 * necessarily assigned.
 */
void set_random_heading(Baddie *const baddie, const unsigned char probability);


void turn_back_baddie(Baddie *const baddie, const Map *const map);


#endif
