/************************************/
/*  Blitz Software Casino           */
/*       Code by Simon Parzer       */
/************************************/

// Includes
#include "allegro.h"  //Allegro Library (Video, Audio, Input, etc.)
#include "Data/graphics.h" //Makros fr Datafile
#include "Data/sounds.h"   //Makros fr Datafile
#include "Data/intro.h"  // Makros fr Datafile
#include <string.h>  //String-Funktionen
#include <stdio.h>
#include <stdlib.h>
#include "fmod/fmod.h"

//Defines
#define JACKPOT 183527

#define K_KREUZ 0
#define K_KARO  1
#define K_PIK   2
#define K_HERZ  3

#define R_BAR1     0
#define R_BAR2     1
#define R_BAR3     2
#define R_KIRSCHE  3
#define R_SIEBEN   4
#define R_JOKER    5
#define R_NIETE    6

#define R_INIT_SPEED 70
#define R_SPEED_SCHWELLE 30

//Strukturen
typedef struct button {
	int x,y; //Position auf dem Bildschirm
  short isSelected; //Mauspfeil auf Text 
	short isClicked; //Button geklickt -> 1, sonst -> 0
	short wasClicked; //Trigger fr Aktion nach klicken
	char text[50]; //Text, der auf dem Button steht
} Button;

typedef struct textbutton {
	int x,y; //Position auf dem Bildschirm
	long color; //Farbe
	long selcolor; //Farbe beim Markieren
	short isSelected; //Mauspfeil auf Text 
	short isClicked; //Text ist geklickt
	short wasClicked; //Text wurde geklickt
	char text[30]; //Naja, der Text eben..
} TextButton;

typedef struct text {
	int x, y;  //Position
	long color; //Farbe
	char text[30]; //Text
} Text;

typedef struct karte {
	int x, y; //Position
	int isSelected; //Selektiert? (0-1)
	int isVerdeckt; //Verdeckt? (0-1)
	int wert; //Wert der Karte (2-14)
	short farbe; //K_KREUZ, K_KARO, ... (0..3)
	BITMAP *bmp; //Bitmap der Karte
} Karte;

typedef struct streifen {
	int speed; //Scrollgeschwindigkeit
	int ypos;  //Position auf dem Streifen (pixel)
	int yposr; //Genaue Position
	int x, y;  //Position auf dem Bildschirm
	int wert1, wert2; //Werte (max 2 gleichzitig)
	BITMAP *bmp;  //Scrollbitmap
} Streifen;

typedef struct roulettezahl {
	int farbe;   //Rot oder Schwarz??
	int zahl;    //Zahl (0..12)
} Roulettezahl;

typedef struct roulettekreis {
	Roulettezahl zahl[13];
	int x, y; //Position von 0
	int selection; //Welche Zahl ist markiert?
	int moves;  //Wie oft geht die Markierung (noch) weiter?
	int delay;  //Wie schnell geht die Markierung weiter?
} Roulettekreis;

typedef struct tippfeld
{
	BITMAP *bmp;
	short isSelected;  //Mauspfeil drauf?
	short isClicked;   //Mauspfeil draufgeklickt?
	int bet;           //Wieviel gesetzt?
	int x, y;          //Position auf dem BILDSCHIRM
} Tippfeld;

typedef struct spieler {
	Text name; //Der Name des Spielers
	long geld; //Wieviel Geld der Spieler hat
	long coins; //Wieviele Mnzen der Spieler hat
} Spieler;

typedef struct highscore {
	Spieler player[10];
} Highscore;

//Datafiles global definieren
DATAFILE *graphics;
DATAFILE *sounds;

//Buffer fr Double-Buffering
BITMAP *buffer;

//Suche nach Mp3s
struct al_ffblk mp3seek;
char mp3fname[512];
FSOUND_STREAM *bkmusik;

//Funktionskpfe
void puttextbutton(BITMAP *dest, TextButton *output);
void UpdateHighscore(Highscore *, Spieler *);

void frame()
{
	acquire_bitmap(buffer);
	blit(buffer, screen, 0, 0, 0, 0, 1024, 768);  //Buffer auf Bildschirm
	release_bitmap(buffer);
	//vsync();
}

void FmodPlay(int nummer)
{
	FSOUND_SAMPLE *toplay;
	toplay=FSOUND_Sample_Load(FSOUND_FREE, sounds[nummer].dat, FSOUND_LOADMEMORY, 0, sounds[nummer].size);
	FSOUND_Sample_SetDefaults(toplay, -1, 255, FSOUND_STEREOPAN, -1);
	FSOUND_PlaySound(FSOUND_FREE, toplay);
	//Der Sound wird am Ende durch das FMOD-Managing-System aus dem Speicher gelscht!
}

signed char F_CALLBACKAPI nextseek(FSOUND_STREAM *stream, void *buff, int len, void *param)
{
	//"buff" und "param" sind mir egal
	if (al_findnext(&mp3seek))
	{
		al_findfirst("mp3/*.mp3", &mp3seek, 0xFFFF);
	}
	if (bkmusik!=NULL) 
	{
		FSOUND_Stream_Close(bkmusik);
		strcpy(mp3fname, "mp3/");
		strcat(mp3fname, mp3seek.name);
		bkmusik=FSOUND_Stream_Open(mp3fname, 0, 0, 0);
		if (bkmusik!=NULL) 
		{
			FSOUND_Stream_Play(FSOUND_FREE, bkmusik);
			FSOUND_Stream_SetEndCallback(bkmusik, nextseek, NULL);
			FSOUND_SetVolume(FSOUND_ALL, 50);
		}
	}
	return TRUE;
}

void puttextxy(BITMAP *dest, Text *output)
{
	long shadow;
	shadow=makecol32(getr32(output->color)/2, getg32(output->color)/2, getb32(output->color)/2);
	textout_centre(dest, graphics[ARIALBL].dat, (*output).text, output->x+10, (*output).y+10, shadow);
	textout_centre(dest, graphics[ARIALBL].dat, (*output).text, output->x, (*output).y, (*output).color);
}

void puttext(BITMAP *dest, Text *output)
{
	long shadow;
	shadow=makecol32(getr32(output->color)/2, getg32(output->color)/2, getb32(output->color)/2);
	textout_centre(dest, graphics[ARIALBL].dat, (*output).text, SCREEN_W/2+10, (*output).y+10, shadow);
	textout_centre(dest, graphics[ARIALBL].dat, (*output).text, SCREEN_W/2, (*output).y, (*output).color);
}

int UeberschreibenAbfrage()
{
	int i;
	Text frage;
	TextButton auswahl[2];  //Yes, No

	frage.color=0xFFFFFF;
	strcpy(frage.text, "Do you want to overwrite?");
	frage.x=SCREEN_W/2;
	frage.y=350;

	auswahl[0].color=0xFF0000;
	auswahl[0].selcolor=0xFF5050;
	strcpy(auswahl[0].text, "Yes");
	auswahl[0].y=525;
	auswahl[0].isSelected=0;
	auswahl[0].x=(SCREEN_W - text_length(graphics[ARIALBL].dat, auswahl[0].text)) / 2;

	auswahl[1].color=0x00FF00;
	auswahl[1].selcolor=0x50FF50;
	strcpy(auswahl[1].text, "No");
	auswahl[1].y=450;
	auswahl[1].isSelected=0;
	auswahl[1].x=(SCREEN_W - text_length(graphics[ARIALBL].dat, auswahl[1].text)) / 2;

	while (!key[KEY_ESC])
	{
		clear_to_color(buffer, 0x777777); // Hintergrund = grau
		puttext(buffer, &frage);
		for (i=0; i<=1; i++)  {
			puttextbutton(buffer, &auswahl[i]);
			if ((mouse_x>auswahl[i].x) && (mouse_x<auswahl[i].x+text_length(graphics[ARIALBL].dat, auswahl[i].text)) &&
					(mouse_y>auswahl[i].y) && (mouse_y<auswahl[i].y+text_height(graphics[ARIALBL].dat)))
			{ // Mauspfeil auf "Button"
				auswahl[i].isSelected=1;
			}
			else
			{
				auswahl[i].isSelected=0;
			}
			if ((auswahl[i].isSelected) && (mouse_b & 1))
			{ // "Button" geklickt
				auswahl[i].isClicked=1;
			}
			else
			{
				auswahl[i].isClicked=0;
			}
		}
		draw_sprite(buffer, graphics[MAUSPF].dat, mouse_x, mouse_y);
		frame();
		if (auswahl[0].isClicked)
		{
			return 0;
		}
		if (auswahl[1].isClicked)
		{
			return 3;
		}
	}
	return 3;
}

int NameEingeben(Spieler *neu)
{
	FILE *ftest;
	char fname[25];
	int i;
	char buchst;
	Text name;
	strcpy(name.text, "Insert your Name");
	name.y=200;
	name.color=0x0000FF;
	(*neu).geld=500;
	(*neu).coins=10;
	strcpy((*neu).name.text, "_");
	(*neu).name.y=300;
	(*neu).name.color=0xFFFFFF;
	i=0;
	key[KEY_ENTER]=0;
	while(!key[KEY_ENTER])
	{
		//show_mouse(NULL);
		clear_to_color(buffer, 0x777777); //Hintergrund = grau
		puttext(buffer, &name);
		puttext(buffer, &(*neu).name);
		frame();
		//show_mouse(buffer);
		//draw_sprite(buffer, graphics[MAUSPF].dat, mouse_x, mouse_y);
		clear_keybuf();
		buchst=readkey();
		if (buchst==8)
		{
			if (i>0) i--;
		}
		else if (buchst==13)
		{
		}
		else
		{
			(*neu).name.text[i]=buchst;
			i++;
		}
		(*neu).name.text[i]='\0';
		if (i>=20)
		{
			key[KEY_ENTER]=1;
		}
	}
	strcpy(fname, "saves/");
	strcat(fname, (*neu).name.text);
	strcat(fname, ".sav");
	ftest=fopen(fname, "r");
	if (ftest!=NULL)
	{
		return UeberschreibenAbfrage();
	}
	else
	{
		return 0;
	}
}

void draw_card_bmp(Karte *card)
{
  BITMAP *letter, *symbol_k, *symbol;
	char buchst[3];
	int letter_w, letter_h;
	long color;
	if (card->isVerdeckt)
	{
		blit(graphics[KARTE_R].dat, card->bmp, 0, 0, 0, 0, 100, 150);
		return;  //!!!!!//
	}
	blit(graphics[KARTE].dat, card->bmp, 0, 0, 0, 0, 100, 150);
	if ((card->farbe==K_KARO) || (card->farbe==K_HERZ))
	{
		color=0xFF0000;  // Rot
	}
	else
	{
		color=0x000000;  // Schwarz
	}
	buchst[1]='\0';
	switch (card->wert)
	{
		case 10: buchst[0]='1'; buchst[1]='0'; buchst[2]='\0'; break;
	  case 11: buchst[0]='J'; break;
		case 12: buchst[0]='Q'; break;
		case 13: buchst[0]='K'; break;
		case 14: buchst[0]='A'; break;
		default: buchst[0]='0' + card->wert; break;
	}
	switch (card->farbe)
	{
		case K_KREUZ: symbol_k=graphics[KREUZ_K].dat;
			            symbol=graphics[KREUZ].dat; break;
		case K_KARO: symbol_k=graphics[KARO_K].dat;
								 symbol=graphics[KARO].dat; break;
		case K_PIK: symbol_k=graphics[PIK_K].dat;
			          symbol=graphics[PIK].dat; break;
		case K_HERZ: symbol_k=graphics[HERZ_K].dat;
			           symbol=graphics[HERZ].dat; break;
	}
	letter_w=text_length(graphics[TNR].dat, buchst);
	letter_h=text_height(graphics[TNR].dat);
	letter=create_bitmap(letter_w, letter_h);
	clear_to_color(letter, 0xFF00FF);
	textprintf(letter, graphics[TNR].dat, 0, 0, color, buchst);
	
	// Groe Symbole -> Richtig verteilt
	// Bei Bildkarten das Bild anbringen...
	switch (card->wert)
	{
		case 2: draw_sprite(card->bmp, symbol, 40, 12);
						draw_sprite_vh_flip(card->bmp, symbol, 40, 117); break;
		case 3: draw_sprite(card->bmp, symbol, 40, 12);
				    draw_sprite(card->bmp, symbol, 40, 65);
						draw_sprite_vh_flip(card->bmp, symbol, 40, 117); break;
		case 4: draw_sprite(card->bmp, symbol, 20, 12); 
			      draw_sprite(card->bmp, symbol, 60, 12);
						draw_sprite_vh_flip(card->bmp, symbol, 20, 117); 
						draw_sprite_vh_flip(card->bmp, symbol, 60, 117); break;
		case 5: draw_sprite(card->bmp, symbol, 20, 12); 
			      draw_sprite(card->bmp, symbol, 60, 12);
						draw_sprite(card->bmp, symbol, 40, 65);
						draw_sprite_vh_flip(card->bmp, symbol, 20, 117); 
						draw_sprite_vh_flip(card->bmp, symbol, 60, 117); break;
		case 6: draw_sprite(card->bmp, symbol, 20, 12); 
			      draw_sprite(card->bmp, symbol, 60, 12);
						draw_sprite(card->bmp, symbol, 20, 65);
						draw_sprite(card->bmp, symbol, 60, 65);
						draw_sprite_vh_flip(card->bmp, symbol, 20, 117); 
						draw_sprite_vh_flip(card->bmp, symbol, 60, 117); break;
		case 7: draw_sprite(card->bmp, symbol, 20, 12); 
			      draw_sprite(card->bmp, symbol, 60, 12);
						draw_sprite(card->bmp, symbol, 20, 65);
						draw_sprite(card->bmp, symbol, 60, 65);
						draw_sprite(card->bmp, symbol, 40, 39);
						draw_sprite_vh_flip(card->bmp, symbol, 20, 117); 
						draw_sprite_vh_flip(card->bmp, symbol, 60, 117); break;
		case 8: draw_sprite(card->bmp, symbol, 20, 12); 
			      draw_sprite(card->bmp, symbol, 60, 12);
						draw_sprite(card->bmp, symbol, 20, 65);
						draw_sprite(card->bmp, symbol, 60, 65);
						draw_sprite(card->bmp, symbol, 40, 39);
						draw_sprite_vh_flip(card->bmp, symbol, 40, 90);
						draw_sprite_vh_flip(card->bmp, symbol, 20, 117); 
						draw_sprite_vh_flip(card->bmp, symbol, 60, 117); break;
		case 9: draw_sprite(card->bmp, symbol, 20, 12); 
			      draw_sprite(card->bmp, symbol, 60, 12);
						draw_sprite(card->bmp, symbol, 20, 45); 
			      draw_sprite(card->bmp, symbol, 60, 45);
						draw_sprite(card->bmp, symbol, 40, 65);
						draw_sprite_vh_flip(card->bmp, symbol, 20, 84); 
						draw_sprite_vh_flip(card->bmp, symbol, 60, 84);
						draw_sprite_vh_flip(card->bmp, symbol, 20, 117); 
						draw_sprite_vh_flip(card->bmp, symbol, 60, 117); break;
		case 10: draw_sprite(card->bmp, symbol, 20, 12); 
			       draw_sprite(card->bmp, symbol, 60, 12);
						 draw_sprite(card->bmp, symbol, 40, 29);
						 draw_sprite(card->bmp, symbol, 20, 45); 
			       draw_sprite(card->bmp, symbol, 60, 45);
						 draw_sprite_vh_flip(card->bmp, symbol, 20, 84); 
						 draw_sprite_vh_flip(card->bmp, symbol, 60, 84);
						 draw_sprite_vh_flip(card->bmp, symbol, 40, 100);
						 draw_sprite_vh_flip(card->bmp, symbol, 20, 117); 
						 draw_sprite_vh_flip(card->bmp, symbol, 60, 117); break;
			// Bube
		case 11: draw_sprite(card->bmp, graphics[BUBE].dat, 0, 0); break;
			// Dame
		case 12: draw_sprite(card->bmp, graphics[DAME].dat, 0, 0); break;
			// Knig
		case 13: draw_sprite(card->bmp, graphics[KOENIG].dat, 0, 0); break;
			// Ass
		case 14: draw_sprite(card->bmp, symbol, 40, 65); break;
	}
	// Buchstabe bzw. Zahl
	draw_sprite(card->bmp, letter, 6, 6);
	draw_sprite(card->bmp, letter, 94 - letter_w, 6);
	draw_sprite_vh_flip(card->bmp, letter, 6, 144 - letter_h);
	draw_sprite_vh_flip(card->bmp, letter, 94 - letter_w, 144 - letter_h);
	  
	// Kleines Symbol unter Buchstaben bzw. Zahl
	draw_sprite(card->bmp, symbol_k, 6, letter_h + 8);
	draw_sprite(card->bmp, symbol_k, 94 - symbol_k->w, letter_h + 8);
	draw_sprite_vh_flip(card->bmp, symbol_k, 6, 144 - letter_h - symbol_k->h);
	draw_sprite_vh_flip(card->bmp, symbol_k, 94 - symbol_k->w, 144 - letter_h - symbol_k->h);

	destroy_bitmap(letter);
}

void draw_poker_card(Karte *card)
{
	draw_sprite(buffer, card->bmp, card->x, card->y);
	if (card->isSelected)
	{
		rect(buffer, card->x-4, card->y-4, card->x+104, card->y+154, 0x700000);
		rect(buffer, card->x-3, card->y-3, card->x+103, card->y+153, 0xA00000);
		rect(buffer, card->x-2, card->y-2, card->x+102, card->y+152, 0xFF0000);
	}
}

void PokerBtnInit(Button *btn)
{
	int i;
	for (i=0; i<=8; i++)
	{
		btn[i].isClicked=0;
		btn[i].wasClicked=0;
		btn[i].isSelected=0;
		btn[i].x=85 + i*95;
		btn[i].y=625;
	}
	strcpy(btn[0].text, "Cash");
	strcpy(btn[1].text, "Bet One");
	strcpy(btn[2].text, "1");
	strcpy(btn[3].text, "2");
	strcpy(btn[4].text, "3");
	strcpy(btn[5].text, "4");
	strcpy(btn[6].text, "5");
	strcpy(btn[7].text, "Bet Max");
	strcpy(btn[8].text, "Draw");
}

void draw_button(Button todraw)
{
  if (todraw.isClicked)
	{
		draw_sprite(buffer, graphics[BUTTONP].dat, todraw.x, todraw.y);
	}
	else
	{
		draw_sprite(buffer, graphics[BUTTON].dat, todraw.x, todraw.y);
	}
	if (todraw.isSelected)
	{
		textprintf_centre(buffer, graphics[TNR].dat, (todraw.x + 75/2), (todraw.y + (75/2) - (text_height(graphics[TNR].dat)/2)), 0xff0000, todraw.text);
	}
	else
	{
		textprintf_centre(buffer, graphics[TNR].dat, (todraw.x + 75/2), (todraw.y + (75/2) - (text_height(graphics[TNR].dat)/2)), 0xffff00, todraw.text);
  }
}

void draw_help_line(int y, char *text, char *n1, char *n2, char *n3, char *n4, char *n5, long color)
{
  textout(buffer, font, text, 150, y, color);
	textout(buffer, font, n1, 400, y, color);
	textout(buffer, font, n2, 500, y, color);
	textout(buffer, font, n3, 600, y, color);
	textout(buffer, font, n4, 700, y, color);
	textout(buffer, font, n5, 800, y, color);
}

void draw_poker_help(short win)
{
	long color;
	rect(buffer, 145, 25, 860, 145, 0xffffff);
	rect(buffer, 143, 23, 862, 147, 0xffffff);
	line(buffer, 370, 25, 370, 145, 0xffffff);
	line(buffer, 470, 25, 470, 145, 0xffffff);
	line(buffer, 570, 25, 570, 145, 0xffffff);
	line(buffer, 670, 25, 670, 145, 0xffffff);
	line(buffer, 770, 25, 770, 145, 0xffffff);
	color=0xffffff;
	draw_help_line(30, "Royal Flush", "250", "500", "750", "1000", "Jackpot", color);
	draw_help_line(40, "4 Aces", "240", "480", "720", "960", "1200", color);
	draw_help_line(50, "4 2,3 or 4", "120", "240", "360", "480", "600", color);
	draw_help_line(60, "Straight Flush", "50", "100", "150", "200", "250", color);
	draw_help_line(70, "4 of a Kind", "50", "100", "150", "200", "250", color);
	draw_help_line(80, "Full House", "9", "18", "27", "36", "45", color);
	draw_help_line(90, "Flush", "6", "12", "18", "24", "30", color);
	draw_help_line(100, "Straight", "4", "8", "12", "16", "20", color);
	draw_help_line(110, "3 of a Kind", "2", "4", "6", "8", "10", color);
	draw_help_line(120, "2 Pairs", "1", "2", "3", "4", "5", color);
	draw_help_line(130, "Jacks or Better", "1", "2", "3", "4", "5", color);

	color=0xffff00;
	switch(win)
	{
		case 11: draw_help_line(30, "Royal Flush", "250", "500", "750", "1000", "Jackpot", color); break;
		case 10: draw_help_line(40, "4 Aces", "240", "480", "720", "960", "1200", color); break;
		case 9: draw_help_line(50, "4 2,3 or 4", "120", "240", "360", "480", "600", color); break;
		case 8: draw_help_line(60, "Straight Flush", "50", "100", "150", "200", "250", color); break;
		case 7: draw_help_line(70, "4 of a Kind", "50", "100", "150", "200", "250", color); break;
		case 6: draw_help_line(80, "Full House", "9", "18", "27", "36", "45", color); break;
		case 5: draw_help_line(90, "Flush", "6", "12", "18", "24", "30", color); break;
		case 4: draw_help_line(100, "Straight", "4", "8", "12", "16", "20", color); break;
		case 3: draw_help_line(110, "3 of a Kind", "2", "4", "6", "8", "10", color); break;
		case 2: draw_help_line(120, "2 Pairs", "1", "2", "3", "4", "5", color); break;
		case 1: draw_help_line(130, "Jacks or Better", "1", "2", "3", "4", "5", color); break;
	}
}

void draw_coins(Spieler *player, long inserted, short bet)
{
	textprintf_centre(buffer, graphics[TNR].dat, SCREEN_W/2-200, 720, 0xFF0000, "Your Coins: %ld", player->coins);
	textprintf_centre(buffer, graphics[TNR].dat, SCREEN_W/2, 720, 0xFF9900, "Inserted: %ld", inserted);
  textprintf_centre(buffer, graphics[TNR].dat, SCREEN_W/2+200, 720, 0x33FF33, "Bet: %d", bet);
}

void draw_poker_logo()
{
	int i;
	for (i=15; i>0; i--)
	{
	  textout_centre(buffer, graphics[ARIALBL].dat, "Virtual Poker", SCREEN_W/2-i, SCREEN_H/2-i, 0x00FF00);
  }
	textout_centre(buffer, graphics[ARIALBL].dat, "Virtual Poker", SCREEN_W/2, SCREEN_H/2, 0xFFFF00);
}

void PokerCardInit(Karte card[])
{
	int i;
	card[0].x=1024/2-300;
	card[1].x=1024/2-175;
	card[2].x=1024/2-50;
	card[3].x=1024/2+75;
	card[4].x=1024/2+200;
  for (i=0; i<=4; i++)
	{
		card[i].y=SCREEN_H/2-75;
		card[i].isSelected=0;
		card[i].bmp=create_bitmap(100, 150);
	}
}

void random_poker_cards(Karte card[])
{
	int i, j;
	short gleich;
	for (i=0; i<=4; i++)
	{
		if (card[i].isSelected)
		{
			do
			{
				gleich=0;
			  card[i].wert=(rand() % 13) + 2;
		    card[i].farbe=rand() % 4;
				for (j=0; j<=4; j++)
				{
					if ((card[i].wert==card[j].wert) && (card[i].farbe==card[j].farbe) && (j!=i)) 
					{
						gleich=1;
					}
				}
			} while (gleich);
		}
	}
}

void sort_poker_cards(Karte tosort[])
{
	int i;
	short swap;
	Karte tmp;
	do
	{
		swap=0;
		for (i=0; i<=3; i++)
		{
			if (tosort[i].wert>tosort[i+1].wert)
			{
        tmp.wert=tosort[i].wert;
				tmp.farbe=tosort[i].farbe;
				tosort[i].wert=tosort[i+1].wert;
				tosort[i].farbe=tosort[i+1].farbe;
				tosort[i+1].wert=tmp.wert;
				tosort[i+1].farbe=tmp.farbe;
				swap=1;
			}
		}
	} while (swap);
}

short check_poker_win(Karte card[])
{
  int i;
	short win;
	short counter;
	short wert;
	Karte sorted[5];
	for (i=0; i<5; i++)
	{
		sorted[i]=card[i];
	}
	sort_poker_cards(sorted);
	win=0;
	//Jacks or Better
	//2 Pairs
  counter=0;
	wert=0;
	for (i=0; i<4; i++)
	{
		if (sorted[i].wert==sorted[i+1].wert)
		{
      counter++;
			if (sorted[i].wert>wert) wert=sorted[i].wert;
			i++;
		}
	}
	if (counter==1 && wert>10) win=1;
	else if (counter==2) win=2;
  //3 of a Kind
	for (i=0; i<3; i++)
	{
		if ((sorted[i].wert==sorted[i+1].wert) &&
			  (sorted[i].wert==sorted[i+2].wert))
		{
			win=3;
		}
	}
	//Straight
	counter=0;
	for (i=0; i<4; i++)
	{
		if (sorted[i].wert+1==sorted[i+1].wert)
		{
			counter++;
		}
	}
	if (counter>3) win=4;
	//Flush
	if ((sorted[0].farbe==sorted[1].farbe) &&
		  (sorted[0].farbe==sorted[2].farbe) &&
			(sorted[0].farbe==sorted[3].farbe) &&
			(sorted[0].farbe==sorted[4].farbe))
	{
		win=5;
	}
	//Full House
	if (((sorted[0].wert==sorted[1].wert) && ((sorted[2].wert==sorted[3].wert) && 
																						(sorted[2].wert==sorted[4].wert)))
		  || (((sorted[0].wert==sorted[1].wert) &&
			     (sorted[0].wert==sorted[2].wert)) && (sorted[3].wert==sorted[4].wert)))
	{
		win=6;
	}
	//4 of a Kind
	counter=0;
	wert=0;
	for (i=0; i<4; i++)
	{
		if (sorted[i].wert==sorted[i+1].wert) 
		{ 
			if (wert==0) wert=sorted[i].wert;
			if (sorted[i].wert==wert) counter++;
		}
	}
	if (counter>2) win=7;
	//Straight Flush
  counter=0;
	if ((sorted[0].farbe==sorted[1].farbe) &&
		  (sorted[0].farbe==sorted[2].farbe) &&
			(sorted[0].farbe==sorted[3].farbe) &&
			(sorted[0].farbe==sorted[4].farbe))
	{
		counter=1;
	}
	for (i=0; i<4; i++)
	{
		if (sorted[i].wert+1==sorted[i+1].wert)
		{
			counter++;
		}
	}
	if (counter>4) win=8;
	//4 2,3 or 4
	//4 Aces
	counter=0;
	wert=0;
	for (i=0; i<4; i++)
	{
		if (sorted[i].wert==sorted[i+1].wert) 
		{ 
			if (wert==0) wert=sorted[i].wert;
			if (sorted[i].wert==wert) counter++;
		}
	}
	if ((counter>2) && wert<5) win=9;
	if ((counter>2) && wert==14) win=10;
	//Royal Flush
	counter=0;
	for (i=0; i<4; i++)
	{
		if (sorted[i].wert+1==sorted[i+1].wert)
		{
			counter++;
		}
	}
  if ((sorted[0].farbe==sorted[1].farbe) &&
		  (sorted[0].farbe==sorted[2].farbe) &&
			(sorted[0].farbe==sorted[3].farbe) &&
			(sorted[0].farbe==sorted[4].farbe))
	{
		counter++;
	}
	if (sorted[0].wert==10) counter++;
	if (counter>5) win=11;

	return win;
}

long give_poker_gewinn(short win, short bet)
{
	long gewinn;
	switch (win)
	{
		case 0: gewinn=0; break;
		case 1: gewinn=bet; break;
		case 2: gewinn=bet; break;
		case 3: gewinn=2*bet; break;
		case 4: gewinn=4*bet; break;
		case 5: gewinn=6*bet; break;
		case 6: gewinn=9*bet; break;
		case 7: gewinn=50*bet; break;
		case 8: gewinn=50*bet; break;
		case 9: gewinn=120*bet; break;
		case 10: gewinn=240*bet; break;
		case 11: gewinn=250*bet; break;
	}
	if ((win>=11) && (bet>=5)) gewinn=JACKPOT;
	return gewinn;
}

void draw_verdoppeln_abfrage(long gewinn)
{
	textprintf_centre(buffer, graphics[TNR].dat, SCREEN_W/2, 500, 0xffffff,
		                "Your Win is %d. Do you want to play further (1=Y, 2=N)?", gewinn);
}

/*************************************/
/* Erklrung der Variable "ingame"   */
/*************************************/
/*  0: Spiel hat noch nicht begonnen */
/*  1: Spiel hat begonnen            */
/*  3: Leider nix gewonnen           */
/*  5: Abfrage zum Verdoppeln des    */
/*     Gewinns                       */
/*  2: Initialisierung Verdoppeln    */
/*  4: Verdoppeln ist gestartet      */
/*************************************/
void Poker(Spieler *player)
{
	int i;
	short ingame;
	short draws;
	short bet;
	short win;
	long gewinn;
	long inserted;
	Button btn[9]; // Cash, BetOne, 1..5, BetMax, Draw
	Karte card[5];
	PokerBtnInit(btn);
	PokerCardInit(card);
	bet=0; inserted=0;
	ingame=0;
	draws=0; win=0;
  while (!key[KEY_ESC])
	{
	  //show_mouse(NULL);
		clear_to_color(buffer, 0x5555ff);
	  draw_poker_help(win);
		if ((inserted<=0) && (bet<=0) && (ingame<2))
		{
      draw_poker_logo();
		}
		else if ((bet<=0) && (!ingame))
		{
			for (i=0; i<=4; i++)
			{
				card[i].isVerdeckt=1;
				card[i].isSelected=0;
				draw_card_bmp(&card[i]);
			}
		}
		else if (!ingame)
		{
      ingame=1;
			draws=2;
			for (i=0; i<=4; i++)
			{
				card[i].isSelected=1;
			}
		}
		if (ingame==5)
		{
			draw_verdoppeln_abfrage(gewinn);
		}
    if (ingame==2)
		{
			for (i=0; i<=4; i++)
			{
				card[i].isVerdeckt=1;
				draw_card_bmp(&card[i]);
				card[i].isSelected=1;
			}
			random_poker_cards(card);
			for (i=0; i<=4; i++)
			{
				card[i].isSelected=0;
			}
			card[0].isVerdeckt=0;
			draw_card_bmp(&card[0]);
			ingame=4;
		}
		if (inserted>0 || bet>0 || ingame>0)
		{
			for (i=0; i<=4; i++)
			{
				draw_poker_card(&card[i]);
			}
			if ((ingame==3) && ((mouse_b & 1) || (mouse_b & 2)))
			{
				bet=0;
        ingame=0;
			}
		}
		draw_coins(player, inserted, bet);
		if (mouse_b & 2)
		{
			if (player->coins>0)
			{
				player->coins--;
				inserted++;
			}
		}
	  for (i=0; i<=8; i++)
		{
		  draw_button(btn[i]);
			if (((mouse_x>btn[i].x) && (mouse_x<btn[i].x+75)) &&
			  ((mouse_y>btn[i].y) && (mouse_y<btn[i].y+75)))
			{ // Mauspfeil auf Button
			  btn[i].isSelected=1;
			}
		  else
			{
			  btn[i].isSelected=0;
			}
			if ((btn[i].isSelected) && (mouse_b & 1))
			{
				btn[i].isClicked=1;
			}
			else
			{
				if (btn[i].isClicked) btn[i].wasClicked=1;
				else btn[i].wasClicked=0;
				btn[i].isClicked=0;
			}
		}
		if (btn[0].wasClicked)
		{
			while (inserted>0)
			{
        inserted--;
				player->coins++;
				rectfill(buffer, 0, 720, 1024,  768, 0x5555ff);
				draw_coins(player, inserted, bet);
				frame();
				FmodPlay(MUENZE);
				rest(20);
			}
			btn[0].wasClicked=0;
		}
		if (btn[1].wasClicked)
		{
			if ((bet<5) && (inserted>0) && (!ingame || draws>1))
			{
				bet++;
			  inserted--;
			}
			btn[1].wasClicked=0;
		}
		for (i=2; i<=6; i++)
		{
			if ((btn[i].wasClicked) && (ingame==1) && (draws<2))
			{
				if (card[i-2].isSelected==0) card[i-2].isSelected=1;
				else card[i-2].isSelected=0;
				btn[i].wasClicked=0;
			}
			if ((btn[i].wasClicked) && (ingame==4) && (i!=2))
			{
				card[i-2].isVerdeckt=0;
				draw_card_bmp(&card[i-2]);
				if (card[i-2].wert>card[0].wert)
				{
					gewinn*=2;
				  FmodPlay(YOUWIN);
					ingame=5;
				}
				else
				{
					gewinn=0;
					win=0;
					ingame=3;
				}
				btn[i].wasClicked=0;
			}
		}
		if (btn[2].wasClicked && ingame==5)
		{
			ingame=2;
			btn[2].wasClicked=0;
		}
		if (btn[3].wasClicked && ingame==5)
		{
			ingame=0;
			inserted+=gewinn;
			gewinn=0;
			win=0;
			btn[3].wasClicked=0;
		}
		if (btn[7].wasClicked)
		{
			if ((bet<5) && (inserted>0) && (!ingame || draws>1))
			{
				while (inserted>0 && bet<5)
				{
					inserted--;
					bet++;
				}
			}
			btn[7].wasClicked=0;
		}
		if (btn[8].wasClicked && ingame==1)
		{
			random_poker_cards(card);
			for (i=0; i<=4; i++)
			{
				if (draws==2) 
				{ 
					card[i].isVerdeckt=0;
					card[i].isSelected=0;
				}
				draw_card_bmp(&card[i]);
			}
			draws--;
			if (draws<=0)
			{
				win=check_poker_win(card);
				if (win>0) 
				{
					ingame=5;
					gewinn=give_poker_gewinn(win, bet);
					if (gewinn>0) FmodPlay(YOUWIN);
					bet=0;
				}
				else 
				{
					ingame=3;
				}
			}
			btn[8].wasClicked=0;
		}
		//show_mouse(buffer);
		draw_sprite(buffer, graphics[MAUSPF].dat, mouse_x-20, mouse_y-20);
	  frame();
	}
	player->coins+=inserted;
	for (i=0; i<=4; i++)
	{
    destroy_bitmap(card[i].bmp);
	}
}

void InitRouletteKreis(Roulettekreis *kreis)
{
	kreis->zahl[0].farbe=0x00FF00;
	kreis->zahl[0].zahl=0;
	kreis->zahl[1].farbe=0xFF0000;
	kreis->zahl[1].zahl=5;
	kreis->zahl[2].farbe=0x000000;
	kreis->zahl[2].zahl=12;
	kreis->zahl[3].farbe=0xFF0000;
	kreis->zahl[3].zahl=3;
	kreis->zahl[4].farbe=0x000000;
	kreis->zahl[4].zahl=10;
	kreis->zahl[5].farbe=0xFF0000;
	kreis->zahl[5].zahl=1;
	kreis->zahl[6].farbe=0x000000;
	kreis->zahl[6].zahl=8;
	kreis->zahl[7].farbe=0xFF0000;
	kreis->zahl[7].zahl=9;
	kreis->zahl[8].farbe=0x000000;
	kreis->zahl[8].zahl=2;
	kreis->zahl[9].farbe=0xFF0000;
	kreis->zahl[9].zahl=7;
	kreis->zahl[10].farbe=0x000000;
	kreis->zahl[10].zahl=6;
	kreis->zahl[11].farbe=0xFF0000;
	kreis->zahl[11].zahl=11;
	kreis->zahl[12].farbe=0x000000;
	kreis->zahl[12].zahl=4;
	kreis->x=487; //1024/2-50/2
	kreis->y=100;
	kreis->selection=0;
}

Draw_RouletteKreis(Roulettekreis *kreis)
{
	BITMAP *help;
	fixed winkel;
	float f_winkel;
	int i;
	int x;
	char c_zahl[5];
  
	help=create_bitmap(50, 200); //Doppelte Hhe
	for (i=0; i<=12; i++)
	{
		clear_to_color(help, 0xFF00FF);
		draw_sprite(help, graphics[RKREIS].dat, 0, 0);
		
		sprintf(c_zahl, "%d", kreis->zahl[i].zahl);
		x=28-text_length(graphics[TNR].dat, c_zahl);

		if (kreis->selection!=i)
		{
		  floodfill(help, 10, 5, kreis->zahl[i].farbe);
			textprintf(help, graphics[TNR].dat, x, 5, 0xFFFF00, "%s", c_zahl);
		}
		else
		{
			floodfill(help, 10, 5, 0xFFFF00);
			textprintf(help, graphics[TNR].dat, x, 5, kreis->zahl[i].farbe, "%s", c_zahl);
		}
    
		f_winkel=(float)256/13*i;
		winkel=ftofix(f_winkel);
		rotate_sprite(buffer, help, kreis->x, kreis->y, winkel);
	}
	textprintf(buffer, graphics[ARIALBL].dat, 300, 100, kreis->zahl[kreis->selection].farbe,
		         "%d", kreis->zahl[kreis->selection].zahl);
	destroy_bitmap(help);
}

void InitTippfelder(Tippfeld zahl[])
{
	int i;
	int w, h;
	long color;
	char c_zahl[5];
	for (i=0; i<=12; i++)
	{
		sprintf(c_zahl, "%d", i);
		w=text_length(graphics[TNR].dat, c_zahl);
		h=text_height(graphics[TNR].dat);
		zahl[i].bmp=create_bitmap(w, h);
    clear_to_color(zahl[i].bmp, 0xFF00FF);
		switch (i)
		{
			case 0: color=0x00FF00; break;
			case 1:
			case 3:
			case 5:
			case 7:
			case 9:
			case 11: color=0xFF0000; break;
			case 2:
			case 4:
			case 6:
			case 8:
			case 10:
			case 12: color=0x000000; break;
			default: color=0xFFFFFF; break; //Keine Ahnung wieso...
		}
		textprintf(zahl[i].bmp, graphics[TNR].dat, 0, 0, color, "%s", c_zahl);
		zahl[i].bet=0;
  }
	zahl[0].x=477;
	zahl[0].y=400;
	zahl[1].x=412;
	zahl[1].y=455;
	zahl[2].x=477;
	zahl[2].y=455;
	zahl[3].x=542;
	zahl[3].y=455;
	zahl[4].x=412;
	zahl[4].y=510;
	zahl[5].x=477;
	zahl[5].y=510;
	zahl[6].x=542;
	zahl[6].y=510;
	zahl[7].x=412;
	zahl[7].y=565;
	zahl[8].x=477;
	zahl[8].y=565;
	zahl[9].x=542;
	zahl[9].y=565;
	zahl[10].x=412;
	zahl[10].y=620;
	zahl[11].x=477;
	zahl[11].y=620;
	zahl[12].x=542;
	zahl[12].y=620;
	zahl[13].bmp=create_bitmap(20, 25);
	clear_to_color(zahl[13].bmp, 0xFF0000);
	zahl[13].bet=0;
	zahl[14].bmp=create_bitmap(20, 25);
	clear_to_color(zahl[14].bmp, 0x000000);
	zahl[14].bet=0;
	w=text_length(graphics[TNR].dat, "7-12");
	h=text_height(graphics[TNR].dat);
	zahl[15].bmp=create_bitmap(w, h);
	clear_to_color(zahl[15].bmp, 0xFF00FF);
	textout(zahl[15].bmp, graphics[TNR].dat, "7-12", 0, 0, 0x900000);
	zahl[15].bet=0;
	w=text_length(graphics[TNR].dat, "1-6");
	h=text_height(graphics[TNR].dat);
	zahl[16].bmp=create_bitmap(w, h);
	clear_to_color(zahl[16].bmp, 0xFF00FF);
	textout(zahl[16].bmp, graphics[TNR].dat, "1-6", 0, 0, 0x900000);
	zahl[16].bet=0;

	zahl[13].x=607;
	zahl[13].y=565;
	zahl[14].x=347;
	zahl[14].y=565;
	zahl[15].x=347;
	zahl[15].y=510;
	zahl[16].x=607;
	zahl[16].y=510;
}

void Draw_Tippfelder(Tippfeld zahl[])
{
	int i;
	for (i=0; i<=16; i++)
	{
		if (!zahl[i].bet)
		{
			rectfill(buffer, zahl[i].x, zahl[i].y, zahl[i].x+50, zahl[i].y+50, 0xFFFFFF);
		}
		else
		{
			rectfill(buffer, zahl[i].x, zahl[i].y, zahl[i].x+50, zahl[i].y+50, 0xFFFF00);
		}
		rectfill(buffer, zahl[i].x+50, zahl[i].y, zahl[i].x+60, zahl[i].y+50, 0x505050);
		draw_sprite(buffer, zahl[i].bmp, zahl[i].x+25-zahl[i].bmp->w/2, zahl[i].y+25-zahl[i].bmp->h/2);
		if (!zahl[i].bet)
		{
			textprintf(buffer, font, zahl[i].x+52, zahl[i].y+21, 0xFFFFFF, "%d", zahl[i].bet);
		}
		else
		{
			textprintf(buffer, font, zahl[i].x+52, zahl[i].y+21, 0xFFFF00, "%d", zahl[i].bet);
		}
	}
}

void DestroyTippfelder(Tippfeld zahl[])
{
	int i;
	for (i=0; i<=16; i++)
	{
		destroy_bitmap(zahl[i].bmp);
	}
}

void InitRouletteButtons(Button btn[])
{
	strcpy(btn[0].text, "Start");
	btn[0].x=700;
	btn[0].y=425;
	btn[0].isClicked=0;
	btn[0].isSelected=0;
	btn[0].wasClicked=0;
	strcpy(btn[1].text, "Cash");
	btn[1].x=85;
	btn[1].y=625;
	btn[1].isClicked=0;
	btn[1].isSelected=0;
	btn[1].wasClicked=0;
}

void MoveRouletteSelection(Roulettekreis *kreis, short *ingame)
{
	if (*ingame>0)
	{
		if (kreis->moves>0)
		{
			if (kreis->moves<=10)
			{
				kreis->delay--;
				if (kreis->delay<=0) 
				{
					kreis->delay=10-kreis->moves;
					kreis->moves--;
					kreis->selection++;
					FmodPlay(RWEITER);
				}
			}
			else
			{
				kreis->moves--;
				kreis->selection++;
				FmodPlay(RWEITER);
			}
			if (kreis->selection>12)
			{
				kreis->selection=0;
			}
		}
		else
		{
			if (*ingame==1) *ingame=2;
		}
		rest(30);
	}
}

long check_roulette_win(Roulettekreis *kreis, Tippfeld zahl[])
{
  int i;
	int selected;
	short rot=0, schwarz=0, high=0, low=0;
	long win=0;
	selected=kreis->zahl[kreis->selection].zahl;
	if (selected>=1 && selected<=6)
	{
		low=1;
	}
	else if (selected>=7 && selected<=12)
	{
		high=1;
	}
	switch (selected)
	{
		case 1:
		case 3:
		case 5:
		case 7:
		case 9:
		case 11: rot=1; break;
		case 2:
		case 4:
		case 6:
		case 8:
		case 10:
		case 12: schwarz=1; break;
	}

	for (i=0; i<=12; i++)
	{
		if (selected==i)
		{
			win+=zahl[i].bet*12; //Kann 0 sein!!
		}
	}
	if (rot)
	{
		win+=zahl[13].bet*2;
	}
	else if (schwarz)
	{
		win+=zahl[14].bet*2;
	}
	if (high)
	{
		win+=zahl[15].bet*2;
	}
	else if (low)
	{
		win+=zahl[16].bet*2;
	}

	return win;
}

void RouletteCleanUp(Tippfeld zahl[])
{
	int i;
	//Abrumphase
	for (i=0; i<=16; i++)
	{
		zahl[i].bet=0;
	}
}

/* INGAME */
/* ****** */
/*        */
/* 0=normal */
/* 1=bewegung */
/* 2=OK-Button */
/* 3=wait   */
/**************/

void Roulette(Spieler *player)
{
	int i;
	long lastwin=0;
  short ingame;
	long inserted;
	short bet;
	Roulettekreis kreis;
	Tippfeld zahl[17];  //0..12, red, black, high, low
	Button btn[2];      //Start/OK, Cash
	InitRouletteButtons(btn);
	InitRouletteKreis(&kreis);
	InitTippfelder(zahl);
	
	inserted=0; bet=0; ingame=0;
	while (!key[KEY_ESC])
	{
	  clear_to_color(buffer, 0x5555ff);
		if (mouse_b & 2)
		{
			if (player->coins>0)
			{
				player->coins--;
				inserted++;
			}
		}
		for (i=0; i<=16; i++)
		{
		   if (((mouse_x>zahl[i].x) && (mouse_x<zahl[i].x+50)) &&
			    ((mouse_y>zahl[i].y) && (mouse_y<zahl[i].y+50)))
			 { // Mauspfeil auf Tippfeld
			   zahl[i].isSelected=1;
			 }
			 else
			 {
			   zahl[i].isSelected=0;
			 }
			 if ((zahl[i].isSelected) && (mouse_b & 1))
			 {
			 	 zahl[i].isClicked=1;
			 }
			 else if (zahl[i].isClicked)
			 {
				 zahl[i].isClicked=0;
				 if (!ingame)
				 {
					 if (inserted>0 && bet<8)
					 {
					   inserted--;
					   bet++;
					   zahl[i].bet++;
					 }
				 }
			 }
		}
		for (i=0; i<2; i++)
		{
		  draw_button(btn[i]);
			if (((mouse_x>btn[i].x) && (mouse_x<btn[i].x+75)) &&
			   ((mouse_y>btn[i].y) && (mouse_y<btn[i].y+75)))
			{ // Mauspfeil auf Button
			  btn[i].isSelected=1;
			}
		  else
			{ // Dann eben nicht...
			  btn[i].isSelected=0;
			}
		  if ((btn[i].isSelected) && (mouse_b & 1))
			{
			  btn[i].isClicked=1;
			}
		  else if (btn[i].isClicked)
			{
			  btn[i].isClicked=0;
				btn[i].wasClicked=1;
			}
			else
			{
				btn[i].wasClicked=0;
			}
		}
		MoveRouletteSelection(&kreis, &ingame);
		if (ingame==2)
		{
			//Gewinn(e) auszahlen...
			lastwin=check_roulette_win(&kreis, zahl);
			if (lastwin>0) FmodPlay(YOUWIN);
			strcpy(btn[0].text, "OK");
      ingame=3;
		}
		if (ingame==3)
		{
			textprintf_centre(buffer, graphics[TNR].dat, btn[0].x+75/2, btn[0].y-25, 0xFFFFFF, "You won %ld coins", lastwin);
		}

		Draw_RouletteKreis(&kreis);
	  Draw_Tippfelder(zahl);
		draw_coins(player, inserted, bet);
		draw_sprite(buffer, graphics[MAUSPF].dat, mouse_x-20, mouse_y-20);
	  frame();
		if (btn[0].wasClicked)
		{
			if (!ingame)
			{
			  if (bet>0)
				{ 
				  ingame=1;
				  kreis.moves=(rand() % 30) + 20;
					kreis.delay=0;  
				}
			}
		  if (ingame==3)
			{
			  //... und abrumen
			  RouletteCleanUp(zahl);
			  inserted+=lastwin;
			  bet=0;
			  strcpy(btn[0].text, "Start");
        ingame=0;
			}
		}
		if (btn[1].wasClicked)
		{
			while (inserted>0)
			{
        inserted--;
				player->coins++;
				rectfill(buffer, 0, 720, 1024,  768, 0x5555ff);
				draw_coins(player, inserted, bet);
				frame();
				FmodPlay(MUENZE);
				rest(20);
			}
			btn[0].wasClicked=0;
		}
	}
	player->coins+=inserted;
	DestroyTippfelder(zahl);
}

void BanditBtnInit(Button btn[])
{
	int i;
	strcpy(btn[0].text, "Cash");
	strcpy(btn[1].text, "Bet One");
	strcpy(btn[2].text, "Spin");
	strcpy(btn[3].text, "Bet Max");
	for (i=0; i<4; i++)
	{
		btn[i].x=300 + i*100;
		btn[i].y=625;
		btn[i].isClicked=0;
		btn[i].isSelected=0;
		btn[i].wasClicked=0;
	}
}

void BanditRolleInit(Streifen rolle[])
{
	int i;
	rolle[0].x=500/2-32 - 100;
	rolle[1].x=500/2-32;
	rolle[2].x=500/2-32 + 100;
	for (i=0; i<3; i++)
	{
	  rolle[i].speed=0;
		rolle[i].y=300/2-32;
	  rolle[i].ypos=0;
		rolle[i].yposr=0;
		rolle[i].bmp=create_bitmap(64, 128);
		rolle[i].wert1=R_JOKER;
		rolle[i].wert2=R_BAR1;
	}
}

void BanditRolleDestroy(Streifen rolle[])
{
	int i;
  for (i=0; i<3; i++)
	{
	  destroy_bitmap(rolle[i].bmp);
	}
}

void draw_rolle(Streifen rolle)
{
	blit(rolle.bmp, buffer, 0, rolle.ypos, rolle.x+50, rolle.y+150, 64, 64);
}

void draw_rolle_bmp(Streifen rolle)
{
	switch (rolle.wert1)
	{
		case R_BAR1: draw_sprite(rolle.bmp, graphics[BAR1].dat, 0, 0); break;
		case R_BAR2: draw_sprite(rolle.bmp, graphics[BAR2].dat, 0, 0); break;
		case R_BAR3: draw_sprite(rolle.bmp, graphics[BAR3].dat, 0, 0); break;
		case R_KIRSCHE: draw_sprite(rolle.bmp, graphics[KIRSCHE].dat, 0, 0); break;
		case R_SIEBEN: draw_sprite(rolle.bmp, graphics[SIEBEN].dat, 0, 0); break;
		case R_JOKER: draw_sprite(rolle.bmp, graphics[JOKER].dat, 0, 0); break;
		case R_NIETE: draw_sprite(rolle.bmp, graphics[NIETE].dat, 0, 0); break;
	}
	switch (rolle.wert2)
	{
		case R_BAR1: draw_sprite(rolle.bmp, graphics[BAR1].dat, 0, 64); break;
		case R_BAR2: draw_sprite(rolle.bmp, graphics[BAR2].dat, 0, 64); break;
		case R_BAR3: draw_sprite(rolle.bmp, graphics[BAR3].dat, 0, 64); break;
		case R_KIRSCHE: draw_sprite(rolle.bmp, graphics[KIRSCHE].dat, 0, 64); break;
		case R_SIEBEN: draw_sprite(rolle.bmp, graphics[SIEBEN].dat, 0, 64); break;
		case R_JOKER: draw_sprite(rolle.bmp, graphics[JOKER].dat, 0, 64); break;
		case R_NIETE: draw_sprite(rolle.bmp, graphics[NIETE].dat, 0, 64); break;
	}
}

int RolleGetWert()
{
	int x;
	int neuerwert;
	x=(rand() % 34)+1;
  if (x==1)
	{
		neuerwert=R_JOKER;
	}
	if (x==2 || x==3)
	{
		neuerwert=R_SIEBEN;
	}
	if (x==4 || x==5)
	{
		neuerwert=R_KIRSCHE;
	}
	if (x>=6 && x<=8)
	{
		neuerwert=R_BAR3;
	}
	if (x>=9 && x<=12)
	{
		neuerwert=R_BAR2;
	}
	if (x>=13 && x<=17)
	{
		neuerwert=R_BAR1;
	}
	if (x>=18 && x<=34)
	{
		neuerwert=R_NIETE;
	}
	return neuerwert;
}

void BanditFlipRolle(Streifen *rolle)
{
	rolle->wert1=rolle->wert2;
	do
  {
	  rolle->wert2=RolleGetWert();
	} while (rolle->wert2==rolle->wert1);
	draw_rolle_bmp(*rolle);
	rolle->ypos=0;
	rolle->yposr=0;
}

void BanditRolleMove(Streifen rolle[], short *ingame)
{
	int i;
	if (*ingame>0)
	{
		rest(5);
		for (i=0; i<3; i++)
		{
			rolle[i].yposr+=rolle[i].speed;
			rolle[i].ypos=rolle[i].yposr/10;
			if (rolle[i].ypos>=64)
			{
				BanditFlipRolle(&rolle[i]);
			}
		}
		if (*ingame==2)
		{
			if (rolle[0].speed>0)
			{
				rolle[0].speed--;
			}
			if (rolle[0].speed<R_SPEED_SCHWELLE)
			{
				if (rolle[1].speed>0) 
				{
					rolle[1].speed--;
				}
			}
			if (rolle[1].speed<R_SPEED_SCHWELLE)
			{
				if (rolle[2].speed>0)
				{
					rolle[2].speed--;
				}
			}
			for (i=0; i<3; i++)
			{
				if (rolle[i].ypos>0 && rolle[i].speed<R_SPEED_SCHWELLE)
				{
					rolle[i].speed=R_SPEED_SCHWELLE;
					//rolle[i].yposr+=10;
				}
				if (rolle[i].ypos==0 && rolle[i].speed<=R_SPEED_SCHWELLE)
				{
					rolle[i].speed=0;
				}
			}
			if (rolle[0].speed<=0 && rolle[1].speed<=0 && rolle[2].speed<=0)
			{
				*ingame=3;
			}
		}
	}
}

long check_bandit_win(Streifen rolle[], short bet)
{
	long win=0; //Der Gewinn
	int i; //Schleifen-Variable
	int c_joker=0; //Joker-Count
	int c_kirsch=0; //Kirschen-Count
	int c_bar=0;    //Bar-Count (Any Bar)
	int c_bar1=0;   //Bar -
	int c_bar2=0;   // Counts
	int c_bar3=0;   //  !!
	int c_sieben=0; // 7-Count (Wieviele Siebener)
	for (i=0; i<3; i++)
	{
		if (rolle[i].wert1==R_JOKER)
		{
			c_joker++;
		}
		else if (rolle[i].wert1==R_SIEBEN)
		{
			c_sieben++;
		}
		else if (rolle[i].wert1==R_KIRSCHE)
		{
			c_kirsch++;
		}
		else if (rolle[i].wert1>=R_BAR1 && rolle[i].wert1<=R_BAR3)
		{
			c_bar++;
		}
		//An dieser Stelle KEIN else if!!!
		if (rolle[i].wert1==R_BAR1)
		{
			c_bar1++;
		}
		else if (rolle[i].wert1==R_BAR2)
		{
			c_bar2++;
		}
		else if (rolle[i].wert1==R_BAR3)
		{
			c_bar3++;
		}
	}
  //Joker zhlt als alles (auer als 1 Kirsche)
	c_bar+=c_joker;
	c_bar1+=c_joker;
	c_bar2+=c_joker;
	c_bar3+=c_joker;
	c_sieben+=c_joker;
	if (c_kirsch>0) c_kirsch+=c_joker;
	//************************
	if (c_bar>=3)
	{
    win=5;
	}
	if (c_bar1>=3)
	{
		win=10;
	}
	if (c_bar2>=3)
	{
		win=25;
	}
	if (c_bar3>=3)
	{
		win=40;
	}
	if (c_sieben>=3)
	{
		win=80;
	}
	switch (c_kirsch) 
	{
		case 1: win=2; break;
		case 2: win=5; break;
		case 3: win=10; break;
	}
	win*=bet;
	if (c_joker==1)
	{
		win*=2;
	}
	else if (c_joker==2)
	{
		win*=4;
	}
	//MUSS ganz am Schluss sein!!
	if (c_joker>=3)
	{
		win=800;
		if (bet==3)
		{
			win=JACKPOT;
		}
	}
	return win;
}

void draw_bandit_help()
{
  draw_sprite(buffer, graphics[ANYBAR].dat, 600, 5);
	draw_sprite(buffer, graphics[ANYBAR].dat, 670, 5);
	draw_sprite(buffer, graphics[ANYBAR].dat, 740, 5);
	textout(buffer, graphics[ARIALBL].dat, "5", 850, 1, 0xffff00);
	
	draw_sprite(buffer, graphics[BAR1].dat, 600, 74);
	draw_sprite(buffer, graphics[BAR1].dat, 670, 74);
	draw_sprite(buffer, graphics[BAR1].dat, 740, 74);
	textout(buffer, graphics[ARIALBL].dat, "10", 850, 70, 0xffff00);

	draw_sprite(buffer, graphics[BAR2].dat, 600, 143);
	draw_sprite(buffer, graphics[BAR2].dat, 670, 143);
	draw_sprite(buffer, graphics[BAR2].dat, 740, 143);
	textout(buffer, graphics[ARIALBL].dat, "25", 850, 139, 0xffff00);

	draw_sprite(buffer, graphics[BAR3].dat, 600, 212);
	draw_sprite(buffer, graphics[BAR3].dat, 670, 212);
	draw_sprite(buffer, graphics[BAR3].dat, 740, 212);
	textout(buffer, graphics[ARIALBL].dat, "40", 850, 208, 0xffff00);

	draw_sprite(buffer, graphics[SIEBEN].dat, 600, 281);
	draw_sprite(buffer, graphics[SIEBEN].dat, 670, 281);
	draw_sprite(buffer, graphics[SIEBEN].dat, 740, 281);
	textout(buffer, graphics[ARIALBL].dat, "80", 850, 277, 0xffff00);

	draw_sprite(buffer, graphics[JOKER].dat, 600, 350);
	draw_sprite(buffer, graphics[JOKER].dat, 670, 350);
	draw_sprite(buffer, graphics[JOKER].dat, 740, 350);
	textout(buffer, graphics[ARIALBL].dat, "800", 850, 346, 0xffff00);

	textout(buffer, graphics[ARIALBL].dat, "1x", 600, 415, 0x00ff00);
	draw_sprite(buffer, graphics[KIRSCHE].dat, 670, 419);
	textout(buffer, graphics[ARIALBL].dat, "2", 850, 415, 0xffff00);

	textout(buffer, graphics[ARIALBL].dat, "2x", 600, 483, 0x00ff00);
  draw_sprite(buffer, graphics[KIRSCHE].dat, 670, 488);
	textout(buffer, graphics[ARIALBL].dat, "5", 850, 483, 0xffff00);

  draw_sprite(buffer, graphics[KIRSCHE].dat, 600, 557);
	draw_sprite(buffer, graphics[KIRSCHE].dat, 670, 557);
	draw_sprite(buffer, graphics[KIRSCHE].dat, 740, 557);
	textout(buffer, graphics[ARIALBL].dat, "10", 850, 553, 0xffff00);
}

void draw_win(long win)
{
	textprintf(buffer, graphics[TNR].dat, 30, 630, 0x00ff00, "Last Win: %ld", win);
}

/***********/
/* INGAME  */
/*         */
/* 0=Ruhe  */
/* 1=Beweg */
/* 2=Brems */
/* 3=Check */
/***********/
void Bandit(Spieler *player)
{
	int i;
	long lastwin=0;
  short ingame;
	long inserted;
	short bet;
	Button btn[4];  // Cash, Bet One, Spin, Bet Max
	Streifen rolle[3];
	BanditBtnInit(btn);
	BanditRolleInit(rolle);
	for (i=0; i<3; i++)
	{
		draw_rolle_bmp(rolle[i]);
	}
	inserted=0; bet=0;
	ingame=0;
	clear_to_color(buffer, 0x5555ff);
	draw_bandit_help();
	while (!key[KEY_ESC])
	{
		clear_to_color(buffer, 0x5555ff);
		draw_bandit_help();
		draw_sprite(buffer, graphics[BANDIT].dat, 50, 150);
		for (i=0; i<3; i++)
		{
			draw_rolle(rolle[i]);
		}
		draw_coins(player, inserted, bet);
		draw_win(lastwin);
		for (i=0; i<4; i++)
		{
			draw_button(btn[i]);
			if (((mouse_x>btn[i].x) && (mouse_x<btn[i].x+75)) &&
			  ((mouse_y>btn[i].y) && (mouse_y<btn[i].y+75)))
			{ // Mauspfeil auf Button
			  btn[i].isSelected=1;
			}
		  else
			{
			  btn[i].isSelected=0;
			}
			if ((btn[i].isSelected) && (mouse_b & 1))
			{
				btn[i].isClicked=1;
			}
			else
			{
				if (btn[i].isClicked) btn[i].wasClicked=1;
				else btn[i].wasClicked=0;
				btn[i].isClicked=0;
			}
		}
		if (ingame==3)
		{
			lastwin=check_bandit_win(rolle, bet);
			if (lastwin>0) FmodPlay(YOUWIN);
			inserted+=lastwin;
			bet=0;
			ingame=0;
		}
		BanditRolleMove(rolle, &ingame);
		if (mouse_b & 2)
		{
			if (player->coins>0)
			{
				player->coins--;
				inserted++;
			}
		}
		if (btn[0].wasClicked)
		{
			while (inserted>0)
			{
        inserted--;
				player->coins++;
				rectfill(buffer, 0, 720, 1024,  768, 0x5555ff);
				draw_coins(player, inserted, bet);
				frame();
				FmodPlay(MUENZE);
				rest(20);
			}
			btn[0].wasClicked=0;
		}
		if (btn[1].wasClicked && !ingame)
		{
			if (bet<3 && inserted>0)
			{
				inserted--;
				bet++;
			}
		}
    if (btn[2].wasClicked)
		{
			if (ingame==0 && bet>0)
			{
				for (i=0; i<3; i++)
				{
					rolle[i].speed=R_INIT_SPEED;
				}
				ingame=1;
			}
      else if (ingame==1)
			{
				ingame=2;
			}
		}
		if (btn[3].wasClicked && !ingame)
		{
      while (bet<3 && inserted>0)
			{
				inserted--;
				bet++;
			}
		}
		draw_sprite(buffer, graphics[MAUSPF].dat, mouse_x-20, mouse_y-20);
		frame();
	}
	player->coins+=inserted;
	BanditRolleDestroy(rolle);
}

void Wechseln(Spieler *player)
{
	int i;
	int moneyleft;
	Text buy, sell;
	Button btn[6]; //1,10,100,1,10,100
	buy.color=0xFFFF00;
	buy.x=187;
	buy.y=400;
	strcpy(buy.text, "Buy Coins");
	sell.color=0xFFFF00;
	sell.x=737;
	sell.y=400;
	strcpy(sell.text, "Sell Coins");
	for (i=0; i<6; i++)
	{
		btn[i].isClicked=0;
		btn[i].isSelected=0;
		btn[i].wasClicked=0;
		btn[i].y=500;
	}
	strcpy(btn[0].text, "1");
	btn[0].x=50;
	strcpy(btn[1].text, "10");
	btn[1].x=150;
	strcpy(btn[2].text, "100");
	btn[2].x=250;
	strcpy(btn[3].text, "1");
	btn[3].x=600;
	strcpy(btn[4].text, "10");
	btn[4].x=700;
	strcpy(btn[5].text, "100");
	btn[5].x=800;
	while (!key[KEY_ESC])
	{
		clear_to_color(buffer, 0x5555FF);
		puttextxy(buffer, &buy);
		puttextxy(buffer, &sell);
		textprintf_centre(buffer, graphics[ARIALBL].dat, 512, 150, 0xFFFFFF, "Money: %ld,%02ld", 
			player->geld/100, player->geld%100);
		textprintf_centre(buffer, graphics[ARIALBL].dat, 512, 220, 0xFFFFFF, "Coins: %ld", 
			player->coins);
		for (i=0; i<6; i++)
		{
			draw_button(btn[i]);
			if (((mouse_x>btn[i].x) && (mouse_x<btn[i].x+75)) &&
			  ((mouse_y>btn[i].y) && (mouse_y<btn[i].y+75)))
			{ // Mauspfeil auf Button
			  btn[i].isSelected=1;
			}
		  else
			{
			  btn[i].isSelected=0;
			}
			if ((btn[i].isSelected) && (mouse_b & 1))
			{
				btn[i].isClicked=1;
			}
			else
			{
				if (btn[i].isClicked) btn[i].wasClicked=1;
				else btn[i].wasClicked=0;
				btn[i].isClicked=0;
			}
		}
		if (btn[0].wasClicked)
		{
			if (player->geld>=50)
			{
				player->geld-=50;
				player->coins+=1;
			}
		}
		if (btn[1].wasClicked)
		{
			if (player->geld<500)
			{
				moneyleft=player->geld % 50;
				player->coins+=player->geld/50;
				player->geld=moneyleft;
			}
			else
			{
				player->geld-=500;
				player->coins+=10;
			}
		}
		if (btn[2].wasClicked)
		{
			if (player->geld<5000)
			{
				moneyleft=player->geld % 50;
				player->coins+=player->geld/50;
				player->geld=moneyleft;
			}
			else
			{
				player->geld-=5000;
				player->coins+=100;
			}
		}
		if (btn[3].wasClicked)
		{
			if (player->coins>0)
			{
				player->coins--;
				player->geld+=50;
			}
		}
		if (btn[4].wasClicked)
		{
			if (player->coins<10)
			{
				player->geld+=player->coins*50;
				player->coins=0;
			}
			else
			{
				player->coins-=10;
				player->geld+=500;
			}
		}
		if (btn[5].wasClicked)
		{
			if (player->coins<100)
			{
				player->geld+=player->coins*50;
				player->coins=0;
			}
		  else
			{
				player->coins-=100;
				player->geld+=5000;
			}
		}
		draw_sprite(buffer, graphics[MAUSPF].dat, mouse_x-20, mouse_y-20);
		frame();
	}
}

void Speichern(Spieler *player)
{
	FILE *output;
	char fname[40];
	strcpy(fname, "saves/");
	strcat(fname, player->name.text);
	strcat(fname, ".sav");
	output=fopen(fname, "wb");
	if (output==NULL)
	{
		allegro_message("Error while saving %s!", fname);
		exit(2);
	}
	fwrite(player, sizeof(Spieler), 1, output);
	fclose(output);
}

void earn_money(void *param)
{
	Spieler *player=(Spieler *)param;
	player->geld+=20;
}

void SpielMenue(Spieler *player, Highscore *high)
{
	const int anzahl=5;
	int i;
	short ende;
	TextButton auswahl[5];
	auswahl[0].y=100;
	strcpy(auswahl[0].text, "Poker");
	auswahl[1].y=200;
	strcpy(auswahl[1].text, "Roulette");
	auswahl[2].y=300;
	strcpy(auswahl[2].text, "One-armed Bandit");
	auswahl[3].y=400;
	strcpy(auswahl[3].text, "Buy coins");
	auswahl[4].y=500;
	strcpy(auswahl[4].text, "Save and Exit");
	for (i=0; i<=anzahl-1; i++)  {
		auswahl[i].x=(SCREEN_W - text_length(graphics[ARIALBL].dat, auswahl[i].text)) / 2;
		auswahl[i].color=0x0000A0;
		auswahl[i].selcolor=0xFFFF00;
		auswahl[i].isSelected=0;
		auswahl[i].isClicked=0;
	}
	install_param_int((void *)earn_money, player, 10000);
	ende=0;
	while (!ende)  {
    //show_mouse(NULL);
		clear_to_color(buffer, 0x777777); // Hintergrund = grau
		for (i=0; i<=anzahl-1; i++)  {
			puttextbutton(buffer, &auswahl[i]);
			if ((mouse_x>auswahl[i].x) && (mouse_x<auswahl[i].x+text_length(graphics[ARIALBL].dat, auswahl[i].text)) &&
				  (mouse_y>auswahl[i].y) && (mouse_y<auswahl[i].y+text_height(graphics[ARIALBL].dat)))
			{ // Mauspfeil auf "Button"
				auswahl[i].isSelected=1;
			}
			else
			{
				auswahl[i].isSelected=0;
			}
			if ((auswahl[i].isSelected) && (mouse_b & 1))
			{ // "Button" geklickt
				auswahl[i].isClicked=1;
			}
			else
			{
				if (auswahl[i].isClicked) auswahl[i].wasClicked=1;
				else auswahl[i].wasClicked=0;
				auswahl[i].isClicked=0;
			}
		}
		if (auswahl[0].wasClicked)
		{
			Poker(player);
		}
		if (auswahl[1].wasClicked) 
		{
			Roulette(player);
		}
		if (auswahl[2].wasClicked)
		{
			Bandit(player);
		}
		if (auswahl[3].wasClicked)
		{
			Wechseln(player);
		}
		if (auswahl[4].wasClicked)
		{
			Speichern(player);
			UpdateHighscore(high, player);
			ende=1;
		}
		//show_mouse(buffer);	
		draw_sprite(buffer, graphics[MAUSPF].dat, mouse_x-20, mouse_y-20);
		frame();
	}
  remove_param_int(earn_money, player);
}

void PlayerInit(Spieler *player)
{
	player->coins=10;
	player->geld=1500;
}

void NewGame(Highscore *high)
{
	Spieler player;
	if (!NameEingeben(&player)) // Der Spieler gibt seinen Namen ein und wird initialisiert
	{
		SpielMenue(&player, high);   // Das Spielmen (es geht los!)
	}
}

void puttextbutton(BITMAP *dest, TextButton *output)
{
	long shadow;
	if ((*output).isSelected)  {
		shadow=makecol32(getr32(output->selcolor)/2, getg32(output->selcolor)/2, getb32(output->selcolor)/2);
		textout_centre(dest, graphics[ARIALBL].dat, (*output).text, SCREEN_W/2+10, (*output).y+10, shadow);
		textout_centre(dest, graphics[ARIALBL].dat, (*output).text, SCREEN_W/2, (*output).y, (*output).selcolor);
	}
	else
	{
		shadow=makecol32(getr32(output->color)/2, getg32(output->color)/2, getb32(output->color)/2);
		textout_centre(dest, graphics[ARIALBL].dat, (*output).text, SCREEN_W/2+10, (*output).y+10, shadow);
		textout_centre(dest, graphics[ARIALBL].dat, (*output).text, SCREEN_W/2, (*output).y, (*output).color);
	}
}

void show_files(const char *files)
{
	char text[512];
	int zahl;
	int x, y;
	struct al_ffblk ffblk; int done; //Fr die Auflistung
	zahl=0;
	done=al_findfirst(files, &ffblk, 0xFFFF);  //Alle Flags = Alle Dateien
	while (!done)
	{
		x=zahl%7*140+20;
		y=zahl/7*15+450;
		strcpy(text, ffblk.name);
		text[strlen(text)-4]='\0';
		textout(buffer, font, text, x, y, 0xFFFFFF);
		done=al_findnext(&ffblk);
		zahl++;
	}
}

int NameLaden(Spieler *neu)
{
	FILE *input;
	char fname[25];
	int i;
	char buchst;
	Text name;
	strcpy(name.text, "Insert your Name");
	name.y=200;
	name.color=0x0000FF;
	strcpy((*neu).name.text, "_");
	(*neu).name.y=300;
	(*neu).name.color=0xFFFFFF;
	i=0;
	key[KEY_ENTER]=0;
	while(!key[KEY_ENTER])
	{
		//show_mouse(NULL);
		clear_to_color(buffer, 0x777777); //Hintergrund = grau
		puttext(buffer, &name);
		puttext(buffer, &(*neu).name);
		show_files("saves/*.sav");
		frame();
		//show_mouse(buffer);
		//draw_sprite(buffer, graphics[MAUSPF].dat, mouse_x, mouse_y);
		clear_keybuf();
		buchst=readkey();
		if (buchst==8)
		{
			if (i>0) i--;
		}
		else if (buchst==13)
		{
		}
		else
		{
			(*neu).name.text[i]=buchst;
			i++;
		}
		(*neu).name.text[i]='\0';
		if (i>=20)
		{
			key[KEY_ENTER]=1;
		}
	}
	strcpy(fname, "saves/");
	strcat(fname, (*neu).name.text);
	strcat(fname, ".sav");
	input=fopen(fname, "rb");
	if (input!=NULL)
	{
		fread(neu, sizeof(Spieler), 1, input);
		return 0;
	}
	else
	{
		return 2;
	}
	return 1;
}

void LoadGame(Highscore *high)
{
	Spieler player;
	if (!NameLaden(&player))
	{
		SpielMenue(&player, high);  //Mgen die Spiele beginnen!
	}
}

Highscore CreateHighscore()
{
	int i;
	Highscore tocreate;
	for (i=0; i<=9; i++)
	{
		strcpy(tocreate.player[i].name.text, "Blitz Software");
		tocreate.player[i].coins=(10-i)*5;
		tocreate.player[i].geld=(10-i)*2;
	}
	return tocreate;
}

Highscore LoadHighscore()
{
	Highscore toload;
	FILE *fhscore;
	fhscore=fopen("Highscore.dat", "rb");
	if (fhscore==NULL)
	{
		toload=CreateHighscore();
	}
	else
	{
		fread(&toload, sizeof(Highscore), 1, fhscore);
		fclose(fhscore);
	}
	return toload;
}

void SaveHighscore(Highscore *tosave)
{
	FILE *fhscore;
	fhscore=fopen("Highscore.dat", "wb");
	if (fhscore==NULL)
	{
		allegro_message("ERROR: Could not save Highscore!");
	}
	else
	{
		fwrite(tosave, sizeof(Highscore), 1, fhscore);
		fclose(fhscore);
	}
}

void UpdateHighscore(Highscore *toupdate, Spieler *player)
{
	int i;
	int doppelt, doppeltindex;
	int points, newpoints;
	int index;
	newpoints=player->geld+player->coins*50;
	index=-1;
	doppelt=0;
	doppeltindex=9;
	for (i=0; i<=9 && !doppelt; i++)
	{
		points=toupdate->player[i].geld+toupdate->player[i].coins*50;
		if (newpoints>points && index<0)
		{
			index=i;
		}
		if (!strcmp(toupdate->player[i].name.text, player->name.text))
		{
			doppelt=1;
			doppeltindex=i;
		}
	}
	if (index>-1)
	{
		for (i=doppeltindex; i>index; i--)
		{
			toupdate->player[i]=toupdate->player[i-1];
		}
		toupdate->player[index]=*player;
	}
}

void DisplayHighscore(Highscore *todisplay)
{
	int i;
	long points;
	clear_to_color(buffer, 0x0000FF);
	for (i=0; i<=9; i++)
	{
		todisplay->player[i].name.color=0xFFFFFF;
		todisplay->player[i].name.x=300;
		todisplay->player[i].name.y=i*70+20;
		points=todisplay->player[i].geld+todisplay->player[i].coins*50;
		puttextxy(buffer, &todisplay->player[i].name);
		textprintf_right(buffer, graphics[ARIALBL].dat, 900, i*70+20, 0xFFFF00, "%ld,%02ld", 
			               points/100, points%100);
	}
	frame();
	clear_keybuf();
	while (!keypressed() && !mouse_b & 1) {} //Entweder Tastendruck
	while (mouse_b & 1) {}                   //Oder Mausklick
}

void hmenue()
{
	Highscore high;
	int i;
	int click=0;
	short ende;
	TextButton auswahl[4];
	auswahl[0].y=100;
	strcpy(auswahl[0].text, "New Game");
	auswahl[1].y=250;
	strcpy(auswahl[1].text, "Load Game");
	auswahl[2].y=400;
	strcpy(auswahl[2].text, "Highscore");
	auswahl[3].y=550;
	strcpy(auswahl[3].text, "Return to System");
	for (i=0; i<=3; i++)  {
		auswahl[i].x=(SCREEN_W - text_length(graphics[ARIALBL].dat, auswahl[i].text)) / 2;
		auswahl[i].color=0x009000;
		auswahl[i].selcolor=0xFFFF00;
		auswahl[i].isSelected=0;
		auswahl[i].isClicked=0;
	}
	high=LoadHighscore();
	ende=0;
	while (!ende)  {
    //show_mouse(NULL);
		clear_to_color(buffer, 0x777777); // Hintergrund = grau
		for (i=0; i<=3; i++)  {
			puttextbutton(buffer, &auswahl[i]);
			if ((mouse_x>auswahl[i].x) && (mouse_x<auswahl[i].x+text_length(graphics[ARIALBL].dat, auswahl[i].text)) &&
				  (mouse_y>auswahl[i].y) && (mouse_y<auswahl[i].y+text_height(graphics[ARIALBL].dat)))
			{ // Mauspfeil auf "Button"
				auswahl[i].isSelected=1;
			}
			else
			{
				auswahl[i].isSelected=0;
			}
			if ((auswahl[i].isSelected) && mouse_b & 1)
			{ // "Button" geklickt
				auswahl[i].isClicked=1;
			}
			else
			{
				if (auswahl[i].isClicked) auswahl[i].wasClicked=1;
				else auswahl[i].wasClicked=0;
				auswahl[i].isClicked=0;
			}
		}
		if (auswahl[0].wasClicked)
		{
			NewGame(&high);
		}
		if (auswahl[1].wasClicked)
		{
			LoadGame(&high);
		}
		if (auswahl[2].wasClicked)
		{
			DisplayHighscore(&high);
		}
		if (auswahl[3].wasClicked) 
		{
			SaveHighscore(&high);
			ende=1;
		}
		//show_mouse(buffer);	
		draw_sprite(buffer, graphics[MAUSPF].dat, mouse_x-20, mouse_y-20);
		frame();
		//if (key[KEY_ESC]) ende=1;
		if (click) ende=0;
	}
}

void highcolor_fade_out(DATAFILE *intro)
{
  int i;
	BITMAP *bild, *trans_bild;

  bild = create_bitmap(SCREEN_W, SCREEN_H);
  trans_bild = create_bitmap(SCREEN_W, SCREEN_H);
  blit(buffer, bild, 0,0, 0,0, SCREEN_W, SCREEN_H);
  for (i=255; i > 0; i-=20)
  {
    //clear_to_color(trans_bild, 0xffffff);
		blit(intro[BILD2].dat, trans_bild, 0, 0, 0, 0, 1024, 768);
    set_trans_blender(0,0,0,i);
    draw_trans_sprite(trans_bild, bild, 0, 0);
    blit(trans_bild, buffer, 0,0, 0,0, SCREEN_W, SCREEN_H);
		frame();
  }
  destroy_bitmap(bild);
  destroy_bitmap(trans_bild);
  blit(intro[BILD2].dat, buffer, 0, 0, 0, 0, 1024, 768);
	frame();
}

void Intro()
{
	int w, h;
	int i;
	DATAFILE *intro;
	BITMAP *quality;
	intro=load_datafile("Data/intro.dat");
	if (!(intro==NULL))
	{
	  clear(buffer);
		quality=create_bitmap(40, 30);
		stretch_blit(intro[BSINTRO].dat, quality, 0, 0, 1024, 768, 0, 0, 40, 30);
		stretch_blit(quality, buffer, 0, 0, 40, 30, 0, 0, 1024, 768);
		frame();
		rest(2000);
		for (w=80, h=60; w<=640, h<=480; w+=40, h+=30)
		{
			if (w>320) w=1024;
			if (h>200) h=768;
			destroy_bitmap(quality);
			quality=create_bitmap(w, h);
			stretch_blit(intro[BSINTRO].dat, quality, 0, 0, 1024, 768, 0, 0, w, h);
			stretch_blit(quality, buffer, 0, 0, w, h, 0, 0, 1024, 768);
			frame();
			rest(100);
		}
		rest(500);
		quality=create_bitmap(1024, 5);
		for (i=0; i<=763; i+=5)
		{
      blit(intro[BSINTRO].dat, quality, 0, i, 0, 0, 1024, 5);
			blit(quality, buffer, 0, 0, 0, i, 1024, 5);
			line(buffer, 0, i+6, 1024, i+6, 0xFF0000);
			frame();
			rest(10);
		}
		draw_sprite(buffer, intro[BSINTRO].dat, 0, 0);
		frame();
		highcolor_fade_out(intro);
		for (i=0; i<=500 && !keypressed() && !mouse_b & 1; i++)
		{
			rest(10);
		}
		while (mouse_b & 1) {}
		destroy_bitmap(quality);
	  unload_datafile(intro);
	}
	if (!al_findfirst("mp3/*.mp3", &mp3seek, 0xFFFF))
	{
		strcpy(mp3fname, "mp3/");
		strcat(mp3fname, mp3seek.name);
		bkmusik=FSOUND_Stream_Open(mp3fname, 0, 0, 0);
		if (bkmusik!=NULL)
		{
			FSOUND_Stream_Play(FSOUND_FREE, bkmusik);
			FSOUND_Stream_SetEndCallback(bkmusik, nextseek, NULL);
			FSOUND_SetVolume(FSOUND_ALL, 50);
		}
	}
}

void init()
{
	BITMAP *hehe;
	srand(time(0));  //Zufallsgenerator
	allegro_init();  //Allegro Start
	install_keyboard();  //Allegro Tastatur
	install_timer();     //Allegro Timer
	install_mouse();     //Allegro Maus
	text_mode(-1);       //Textmaske transparent
	set_color_depth(32);  //Farbtiefe = 32 Bit
	FSOUND_Init(44100,32,0);  //Initialisiert FMOD-Sound (Mp3, Ogg, Mod, etc.)
	if (set_gfx_mode(GFX_AUTODETECT, 1024, 768, 0, 0)!=0)  {	//Auflsung = 1024x768
		allegro_message("Fehler  beim Setzen des Grafikmodus!"); // Fehlerbehandlung
		exit(1);
	}
	/* Anmerkung:
	   Wenn die Sprites vor dem Setzen des Grafikmodus geladen
		 werden, gibt es Fehler bei der Farbkonvertierung
	*/
	graphics=load_datafile("Data/Graphics.dat");	  //Sprites laden
	if (graphics==NULL)  {                 //Fehlerbehandlung
		allegro_message("Fehler beim Laden von ""Graphics.dat""");
		exit(1);
	}
	sounds=load_datafile("Data/Sounds.dat");
	if (sounds==NULL) {
		allegro_message("Fehler beim Laden von ""Sounds.dat""");
		exit(1);
	}
	show_mouse(NULL);
	hehe=create_video_bitmap(1024,768);       //Benutzt den Bildschirmspeicher -> unbrauchbar!!
	buffer=create_video_bitmap(1024,768);     //DAS ist ein neues Videobitmap!!
	if (buffer==NULL)
	{
		allegro_message("%s\n%s\n",
			              "Failed to allocate Video Bitmap for Double Buffering!",
										"Using Memory Bitmap");
		buffer=create_bitmap(1024,768);
	}
	destroy_bitmap(hehe);
}

void beenden()
{
	show_mouse(NULL);        //Maus (wenn ntig) vom Buffer entfernen
	destroy_bitmap(buffer);  //buffer entfernen
	unload_datafile(graphics);  //Sprites aus dem RAM lschen
	if (bkmusik!=NULL) FSOUND_Stream_Close(bkmusik);   //Aktuellen Stream freigeben
	FSOUND_Close();            //Tschs, du FMOD!
	allegro_exit();  //Allegro Stopp
}

int main()
{
	init();  //Initialisierung
	Intro(); //Blitz Software Intro
	hmenue(); //Hauptmen
	beenden();  //Beenden = Gegenteil von Initialisierung
	return 0;
}
END_OF_MAIN();
