#include "tanky.h"

#include <math.h>
#include <alloc.h>
#include <string.h>
#include <ctype.h>


//----------------------------------------------------------------------------
//-------------------------|    F U N K C I E     |---------------------------
//----------------------------------------------------------------------------




//----------------------------------| PRERUSENIA

void interrupt ( *old) (...);
void interrupt ( *old2)(...);
void interrupt  handler(...)
{
	a=inportb(0x60);
	if(a<128) klavesy[a]=1;
	else {a-=128;klavesy[a]=0;}
	old();
}

void interrupt handler2(...)
{
	moze=1;
	tiky++;
	if(tiky==18) {tiky=0;cas++;}
	old2();
}

void set_keyboard_interrupt(void) {
   old = getvect(0x9);
   setvect(9,handler);
}

void restore_keyboard_interrupt(void) {
   setvect(9,old);
}

void set_interrupts(void) {
   set_keyboard_interrupt();
   old2= getvect(0x1c);
   setvect(0x1c,handler2);
}

void restore_interrupts(void) {
   restore_keyboard_interrupt();
   setvect(0x1c,old2);
}


//----------------------------------| INICIALIZACIA GRAFIKY

void initgraphics(void)
{
	int gdriver = VGA, gmode = VGAHI, errorcode;
	initgraph(&gdriver, &gmode, "");

	errorcode = graphresult();
	if (errorcode != grOk)
	{
		printf("Graphics error: %s\n", grapherrormsg(errorcode));
		printf("Press any key to halt:");
		getch();
		exit(1);
	}
}

void closegraphics(void)
{
	closegraph();
}





//----------------------------------| Wait for timer end
void cakaj(void)
{
  while(moze==0) {}
  moze=0;
}




//----------------------------------| Vrat farbu 15,8 alebo 7

int getfarbapole[3]={15,8,7};
int getfarba(void)
{
  return getfarbapole[random(3)];
}



//----------------------------------| MiniBod Things
void setminibod(int i, int x, int y, int exist) {
   minibod[i].exist=exist;
   minibod[i].x=x;
   minibod[i].y=y;
   minibod[i].xx=pos[random(32)].xx*2/3;
   minibod[i].yy=pos[random(32)].yy*2/3;
   minibod[i].c=getfarba();
}

void initminibod(void) {
   int i;
   last_minibod=0;
   for(i=0;i<MAX_MINIBOD;i++) setminibod(i,0,0,0);
}

void addminibod(int x, int y, int num) {
   int j,x1,y1;

   for(j=0;j<num;j++) {
      last_minibod++;
      if(last_minibod>=MAX_MINIBOD) last_minibod=0;
      if(minibod[last_minibod].exist>0) {
         x1=minibod[last_minibod].x;y1=minibod[last_minibod].y;
         if(!pole[x1>>3][y1>>3] && y1>50) putpixel(x1,y1,0);
      }
      setminibod(last_minibod,x,y,20);
   }
}

void moveminibod(void) {
   int x1,y1,i;
   for(i=0;i<MAX_MINIBOD;i++) {
      if(minibod[i].exist>0) {
         minibod[i].exist--;
         x1=minibod[i].x;y1=minibod[i].y;
         if(!pole[x1>>3][y1>>3] && y1>50) putpixel(x1,y1,0);
         minibod[i].x+=minibod[i].xx;
         minibod[i].y+=minibod[i].yy;
         x1=minibod[i].x;y1=minibod[i].y;
         if(!pole[x1>>3][y1>>3] && minibod[i].exist && y1>50) putpixel(x1,y1,minibod[i].c);
      }
   }
}

//----------------------------------| Zrychlenie a spomalenie klavesnice
void klavesnica_zpomal(void)
{
  asm { mov ah,3;mov al,5;mov bl,31;mov bh,3;int 0x16;}
}
void klavesnica_zrychli(void)
{
  asm { mov ah,3;mov al,5;xor bx,bx;int 0x16;}
}


//----------------------------------| KOCKA

void kocka(int x, int y, int c)
{
  putimage((x<<3),(y<<3),obrazok[c],0);
}

void kocka2(int x, int y, int c)
{
  if(c)
  putimage((x<<3),(y<<3),obrazok[c],0);
}


//----------------------------------| NACITAJ DATA = LOAD TILES

unsigned get_bit(unsigned char a,int bit) {
   return ((a>>bit)&1);
}

//void create_bc_image(char *array,)

void nacitaj_data(void)
{
  int i,j,k,l;
  int pom;
  unsigned int b1,b2,b3,b4;
  char c;
  char pomobr[134];
  int bits[8];

  f=fopen("tanky_v4.dat","rb");

  //------ planar format suxx
  //--- load icons (16x16)
  for(i=0;i<3;i++)
  {
     info_icon[i]=farmalloc(134);
     pomobr[0]=15; // write header
     pomobr[1]=0;
     pomobr[2]=15;
     pomobr[3]=0;
     pomobr[132]=1; // write ender
     pomobr[133]=0;

     for(k=0;k<16;k++) {
        b1=0;b2=0;b3=0;b4=0;
        for(j=0;j<16;j++) {
           fread(&c,1,1,f);
           b1+=get_bit(c,0)<<(15-j);
           b2+=get_bit(c,1)<<(15-j);
           b3+=get_bit(c,2)<<(15-j);
           b4+=get_bit(c,3)<<(15-j);
        }
        //pomobr[k*8+4]=b4>>8; pomobr[k*8+5]=b4&0x00ff;
        pomobr[k*8+5]=b4;    pomobr[k*8+4] = (b4>>8)&0x00ff;
        pomobr[k*8+7]=b3;    pomobr[k*8+6] = (b3>>8)&0x00ff;
        pomobr[k*8+9]=b2;    pomobr[k*8+8] = (b2>>8)&0x00ff;
        pomobr[k*8+11]=b1;   pomobr[k*8+10]= (b1>>8)&0x00ff;
     }

     for(k=0;k<134;k++) {
        *(((char*)info_icon[i])+k)=pomobr[k];
     }
  }


  //--- load tiles (8x8)
  for(i=0;i<TILES;i++)
  {
     obrazok[i]=farmalloc(38);
     pomobr[0]=7; // write header
     pomobr[1]=0;
     pomobr[2]=7;
     pomobr[3]=0;
     pomobr[36]=1; // write ender
     pomobr[37]=0;

     for(k=0;k<8;k++) {
        b1=0;b2=0;b3=0;b4=0;
        for(j=0;j<8;j++) {
           fread(&c,1,1,f);
           b1+=get_bit(c,0)<<(7-j);
           b2+=get_bit(c,1)<<(7-j);
           b3+=get_bit(c,2)<<(7-j);
           b4+=get_bit(c,3)<<(7-j);
        }
        pomobr[k*4+4]=b4;
        pomobr[k*4+5]=b3;
        pomobr[k*4+6]=b2;
        pomobr[k*4+7]=b1;
     }

     for(k=0;k<38;k++) {
        *(((char*)obrazok[i])+k)=pomobr[k];
     }
  }
  fclose(f);

}


//----------------------------------| SPRAVPOLE = LOAD LEVEL

void spravpole(int cislo)
{
  int      i,j;
  char policko;
  long int posun;
  char magic[4];
  char far *buf;

  posun=(long(cislo))*22100l;

  f=fopen("tanky_v4.lev","rb");
  fseek(f,posun,SEEK_SET);

  //read magic "T_V4"
  fread(magic,4,1,f);

  //read level_description
  fread(level_description,60,1,f);

  //read tank attrs
  for(j=0;j<3;j++) {
     fread(&poziciax[j],2,1,f);
     fread(&poziciay[j],2,1,f);
     fread(&tank[j].smer,2,1,f);
  }

  // read void 18 bytes (next 3 tanks positions)
  for(j=0;j<9;j++) {
    fread(&i,2,1,f);
  }

  //read level data
  buf=(char*)farmalloc(22000);
  if(buf==NULL) {
     closegraphics();
     printf("ERROR: No more memory !\n\n\n");
     exit(1);
  }

  fread(buf,22000,1,f);
  for(j=0;j<55;j++)
  for(i=0;i<80;i++)
  {
     //pole[i][j+5]=buf[(j*80+i)*2];
     //vydrz[i][j+5]=buf[(j*80+i)*2+1];
     pole[i][j+5]=buf[(j*80+i)*5];
     vydrz[i][j+5]=buf[(j*80+i)*5+1];
     cycle_min[i][j+5]=buf[(j*80+i)*5+2];
     cycle_max[i][j+5]=buf[(j*80+i)*5+3];
     cycle_akt[i][j+5]=buf[(j*80+i)*5+4];
  }
  farfree(buf);

}


//----------------------------------| VYKRESLI POLE
void vykresli_pole(void)
{
  int i,j;
  for(i=0;i<28;i++)
  {
         /*
	 for(j=i;j<80-i;j++) if(pole[j][i+5]!=POLICKO_MINIMINA) kocka2(j,i+5,pole[j][i+5]);
	 for(j=i;j<60-i;j++) if(pole[80-i][j]!=POLICKO_MINIMINA) kocka2(80-i,j,pole[80-i][j]);
	 for(j=79-i;j>=i;j--) if(pole[j][59-i]!=POLICKO_MINIMINA) kocka2(j,59-i,pole[j][59-i]);
	 for(j=59-i;j>=i;j--) if(pole[i][j]!=POLICKO_MINIMINA) kocka2(i,j,pole[i][j]);
         */
	 for(j=i;j<80-i;j++)  kocka2(j,i+5,pole[j][i+5]);
	 for(j=i;j<60-i;j++)  kocka2(80-i,j,pole[80-i][j]);
	 for(j=79-i;j>=i;j--) kocka2(j,59-i,pole[j][59-i]);
	 for(j=59-i;j>=i;j--) kocka2(i,j,pole[i][j]);
  }
}


//----------------------------------| NAKTANK
void naktank(int t)
{
  setcolor(tank[t].c);
  if(tank[t].bonus==BONUS_TOUCH_OF_DEATH) setcolor(13);
  for(int i=0;i<10;i++) line(tank[t].x+pos[tank[t].smer].px[i],tank[t].y+pos[tank[t].smer].py[i],tank[t].x+pos[tank[t].smer].px[i+1],tank[t].y+pos[tank[t].smer].py[i+1]);
  line(tank[t].x+pos[tank[t].smer].px[0],tank[t].y+pos[tank[t].smer].py[0],tank[t].x+pos[tank[t].smer].px[10],tank[t].y+pos[tank[t].smer].py[10]);
}


//----------------------------------| ZMAZTANK
void zmaztank(int t)
{
  setcolor(0);
  for(int i=0;i<10;i++) line(tank[t].x+pos[tank[t].smer].px[i],tank[t].y+pos[tank[t].smer].py[i],tank[t].x+pos[tank[t].smer].px[i+1],tank[t].y+pos[tank[t].smer].py[i+1]);
  line(tank[t].x+pos[tank[t].smer].px[0],tank[t].y+pos[tank[t].smer].py[0],tank[t].x+pos[tank[t].smer].px[10],tank[t].y+pos[tank[t].smer].py[10]);
}


void draw_energy_bar(int i, int e) {
   setfillstyle(1,energy_bar_color[e]);
   bar(i*200+49+e*20,11,i*200+66+e*20,17);
}

void erase_energy_bar(int i, int e) {
   setfillstyle(1,0);
   bar(i*200+49+e*20,11,i*200+66+e*20,17);
}



void draw_speed_bar(int i, int r, int col) {
   setcolor(col);
   rectangle(i*200+48+(abs(r))*3,25,i*200+49+(abs(r))*3,30);
}


//----------------------------------| VYKRESLI UDAJE

void vykresli_udaje(void)
{
  int i,j;
  char *string="  ";
  settextjustify(1,1);

  for(i=0;i<3;i++)
	 if(tank[i].exist)
	 {
		sprintf(string,"%d",i+1);
		setcolor(tank[i].c-8);
		settextstyle(1,0,5);
		outtextxy(i*200+20,12,string);outtextxy(i*200+19,13,string);
		setcolor(tank[i].c);
		outtextxy(i*200+18,14,string);outtextxy(i*200+17,15,string);
		setcolor(0);
		for(j=0;j<40;j+=2) line(i*200+2,j,i*200+40,j);
		setcolor(tank[i].c);rectangle(i*200+2,0,i*200+200,38);
		settextstyle(1,0,2);


                putimage(i*200+30,3,info_icon[0],0);
                putimage(i*200+30,20,info_icon[1],0);
                putimage(i*200+155,3,info_icon[2],0);

		//setcolor(15);outtextxy(i*200+40,8,"S:");setcolor(7);outtextxy(i*200+39,9,"S:");
		//setcolor(15);outtextxy(i*200+40,25,"R:");setcolor(7);outtextxy(i*200+39,26,"R:");
		//setcolor(15);outtextxy(i*200+160,8,"M:");setcolor(7);outtextxy(i*200+159,9,"M:");

                erase_bonus_name(i);
                setcolor(7);
                rectangle(i*200+49,23,i*200+51+60,32);
                for(j=1;j<=20;j++) draw_speed_bar(i,j,8);
		for(j=0;j<tank[i].max_shots;j++) draw_ammo_bar(i,j);

                //energy bar
		for(j=0;j<5;j++) {
                   draw_energy_bar(i,j);
		}


	 }


}


//----------------------------------| VYPOCET
void vypocet(void)
{
int i,j;
double pom,size=2.0;

for(i=0;i<32;i++)
{
	pom=UH(i*11.25);
	pos[i].px[0]=5.83*cos(pom-UH(149.0))*size; pos[i].py[0]=5.83*sin(pom-UH(149.0))*size;
	pos[i].px[1]=5.1 *cos(pom-UH(168.5))*size; pos[i].py[1]=5.1 *sin(pom-UH(168.5))*size;
	pos[i].px[2]=3.0 *cos(pom-UH(180.0))*size; pos[i].py[2]=3.0 *sin(pom-UH(180.0))*size;
	pos[i].px[3]=5.1 *cos(pom+UH(168.5))*size; pos[i].py[3]=5.1 *sin(pom+UH(168.5))*size;
	pos[i].px[4]=5.83*cos(pom+UH(149.0))*size; pos[i].py[4]=5.83*sin(pom+UH(149.0))*size;
	pos[i].px[5]=4.24*cos(pom+UH(45.0 ))*size; pos[i].py[5]=4.24*sin(pom+UH(45.0 ))*size;
	pos[i].px[6]=3.16*cos(pom+UH(18.45))*size; pos[i].py[6]=3.16*sin(pom+UH(18.45))*size;
	pos[i].px[7]=7.07*cos(pom+UH(8.13 ))*size; pos[i].py[7]=7.07*sin(pom+UH(8.13 ))*size;
	pos[i].px[8]=7.07*cos(pom-UH(8.13 ))*size; pos[i].py[8]=7.07*sin(pom-UH(8.13 ))*size;
	pos[i].px[9]=3.16*cos(pom-UH(18.45))*size; pos[i].py[9]=3.16*sin(pom-UH(18.45))*size;
	pos[i].px[10]=4.24*cos(pom-UH(45.0))*size; pos[i].py[10]=4.24*sin(pom-UH(45.0))*size;

	pos[i].xx=cos(pom)*20;pos[i].yy=sin(pom)*20;
	cisti;
}

for(i=0;i<3;i++)
{
        tank[i].score=0;
	tank[i].rychlost=0;
	tank[i].smer=0;
	tank[i].exist=1;
	tank[i].aktiv=1;
	tank[i].strely=0;
	tank[i].cas=18;
	tank[i].c=10+i;
	tank[i].stit=5;
	tank[i].vybuch=0;
	tank[i].minivybuch=0;
	tank[i].akstrely=0;
	tank[i].casnab=0;
	for(j=0;j<5;j++) {
	  tank[i].strela[j].exist=0;
	  tank[i].strela[j].c=10+i;
	}
}

 tank[0].left =LEFT_KEY;
 tank[0].right=RIGHT_KEY;
 tank[0].up   =UP_KEY;
 tank[0].down =DOWN_KEY;
 tank[0].down2=76;
 tank[0].fire =INS_KEY;

 tank[1].left =A_KEY;
 tank[1].right=D_KEY;
 tank[1].up   =W_KEY;
 tank[1].down =Z_KEY;
 tank[1].down2=S_KEY;
 tank[1].fire =TAB_KEY;

 tank[2].left =L_KEY;
 tank[2].right=UVODZOVKA_KEY;
 tank[2].up   =P_KEY;
 tank[2].down =BODKA_KEY;
 tank[2].down2=BODKOCIARKA_KEY;
 tank[2].fire =O_KEY;

 tank[0].x=50; tank[0].y=200;
 tank[1].x=250;tank[1].y=200;
 tank[2].x=450;tank[2].y=200;

}

//----------------------------------| VYTVOR VYBUCH

void vytvor_vybuch(int k)
{
	int l,m,pom,pom2;
	setfillstyle(1,7);bar(k*200+30,1,k*200+199,37);
	tank[k].aktiv=0;
	tank[k].vybuch=80;

        m=0;
        pom2=tank[k].max_shots-count_shots(k);
        while(m<pom2)
	for(l=0;l<MAX_SHOTS;l++) if(tank[k].strela[l].exist==0) {
	    tank[k].strela[l].exist=1;
	    tank[k].strela[l].zivot=INITZIVOT;
	    tank[k].strela[l].x=tank[k].x;
	    tank[k].strela[l].y=tank[k].y;
	    pom=random(32);
	    tank[k].strela[l].xx=pos[pom].xx/3;
	    tank[k].strela[l].yy=pos[pom].yy/3;
            m++;
            break;
	}






	 for(l=0;l<10;l++)
	 {
		 tank[k].ciara[l].x1=tank[k].x+pos[tank[k].smer].px[l];
		 tank[k].ciara[l].y1=tank[k].y+pos[tank[k].smer].py[l];
		 tank[k].ciara[l].x2=tank[k].x+pos[tank[k].smer].px[l+1];
		 tank[k].ciara[l].y2=tank[k].y+pos[tank[k].smer].py[l+1];
		 tank[k].ciara[l].c =tank[k].c;
		 tank[k].ciara[l].exist=1;
		 tank[k].ciara[l].xx=pos[tank[k].smer].px[l]<3 ? pos[tank[k].smer].px[l]/2 : pos[tank[k].smer].px[l]/3;
		 tank[k].ciara[l].yy=pos[tank[k].smer].py[l]<3 ? pos[tank[k].smer].py[l]/2 : pos[tank[k].smer].py[l]/3;
	 }
	 tank[k].ciara[10].x1=tank[k].x+pos[tank[k].smer].px[0];
	 tank[k].ciara[10].y1=tank[k].y+pos[tank[k].smer].py[0];
	 tank[k].ciara[10].x2=tank[k].x+pos[tank[k].smer].px[10];
	 tank[k].ciara[10].y2=tank[k].y+pos[tank[k].smer].py[10];
	 tank[k].ciara[10].xx=pos[tank[k].smer].px[10]<3 ? pos[tank[k].smer].px[10]/2 : pos[tank[k].smer].px[10]/3;
	 tank[k].ciara[10].yy=pos[tank[k].smer].py[10]<3 ? pos[tank[k].smer].py[10]/2 : pos[tank[k].smer].py[10]/3;
	 tank[k].ciara[10].c =tank[k].c;
	 tank[k].ciara[10].exist=1;

	 pom=0;
	 if(tank[k].minivybuch)
	 {
		 for(l=0;l<10;l++)
		 {
		  if(tank[k].bod[l].exist) putpixel(tank[k].bod[l].x,tank[k].bod[l].y,0);
		 }
	 }

	 for(l=-2;l<=2;l++)
	 {
		 tank[k].bod[pom].xx=l;
		 tank[k].bod[pom].yy=-3;
		 tank[k].bod[pom].x=tank[k].x+(tank[k].bod[pom].xx<<1);
		 tank[k].bod[pom].y=tank[k].y+(tank[k].bod[pom].yy<<1);
		 tank[k].bod[pom].c=14;
		 tank[k].bod[pom].exist=1;
		 pom++;
		 tank[k].bod[pom].xx=l;
		 tank[k].bod[pom].yy=3;
		 tank[k].bod[pom].x=tank[k].x+(tank[k].bod[pom].xx<<1);
		 tank[k].bod[pom].y=tank[k].y+(tank[k].bod[pom].yy<<1);
		 tank[k].bod[pom].c=14;
		 tank[k].bod[pom].exist=1;
		 pom++;

		 tank[k].bod[pom].xx=-3;
		 tank[k].bod[pom].yy=l;
		 tank[k].bod[pom].x=tank[k].x+(tank[k].bod[pom].xx<<1);
		 tank[k].bod[pom].y=tank[k].y+(tank[k].bod[pom].yy<<1);
		 tank[k].bod[pom].c=14;
		 tank[k].bod[pom].exist=1;
		 pom++;
		 tank[k].bod[pom].xx=3;
		 tank[k].bod[pom].yy=l;
		 tank[k].bod[pom].x=tank[k].x+(tank[k].bod[pom].xx<<1);
		 tank[k].bod[pom].y=tank[k].y+(tank[k].bod[pom].yy<<1);
		 tank[k].bod[pom].c=14;
		 tank[k].bod[pom].exist=1;
		 pom++;
	 }

	 for(l=-1;l<=1;l++)
	 {
		 tank[k].bod[pom].xx=l;
		 tank[k].bod[pom].yy=-2;
		 tank[k].bod[pom].x=tank[k].x+(tank[k].bod[pom].xx<<1);
		 tank[k].bod[pom].y=tank[k].y+(tank[k].bod[pom].yy<<1);
		 tank[k].bod[pom].c=tank[k].c;
		 tank[k].bod[pom].exist=1;
		 pom++;
		 tank[k].bod[pom].xx=l;
		 tank[k].bod[pom].yy=2;
		 tank[k].bod[pom].x=tank[k].x+(tank[k].bod[pom].xx<<1);
		 tank[k].bod[pom].y=tank[k].y+(tank[k].bod[pom].yy<<1);
		 tank[k].bod[pom].c=tank[k].c;
		 tank[k].bod[pom].exist=1;
		 pom++;

		 tank[k].bod[pom].xx=-2;
		 tank[k].bod[pom].yy=l;
		 tank[k].bod[pom].x=tank[k].x+(tank[k].bod[pom].xx<<1);
		 tank[k].bod[pom].y=tank[k].y+(tank[k].bod[pom].yy<<1);
		 tank[k].bod[pom].c=tank[k].c;
		 tank[k].bod[pom].exist=1;
		 pom++;
		 tank[k].bod[pom].xx=2;
		 tank[k].bod[pom].yy=l;
		 tank[k].bod[pom].x=tank[k].x+(tank[k].bod[pom].xx<<1);
		 tank[k].bod[pom].y=tank[k].y+(tank[k].bod[pom].yy<<1);
		 tank[k].bod[pom].c=tank[k].c;
		 tank[k].bod[pom].exist=1;
		 pom++;
	 }


}


//----------------------------------| NAPIS MNA = M.V.

void napis_mna(void)
{
  textcolor(7);
  gotoxy(50,1);cprintf("ͻ");
  gotoxy(50,2);cprintf("                        ");
  gotoxy(50,3);cprintf("                        ");
  gotoxy(50,4);cprintf("                        ");
  gotoxy(50,5);cprintf("ͼ");
  textcolor(15);
  gotoxy(53,2);cprintf("%s",text.created_by[lang]);
  gotoxy(53,4);cprintf("      - 2002 -    ");
  textcolor(12);
  gotoxy(53,3);cprintf("  MICHAL VESELENYI");

}


//----------------------------------| NAPIS OVLADANIE

void napis_ovladanie(void)
{
  textcolor(6);gotoxy(1,13);cprintf("----------------------------- %s ------------------------------------", text.controls[lang]);
  printf("\n\n");
  show_keyboard();
}


//----------------------------------| NAPIS "PRATANKY"

void napis_pratanky(void)
{
  int nahoda;
  nahoda=rand()%8;
  textcolor(rand()%15+1);
  switch(nahoda)
  {
  case 0: gotoxy(1,1);cprintf("");
	  gotoxy(1,2);cprintf(" ");
	  gotoxy(1,3);cprintf("   ");break;
  case 1: gotoxy(6,1);cprintf("");
	  gotoxy(6,2);cprintf("");
	  gotoxy(6,3);cprintf("  ");break;
  case 2: gotoxy(11,1);cprintf("");
	  gotoxy(11,2);cprintf("");
	  gotoxy(11,3);cprintf("  ");break;
  case 3: gotoxy(16,1);cprintf("");
	  gotoxy(16,2);cprintf("  ");
	  gotoxy(16,3);cprintf("  ");break;
  case 4: gotoxy(20,1);cprintf("");
	  gotoxy(20,2);cprintf("");
	  gotoxy(20,3);cprintf("  ");break;
  case 5: gotoxy(25,1);cprintf("  ");
	  gotoxy(25,2);cprintf(" ");
	  gotoxy(25,3);cprintf("   ");break;
  case 6: gotoxy(31,1);cprintf(" ");
	  gotoxy(31,2);cprintf(" ");
	  gotoxy(31,3);cprintf("  ");break;
  case 7: gotoxy(36,1);cprintf("   ");
	  gotoxy(36,2);cprintf("  ");
	  gotoxy(36,3);cprintf("    ");break;
  }
  gotoxy(43,2);cprintf("v4");
  textcolor(0);

}


void napis_rychlost(int r)
{
  textcolor(7);gotoxy(44,8);cprintf("%s ", text.speed[lang]);
  textcolor(14+128);cprintf("%d",r+1);
  textcolor(10);cprintf(" %s  ",text.speed_value[lang][r]);
}



void show_keyboard() {
   char klav[]=
   "`0b`ͻ`07``0b`ͻ`07``0c`ͻ`07`    `0a`ͻ`07`   `0a`ͻ`07`Ŀ\n"
   "`0b` TAB `07` Q `0b` W `07` E  R  T  Y  U  I `0c` O  P `07` [       `0a`INS`07`    7 `0a` 8 `07` 9 \n"
   "`0b`ͼͼͻ`07``0c`ͼͻ`07`   `0a`ͼ   ͼͻ`07`\n"
   " CAPS `0b` A  S  D `07` F  G  H  J  K `0c` L  ;  ' `07`             `0a` 4  5  6 `07`\n"
   "`0b`ͻͼ`07``0c`ͻͼ`07`           `0a`ͻͼ`07`\n"
   " SHIFT  `0b` Z `07` X  C  V  B  N  M  , `0c` . `07` /                 1 `0a` 2 `07` 3 \n"
   "`0b`ͼ`07``0c`ͼ`07`             `0a`ͼ`07`\n";
   colortext(klav);
}

void show_bonus_state(void) {
   gotoxy(12,11);
   colortext("`07`[ ] ");
   colortext((char*)text.bonus_enabled[lang]);
   if(bonus_enable) text_char(13,11,'x',14);
}

//----------------------------------| SETUP

void setup(void)
{
   int r=0;
   int kb;

   _setcursortype(_NOCURSOR);
   restore_keyboard_interrupt();

   clrscr();
   cisti;

   grip=4;reargrip=50;speedmul=3;

   textcolor(15);

   napis_mna();

   textcolor(13);gotoxy(12,6);cprintf( "        ͻ              ");
   textcolor(13);gotoxy(9,7);cprintf("%10s  1   %s", text.press[lang], text.pre2[lang]);
   textcolor(13);gotoxy(12,8);cprintf( "        ͹              ");
   textcolor(13);gotoxy(13,9);cprintf( "%6s  2   %s", text.or[lang], text.pre3[lang]);
   textcolor(13);gotoxy(12,10);cprintf("        ͼ              ");
   textcolor(14+128);gotoxy(22,7);cprintf("1");
   textcolor(14+128);gotoxy(22,9);cprintf("2");

   napis_ovladanie();
   napis_rychlost(r);

   bonus_enable=1;
   show_bonus_state();
   while(1)
   {
      if(kbhit()) {
         kb=getch();
         if( (kb=='+' || kb=='=') && r<3 ) { r++; napis_rychlost(r); }
         if( kb=='-' && r>0 ) { r--; napis_rychlost(r); }
         if(kb=='1') {
            tank[0].exist=1;tank[0].aktiv=1;
            tank[1].exist=1;tank[1].aktiv=1;
            tank[2].exist=0;tank[2].aktiv=0;
            pocethracov=2;
            break;
         }
         if(kb=='2') {
            tank[0].exist=1;tank[0].aktiv=1;
            tank[1].exist=1;tank[1].aktiv=1;
            tank[2].exist=1;tank[2].aktiv=1;
            pocethracov=3;
            break;
         }
         if(kb=='b' || kb=='B') {
            if(bonus_enable) { bonus_enable=0; show_bonus_state(); }
            else { bonus_enable=1; show_bonus_state(); }
         }
      }
      napis_pratanky();
      cisti;
      cakaj();
   }

   switch(r) {
      case 0: grip=3;reargrip=90;speedmul=3;strelamul=100;break;
      case 1: grip=6;reargrip=120;speedmul=4;strelamul=110;break;
      case 2: grip=9;reargrip=220;speedmul=6;strelamul=140;break;
      case 3: grip=12;reargrip=330;speedmul=13;strelamul=150;break;
   }
   cisti;
   set_keyboard_interrupt();
}


//----------------------------------| NAPIS "ZNOVA"

void napis_znova(void)
{
  settextstyle(1,0,4);
  setcolor(10);
  outtextxy(320,140,"Nikto nevyhral, tak ideme");setcolor(2);outtextxy(319,141,"Nikto nevyhral, tak ideme");
  settextstyle(1,0,10);setcolor(14);
  outtextxy(320,200,"ZNOVA !!!");setcolor(6);outtextxy(319,201,"ZNOVA !!!");
  setcolor(12);
  settextstyle(1,0,2);
  outtextxy(320,400,"ESC = Koniec !");setcolor(4);outtextxy(319,401,"ESC = Koniec !");
}


//----------------------------------|  ZBUCHNI TANKY

int charToFontIndex(unsigned char c) {
	int i;
	i=c-32;
	if(i>=96) i=95;
	return i;
}

void getCoordsAnim(int anim, int i, int xc, int yc, int x0, int y0, int *x, int *y) {
	int aa,t,tt;
	if(anim<4) {
		aa=3-anim;
		*x=x0+(xc-3)*(1+aa*3);
		*y=y0+(yc-5)*(4+aa*3);
	} 
	else if(anim<8) {
		aa=7-anim; // 3..0
		*x=x0+(xc-3);
		*y=y0+(yc-5)*(aa+6)/3;
	}
	else if(anim<30) {
		aa=anim-8; // 0..21
		tt=i%8-3;
		t=tt<0 ? -tt:tt; t-=2;
		*x=x0+(xc-3);
		*y=y0+(yc-5)*2+aa*t/3-aa;
	}
	else if(anim<36) {
		aa=anim-30; // 0..3
		tt=i%8-3;
		t=tt<0 ? -tt:tt; t-=2;
		*x=x0+(xc-3);
		*y=y0+(yc-5)*(aa+2)+7*t-21-aa*3;
	}
	else if(anim<40) {
		aa=anim-36; // 0..3
		tt=i%8-3;
		t=tt<0 ? -tt:tt; t-=2;
		*x=x0+(xc-3)*(aa*aa*5+1);
		*y=y0+(yc-5)*(5+aa*aa*4)+7*t-21-3*3;
		
	}
}

void linepixel(int x, int y) {
     line(x,y,x,y);
}

extern unsigned char theFont[96][55];
void zbuchni_tanky(char *name)
{
  int i,j,l;
	int k,c,len;
	int xc,yc, x0,y0, x,y;
	int anim,aa;
	len=strlen(name);


  for(i=0;i<3;i++)
  if(tank[i].exist==1)
  {
	 for(l=0;l<10;l++)
	 {
		 cisti;
		 tank[i].ciara[l].x1=tank[i].x+pos[tank[i].smer].px[l];
		 tank[i].ciara[l].y1=tank[i].y+pos[tank[i].smer].py[l];
		 tank[i].ciara[l].x2=tank[i].x+pos[tank[i].smer].px[l+1];
		 tank[i].ciara[l].y2=tank[i].y+pos[tank[i].smer].py[l+1];
		 tank[i].ciara[l].xx=pos[tank[i].smer].px[l]/2;
		 tank[i].ciara[l].yy=pos[tank[i].smer].py[l]/2;
	 }
	 tank[i].ciara[10].x1=tank[i].x+pos[tank[i].smer].px[0];
	 tank[i].ciara[10].y1=tank[i].y+pos[tank[i].smer].py[0];
	 tank[i].ciara[10].x2=tank[i].x+pos[tank[i].smer].px[10];
	 tank[i].ciara[10].y2=tank[i].y+pos[tank[i].smer].py[10];
	 tank[i].ciara[10].xx=pos[tank[i].smer].px[10]/2;
	 tank[i].ciara[10].yy=pos[tank[i].smer].py[10]/2;
  }


  setwritemode(1);

  j=28;
  for(i=0;i<3;i++) if(tank[i].exist==1)
  {
	  setcolor(tank[i].c);
	  for(l=0;l<11;l++)
	  line(tank[i].ciara[l].x1+tank[i].ciara[l].xx*j,tank[i].ciara[l].y1+tank[i].ciara[l].yy*j,tank[i].ciara[l].x2+tank[i].ciara[l].xx*j,tank[i].ciara[l].y2+tank[i].ciara[l].yy*j);
  }

	//--- font anim
        setcolor(15);
	for(anim = 0; anim<13; anim++) {
		for(i=0;i<len;i++) {
			c=charToFontIndex( name[i] );
			x0=320-4*len+i*8; y0=240-6;
			for(k=0;k<theFont[c][0];k++) {
				xc=theFont[c][k*2+1];
				yc=theFont[c][k*2+2];
				getCoordsAnim(anim-1, i, xc, yc, x0,y0,&x, &y);
				if(anim>0) linepixel(x,y);
				getCoordsAnim(anim, i, xc, yc, x0,y0,&x, &y);
				if(anim<40) linepixel(x,y);
			}
		}
                cakaj();
	}


	for(j=28;j>0;j--)
	{
     if(klavesy[F10_KEY]==1) { klavesnica_zrychli();exit(0);}
	  for(i=0;i<3;i++)
	  if(tank[i].exist==1)
	  {
		  setcolor(tank[i].c);
		  for(l=0;l<11;l++)
		  {
			  line(tank[i].ciara[l].x1+tank[i].ciara[l].xx*j,tank[i].ciara[l].y1+tank[i].ciara[l].yy*j,tank[i].ciara[l].x2+tank[i].ciara[l].xx*j,tank[i].ciara[l].y2+tank[i].ciara[l].yy*j);
			  line(tank[i].ciara[l].x1+tank[i].ciara[l].xx*(j-1),tank[i].ciara[l].y1+tank[i].ciara[l].yy*(j-1),tank[i].ciara[l].x2+tank[i].ciara[l].xx*(j-1),tank[i].ciara[l].y2+tank[i].ciara[l].yy*(j-1));
		  }
	  }

	  	//--- font anim
                setcolor(15);
	  	for(i=0;i<len;i++) {
			c=charToFontIndex( name[i] );
			x0=320-4*len+i*8; y0=240-6;
			for(k=0;k<theFont[c][0];k++) {
				xc=theFont[c][k*2+1];
				yc=theFont[c][k*2+2];
				getCoordsAnim(anim-1, i, xc, yc, x0,y0,&x, &y);
				if(anim>0) linepixel(x,y);
				getCoordsAnim(anim, i, xc, yc, x0,y0,&x, &y);
				if(anim<40) linepixel(x,y);
			}
		}
		anim++;

	  if(j==1) for(i=0;i<3;i++) if(tank[i].exist==1)
	  {
		  setwritemode(0);
		  setcolor(tank[i].c);
		  for(l=0;l<11;l++) line(tank[i].ciara[l].x1+tank[i].ciara[l].xx*(j-1),tank[i].ciara[l].y1+tank[i].ciara[l].yy*(j-1),tank[i].ciara[l].x2+tank[i].ciara[l].xx*(j-1),tank[i].ciara[l].y2+tank[i].ciara[l].yy*(j-1));
	  }
	  cakaj();

  }


}

unsigned char theFont[96][55]={
	{ 0 ,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 8 ,  3, 1,  3, 2,  3, 3,  3, 4,  3, 5,  3, 6,  3, 7,  3, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 6 ,  2, 1,  5, 1,  2, 2,  5, 2,  2, 3,  5, 3,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 22,  2, 2,  5, 2,  2, 3,  5, 3,  1, 4,  2, 4,  3, 4,  4, 4,  5, 4,  6, 4,  2, 5,  5, 5,  1, 6,  2, 6,  3, 6,  4, 6,  5, 6,  6, 6,  2, 7,  5, 7,  2, 8,  5, 8,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 21,  3, 1,  2, 2,  3, 2,  4, 2,  5, 2,  1, 3,  3, 3,  1, 4,  3, 4,  2, 5,  3, 5,  4, 5,  3, 6,  5, 6,  3, 7,  5, 7,  1, 8,  2, 8,  3, 8,  4, 8,  3, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 17,  2, 1,  6, 1,  1, 2,  3, 2,  6, 2,  2, 3,  5, 3,  4, 4,  4, 5,  3, 6,  2, 7,  5, 7,  2, 8,  4, 8,  6, 8,  1, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 17,  2, 3,  3, 3,  1, 4,  4, 4,  1, 5,  4, 5,  2, 6,  3, 6,  1, 7,  4, 7,  6, 7,  1, 8,  5, 8,  2, 9,  3, 9,  4, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 3 ,  3, 1,  3, 2,  3, 3,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 9 ,  5, 1,  4, 2,  4, 3,  3, 4,  3, 5,  3, 6,  4, 7,  4, 8,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 9 ,  2, 1,  3, 2,  3, 3,  4, 4,  4, 5,  4, 6,  3, 7,  3, 8,  2, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 14,  2, 3,  5, 3,  3, 4,  4, 4,  1, 5,  2, 5,  3, 5,  4, 5,  5, 5,  6, 5,  3, 6,  4, 6,  2, 7,  5, 7,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 9 ,  3, 3,  3, 4,  1, 5,  2, 5,  3, 5,  4, 5,  5, 5,  3, 6,  3, 7,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 6 ,  2, 8,  3, 8,  4, 8,  2, 9,  3, 9,  1, 10,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 5 ,  1, 5,  2, 5,  3, 5,  4, 5,  5, 5,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 5 ,  3, 8,  2, 9,  3, 9,  4, 9,  3, 10,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 9 ,  6, 1,  6, 2,  5, 3,  4, 4,  3, 5,  2, 6,  1, 7,  0, 8,  0, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 18,  3, 1,  4, 1,  2, 2,  5, 2,  1, 3,  6, 3,  1, 4,  6, 4,  1, 5,  6, 5,  1, 6,  6, 6,  1, 7,  6, 7,  2, 8,  5, 8,  3, 9,  4, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 15,  3, 1,  2, 2,  3, 2,  1, 3,  3, 3,  3, 4,  3, 5,  3, 6,  3, 7,  3, 8,  1, 9,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 20,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  6, 3,  6, 4,  5, 5,  3, 6,  4, 6,  2, 7,  1, 8,  1, 9,  2, 9,  3, 9,  4, 9,  5, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 20,  1, 1,  2, 1,  3, 1,  4, 1,  5, 1,  6, 1,  6, 2,  5, 3,  4, 4,  3, 5,  4, 5,  5, 5,  6, 6,  6, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 19,  5, 1,  4, 2,  5, 2,  3, 3,  5, 3,  2, 4,  5, 4,  1, 5,  5, 5,  1, 6,  5, 6,  1, 7,  2, 7,  3, 7,  4, 7,  5, 7,  6, 7,  5, 8,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 23,  1, 1,  2, 1,  3, 1,  4, 1,  5, 1,  6, 1,  1, 2,  1, 3,  1, 4,  3, 4,  4, 4,  5, 4,  1, 5,  2, 5,  6, 5,  6, 6,  6, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 21,  3, 1,  4, 1,  5, 1,  2, 2,  1, 3,  1, 4,  1, 5,  3, 5,  4, 5,  5, 5,  1, 6,  2, 6,  6, 6,  1, 7,  6, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 14,  1, 1,  2, 1,  3, 1,  4, 1,  5, 1,  6, 1,  6, 2,  5, 3,  4, 4,  4, 5,  3, 6,  3, 7,  2, 8,  2, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 24,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  6, 3,  1, 4,  6, 4,  2, 5,  3, 5,  4, 5,  5, 5,  1, 6,  6, 6,  1, 7,  6, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0 },
	{ 21,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  6, 3,  1, 4,  5, 4,  6, 4,  2, 5,  3, 5,  4, 5,  6, 5,  6, 6,  6, 7,  5, 8,  2, 9,  3, 9,  4, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 10,  3, 3,  2, 4,  3, 4,  4, 4,  3, 5,  3, 8,  2, 9,  3, 9,  4, 9,  3, 10,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 11,  3, 3,  2, 4,  3, 4,  4, 4,  3, 5,  2, 8,  3, 8,  4, 8,  2, 9,  3, 9,  1, 10,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 9 ,  6, 1,  5, 2,  4, 3,  3, 4,  2, 5,  3, 6,  4, 7,  5, 8,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 12,  1, 4,  2, 4,  3, 4,  4, 4,  5, 4,  6, 4,  1, 7,  2, 7,  3, 7,  4, 7,  5, 7,  6, 7,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 9 ,  1, 1,  2, 2,  3, 3,  4, 4,  5, 5,  4, 6,  3, 7,  2, 8,  1, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 13,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  6, 3,  6, 4,  5, 5,  4, 6,  4, 7,  4, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 27,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  6, 3,  1, 4,  4, 4,  5, 4,  6, 4,  1, 5,  3, 5,  6, 5,  1, 6,  3, 6,  5, 6,  6, 6,  1, 7,  4, 7,  6, 7,  1, 8,  2, 9,  3, 9,  4, 9,  5, 9 },
	{ 22,  3, 1,  4, 1,  2, 2,  5, 2,  1, 3,  6, 3,  1, 4,  6, 4,  1, 5,  6, 5,  1, 6,  2, 6,  3, 6,  4, 6,  5, 6,  6, 6,  1, 7,  6, 7,  1, 8,  6, 8,  1, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 24,  1, 1,  2, 1,  3, 1,  4, 1,  1, 2,  5, 2,  1, 3,  6, 3,  1, 4,  5, 4,  1, 5,  2, 5,  3, 5,  4, 5,  1, 6,  5, 6,  1, 7,  6, 7,  1, 8,  5, 8,  1, 9,  2, 9,  3, 9,  4, 9,  0, 0,  0, 0,  0, 0 },
	{ 17,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  1, 4,  1, 5,  1, 6,  1, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 22,  1, 1,  2, 1,  3, 1,  4, 1,  1, 2,  5, 2,  1, 3,  6, 3,  1, 4,  6, 4,  1, 5,  6, 5,  1, 6,  6, 6,  1, 7,  6, 7,  1, 8,  5, 8,  1, 9,  2, 9,  3, 9,  4, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 22,  1, 1,  2, 1,  3, 1,  4, 1,  5, 1,  6, 1,  1, 2,  1, 3,  1, 4,  1, 5,  2, 5,  3, 5,  4, 5,  1, 6,  1, 7,  1, 8,  1, 9,  2, 9,  3, 9,  4, 9,  5, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 17,  1, 1,  2, 1,  3, 1,  4, 1,  5, 1,  6, 1,  1, 2,  1, 3,  1, 4,  1, 5,  2, 5,  3, 5,  4, 5,  1, 6,  1, 7,  1, 8,  1, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 22,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  1, 4,  1, 5,  1, 6,  4, 6,  5, 6,  6, 6,  1, 7,  6, 7,  1, 8,  5, 8,  6, 8,  2, 9,  3, 9,  4, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 22,  1, 1,  6, 1,  1, 2,  6, 2,  1, 3,  6, 3,  1, 4,  6, 4,  1, 5,  2, 5,  3, 5,  4, 5,  5, 5,  6, 5,  1, 6,  6, 6,  1, 7,  6, 7,  1, 8,  6, 8,  1, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 17,  1, 1,  2, 1,  3, 1,  4, 1,  5, 1,  3, 2,  3, 3,  3, 4,  3, 5,  3, 6,  3, 7,  3, 8,  1, 9,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 16,  3, 1,  4, 1,  5, 1,  6, 1,  7, 1,  5, 2,  5, 3,  5, 4,  5, 5,  5, 6,  5, 7,  1, 8,  5, 8,  2, 9,  3, 9,  4, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 18,  1, 1,  6, 1,  1, 2,  5, 2,  1, 3,  4, 3,  1, 4,  3, 4,  1, 5,  2, 5,  1, 6,  3, 6,  1, 7,  4, 7,  1, 8,  5, 8,  1, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 14,  1, 1,  1, 2,  1, 3,  1, 4,  1, 5,  1, 6,  1, 7,  1, 8,  1, 9,  2, 9,  3, 9,  4, 9,  5, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 24,  0, 1,  6, 1,  0, 2,  6, 2,  0, 3,  1, 3,  5, 3,  6, 3,  0, 4,  2, 4,  4, 4,  6, 4,  0, 5,  3, 5,  6, 5,  0, 6,  3, 6,  6, 6,  0, 7,  6, 7,  0, 8,  6, 8,  0, 9,  6, 9,  0, 0,  0, 0,  0, 0 },
	{ 22,  1, 1,  6, 1,  1, 2,  6, 2,  1, 3,  2, 3,  6, 3,  1, 4,  3, 4,  6, 4,  1, 5,  4, 5,  6, 5,  1, 6,  5, 6,  6, 6,  1, 7,  6, 7,  1, 8,  6, 8,  1, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 22,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  6, 3,  1, 4,  6, 4,  1, 5,  6, 5,  1, 6,  6, 6,  1, 7,  6, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 20,  1, 1,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  6, 3,  1, 4,  6, 4,  1, 5,  2, 5,  3, 5,  4, 5,  5, 5,  1, 6,  1, 7,  1, 8,  1, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 25,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  6, 3,  1, 4,  6, 4,  1, 5,  6, 5,  1, 6,  6, 6,  1, 7,  3, 7,  6, 7,  1, 8,  4, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  6, 10,  0, 0,  0, 0 },
	{ 24,  1, 1,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  6, 3,  1, 4,  6, 4,  1, 5,  2, 5,  3, 5,  4, 5,  5, 5,  1, 6,  3, 6,  1, 7,  4, 7,  1, 8,  5, 8,  1, 9,  6, 9,  0, 0,  0, 0,  0, 0 },
	{ 20,  2, 1,  3, 1,  4, 1,  5, 1,  1, 2,  6, 2,  1, 3,  1, 4,  2, 5,  3, 5,  4, 5,  5, 5,  6, 6,  6, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 15,  0, 1,  1, 1,  2, 1,  3, 1,  4, 1,  5, 1,  6, 1,  3, 2,  3, 3,  3, 4,  3, 5,  3, 6,  3, 7,  3, 8,  3, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 20,  1, 1,  6, 1,  1, 2,  6, 2,  1, 3,  6, 3,  1, 4,  6, 4,  1, 5,  6, 5,  1, 6,  6, 6,  1, 7,  6, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 17,  0, 1,  6, 1,  0, 2,  6, 2,  1, 3,  5, 3,  1, 4,  5, 4,  1, 5,  5, 5,  2, 6,  4, 6,  2, 7,  4, 7,  2, 8,  4, 8,  3, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 23,  0, 1,  6, 1,  0, 2,  6, 2,  0, 3,  6, 3,  0, 4,  6, 4,  0, 5,  3, 5,  6, 5,  0, 6,  3, 6,  6, 6,  0, 7,  3, 7,  6, 7,  0, 8,  2, 8,  4, 8,  6, 8,  1, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 17,  0, 1,  6, 1,  0, 2,  6, 2,  1, 3,  5, 3,  2, 4,  4, 4,  3, 5,  2, 6,  4, 6,  1, 7,  5, 7,  0, 8,  6, 8,  0, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 13,  0, 1,  6, 1,  0, 2,  6, 2,  1, 3,  5, 3,  2, 4,  4, 4,  3, 5,  3, 6,  3, 7,  3, 8,  3, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 19,  1, 1,  2, 1,  3, 1,  4, 1,  5, 1,  6, 1,  6, 2,  5, 3,  4, 4,  3, 5,  2, 6,  1, 7,  1, 8,  1, 9,  2, 9,  3, 9,  4, 9,  5, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 15,  2, 1,  3, 1,  4, 1,  5, 1,  2, 2,  2, 3,  2, 4,  2, 5,  2, 6,  2, 7,  2, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 9 ,  0, 1,  0, 2,  1, 3,  2, 4,  3, 5,  4, 6,  5, 7,  6, 8,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 15,  1, 1,  2, 1,  3, 1,  4, 1,  4, 2,  4, 3,  4, 4,  4, 5,  4, 6,  4, 7,  4, 8,  1, 9,  2, 9,  3, 9,  4, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 5 ,  3, 1,  2, 2,  4, 2,  1, 3,  5, 3,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 7 ,  0, 10,  1, 10,  2, 10,  3, 10,  4, 10,  5, 10,  6, 10,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 2 ,  3, 0,  4, 1,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 19,  2, 4,  3, 4,  4, 4,  5, 4,  6, 5,  2, 6,  3, 6,  4, 6,  5, 6,  6, 6,  1, 7,  6, 7,  1, 8,  5, 8,  6, 8,  2, 9,  3, 9,  4, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 21,  1, 1,  1, 2,  1, 3,  1, 4,  3, 4,  4, 4,  5, 4,  1, 5,  2, 5,  6, 5,  1, 6,  6, 6,  1, 7,  6, 7,  1, 8,  2, 8,  6, 8,  1, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 14,  2, 4,  3, 4,  4, 4,  5, 4,  1, 5,  6, 5,  1, 6,  1, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 21,  6, 1,  6, 2,  6, 3,  2, 4,  3, 4,  4, 4,  6, 4,  1, 5,  5, 5,  6, 5,  1, 6,  6, 6,  1, 7,  6, 7,  1, 8,  5, 8,  6, 8,  2, 9,  3, 9,  4, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 19,  2, 4,  3, 4,  4, 4,  5, 4,  1, 5,  6, 5,  1, 6,  2, 6,  3, 6,  4, 6,  5, 6,  6, 6,  1, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 16,  3, 1,  4, 1,  5, 1,  2, 2,  6, 2,  2, 3,  2, 4,  1, 5,  2, 5,  3, 5,  4, 5,  5, 5,  2, 6,  2, 7,  2, 8,  2, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 22,  2, 4,  3, 4,  4, 4,  6, 4,  1, 5,  5, 5,  1, 6,  5, 6,  2, 7,  3, 7,  4, 7,  1, 8,  2, 9,  3, 9,  4, 9,  5, 9,  1, 10,  6, 10,  2, 11,  3, 11,  4, 11,  5, 11,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 18,  1, 1,  1, 2,  1, 3,  1, 4,  3, 4,  4, 4,  5, 4,  1, 5,  2, 5,  6, 5,  1, 6,  6, 6,  1, 7,  6, 7,  1, 8,  6, 8,  1, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 12,  3, 2,  2, 4,  3, 4,  3, 5,  3, 6,  3, 7,  3, 8,  1, 9,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 14,  5, 2,  4, 4,  5, 4,  5, 5,  5, 6,  5, 7,  5, 8,  1, 9,  5, 9,  1, 10,  5, 10,  2, 11,  3, 11,  4, 11,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 16,  1, 1,  1, 2,  1, 3,  1, 4,  5, 4,  1, 5,  4, 5,  1, 6,  2, 6,  3, 6,  1, 7,  4, 7,  1, 8,  5, 8,  1, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 14,  2, 1,  3, 1,  3, 2,  3, 3,  3, 4,  3, 5,  3, 6,  3, 7,  3, 8,  1, 9,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 19,  0, 4,  1, 4,  2, 4,  4, 4,  5, 4,  0, 5,  3, 5,  6, 5,  0, 6,  3, 6,  6, 6,  0, 7,  3, 7,  6, 7,  0, 8,  3, 8,  6, 8,  0, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 15,  1, 4,  3, 4,  4, 4,  5, 4,  1, 5,  2, 5,  6, 5,  1, 6,  6, 6,  1, 7,  6, 7,  1, 8,  6, 8,  1, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 16,  2, 4,  3, 4,  4, 4,  5, 4,  1, 5,  6, 5,  1, 6,  6, 6,  1, 7,  6, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 19,  1, 4,  3, 4,  4, 4,  5, 4,  1, 5,  2, 5,  6, 5,  1, 6,  6, 6,  1, 7,  2, 7,  6, 7,  1, 8,  3, 8,  4, 8,  5, 8,  1, 9,  1, 10,  1, 11,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 19,  2, 4,  3, 4,  4, 4,  6, 4,  1, 5,  5, 5,  6, 5,  1, 6,  6, 6,  1, 7,  5, 7,  6, 7,  2, 8,  3, 8,  4, 8,  6, 8,  6, 9,  6, 10,  6, 11,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 10,  1, 4,  3, 4,  4, 4,  5, 4,  2, 5,  6, 5,  2, 6,  2, 7,  2, 8,  2, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 16,  2, 4,  3, 4,  4, 4,  5, 4,  1, 5,  6, 5,  2, 6,  3, 6,  4, 7,  5, 7,  1, 8,  6, 8,  2, 9,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 15,  2, 2,  2, 3,  1, 4,  2, 4,  3, 4,  4, 4,  5, 4,  2, 5,  2, 6,  2, 7,  2, 8,  6, 8,  3, 9,  4, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 14,  1, 4,  5, 4,  1, 5,  5, 5,  1, 6,  5, 6,  1, 7,  5, 7,  1, 8,  5, 8,  2, 9,  3, 9,  4, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 11,  1, 4,  5, 4,  1, 5,  5, 5,  1, 6,  5, 6,  2, 7,  4, 7,  2, 8,  4, 8,  3, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 16,  0, 4,  6, 4,  0, 5,  6, 5,  0, 6,  3, 6,  6, 6,  0, 7,  3, 7,  6, 7,  0, 8,  2, 8,  4, 8,  6, 8,  1, 9,  5, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 12,  1, 4,  6, 4,  2, 5,  5, 5,  3, 6,  4, 6,  3, 7,  4, 7,  2, 8,  5, 8,  1, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 20,  1, 4,  6, 4,  1, 5,  6, 5,  1, 6,  6, 6,  1, 7,  5, 7,  6, 7,  2, 8,  3, 8,  4, 8,  6, 8,  6, 9,  1, 10,  6, 10,  2, 11,  3, 11,  4, 11,  5, 11,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 16,  1, 4,  2, 4,  3, 4,  4, 4,  5, 4,  6, 4,  5, 5,  4, 6,  3, 7,  2, 8,  1, 9,  2, 9,  3, 9,  4, 9,  5, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 14,  4, 1,  5, 1,  6, 1,  3, 2,  3, 3,  4, 4,  2, 5,  3, 5,  4, 6,  3, 7,  3, 8,  4, 9,  5, 9,  6, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 9 ,  3, 1,  3, 2,  3, 3,  3, 4,  3, 5,  3, 6,  3, 7,  3, 8,  3, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 14,  1, 1,  2, 1,  3, 1,  4, 2,  4, 3,  3, 4,  4, 5,  5, 5,  3, 6,  4, 7,  4, 8,  1, 9,  2, 9,  3, 9,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 7 ,  2, 1,  5, 1,  1, 2,  3, 2,  5, 2,  1, 3,  4, 3,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 },
	{ 5 ,  3, 8,  2, 9,  3, 9,  4, 9,  3, 10,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0 }
};






void exitas(int a) {
   restore_interrupts();
   cisti;
   klavesnica_zrychli();
   closegraphics();
   exit(a);
}

int is_visible(int x, int y) {
   //if(!pole[x][y]) return 0;
   if(!cycle_min[x][y]) return 1;
   return (cycle_akt[x][y]>=cycle_min[x][y]);
}

void make_damage(int x,int y,unsigned int damage) {
   int p=pole[x][y];
   if(x<80 && x>0 && y>=5 && y<60)
   if(p && vydrz[x][y]<254 && vydrz[x][y]>0) {
      if(!is_visible(x,y)) return;

      if(damage>=vydrz[x][y]) {
         vydrz[x][y]=0;
      } else {
         vydrz[x][y]-=damage;
      }
      if(vydrz[x][y]==0) vydrz[x][y]=ENERGIA_TO_EXPLODE;
   }

}



// 200   201   202   203   204   205   206   185   186   187   188
//'''''''''                     
//            
//  

void text_char(int x, int y, char c, int color) {
   textattr(color);
   gotoxy(x,y);
   putch(c);
}

void text_box(int x1, int y1, int x2, int y2, int type, int color) {
   int i,j;
   char c11,c12,c21,c22,ch,cv;
   switch(type) {
      case 0: c11=''; c21=''; c22=''; c12=''; ch=''; cv=''; break;
      case 1: c11=''; c21=''; c22=''; c12=''; ch=''; cv=''; break;
      default: c11=type; c21=type; c22=type; c12=type; ch=type; cv=type; break;
   }

   for(i=x1+1; i<x2;i++) { text_char(i,y1,ch,color); text_char(i,y2,ch,color); }
   for(i=y1+1; i<y2;i++) { text_char(x1,i,cv,color); text_char(x2,i,cv,color); }
   text_char(x1,y1,c11,color);
   text_char(x1,y2,c12,color);
   text_char(x2,y2,c22,color);
   text_char(x2,y1,c21,color);
}

void text_hline(int x1, int y, int x2, int type, int type_bord, int color) {
   int i,j;
   char c1,c2,ch;
   switch(type) {
      case 0: ch='';
              switch(type_bord) {
                 case 0: c1=''; c2=''; break;
                 case 1: c1=''; c2=''; break;
                 case 2: c1=ch; c2=ch; break;
              }
              break;
      case 1: ch='';
              switch(type_bord) {
                 case 0: c1=''; c2=''; break;
                 case 1: c1=''; c2=''; break;
                 case 2: c1=ch; c2=ch; break;
              }
              break;
   }

   for(i=x1+1; i<x2;i++) { text_char(i,y,ch,color); }
   text_char(x1,y,c1,color);
   text_char(x2,y,c2,color);
}

int correct_lang_quantity(int q) {
   q=abs(q);
   if(q==0 || q>=5) return 2;
   if(q==1) return 0;
   return 1;
}


int hextoint(int a) {
   if(a>='0' && a<='9') return (a-'0');
   if(a>='a' && a<='f') return (a-'a'+10);
   if(a>='A' && a<='F') return (a-'A'+10);
   return 0;
}

void colortext(char *text) {
   int i,j,l;
   int a1,a2;
   char buf[200];
   l=strlen(text);
   i=0;
   while(i<l) {
      if(text[i]=='`') {
         if(text[i+1]=='`') {
            putch('`');
            i+=2;
         }
         else {
            j=(hextoint(text[i+1])<<4) + hextoint(text[i+2]);
            i+=4;
            textattr(j);
         }
      }
      else {
         if(text[i]=='\n') putch('\r');

         putch(text[i]);
         i++;
      }
   }
}

void modify_speed(int i, int inc) {
   if(inc>0 && tank[i].rychlost<MAXSPEED)
   {

      if(tank[i].rychlost>= 0) {
         tank[i].rychlost++; draw_speed_bar(i,(tank[i].rychlost+1)/2,3);
      }
      if(tank[i].rychlost< 0) {
         draw_speed_bar(i,tank[i].rychlost,8); tank[i].rychlost++;
      }

   }
   if(inc<0 && tank[i].rychlost>(-MAXSPEED/2))
   {

      if(tank[i].rychlost<= 0) {
         tank[i].rychlost--; draw_speed_bar(i,tank[i].rychlost,4);
      }
      if(tank[i].rychlost> 0) {
         draw_speed_bar(i,(tank[i].rychlost+1)/2,8) ;tank[i].rychlost--;
      }

   }
}

void text_fill_line(int x1, int y, int x2, char c, int color) {
   int i,j;
   for(i=x1; i<=x2;i++) { text_char(i,y,c,color); }
}



int minimum(int a, int b) {
   if(a<b) return a;
   return b;
}

int maximum(int a, int b) {
   if(a>b) return a;
   return b;
}


void draw_ammo_bar(int i, int bari) {
   int ma=tank[i].max_shots;
   int spacing, size;
   if(ma==5) { spacing=6; size=4; }
   if(ma==10) { spacing=3; size=2; }
   if(ma==15) { spacing=2; size=1; }
   setfillstyle(1,7);
   bar(i*200+174, bari*spacing+5, i*200+189, bari*spacing+size+4);
}

void erase_ammo_bar(int i, int bari) {
   int ma=tank[i].max_shots;
   int spacing, size;
   if(ma==5) { spacing=6; size=4; }
   if(ma==10) { spacing=3; size=2; }
   if(ma==15) { spacing=2; size=1; }
   setfillstyle(1,0);
   bar(i*200+174, bari*spacing+5, i*200+189, bari*spacing+size+4);
}

void redraw_ammo(int i) {
   int j;
   setfillstyle(1,0); bar(i*200+174, 5, i*200+189, 4*6+9);
   for(j=0;j<tank[i].shots_left;j++) {
      draw_ammo_bar(i,j);
   }
}

int count_shots(int i) {
   int j,n;
   n=0;
   for(j=0;j<MAX_SHOTS;j++) {
      if(tank[i].strela[j].exist==1) n++;
   }
   return n;
}

void erase_bonus_name(int i) {
   int x1=i*200+117, x2=i*200+167;
   setfillstyle(1,0);
   bar(x1,22,x2,33);
   setcolor(8);
   line(x1,22,x2,33);
   line(x2,22,x1,33);
   setcolor(7);
   rectangle(x1,22,x2,33);
}

void draw_bonus_name(int i, int bonus) {
   int x1=i*200+117, x2=i*200+167;
   setfillstyle(1,0);
   bar(x1,22,x2,33);
   setcolor(14);
   rectangle(x1,22,x2,33);
   settextstyle(0,0,1);
   settextjustify(1, 1);
   setcolor(15);
   outtextxy(i*200+142,28, bonus_name[bonus]);
}



void manage_bonus(int i, int bonus, int is_new) {
   int new_shots,x,y,pom,p1,p2;
   if(tank[i].aktiv==0) return;
   //bonus=BONUS_SHIELD_RESTORE;

   if(is_new) {
      tank[i].bonus=bonus;
      tank[i].default_reload_time=DEFAULT_RELOAD_TIME;
      new_shots=5;

      draw_bonus_name(i, bonus);

      switch(bonus) {
         case BONUS_GAUSS_CANNON:
            tank[i].bonus_max_time=15*18;
            tank[i].bonus_color=12;
            break;
         case BONUS_BACKFIRE:
            tank[i].bonus_max_time=15*18;
            tank[i].bonus_color=6;
            tank[i].default_reload_time=18+9;
            break;
         case BONUS_TWO_WAY_FIRE:
            new_shots=10;
            tank[i].bonus_max_time=20*18;
            tank[i].bonus_color=11;
            tank[i].default_reload_time=18+9;
            break;
         case BONUS_WIDE_SHOT:
            new_shots=15;
            tank[i].bonus_max_time=15*18;
            tank[i].bonus_color=10;
            tank[i].default_reload_time=18;
            break;
         case BONUS_FAST_RELOAD:
            tank[i].bonus_max_time=15*18;
            tank[i].bonus_color=2;
            tank[i].default_reload_time=1;
            tank[i].reload_time=1;
            break;
         case BONUS_15_SHOTS:
            new_shots=15;
            tank[i].bonus_max_time=20*18;
            tank[i].bonus_color=5;
            tank[i].default_reload_time=18+9;
            break;
         case BONUS_TOUCH_OF_DEATH:
            tank[i].bonus_max_time=10*18;
            tank[i].bonus_color=13;
            break;
         case BONUS_SHIELD_RESTORE:
            tank[i].bonus_max_time=50;
            tank[i].bonus_color=14;
            break;

         default:
            tank[i].bonus_max_time=15*18;

      }
      if(tank[i].shots_left>new_shots) tank[i].shots_left=new_shots;

      if(tank[i].max_shots<new_shots) {
         pom=
         p1=count_shots(i)+tank[i].shots_left;
         p2=new_shots-p1-1;
         if(p2>0) {
            p2=minimum(p2, abs(tank[i].max_shots-new_shots));
            tank[i].shots_left+=p2;
         }
      }

      tank[i].max_shots=new_shots;

      redraw_ammo(i);
      tank[i].bonus_time=tank[i].bonus_max_time;
   }

   if(tank[i].bonus_time>0) {
      setcolor(7);
      x=i*200+192;
      y=3;
      rectangle(x,y,x+5,y+32);
      pom=tank[i].bonus_time*30/tank[i].bonus_max_time;

      if(tank[i].bonus==BONUS_SHIELD_RESTORE && tank[i].bonus_time%10==0 && tank[i].stit<5) {
         draw_energy_bar(i,tank[i].stit);
         tank[i].stit++;
      }

      setfillstyle(1, tank[i].bonus_color);
      bar(x+1,y+31-pom,x+4,y+31);
      setfillstyle(1,0);
      bar(x+1,y+1,x+4,y+31-pom);
      tank[i].bonus_time--;

      if(tank[i].bonus_time==0) {
         erase_bonus_name(i);
         setfillstyle(1,0);
         bar(x,y,x+5,y+32);
         tank[i].bonus=0;
         tank[i].max_shots=5;
         tank[i].default_reload_time=DEFAULT_RELOAD_TIME;
         if(tank[i].shots_left>tank[i].max_shots) tank[i].shots_left=tank[i].max_shots;
         redraw_ammo(i);
      }
   }

}

void init_bonus(void) {
   int i,j,k;
   int xx,yy,xxx,yyy,d,ok;
   for(j=0;j<20;j++) {
      xx=random(78)+1;
      yy=random(53)+6;
      //xx=14;
      //yy=7;

      xxx=xx*8;
      yyy=yy*8;
      ok=1;
      for(i=0;i<pocethracov;i++) {
         if(abs(xxx-tank[i].x)<50 && abs(yyy-tank[i].y)<50) ok=0;
         if(pole[xx][yy]) ok=0;
      }
      if(ok==1) break;
   }
   if(!ok) {
      bonus_time=0;
      return;
   }
   else {
      bonusx=xx;
      bonusy=yy;
      bonus_time=18*5+random(5*18);
      bonus_etap=0;
      bonus_count=0;
   }
}

void draw_bonus_tile(void) {
   int xx,yy,next,pom,pom2;
   if(bonus_time<=0) return;
   xx=bonusx<<3; yy=bonusy<<3;

   pom2=6+((bonus_time/7)%2)*8;
   pom=bonus_time%7;
   putpixel(xx+pom,yy,pom2);
   putpixel(xx+7-pom,yy+7,pom2);
   putpixel(xx,yy+7-pom,pom2);
   putpixel(xx+7,yy+pom,pom2);

   next=0;
   setcolor(bonus_color);
   switch(bonus_etap) {
      case 0:
         rectangle(xx+3-bonus_count,yy+3-bonus_count,xx+4+bonus_count,yy+4+bonus_count);
         bonus_count++;
         if(bonus_count>2) next=1; break;
      case 1:
         line(xx+1,yy+1+bonus_count,xx+6,yy+1+bonus_count);
         line(xx+1,yy+6-bonus_count,xx+6,yy+6-bonus_count);
         bonus_count++;
         if(bonus_count>2) next=1; break;
      case 2:
         line(xx+1,yy+3-bonus_count,xx+6,yy+3-bonus_count);
         line(xx+1,yy+4+bonus_count,xx+6,yy+4+bonus_count);
         bonus_count++;
         if(bonus_count>2) next=1; break;
      case 3:
         line(xx+3-bonus_count,yy+1,xx+3-bonus_count,yy+6);
         line(xx+4+bonus_count,yy+1,xx+4+bonus_count,yy+6);
         bonus_count++;
         if(bonus_count>2) next=1; break;
      case 4:
         line(xx+1+bonus_count,yy+1,xx+1+bonus_count,yy+6);
         line(xx+6-bonus_count,yy+1,xx+6-bonus_count,yy+6);
         bonus_count++;
         if(bonus_count>2) next=1; break;
      case 5:
         rectangle(xx+1+bonus_count,yy+1+bonus_count,xx+6-bonus_count,yy+6-bonus_count);
         bonus_count++;
         if(bonus_count>2) next=1; break;
      case 6:
         line(xx+1,yy+1+bonus_count,xx+6,yy+1+bonus_count);
         bonus_count++;
         if(bonus_count>6) next=1; break;
      case 7:
         line(xx+1+bonus_count,yy+1,xx+1+bonus_count,yy+6);
         bonus_count++;
         if(bonus_count>6) next=1; break;
   }
   if(next==1) {
      bonus_count=0;
      bonus_etap=random(6);
      bonus_color=random(15)+1;
   }
   bonus_time--;
   if(bonus_time==0) {
      erase_bonus_tile();
   }

}

void erase_bonus_tile(void) {
   int xx,yy;
   xx=bonusx<<3; yy=bonusy<<3;
   setfillstyle(1,0);
   bar(xx,yy,xx+7,yy+7);
}


void fire_shot(int i, int pp2, int pp1) {
   int j;
   erase_ammo_bar(i, tank[i].shots_left-1);
   for(j=0;j<MAX_SHOTS;j++) if(tank[i].strela[j].exist==0) break;
   if(j==MAX_SHOTS) exitas(1);
   tank[i].strela[j].exist=1;
   tank[i].strela[j].zivot=INITZIVOT;
   tank[i].strela[j].x=tank[i].x+((pos[pp2].px[8]+pos[pp2].px[7]) >> 1);
   tank[i].strela[j].y=tank[i].y+((pos[pp2].py[8]+pos[pp2].py[7]) >> 1);
   tank[i].strela[j].xx=pos[pp2].xx*pp1/300;
   tank[i].strela[j].yy=pos[pp2].yy*pp1/300;
   tank[i].strela[j].smer=pp2;
   tank[i].cas=10;
   tank[i].shots_left--;
}


long filesize(FILE *stream) {
   long curpos, length;
   curpos = ftell(stream);
   fseek(stream, 0L, SEEK_END);
   length = ftell(stream);
   fseek(stream, curpos, SEEK_SET);
   return length;
}


int get_num_rounds(void) {
   FILE *f;
   long size;
   f=fopen("tanky_v4.lev","rb");
   size=filesize(f);
   return size/BYTES_PER_LEVEL;
}
