
/*
 *         ~T~ /~\ I I I/ \ /
 *          I  I-I I\I K   Y
 *          I  I I I I I\  I
 *
 *  Version 4, not compatible with 'Tanky 3/2/1'
 *
 *  Last modified : dec 2003
 *  Author : Michal Veselenyi (Slovak Republic)
 *
 *  Compiled with Borland C++ 3.1, on FreeDOS + DOSemu / Debian Unstable
 *
 */


#include "tanky.h"
#include <ctype.h>


//-------------------------------------------------------------------------
//--------------                     --------------------------------------
//-------------- *   *  ***  * *   * --------------------------------------
//-------------- ** ** *   * * **  * --------------------------------------
//-------------- * * * ***** * * * * --------------------------------------
//-------------- *   * *   * * *  ** --------------------------------------
//-------------- *   * *   * * *   * --------------------------------------
//--------------                     --------------------------------------
//-------------------------------------------------------------------------



int main(int argc, char *argv[])
{

   int i,j,k,l,m;
   int p1,p2,p3,p4,p5,p6,p7;
   int kb, level_count, is_winner;
   int maximum,winner;
   int num_rounds;
   int ranking;
   int y;
   char tmpc;
   char motif[10]="*+&%#@.-^";



//--------------------------------------------------------------------------
//---------------------|  I N T I T  |--------------------------------------
//--------------------------------------------------------------------------

set_interrupts();


lang=LANG_ENG;
if(argc!=1) {
   tmpc=tolower(argv[1][0]);
   if(tmpc=='s') lang=LANG_SVK;
}

num_rounds=get_num_rounds();
initminibod();
klavesnica_zpomal();
vypocet();
setup();
cisti;
initgraphics();


//--------------------------------------------------------------------------
//---------------------|  C O D E  |----------------------------------------
//--------------------------------------------------------------------------

nacitaj_data();



level_count=1;
is_final_round=0;
while(1)
{



   //------- init and run match -------

   if(is_final_round) {
      kolo=random(num_rounds)+1;
   }
   else kolo=level_count;

   spravpole(kolo-1);
   cleardevice();
   vykresli_pole();

   //--- run the match
   winner=zapas();

   closegraphics();


   //------- show stats after round # -------

   text_box(1,2,80,4,1,7);
   text_box(1,1,30,4,1,7);
   text_fill_line(2,2,29, ' ', 7);
   text_char(30,2,'',7);


   textattr(7); gotoxy(3,3); cprintf("%s : ",text.level_name[lang]);
   textattr(3); cprintf("%s", level_description);
   textattr(14); gotoxy(3,2); cprintf("%s %d / %d",text.scores_after_round[lang], level_count, num_rounds);

   text_box(1,4,80,pocethracov*5+4,0,7);

   for(i=0;i<pocethracov;i++)
   {
      y=i*5+5;
      tank[i].score += tank[i].score_hits + tank[i].score_victory;
      if(i<pocethracov-1) text_hline(2,y+4,79,1,2,7);

      textcolor(tank[i].c);
      gotoxy(3,y);
      textattr(tank[i].c); cprintf("");
      textattr(tank[i].c+16*(tank[i].c-8)); cprintf(" Tank %d ",i+1);
      textattr(tank[i].c); cprintf("۲");

      if(winner==i) {
         textattr(tank[i].c+128);
         cprintf("  %s",text.round_winner[lang]);
         textattr(7);
      }

      textcolor(14); gotoxy(3,y+1);
      cprintf("Score : %d", tank[i].score);

      k=tank[i].score/30;
      gotoxy(4,y+2);
      for(j=0;j<k;j++) {
         textattr(14+16*6); cprintf("30");
         textattr(6); cprintf("");
      }
      for(j=0;j<tank[i].score-k*30;j++) {
         textattr(14); cprintf("۱");
      }

      textattr(2);
      gotoxy(4,y+3);
      if(tank[i].score_hits) {
         cprintf("( ");
         j=correct_lang_quantity(tank[i].score_hits);
         cprintf("%d %s %s", tank[i].score_hits, text.points[lang][j], text.for_hits[lang]);
         if(tank[i].score_victory) cprintf(", ");
         else cprintf(" )");
      }
      if(tank[i].score_victory) {
         if(tank[i].score_hits==0) cprintf("( ");
         j=correct_lang_quantity(tank[i].score_victory);
         cprintf("%d %s %s", tank[i].score_victory, text.points[lang][j], text.for_victory[lang]);
         cprintf(" )");
      }
   }


   if(winner==3)
   {
     textcolor(7+128); gotoxy(32,1);
     cprintf("%s",text.remiza[lang]);
   }

   textcolor(12);gotoxy(1,24);cprintf("%8s : ", text.press[lang]);
   textcolor(10);gotoxy(12,24);cprintf("%s", text.enter_for_round[lang]);
   textcolor(12);gotoxy(12,25);cprintf("%s", text.esc_for_quit[lang]);

   level_count++;
   //----------- last level done -------------------
   if(level_count>num_rounds) {
      maximum=-1;
      for(i=0;i<pocethracov;i++) if(tank[i].score>maximum) maximum=tank[i].score;
      for(i=0;i<pocethracov;i++) if(tank[i].score==maximum) is_final_round++;
      if(is_final_round>1) { is_final_round=1; }
      else { is_final_round=0; break; }

      //----------- no one is first ----------
      text_box(1,20,80,22,0,13);
      gotoxy(3,21); colortext((char*)text.note[lang]);

   }

   while(1)
   {
      if(klavesy[ENTER_KEY] || klavesy[SPACE_KEY]) break;
      if(klavesy[ESC_KEY]) goto koniec;
      cisti;
   }
   initgraphics();



}     //-----------> end while


lokkoniec:
closegraphics();
clrscr();

textattr(8);
for(i=1;i<25;i++)
for(j=1;j<80;j++) {
   k=random(9);
   tmpc=motif[k];
   gotoxy(j,i); putch(tmpc);
}


for(i=0;i<15;i++) {
   j=minimum(6,i);
   text_box(40-i,12-j,41+i,13+j,0,15);
   cakaj();
}
for(i=0;i<14;i++) {
   j=minimum(5,i);
   text_box(40-i,12-j,41+i,13+j,' ',15);
   cakaj();
}


for(i=0;i<pocethracov;i++) {
   k=0;
   for(j=0;j<pocethracov;j++) {
      if(tank[i].score>=tank[j].score && j!=i) k++;
   }
   ranking=pocethracov-k;

   y=i*4+12-5;

   text_box(30,3,51,6,1,15);
   text_box(31,4,50,5,' ',15);
   textattr(14); gotoxy(33,4); cprintf("P R A T A N K Y");
   gotoxy(40-strlen(text.final_results[lang])/2, 5);
   cprintf("%s",text.final_results[lang]);



   text_box(34,y,53,y+3,0,tank[i].c);
   gotoxy(36,y+1);
   textattr(tank[i].c); cprintf("");
   textattr(tank[i].c+16*(tank[i].c-8)); cprintf(" Tank %d ",i+1);
   textattr(tank[i].c); cprintf("۲");
   gotoxy(36,y+2);
   textattr(14); cprintf("Score : %d", tank[i].score);


   if(ranking==1) {
      textcolor(14+128);
      gotoxy(28,y);cprintf( "_____");
      gotoxy(28,y+1);cprintf( " V ");
      gotoxy(28,y+2);cprintf(" \\/ ");
      gotoxy(28,y+3);cprintf( "  ");
   }
   else {
      textcolor(14);
      gotoxy(30,y+2);cprintf("%d", ranking);
      text_box(28,y+1,32,y+3,1,14);
   }
}


text_fill_line(1, 25, 79, ' ', 7);
textattr(7);
gotoxy(1,25);
cg;



//--------------------------------------------------------------------------
//----------------------    E N D   ----------------------------------------
//--------------------------------------------------------------------------
koniec:


   klavesnica_zrychli();
   restore_interrupts();
   cisti;
   closegraphics();
   return 0;
}

