//===========================================================
// Function Intersection Grapher aka...
//  FunIntGra aka...
//   FIG
// Description: A grapher of what used to be formulas
//              with intersection highlight. It now uses
//              more than functions.
// by Kristos (Kritter)
//===========================================================
// Todo:
//  Readme
//  Save/Load
//===========================================================
// Includes
//===========================================================
#include <allegro.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
//===========================================================
// Global Constants
//===========================================================
#define XRES 640
#define YRES 480
#define HYRES 240
//What are these two?!? Life and Lbak?
// That is what I used in my Game of Life
// Program and Screen Saver as a buffer.
// I just 'cheated' (not really! :] ) and
// copied the code.
#define LIFE(a,b) *(life+(a)*YRES+(b))
//#define LBAK(a,b) *(lbak+(a)*YRES+(b))
//Oooo, debug mode! (Just reports some values.)
//#define DEBUGGIT
//Numeric representation of symbols.
#define F_EXPONENT -1
#define F_SINE -2
#define F_COSINE -3
#define F_TANGENT -4
#define F_TIME_X -5
#define F_TIME_Y -6
#define F_TIME_Z -7
//The following two are parenthesis
#define F_GROUP -8
#define F_UNGROUP -9
#define F_MULTIPLY -10
#define F_DIVIDE -11
#define F_ADD -12
#define F_SUBTRACT -13
#define F_END -14
//Some nice math constants.
#define APPLE_PI 3.1415926535f
#define GOLDEN_NICE 1.6180339887f
//Note: The Golden Mean is (sqrt(5)+1)/2 and (sqrt(5)-1)/2
// which is found plugging the statement 'G==X/Y==Y/X+1'
// into the quadratic formula after somewhat evaluation.
#define B_RENDER 0
#define B_FORMULA_X 1
#define B_FORMULA_Y 2
#define B_FORMULA_Z 3
#define B_RANGE_X_MIN 4
#define B_RANGE_Y_MIN 5
#define B_RANGE_Z_MIN 6
#define B_RANGE_X_MAX 7
#define B_RANGE_Y_MAX 8
#define B_RANGE_Z_MAX 9
#define B_RANGE_X_SKIP 10
#define B_RANGE_Y_SKIP 11
#define B_RANGE_Z_SKIP 12
#define B_COLOR_RED 13
#define B_COLOR_GREEN 14
#define B_COLOR_BLUE 15
#define B_COLOR_BACK 16
#define B_COLOR_NEXT 17
#define B_STYLE_BACK 18
#define B_STYLE_NEXT 19
#define B_COLOR_MORE 20
#define B_COLOR_LESS 21
#define B_POWER_MORE 22
#define B_POWER_LESS 23
#define B_LOAD 24
#define B_SAVE 25
#define B_SCREENSHOT 26
#define B_EXIT 27

#define MSEOVR(a) mouse_x>=aButton[(a)].x&&mouse_x<aButton[(a)].x+aButton[(a)].w&&mouse_y>=aButton[(a)].y&&mouse_y<aButton[(a)].y+aButton[(a)].h
//===========================================================
// Graphics
//===========================================================
//Define the Palette
BITMAP *buffer,*mseBlock;
PALETTE pal;
FILE *loadFile;

//===========================================================
// Declare Global Variables
//===========================================================
//int *lbak;
int *life;
char formula[50];
struct myFormula{
 int a[100];
 float b[100];
};
struct{
 float x,y,z;
}Time;
struct{
 float xMin,xMax,xSkip;
 float yMin,yMax,ySkip;
 float zMin,zMax,zSkip;
}Range;
struct{
 int r,g,b;
}Color[20];
struct{
 int x,y,w,h;
}aButton[28];
int buttonCnt=0;
int ColorCnt;
int ColorPow;
int ColorCur;
bool style;
bool game=true;
myFormula myXForm;
myFormula myYForm;
myFormula myZForm;
char aXForm[100];
char aYForm[100];
char aZForm[100];
char signOf[14];
volatile int go_flg;
void time_it(){go_flg++;}
END_OF_FUNCTION (time_it);

//----------------------------------------------------------------
/*void floattostr(int myNum,char* myStr){
 float i;
 int j;
 char toAdd[100];
 for(i=10000000;i>1&&myNum/i==0;i/=10);
 for(j=0;i>1;i/=10) j++;
 i=0;
 if(myNum<0){
  toAdd[0]='-';
  i=1;
  myNum=-myNum;
 }
 for(;j>=0;j--){
  toAdd[i]=myNum/pow(10,j)+48;
  myNum-=(int)(myNum/pow(10,j))*pow(10,j);
  i++;
 }
 toAdd[i]=0;
 for(i=0;i<100&&toAdd[i]!=0;i++)
  *(myStr+i)=toAdd[i];
 *(myStr+i)=0;
}

//----------------------------------------------------------------
int strtoint(char myStr[100]){
 int myNum=0;
 int myFac=1;
 int i=0;
 int mlt=1;
 if(myStr[0]='-'){
  i=1;
  mlt=-1;
 }
 for(;i<100&&myStr[i]!=0;i++){
  myNum+=(myStr[i]-48)*myFac;
  myFac*=10;
 }
 return myNum*mlt;
}*/

//===========================================================
// idOf : Makes an ID# from 4 characters.
//===========================================================
/*int idOf(char myStr[5]){
 return (myStr[0]-65)*26*26*26+(myStr[1]-65)*26*26+(myStr[2]-65)*26+myStr[3]-65;
}*/

//===========================================================
// loadFIG : Well, loads a FIG. Did you know fig flowers grow in the fruit?
//===========================================================
void loadFIG();
//===========================================================
// saveFIG : Hard times are comin'. Gas prices and all.
//===========================================================
void saveFIG();
//===========================================================
// drawButton : Draws a button
//===========================================================
void drawButton(BITMAP *bmp,char msg[100],int x,int y,int w,int h,int color,int border,int myId=-1);
//===========================================================
// toFormula : Converts char arrays to myFormula format.
//===========================================================
myFormula toFormula(char myOForm[100]);
//===========================================================
// evaluate : Returns the solution to a formula.
//===========================================================
float evaluate(myFormula myForm);
//===========================================================
// drawFIG : This draws the 'FIG'
//===========================================================
void drawFIG();
//===========================================================
// render : This gets the FIG drawn.
//===========================================================
void render();
//===========================================================
// getFloat : Inputs floating point numbers from the user.
//===========================================================
float getFloat(float initial);
//===========================================================
// getFormula : Inputs formulas from the user.
//===========================================================
void getFormula(char *initial);
//===========================================================
// scanClicks : Reacts to the clicking on buttons on the panel.
//===========================================================
void scanClicks();
//===========================================================
// printscreen : You know.
//===========================================================
void printscreen();

//===========================================================
// main : Name a car that runs without an engine.
//===========================================================
int main(){
 //----------------------------------------------------------------
 //Set Stuff Up
 LOCK_VARIABLE (go_flg);
 LOCK_FUNCTION(time_it);
 allegro_init();
 install_keyboard();
 install_timer();
 set_color_depth(32);
 set_gfx_mode(GFX_AUTODETECT,XRES,YRES,0,0);
 install_int_ex(time_it,40000);
 install_mouse();
 buffer=create_bitmap(XRES,YRES);
 clear(buffer);
 mseBlock=create_bitmap(32,64);
 clear_to_color(mseBlock,makecol(255,0,255));
 for(int i=0;i<32;i++)
  line(mseBlock,31-i,i,0,0,makecol(MIN(i*256/16,255),i*256/32,MAX(i*256/16-128,0)));
 text_mode(-1);
 short int mouse_clk=0;
 //Set the signs of the numeric representations.
 signOf[-F_SINE]='S';
 signOf[-F_COSINE]='C';
 signOf[-F_TANGENT]='T';
 signOf[-F_TIME_X]='X';
 signOf[-F_TIME_Y]='Y';
 signOf[-F_TIME_Z]='Z';
 signOf[-F_GROUP]='(';
 signOf[-F_UNGROUP]=')';
 signOf[-F_EXPONENT]='^';
 signOf[-F_MULTIPLY]='*';
 signOf[-F_DIVIDE]='/';
 signOf[-F_ADD]='+';
 signOf[-F_SUBTRACT]='-';
 //Make the buffer
 //lbak=new int[XRES*YRES];
 life=new int[XRES*YRES];
 //Get the resolution halves
 sprintf(aXForm,"CX*S(X/Y)");
 sprintf(aYForm,"SX*S(Y/X)");
 sprintf(aZForm,"Z");
 myXForm=toFormula(aXForm);
 myYForm=toFormula(aYForm);
 myZForm=toFormula(aZForm);
 Range.xMin=-62.8318f;
 Range.xMax=62.8318f;
 Range.xSkip=.5f;
 Range.yMin=-62.8318f;
 Range.yMax=62.8318f;
 Range.ySkip=.5f;
 Range.zMin=0;
 Range.zMax=0;
 Range.zSkip=1;
 Color[0].r=0;
 Color[0].g=0;
 Color[0].b=0;
 Color[1].r=0;
 Color[1].g=0;
 Color[1].b=255;
 Color[2].r=0;
 Color[2].g=255;
 Color[2].b=255;
 Color[3].r=255;
 Color[3].g=255;
 Color[3].b=255;
 ColorCnt=4;
 ColorPow=100;
 ColorCur=0;
 style=0;
 //----------------------------------------------------------------
 //The Action Begins!
 drawButton(buffer,"Render",496,0,128,32,makecol(64,128,255),4,B_RENDER);
 drawButton(buffer,"Formulas",496,32,128,32,makecol(128,128,128),4);
 drawButton(buffer,"X",496,64,43,16,makecol(64,128,255),4,B_FORMULA_X);
 drawButton(buffer,"Y",539,64,43,16,makecol(64,128,255),4,B_FORMULA_Y);
 drawButton(buffer,"Z",582,64,42,16,makecol(64,128,255),4,B_FORMULA_Z);
 drawButton(buffer,"Ranges",496,80,128,32,makecol(128,128,128),4);
 drawButton(buffer,"X",496,112,43,16,makecol(255,128,64),3);
 drawButton(buffer,"Y",539,112,43,16,makecol(255,128,64),3);
 drawButton(buffer,"Z",582,112,42,16,makecol(255,128,64),3);
 drawButton(buffer,"Min",496,128,43,16,makecol(64,128,255),3,B_RANGE_X_MIN);
 drawButton(buffer,"Min",539,128,43,16,makecol(64,128,255),3,B_RANGE_Y_MIN);
 drawButton(buffer,"Min",582,128,42,16,makecol(64,128,255),3,B_RANGE_Z_MIN);
 drawButton(buffer,"Max",496,144,43,16,makecol(48,96,192),3,B_RANGE_X_MAX);
 drawButton(buffer,"Max",539,144,43,16,makecol(48,96,192),3,B_RANGE_Y_MAX);
 drawButton(buffer,"Max",582,144,42,16,makecol(48,96,192),3,B_RANGE_Z_MAX);
 drawButton(buffer,"Skip",496,160,43,16,makecol(64,128,255),3,B_RANGE_X_SKIP);
 drawButton(buffer,"Skip",539,160,43,16,makecol(64,128,255),3,B_RANGE_Y_SKIP);
 drawButton(buffer,"Skip",582,160,42,16,makecol(64,128,255),3,B_RANGE_Z_SKIP);
 drawButton(buffer,"Color",496,176,128,32,makecol(128,128,128),4);
 drawButton(buffer,"Red",496,208,43,32,makecol(128,0,0),4,B_COLOR_RED);
 drawButton(buffer,"Green",539,208,43,32,makecol(0,128,0),4,B_COLOR_GREEN);
 drawButton(buffer,"Blue",582,208,42,32,makecol(0,0,128),4,B_COLOR_BLUE);
 drawButton(buffer,"<",496,240,32,16,makecol(64,128,255),4,B_COLOR_BACK);
 drawButton(buffer,"Color 1",528,240,64,16,makecol(255,128,64),4);
 drawButton(buffer,">",592,240,32,16,makecol(64,128,255),4,B_COLOR_NEXT);
 drawButton(buffer,"-",496,256,32,16,makecol(128,128,128),4,B_COLOR_LESS);
 drawButton(buffer,"of 4",528,256,64,16,makecol(192,96,48),4);
 drawButton(buffer,"+",592,256,32,16,makecol(128,128,128),4,B_COLOR_MORE);
 drawButton(buffer,"<",496,272,32,16,makecol(64,128,255),4,B_STYLE_BACK);
 drawButton(buffer,"Style 1",528,272,64,16,makecol(255,128,64),4);
 drawButton(buffer,">",592,272,32,16,makecol(64,128,255),4,B_STYLE_NEXT);
 drawButton(buffer,"-",496,288,32,16,makecol(48,96,192),4,B_POWER_LESS);
 drawButton(buffer,"Pow 100",528,288,64,16,makecol(192,96,48),4);
 drawButton(buffer,"+",592,288,32,16,makecol(48,96,192),4,B_POWER_MORE);
 drawButton(buffer,"I/O",496,304,128,32,makecol(128,128,128),4);
 drawButton(buffer,"Load",496,336,64,16,makecol(64,128,255),4,B_LOAD);
 drawButton(buffer,"Save",560,336,64,16,makecol(64,128,255),4,B_SAVE);
 drawButton(buffer,"ScreenShot",496,352,128,16,makecol(64,128,255),4,B_SCREENSHOT);
 drawButton(buffer,"Loading Bar",496,368,128,32,makecol(128,128,128),4);
 drawButton(buffer,"Exit",496,464,128,16,makecol(64,128,255),4,B_EXIT);
 srand(time(NULL));
 render();
 drawFIG();
 while(game){
  poll_mouse();
  if(mouse_clk==1) mouse_clk=2;
  if(!mouse_b&1) mouse_clk=0;
  if(mouse_b&1&&!mouse_clk) mouse_clk=1;
  if(mouse_b&2) mouse_clk=1;
  blit(buffer,mseBlock,mouse_x,mouse_y,0,32,32,32);
  masked_blit(mseBlock,buffer,0,0,mouse_x,mouse_y,32,32);
  acquire_screen();
  blit(buffer,screen,0,0,0,0,XRES,YRES);
  release_screen();
  blit(mseBlock,buffer,0,32,mouse_x,mouse_y,32,32);
  if(mouse_clk==1) scanClicks();
  if(key[KEY_ESC]) game=0;
 }
 #ifdef DEBUGGIT
   myFormula myForm=toFormula("X*X*X");
   float j=evaluate(myForm);
   textprintf(screen,font,0,0,makecol(40,40,200),"10*X+2P*(9*3.141)");
   char beanPole[100];
   char cornStalk[20];
   beanPole[0]=0;
   for(int i=0;i<100&&myForm.a[i]!=F_END;i++){
    cornStalk[0]=0;
    if(myForm.a[i]>=0) sprintf(cornStalk,"%f",myForm.b[myForm.a[i]]);
    else sprintf(cornStalk,"%c",signOf[-myForm.a[i]]);
    strcat(beanPole,cornStalk);
   }
   textprintf(screen,font,0,10,makecol(40,100,200),"%s",beanPole);
   textprintf(screen,font,0,20,makecol(40,200,100),"%f",j);
   while(!key[KEY_ESC]){}
 #endif
 destroy_bitmap(buffer);
 destroy_bitmap(mseBlock);
 delete[] life;
// delete[] lbak;
 return 0;
}
END_OF_MAIN();

//===========================================================
// loadFIG : Well, loads a FIG. Did you know fig flowers grow in the fruit?
//===========================================================
void loadFIG(){
 short int mouse_clk;
 struct{
  char name[32];
 }myFile[512];
 int numFiles=0;
 struct al_ffblk info;
 int i=al_findfirst("gallery/*.fig",&info,FA_ARCH);
 char finished=false;
 if(!i){
  strcpy(myFile[numFiles].name,info.name);
  drawButton(buffer,info.name,0,0,192,16,makecol(255-numFiles*4,128,numFiles*2),2);
  numFiles=1;
  while(!i){
   i=al_findnext(&info);
   if(!i){
    strcpy(myFile[numFiles].name,info.name);
    drawButton(buffer,info.name,numFiles<30?0:192,numFiles<30?numFiles*16:numFiles*16-480,192,16,makecol(255-numFiles*4,128,numFiles*2),2);
    numFiles++;
   }
  }
 }else finished=2;
 al_findclose(&info);
 while(!finished){
  if(key[KEY_ESC]) finished=2;
  poll_mouse();
  if(mouse_clk==1) mouse_clk=2;
  if(!mouse_b&1) mouse_clk=0;
  if(mouse_b&1&&!mouse_clk) mouse_clk=1;
  blit(buffer,mseBlock,mouse_x,mouse_y,0,32,32,32);
  masked_blit(mseBlock,buffer,0,0,mouse_x,mouse_y,32,32);
  acquire_screen();
  blit(buffer,screen,0,0,0,0,XRES,YRES);
  release_screen();
  blit(mseBlock,buffer,0,32,mouse_x,mouse_y,32,32);
  if(mouse_clk==1){
   if(mouse_x<192&&mouse_y/16<numFiles){
    char dumplins[100];
    sprintf(dumplins,"gallery/%s",myFile[mouse_y/16].name);
    if((loadFile=fopen(dumplins,"rb"))){
     fscanf(loadFile,"%s %s %s %f %f %f %f %f %f %f %f %f %d %d %d %d %d %d %d %d %d %d %d %d %d %d",&aXForm,&aYForm,&aZForm,&Range.xMin,&Range.xMax,&Range.xSkip,&Range.yMin,&Range.yMax,&Range.ySkip,&Range.zMin,&Range.zMax,&Range.zSkip,&Color[0].r,&Color[0].g,&Color[0].b,&Color[1].r,&Color[1].g,&Color[1].b,&Color[2].r,&Color[2].g,&Color[2].b,&Color[3].r,&Color[3].g,&Color[3].b,&style,&ColorPow);
     fclose(loadFile);
     myXForm=toFormula(aXForm);
     myYForm=toFormula(aYForm);
     myZForm=toFormula(aZForm);
     sprintf(dumplins,"Style %d",style+1);
     drawButton(buffer,dumplins,528,272,64,16,makecol(255,128,64),4);
     sprintf(dumplins,"Pow %d",ColorPow);
     drawButton(buffer,dumplins,528,288,64,16,makecol(192,96,48),4);
    }
    finished=true;
   }
   if(mouse_x>=192&&mouse_x<384&&mouse_y/16+30<numFiles){
    char dumplins[100];
    sprintf(dumplins,"gallery/%s",myFile[mouse_y/16+30].name);
    if((loadFile=fopen(dumplins,"rb"))){
     fscanf(loadFile,"%s %s %s %f %f %f %f %f %f %f %f %f %d %d %d %d %d %d %d %d %d %d %d %d %d %d",&aXForm,&aYForm,&aZForm,&Range.xMin,&Range.xMax,&Range.xSkip,&Range.yMin,&Range.yMax,&Range.ySkip,&Range.zMin,&Range.zMax,&Range.zSkip,&Color[0].r,&Color[0].g,&Color[0].b,&Color[1].r,&Color[1].g,&Color[1].b,&Color[2].r,&Color[2].g,&Color[2].b,&Color[3].r,&Color[3].g,&Color[3].b,&style,&ColorPow);
     fclose(loadFile);
     myXForm=toFormula(aXForm);
     myYForm=toFormula(aYForm);
     myZForm=toFormula(aZForm);
     sprintf(dumplins,"Style %d",style+1);
     drawButton(buffer,dumplins,528,272,64,16,makecol(255,128,64),4);
     sprintf(dumplins,"Pow %d",ColorPow);
     drawButton(buffer,dumplins,528,288,64,16,makecol(192,96,48),4);
    }
    finished=true;
   }
  }
  if(key[KEY_DEL]){
   if(mouse_x<192&&mouse_y/16<numFiles){
    char turkey[100];
    sprintf(turkey,"Delete %s? Y for yes, N for no.",myFile[mouse_y/16].name);
    drawButton(screen,turkey,40,224,560,32,makecol(255,128,64),6);
    while(!key[KEY_ESC]&&!key[KEY_Y]&&!key[KEY_N]){}
    if(key[KEY_Y]){
     char dumplins[100];
     sprintf(dumplins,"gallery/%s",myFile[mouse_y/16].name);
     delete_file(dumplins);
     finished=2;
    }
   }
   if(mouse_x>=192&&mouse_x<384&&mouse_y/16+30<numFiles){
    char turkey[100];
    sprintf(turkey,"Delete %s? Y for yes, N for no.",myFile[mouse_y/16+30].name);
    drawButton(screen,turkey,40,224,560,32,makecol(255,128,64),6);
    while(!key[KEY_ESC]&&!key[KEY_Y]&&!key[KEY_N]){}
    if(key[KEY_Y]){
     char dumplins[100];
     sprintf(dumplins,"gallery/%s",myFile[mouse_y/16+30].name);
     delete_file(dumplins);
     finished=2;
    }
   }
  }
 }
 while(key[KEY_ESC]){}
 if(finished<2) render();
 drawFIG();
}

//===========================================================
// saveFIG : Hard times are comin'. Gas prices and all.
//===========================================================
void saveFIG(){
 short int mouse_clk;
 struct{
  char name[32];
 }myFile[512];
 int numFiles=0;
 struct al_ffblk info;
 int i=al_findfirst("gallery/*.fig",&info,FA_ARCH);
 if(!i){
  strcpy(myFile[numFiles].name,info.name);
  drawButton(buffer,info.name,0,0,192,16,makecol(255-numFiles*4,128,numFiles*2),2);
  numFiles=1;
  while(!i){
   i=al_findnext(&info);
   if(!i){
    strcpy(myFile[numFiles].name,info.name);
//    drawButton(buffer,info.name,0,numFiles*16,256,16,makecol((numFiles+50)*2,numFiles+50,(numFiles+50)*4),2);
    drawButton(buffer,info.name,numFiles<30?0:192,numFiles<30?numFiles*16:numFiles*16-480,192,16,makecol(255-numFiles*4,128,numFiles*2),2);
    numFiles++;
   }
  }
 }
// drawButton(buffer,"New File",0,numFiles*16,256,16,makecol(24,192,96),2);
 drawButton(buffer,"New File",numFiles<30?0:192,numFiles<30?numFiles*16:numFiles*16-480,192,16,makecol(24,192,96),2);
 al_findclose(&info);
 bool finished=false;
 while(!finished){
  if(key[KEY_ESC]) finished=true;
  poll_mouse();
  if(mouse_clk==1) mouse_clk=2;
  if(!mouse_b&1) mouse_clk=0;
  if(mouse_b&1&&!mouse_clk) mouse_clk=1;
  blit(buffer,mseBlock,mouse_x,mouse_y,0,32,32,32);
  masked_blit(mseBlock,buffer,0,0,mouse_x,mouse_y,32,32);
  acquire_screen();
  blit(buffer,screen,0,0,0,0,XRES,YRES);
  release_screen();
  blit(mseBlock,buffer,0,32,mouse_x,mouse_y,32,32);
  if(mouse_clk==1){
   if(mouse_x<192&&mouse_y/16<numFiles){
    char dumplins[100];
    sprintf(dumplins,"gallery/%s",myFile[mouse_y/16].name);
    if((loadFile=fopen(dumplins,"wb"))){
     fprintf(loadFile,"%s %s %s %f %f %f %f %f %f %f %f %f %d %d %d %d %d %d %d %d %d %d %d %d %d %d",aXForm,aYForm,aZForm,Range.xMin,Range.xMax,Range.xSkip,Range.yMin,Range.yMax,Range.ySkip,Range.zMin,Range.zMax,Range.zSkip,Color[0].r,Color[0].g,Color[0].b,Color[1].r,Color[1].g,Color[1].b,Color[2].r,Color[2].g,Color[2].b,Color[3].r,Color[3].g,Color[3].b,style,ColorPow);
     fclose(loadFile);
    }
    finished=true;
   }
   if(mouse_x>=192&&mouse_x<384&&mouse_y/16+30<numFiles){
    char dumplins[100];
    sprintf(dumplins,"gallery/%s",myFile[mouse_y/16+30].name);
    if((loadFile=fopen(dumplins,"wb"))){
     fprintf(loadFile,"%s %s %s %f %f %f %f %f %f %f %f %f %d %d %d %d %d %d %d %d %d %d %d %d %d %d",aXForm,aYForm,aZForm,Range.xMin,Range.xMax,Range.xSkip,Range.yMin,Range.yMax,Range.ySkip,Range.zMin,Range.zMax,Range.zSkip,Color[0].r,Color[0].g,Color[0].b,Color[1].r,Color[1].g,Color[1].b,Color[2].r,Color[2].g,Color[2].b,Color[3].r,Color[3].g,Color[3].b,style,ColorPow);
     fclose(loadFile);
    }
    finished=true;
   }
   if(mouse_x<192&&mouse_y/16==numFiles){
    char squash[50];
    strcpy(squash,"");
    drawButton(screen,"Type in a name. The '.fig' is automatically added.",40,192,560,32,makecol(48,192,96),6);
    getFormula(&squash[0]);
    if(squash[0]){
     char dumplins[100];
     sprintf(dumplins,"gallery/%s.fig",squash);
     if((loadFile=fopen(dumplins,"wb"))){
      fprintf(loadFile,"%s %s %s %f %f %f %f %f %f %f %f %f %d %d %d %d %d %d %d %d %d %d %d %d %d %d",aXForm,aYForm,aZForm,Range.xMin,Range.xMax,Range.xSkip,Range.yMin,Range.yMax,Range.ySkip,Range.zMin,Range.zMax,Range.zSkip,Color[0].r,Color[0].g,Color[0].b,Color[1].r,Color[1].g,Color[1].b,Color[2].r,Color[2].g,Color[2].b,Color[3].r,Color[3].g,Color[3].b,style,ColorPow);
      fclose(loadFile);
     }
     finished=true;
    }
   }
   if(mouse_x>=192&&mouse_x<384&&mouse_y/16+30==numFiles){
    char squash[50];
    strcpy(squash,"");
    drawButton(screen,"Type in a name. The '.fig' is automatically added.",40,192,560,32,makecol(48,192,96),6);
    getFormula(&squash[0]);
    if(squash[0]){
     char dumplins[100];
     sprintf(dumplins,"gallery/%s.fig",squash);
     if((loadFile=fopen(dumplins,"wb"))){
      fprintf(loadFile,"%s %s %s %f %f %f %f %f %f %f %f %f %d %d %d %d %d %d %d %d %d %d %d %d %d %d",aXForm,aYForm,aZForm,Range.xMin,Range.xMax,Range.xSkip,Range.yMin,Range.yMax,Range.ySkip,Range.zMin,Range.zMax,Range.zSkip,Color[0].r,Color[0].g,Color[0].b,Color[1].r,Color[1].g,Color[1].b,Color[2].r,Color[2].g,Color[2].b,Color[3].r,Color[3].g,Color[3].b,style,ColorPow);
      fclose(loadFile);
     }
     finished=true;
    }
   }
  }
 }
 while(key[KEY_ESC]){}
 drawFIG();
}

//===========================================================
// drawButton : Draws a button
//===========================================================
void drawButton(BITMAP *bmp,char msg[100],int x,int y,int w,int h,int color,int border,int myId){
 if(myId>=0){
  aButton[myId].x=x;
  aButton[myId].y=y;
  aButton[myId].w=w;
  aButton[myId].h=h;
 }
 int colorlight=makecol(MIN(getr(color)+40,255),MIN(getg(color)+40,255),MIN(getb(color)+40,255));
 int colordark=makecol(MAX(getr(color)-40,0),MAX(getg(color)-40,0),MAX(getb(color)-40,0));
 int r=getr(color)-30;
 int g=getg(color)-30;
 int b=getb(color)-30;
 int newcolor;
 for(int ty=0;ty<h;ty++){
  for(int tx=0;tx<w;tx++){
   r++;g++;b++;
   newcolor=makecol(MAX(MIN(r,255),0),MAX(MIN(g,255),0),MAX(MIN(b,255),0));
   if(tx<border||ty<border||tx>=w-border||ty>=h-border){
    putpixel(bmp,x+tx,y+ty,newcolor);
//    if(ty*w/h<tx) putpixel(bmp,x+tx,y+ty,colorlight);
//    else putpixel(bmp,x+tx,y+ty,colordark);
   }else putpixel(bmp,x+tx,y+ty,color);
  }
  r=r-w-1;
  g=g-w-1;
  b=b-w-1;
 }
 int l;
 for(l=0;l<100&&msg[l]!=0;l++);
 textprintf(bmp,font,x+w/2-4*l,y+h/2-3,colordark,"%s",msg);
 textprintf(bmp,font,x+w/2-4*l,y+h/2-5,colorlight,"%s",msg);
 textprintf(bmp,font,x+w/2-4*l,y+h/2-4,0,"%s",msg);
}

//===========================================================
// toFormula : Converts char arrays to myFormula format.
//===========================================================
myFormula toFormula(char myOForm[100]){
 myFormula myForm;
 int i;
 float j=0;
 int d=0;
 int o=0;
 int m=0;
 int n=0;
 bool p=false;
 for(i=0;i<100&&myOForm[i]!=0;i++){
  //Negator
  if(myOForm[i]=='-'&&!p/*&&myForm.a[m-1]<0&&myForm.a[m-1]!=F_GROUP&&myForm.a[m-1]!=F_UNGROUP*/){
   myForm.a[m]=n;
   myForm.b[n]=-1;
   myForm.a[m+1]=F_MULTIPLY;
   m+=2;n++;i++;
  }
  //Constant
  if(myOForm[i]>47&&myOForm[i]<58){
   if(!d) j=j*10+myOForm[i]-48;
   else j+=(float)(myOForm[i]-48)/(d*=10);
   p=true;
  }
  //Decimal Point
  if(myOForm[i]=='.') d=1;
  //Pi
  if(myOForm[i]=='P'){
   myForm.a[m]=n;
   myForm.b[n]=APPLE_PI*(p?j:1);
   j=0;d=0;m++;n++;p=false;
  }
  //The Golden Mean
  if(myOForm[i]=='G'){
   myForm.a[m]=n;
   myForm.b[n]=GOLDEN_NICE*(p?j:1);
   j=0;d=0;m++;n++;p=false;
  }
  //Random
  if(myOForm[i]=='R'){
   myForm.a[m]=n;
   myForm.b[n]=rand()*(p?j:1);
   j=0;d=0;m++;n++;p=false;
  }
  //End Constant
  if(myOForm[i]<48||myOForm[i]>57){
   if(p&&myOForm[i]!='.'){
    myForm.a[m]=n;
    myForm.b[n]=j;
    j=0;d=0;m++;n++;p=false;
   }
  }
  //Symbol
  for(o=1;o<14;o++){
   if(myOForm[i]==signOf[o]){
    myForm.a[m]=-o;
    m++;o=14;
   }
  }
 }
 //Last Number
 if(myOForm[i]<48||myOForm[i]>57){
  if(p){
   myForm.a[m]=n;
   myForm.b[n]=j;
//   j=0;d=0;m++;n++;
   m++;
  }
 }
 myForm.a[m]=F_END;
 return myForm;
}

//===========================================================
// evaluate : Returns the solution to a formula.
//===========================================================
float evaluate(myFormula myForm){
 myFormula mySForm;
 myFormula myNForm;
 float f;
 int m=0;
 int n=0;
 int k=0;
 int l=0;
 int p=0;
 //Parenthesis
 for(int i=0;i<100;i++){
  if(myForm.a[i]==F_UNGROUP) m--;
  if(m){
   if(myForm.a[i]>=0){
    mySForm.a[k]=n;
    mySForm.b[n]=myForm.b[myForm.a[i]];
    k++;n++;
   }else{
    mySForm.a[k]=myForm.a[i];
    k++;
   }
  }
  if(myForm.a[i]==F_GROUP) m++;
  if(!m){
   if(k){
    mySForm.a[k]=F_END;
    myNForm.a[l]=p;
    myNForm.b[p]=evaluate(mySForm);
    l++;p++;k=0;n=0;
   }else{
    if(myForm.a[i]>=0){
     myNForm.a[l]=p;
     myNForm.b[p]=myForm.b[myForm.a[i]];
     l++;p++;
    }else{
     myNForm.a[l]=myForm.a[i];
     l++;
    }
   }
  }
  if(myForm.a[i+1]==F_END) i=100;
 }
 myNForm.a[l]=F_END;
 int jj=0;
 for(int ii=0;ii<100&&myNForm.a[ii]!=F_END;ii++)
  if(myNForm.a[ii]>jj) jj=myNForm.a[ii];
 jj++;
 //Time
 for(int i=0;i<100;i++){
  if(myNForm.a[i]==F_TIME_X){
   myNForm.a[i]=jj++;
   myNForm.b[myNForm.a[i]]=Time.x;
  }
  if(myNForm.a[i]==F_TIME_Y){
   myNForm.a[i]=jj++;
   myNForm.b[myNForm.a[i]]=Time.y;
  }
  if(myNForm.a[i]==F_TIME_Z){
   myNForm.a[i]=jj++;
   myNForm.b[myNForm.a[i]]=Time.z;
  }
  if(myNForm.a[i+1]==F_END) i=100;
 }
 //Trig
 for(int i=0;i<100;i++){
  if(myNForm.a[i]==F_SINE){
   myNForm.b[myNForm.a[i+1]]=sin(myNForm.b[myNForm.a[i+1]]);
   for(int k=i;k<100&&myNForm.a[k]!=F_END;k++) myNForm.a[k]=myNForm.a[k+1];
  }
  if(myNForm.a[i]==F_COSINE){
   myNForm.b[myNForm.a[i+1]]=cos(myNForm.b[myNForm.a[i+1]]);
   for(int k=i;k<100&&myNForm.a[k]!=F_END;k++) myNForm.a[k]=myNForm.a[k+1];
  }
  if(myNForm.a[i]==F_TANGENT){
   myNForm.b[myNForm.a[i+1]]=tan(myNForm.b[myNForm.a[i+1]]);
   for(int k=i;k<100&&myNForm.a[k]!=F_END;k++) myNForm.a[k]=myNForm.a[k+1];
  }
  if(myNForm.a[i+1]==F_END) i=100;
 }
 //Exponents
 for(int i=0;i<100;i++){
  if(myNForm.a[i]==F_EXPONENT){
   myNForm.b[myNForm.a[i-1]]=pow(myNForm.b[myNForm.a[i-1]],myNForm.b[myNForm.a[i+1]]);
   for(int k=i;k<100&&myNForm.a[k-1]!=F_END;k++) myNForm.a[k]=myNForm.a[k+2];
   i--;
  }
  if(myNForm.a[i+1]==F_END) i=100;
 }
 //Multiplication and Division
 for(int i=0;i<100;i++){
  if(myNForm.a[i]==F_MULTIPLY){
   myNForm.b[myNForm.a[i-1]]=myNForm.b[myNForm.a[i-1]]*myNForm.b[myNForm.a[i+1]];
   for(int k=i;k<100&&myNForm.a[k-1]!=F_END;k++) myNForm.a[k]=myNForm.a[k+2];
   i--;
  }
  if(myNForm.a[i]==F_DIVIDE){
   if(myNForm.b[myNForm.a[i+1]]) myNForm.b[myNForm.a[i-1]]=myNForm.b[myNForm.a[i-1]]/myNForm.b[myNForm.a[i+1]];
   else myNForm.b[myNForm.a[i-1]]=9e99;
   for(int k=i;k<100&&myNForm.a[k-1]!=F_END;k++) myNForm.a[k]=myNForm.a[k+2];
   i--;
  }
  if(myNForm.a[i+1]==F_END) i=100;
 }
 //Addition and Subtraction
 for(int i=0;i<100;i++){
  if(myNForm.a[i]==F_ADD){
   myNForm.b[myNForm.a[i-1]]=myNForm.b[myNForm.a[i-1]]+myNForm.b[myNForm.a[i+1]];
   for(int k=i;k<100&&myNForm.a[k-1]!=F_END;k++) myNForm.a[k]=myNForm.a[k+2];
   i--;
  }
  if(myNForm.a[i]==F_SUBTRACT){
   myNForm.b[myNForm.a[i-1]]=myNForm.b[myNForm.a[i-1]]-myNForm.b[myNForm.a[i+1]];
   for(int k=i;k<100&&myNForm.a[k-1]!=F_END;k++) myNForm.a[k]=myNForm.a[k+2];
   i--;
  }
  if(myNForm.a[i+1]==F_END) i=100;
 }
 return myNForm.b[myNForm.a[0]];
}

//===========================================================
// drawFIG : This draws the 'FIG'
//===========================================================
void drawFIG(){
 unsigned long address;
 bmp_select(buffer);
 for(int ty=0;ty<YRES;ty++){
  address=bmp_write_line(buffer,ty);
  for(int tx=0;tx<YRES;tx++){
/*   int a=LIFE(tx,ty)*ColorPow;
   int b=0;
   int c=0;
   if(a>255){
    b=a-255;
    a=255;
    if(b>255){
     c=b-255;
     b=255;
    }
   }*/
   int a,b,c,d;
   int i=0;
   d=LIFE(tx,ty)*ColorPow;
   if(d>255){
    d-=255;
    i++;
   }
   if(d>255){
    d-=255;
    i++;
   }
   if(d>255) d=255;
   if(d<0) d=0;
   a=Color[i].r+d*(float)(Color[i+1].r-Color[i].r)/255;
   b=Color[i].g+d*(float)(Color[i+1].g-Color[i].g)/255;
   c=Color[i].b+d*(float)(Color[i+1].b-Color[i].b)/255;
   bmp_write32(address+tx*sizeof(long),makecol32(a,b,c));
  }
  bmp_unwrite_line(buffer);
 }
}

//===========================================================
// render : This gets the FIG drawn.
//===========================================================
void render(){
 drawButton(screen,"Esc to Cancel",496,368,128,32,makecol(128,128,128),4);
 int tx,ty,tz;
 char bannana[20];
 //Clear the buffer
 for(int x=0;x<XRES;x++) for(int y=0;y<YRES;y++) LIFE(x,y)=0;
 //for(int x=0;x<XRES;x++) for(int y=0;y<YRES;y++) LBAK(x,y)=0;
 //Render Away!
 for(Time.x=Range.xMin;Time.x<=Range.xMax&&!key[KEY_ESC];Time.x+=Range.xSkip){
  for(Time.y=Range.yMin;Time.y<=Range.yMax&&!key[KEY_ESC];Time.y+=Range.ySkip){
   for(Time.z=Range.zMin;Time.z<=Range.zMax&&!key[KEY_ESC];Time.z+=Range.zSkip){
//Frozen Bloom .1
//    tx=(sqrt(Time.x*Time.x+Time.y*Time.y)*Time.x*Time.y/1000+Time.x/Time.y-sin(Time.x)*Time.y)*hxres/5+hxres;
//    ty=Time.y*hyres/5+hyres;
    tx=(int)(evaluate(myXForm)*HYRES)+HYRES;
    ty=(int)(evaluate(myYForm)*HYRES)+HYRES;
    tz=(int)evaluate(myZForm);
    if(tx>=0&&tx<YRES&&ty>=0&&ty<YRES&&style==0) LIFE(tx,ty)+=1;
    if(tx>=0&&tx<YRES&&ty>=0&&ty<YRES&&style==1&&tz>LIFE(tx,ty)) LIFE(tx,ty)=tz;
    if(key[KEY_F1]){
     drawFIG();
     acquire_screen();
     blit(buffer,screen,0,0,0,0,XRES,YRES);
     release_screen();
    }
   }
   if(key[KEY_F2]){
    drawFIG();
    acquire_screen();
    blit(buffer,screen,0,0,0,0,XRES,YRES);
    release_screen();
   }
  }
  if(key[KEY_F3]){
   drawFIG();
   acquire_screen();
   blit(buffer,screen,0,0,0,0,XRES,YRES);
   release_screen();
  }
  vline(screen,500+(Time.x-Range.xMin)*120/(Range.xMax-Range.xMin),372,375,makecol(64,192,96));
  vline(screen,500+(Time.x-Range.xMin)*120/(Range.xMax-Range.xMin),392,395,makecol(64,96,192));
 }
 while(key[KEY_ESC]){}
}

//===========================================================
// getFloat : Inputs floating point numbers from the user.
//===========================================================
float getFloat(float initial){
 char myFloatS[22];
 int x,i,j;
 float final=0;
 sprintf(myFloatS,"%f",initial);
 for(x=0;x<100&&myFloatS[x]!=0;x++);
 drawButton(screen,myFloatS,40,224,560,32,makecol(32,128,64),6);
 clear_keybuf();
// set_keyboard_rate(0,0);
 while(!key[KEY_ENTER]&&!key[KEY_ESC]){
  i=ureadkey(NULL);
  if(i>47&&i<58&&x<20||i=='.'&&x<20||i=='-'&&x==0){
   myFloatS[x]=i;
   x++;
   myFloatS[x]=0;
  }
  if(key[KEY_BACKSPACE]&&x>0){
   x--;
   myFloatS[x]=0;
  }
  drawButton(screen,myFloatS,40,224,560,32,makecol(32,128,64),6);
 }
 i=0;j=1;
 for(x=0;x<20&&myFloatS[x]!=0;x++){
  if(myFloatS[x]=='.') i=10;
  else if(myFloatS[x]=='-') j=-1;
  else{
   if(i){
    final+=(float)(myFloatS[x]-48)/(float)i;
    i*=10;
   }else final=final*10+myFloatS[x]-48;
  }
 }
 if(key[KEY_ESC]){
  while(key[KEY_ESC]){}
  return initial;
 }
 else return final*j;
}

//===========================================================
// getFormula : Inputs formulas from the user.
//===========================================================
void getFormula(char *initial){
 int x,i;
 char final[100];
 for(i=0;i<100&&*(initial+i);i++) final[i]=*(initial+i);
 final[i]=0;
 x=i;
// for(x=0;x<100&&final[x]!=0;x++);
 drawButton(screen,final,40,224,560,32,makecol(32,128,64),6);
 clear_keybuf();
 set_keyboard_rate(0,0);
 while(!key[KEY_ENTER]&&!key[KEY_ESC]){
  i=ureadkey(NULL);
  if(i&&!key[KEY_BACKSPACE]&&!key[KEY_ENTER]&&!key[KEY_ESC]&&x<99){
   final[x]=i;
   x++;
   final[x]=0;
  }
  if(key[KEY_BACKSPACE]&&x>0){
   x--;
   final[x]=0;
  }
  drawButton(screen,final,40,224,560,32,makecol(32,128,64),6);
 }
 if(key[KEY_ESC]){
  while(key[KEY_ESC]){}
  return;
 }
 for(i=0;i<100&&final[i];i++) *(initial+i)=final[i];
 *(initial+i)=0;
 return;
}

//===========================================================
// scanClicks : Reacts to the clicking on buttons on the panel.
//===========================================================
void scanClicks(){
 if(MSEOVR(B_RENDER)){
  render();
  drawFIG();
  return;
 }
 if(MSEOVR(B_FORMULA_X)){
  getFormula(&aXForm[0]);
  myXForm=toFormula(aXForm);
  return;
 }
 if(MSEOVR(B_FORMULA_Y)){
  getFormula(&aYForm[0]);
  myYForm=toFormula(aYForm);
  return;
 }
 if(MSEOVR(B_FORMULA_Z)){
  getFormula(&aZForm[0]);
  myZForm=toFormula(aZForm);
  return;
 }
 if(MSEOVR(B_RANGE_X_MIN)){
  Range.xMin=getFloat(Range.xMin);
  return;
 }
 if(MSEOVR(B_RANGE_Y_MIN)){
  Range.yMin=getFloat(Range.yMin);
  return;
 }
 if(MSEOVR(B_RANGE_Z_MIN)){
  Range.zMin=getFloat(Range.zMin);
  return;
 }
 if(MSEOVR(B_RANGE_X_MAX)){
  Range.xMax=getFloat(Range.xMax);
  return;
 }
 if(MSEOVR(B_RANGE_Y_MAX)){
  Range.yMax=getFloat(Range.yMax);
  return;
 }
 if(MSEOVR(B_RANGE_Z_MAX)){
  Range.zMax=getFloat(Range.zMax);
  return;
 }
 if(MSEOVR(B_RANGE_X_SKIP)){
  Range.xSkip=getFloat(Range.xSkip);
  return;
 }
 if(MSEOVR(B_RANGE_Y_SKIP)){
  Range.ySkip=getFloat(Range.ySkip);
  return;
 }
 if(MSEOVR(B_RANGE_Z_SKIP)){
  Range.zSkip=getFloat(Range.zSkip);
  return;
 }
 if(MSEOVR(B_COLOR_RED)){
  Color[ColorCur].r=(int)getFloat((float)Color[ColorCur].r);
  drawFIG();
  return;
 }
 if(MSEOVR(B_COLOR_GREEN)){
  Color[ColorCur].g=(int)getFloat((float)Color[ColorCur].g);
  drawFIG();
  return;
 }
 if(MSEOVR(B_COLOR_BLUE)){
  Color[ColorCur].b=(int)getFloat((float)Color[ColorCur].b);
  drawFIG();
  return;
 }
 if(MSEOVR(B_COLOR_BACK)&&ColorCur>0){
  ColorCur--;
  char mashTaters[20];
  sprintf(mashTaters,"Color %d",ColorCur+1);
  drawButton(buffer,mashTaters,528,240,64,16,makecol(255,128,64),4);
  return;
 }
 if(MSEOVR(B_COLOR_NEXT)&&ColorCur<ColorCnt-1){
  ColorCur++;
  char mashTaters[20];
  sprintf(mashTaters,"Color %d",ColorCur+1);
  drawButton(buffer,mashTaters,528,240,64,16,makecol(255,128,64),4);
  return;
 }
 if(MSEOVR(B_STYLE_BACK)&&style!=0){
  style=0;
  drawButton(buffer,"Style 1",528,272,64,16,makecol(255,128,64),4);
  drawButton(screen,"Intersection Highlight (Crystal) Mode. Rerender to see changes. (Press Enter)",0,224,640,32,makecol(255,128,64),1);
  while(!key[KEY_ENTER]&&!key[KEY_ESC]){}
  return;
 }
 if(MSEOVR(B_STYLE_NEXT)&&style!=1){
  style=1;
  drawButton(buffer,"Style 2",528,272,64,16,makecol(255,128,64),4);
  drawButton(screen,"Highest Z (3D) Mode. Rerender to see changes. (Press Enter)",0,224,640,32,makecol(255,128,64),1);
  while(!key[KEY_ENTER]&&!key[KEY_ESC]){}
  return;
 }
 if(MSEOVR(B_POWER_LESS)){
  ColorPow--;
  char beanSoup[20];
  sprintf(beanSoup,"Pow %d",ColorPow);
  drawButton(buffer,beanSoup,528,288,64,16,makecol(192,96,48),4);
  drawFIG();
  return;
 }
 if(MSEOVR(B_POWER_MORE)){
  ColorPow++;
  char beanSoup[20];
  sprintf(beanSoup,"Pow %d",ColorPow);
  drawButton(buffer,beanSoup,528,288,64,16,makecol(192,96,48),4);
  drawFIG();
  return;
 }
 if(MSEOVR(B_LOAD)){
  loadFIG();
  return;
 }
 if(MSEOVR(B_SAVE)){
  saveFIG();
  return;
 }
 if(MSEOVR(B_SCREENSHOT)){
  printscreen();
  return;
 }
 if(MSEOVR(B_EXIT)) game=false;
}

//===========================================================
// printscreen : You know.
//===========================================================
void printscreen(){
 int t=0;
 char u[40];
 sprintf(u,"Screenshots/shot%d.bmp",t);
 while(exists(u)){
  t++;
  sprintf(u,"Screenshots/shot%d.bmp",t);
 }
 save_bmp(u,buffer,pal);
 while(key[KEY_Q]||key[KEY_W]){}
}

