#include <allegro.h>

#include "datafile.h"

#include "main_u.h"
#include "incl\ttt_cube.h"
#include "incl\ttt_field.h"

enum GAMETYPE {
  e_MENU = 0,
  e_PLAY_GAME,
  e_ABOUT,
  e_QUIT_GAME,
};

const int MAX_MENU_ITEM = 3;

void INIT_ALLEGRO();
void SHUTDOWN_ALLEGRO();
void draw_screen(BITMAP *bmp);

//Timer installer
volatile int logic_update = 0;

void tf_01()
{
  logic_update++;
}
END_OF_FUNCTION(tf_01)

int main(int argc, char *argv[])
{
  INIT_ALLEGRO();

  //Load datafile
  if (exists("datafile.dat"))
  {
    data = load_datafile("datafile.dat");
    if (data == 0)
    {
      allegro_message("Unable to load the datafile. Sorry...");
      exit(0);
    }
  }
  else
  {
    allegro_message("The datafile was not found...");
    exit(0);
  }

  //Show intro
  blit((BITMAP *)data[DF_INTRO].dat, screen, 0, 0, 0, 0, SCREEN_X, SCREEN_Y);

  int intro_ticks = 0;
  do {
    if (logic_update)
    {
      intro_ticks++;
      logic_update = 0;
    }
  } while (intro_ticks != (FRAMES_PER_SECOND * 3));

  int input_delay = 0;

  GAMETYPE game_type = e_MENU;

  //Menu vars
  int menu_item = 0;
  int last_menu_item = -1;
  int menu_y_pos[][2] = {
    230, 390,
    302, 409,
    375, 92,
    447, 165,
  };
  int cube_size = 28;
  int x_offset = 180;
  int menu_x_pos_extra = 0;

  //Game global vars
  c_field *play_field = new c_field(SCREEN_X / 2, (SCREEN_Y / 2) + 150);
  play_field->set_field_bitmap(EMPTY, (BITMAP *)data[DF_EMPTY].dat);
  play_field->set_field_bitmap(PLAYER_01, (BITMAP *)data[DF_PLAYER_01].dat);
  play_field->set_field_bitmap(PLAYER_02, (BITMAP *)data[DF_PLAYER_02].dat);

  play_field->set_selector_bitmap(EMPTY, (BITMAP *)data[DF_SELECTOR_TRUE].dat);
  play_field->set_selector_bitmap(PLAYER_01, (BITMAP *)data[DF_SELECTOR_FALSE].dat);
  play_field->set_selector_bitmap(PLAYER_02, (BITMAP *)data[DF_SELECTOR_FALSE].dat);

  bool got_score_for_current_game = false;

  char *player_names[2] = {
    "X",
    "O",
  };

  int player_score[2];

  int num_players = -1;

  //Start game loop
  while (game_type != e_QUIT_GAME)
  {
    if (logic_update)
    {
      switch (game_type)
      {
        case e_MENU: {
          //INPUT
          if (input_delay != 0) input_delay--;
          if (input_delay == 0)
          {
            last_menu_item = menu_item;

            if (key[KEY_UP])    menu_item--;
            if (key[KEY_DOWN])  menu_item++;

            if (menu_item == -1)                  menu_item = MAX_MENU_ITEM;
            if (menu_item == (MAX_MENU_ITEM + 1)) menu_item = 0;

            if (menu_item != last_menu_item) input_delay = INPUT_DELAY_TICKS;

            if (key[KEY_ENTER])
            {
              switch (menu_item)
              {
                case 0: { // one player game init
                  play_field->reset();
                  play_field->set_two_player_mode(false);
                  got_score_for_current_game = false;

                  player_score[0] = 0;
                  player_score[1] = 0;

                  input_delay = INPUT_DELAY_TICKS * 2;

                  game_type = e_PLAY_GAME;
                  break;
                }
                case 1: { //two player game init 
                  play_field->reset();
                  play_field->set_two_player_mode(true);
                  got_score_for_current_game = false;

                  player_score[0] = 0;
                  player_score[1] = 0;

                  input_delay = INPUT_DELAY_TICKS * 2;

                  game_type = e_PLAY_GAME;
                  break;
                }
                case 2: {  // about screen
                  input_delay = INPUT_DELAY_TICKS * 2;
                  game_type = e_ABOUT;
                  break;
                }
                case 3: {  //quit game
                  game_type = e_QUIT_GAME;
                  break;
                }
              }
            }

            if (key[KEY_ESC]) game_type = e_QUIT_GAME;
          }

          menu_x_pos_extra += 2;
          if (menu_x_pos_extra > menu_y_pos[menu_item][1]) menu_x_pos_extra = 0;

          //DRAW TO SCREEN
          blit((BITMAP *)data[DF_MENU].dat, BUFFER, 0, 0, 0, 0, SCREEN_X, SCREEN_Y);

          set_trans_blender(0, 0, 0, 128);
          draw_trans_sprite(BUFFER, (BITMAP *)data[DF_MENU_SELECT].dat, x_offset + menu_x_pos_extra, menu_y_pos[menu_item][0]);

          break;
        }
        case e_PLAY_GAME: {
          blit((BITMAP *)data[DF_BACKGROUND].dat, BUFFER, 0, 0, 0, 0, SCREEN_X, SCREEN_Y);

          if (play_field->field_flags & f_fl_WINNER)
          {
            textprintf_centre_ex(BUFFER, font, (SCREEN_X / 2), 445, makecol(128,128,128), -1, "Player %s is the winner!!!", player_names[play_field->get_winner() - 1]);
            if (!got_score_for_current_game)
            {
              player_score[play_field->get_winner()-1]++;
              got_score_for_current_game = true;
            }
          }
          else if (play_field->field_flags & f_fl_FIELD_FULL)
          {
            textprintf_centre_ex(BUFFER, font, (SCREEN_X / 2), 445, makecol(128,128,128), -1, "It's a draw");
          }

          if ((play_field->field_flags & f_fl_WINNER) || (play_field->field_flags & f_fl_FIELD_FULL))
          {
            textprintf_centre_ex(BUFFER, font, SCREEN_X / 2, 460, makecol(128,128,128), -1, "Press 'N' to start a new game...");
          }
          else
          {
            textprintf_centre_ex(BUFFER, font, SCREEN_X / 2, 460, makecol(128,128,128), -1, "Player %s's turn", player_names[play_field->current_player() - 1]);
          }

          if ((key[KEY_N]) && ((play_field->field_flags & f_fl_WINNER) || (play_field->field_flags & f_fl_FIELD_FULL)))
          {
            play_field->reset();
            got_score_for_current_game = false;
          }

          if ((!play_field->is_two_player_game()) && (play_field->current_player() == PLAYER_02))
          {
            //cpu move
            if (!play_field->make_cpu_move()) play_field->switch_player();
          }
          else
          {
            if (input_delay != 0) input_delay--;
            //player move
            if (input_delay == 0)
            {
              if (play_field->input() == 1) input_delay = INPUT_DELAY_TICKS;
            }
          }

          play_field->do_animate();
          play_field->do_translate();

          textprintf_centre_ex(BUFFER, font, SCREEN_X / 2, 475, makecol(128,128,128), -1, "%d - Player X | Player O - %d", player_score[0], player_score[1]);

          play_field->draw(BUFFER);

          if (play_field->field_flags & f_fl_ESCAPE)
          {
            menu_item       = 0;
            last_menu_item  = -1;
            input_delay     = INPUT_DELAY_TICKS * 2;
            game_type       = e_MENU;
          }

          break;
        }
        case e_ABOUT: {
          blit((BITMAP *)data[DF_ABOUT].dat, BUFFER, 0, 0, 0, 0, SCREEN_X, SCREEN_Y);

          if (input_delay != 0) input_delay--;
          if (input_delay == 0)
          {
            if (key[KEY_SPACE]) game_type = e_MENU;
          }

          break;
        }
        default: {
          game_type = e_QUIT_GAME;
          break;
        }
      };

      //Draw buffer to screen
      draw_screen(BUFFER);

      logic_update = 0;
    }
  }

  delete play_field;

  SHUTDOWN_ALLEGRO();
	return 0;
}
END_OF_MAIN();


void INIT_ALLEGRO()
{
  //Allegro init functions
  allegro_init();

  //Input devices
  install_keyboard();
  USE_MOUSE = (install_mouse() != -1);

	//Timer
  install_timer();
  LOCK_VARIABLE(logic_update);
  LOCK_FUNCTION(tf_01);

  install_int_ex(tf_01, BPS_TO_TIMER(FRAMES_PER_SECOND));

  //Set graphic mode
  set_color_depth(16);
  if (set_gfx_mode(GFX_AUTODETECT, SCREEN_X, SCREEN_Y, 0, 0) != 0)
  {
    allegro_message(allegro_error);
    exit(0);
  }
  set_projection_viewport(0, 0, SCREEN_X, SCREEN_Y);

  BUFFER    = create_bitmap(SCREEN_X, SCREEN_Y);
  DB_BUFFER = create_bitmap(SCREEN_X, SCREEN_Y);

  clear_to_color(BUFFER, bitmap_mask_color(BUFFER));
  clear_to_color(DB_BUFFER, makecol(0,0,0));
}

void SHUTDOWN_ALLEGRO()
{
	destroy_bitmap(BUFFER);
	destroy_bitmap(DB_BUFFER);
}

void draw_screen(BITMAP *bmp)
{
  //acquire_screen();
  blit(bmp, screen, 0, 0, 0, 0, SCREEN_X, SCREEN_Y);
  //release_screen();
}


