#ifndef ttt_cube_h
#define ttt_cube_h

#include <allegro.h>
#include "..\main_u.h"

/*
 -  A point in the 3d world
*/
class VTX
{
public:
  VTX(int nx = 0, int ny = 0, int nz = 0) : x(nx), y(ny), z(nz) {;}
  fixed x, y, z;
};

/*
 -  A triangle defined somewhere in the 3d world
*/
class TRIANGLE
{
public:
  TRIANGLE() {;}
  TRIANGLE(VTX np1, VTX np2, VTX np3) : p1(np1), p2(np2), p3(np3) {;}
  VTX p1, p2, p3;
};

/*
 -  A square defined somewhere in the 3d world
*/
class SQUARE
{
public:
  SQUARE() {}
  SQUARE(VTX *list, int np1, int np2, int np3, int np4) : vtxlist(list), p1(np1), p2(np2), p3(np3), p4(np4) {;}
  VTX *vtxlist;
  int p1, p2, p3, p4;
};

//Constants for setting 3d objects values
const int POSITION       = 1;
const int ROTATION       = 2;
const int MOVEMENT       = 3;
const int ROTATION_SPEED = 4;
const int MIN_3D_POS     = 5;
const int MAX_3D_POS     = 6;

//Compares quads and return the top one you see, use for qsort
int quad_cmp(const void *e1, const void *e2);

/*
 -  An object defined somewhere in the 3d world
*/
class c_OBJECT_3D
{
public:
  c_OBJECT_3D();

  virtual ~c_OBJECT_3D() {}

  virtual void set(int SET_PROPERTY, fixed px, fixed py, fixed pz);

  //Animate the objects movement, rotation etc...
  virtual void animate();

  virtual void translate() {;}
  virtual void draw(BITMAP *dest) {;}

  VTX get_position()       const { return position;}
  VTX get_movement()       const { return movement;}
  VTX get_rotation()       const { return rotation;}
  VTX get_rotation_speed() const { return rotation_speed;}
private:
protected:
  VTX position, movement, rotation, rotation_speed, world_min, world_max;
};

#define c_BOX_NUMBER_OF_VTX    8
#define c_BOX_NUMBER_OF_SQUARE 6


/*
 - A box in the 3d world
*/
class c_BOX : public c_OBJECT_3D
{
public:
  c_BOX(int new_size_x = 32, int new_size_y = 32, int new_size_z = 32);
  ~c_BOX();

  //Calculate all the thing to get the right side of the
  //cube on the screen
  void translate();

  void draw(BITMAP *dest, BITMAP *texture = NULL);
private:
  int       size_x, size_y, size_z;
  VTX       points[c_BOX_NUMBER_OF_VTX], output_points[c_BOX_NUMBER_OF_VTX];
  SQUARE    faces[c_BOX_NUMBER_OF_SQUARE], output_faces[c_BOX_NUMBER_OF_SQUARE];
  BITMAP    *cube_texture;

  void set_points(int x, int y, int z);
  void set_faces();

  //Draws a quad on the bitmap
  void quad(BITMAP *dest, VTX *p1, VTX *p2, VTX *p3, VTX *p4, BITMAP *texture = NULL);
protected:
};
#endif
