#include <allegro.h>

#include "ttt_cube.h"

int quad_cmp(const void *e1, const void *e2)
{
  SQUARE *q1 = (SQUARE *)e1;
  SQUARE *q2 = (SQUARE *)e2;

  fixed d1 = (q1->vtxlist[q1->p1].z + q1->vtxlist[q1->p2].z + q1->vtxlist[q1->p3].z + q1->vtxlist[q1->p4].z);
  fixed d2 = (q2->vtxlist[q2->p1].z + q2->vtxlist[q2->p2].z + q2->vtxlist[q2->p3].z + q2->vtxlist[q2->p4].z);

  return d2 - d1;
}

/*
	c_OBJECT_3D
*/
  c_OBJECT_3D::c_OBJECT_3D()
  {
    set(POSITION        , itofix(0), itofix(0), itofix(0));
    set(ROTATION        , itofix(0), itofix(0), itofix(0));
    set(MOVEMENT        , itofix(0), itofix(0), itofix(0));
    set(ROTATION_SPEED  , itofix(0), itofix(0), itofix(0));
  }

  void c_OBJECT_3D::set(int SET_PROPERTY, fixed px, fixed py, fixed pz)
  {
    VTX *p_to_vtx;

    switch (SET_PROPERTY)
    {
      case POSITION       : p_to_vtx = &position;       break;
      case ROTATION       : p_to_vtx = &rotation;       break;
      case MOVEMENT       : p_to_vtx = &movement;       break;
      case ROTATION_SPEED : p_to_vtx = &rotation_speed; break;
      case MIN_3D_POS     : p_to_vtx = &world_min;      break;
      case MAX_3D_POS     : p_to_vtx = &world_max;      break;
    }

    p_to_vtx->x = px;
    p_to_vtx->y = py;
    p_to_vtx->z = pz;
  }

  void c_OBJECT_3D::animate()
  {
    position.x += movement.x;
    position.y += movement.y;
    position.z += movement.z;


    if ((position.x < world_min.x) || (position.x > world_max.x)) movement.x = -movement.x;
    if ((position.y < world_min.y) || (position.y > world_max.y)) movement.y = -movement.y;
    if ((position.z < world_min.z) || (position.z > world_max.z)) movement.z = -movement.z;

    rotation.x += rotation_speed.x;
    rotation.y += rotation_speed.y;
    rotation.z += rotation_speed.z;
  }

/*
	C_BOX
*/
  c_BOX::c_BOX(int new_size_x, int new_size_y, int new_size_z = 32) : size_x(new_size_x), size_y(new_size_y), size_z(new_size_z)
  {
    cube_texture = create_bitmap(size_x, size_y);
    clear_to_color(cube_texture, makecol(255, 0, 0));
    rect(cube_texture, 1, 1, size_x - 3, size_y - 3, makecol(0, 255, 0));
    textprintf_ex(cube_texture, font, 6, 6, makecol(0,0,0), -1, "X");

    set_points(size_x, size_y, size_z);
    set_faces();
  }

	c_BOX::~c_BOX()
  {
    destroy_bitmap(cube_texture);
  }

  void c_BOX::translate()
  {
    MATRIX matrix;

    VTX *outpoint = output_points;
    SQUARE *outface = output_faces;

    get_transformation_matrix(&matrix, itofix(1), rotation.x, rotation.y, rotation.z, position.x, position.y, position.z);

    for (int i = 0; i < c_BOX_NUMBER_OF_VTX; i++)
    {
      apply_matrix(&matrix, points[i].x, points[i].y, points[i].z, &outpoint[i].x, &outpoint[i].y, &outpoint[i].z);
      persp_project(outpoint[i].x, outpoint[i].y, outpoint[i].z, &outpoint[i].x, &outpoint[i].y);
    }

    for (int i = 0; i < c_BOX_NUMBER_OF_SQUARE; i++)
    {
      outface[i] = faces[i];
      outface[i].vtxlist = outpoint;
    }
  }

  void c_BOX::draw(BITMAP *dest, BITMAP *texture)
  {
    VTX p1, p2, p3, p4;
    SQUARE *face = output_faces;

    qsort(output_faces, c_BOX_NUMBER_OF_SQUARE, sizeof(SQUARE), quad_cmp);

    for (int i = 0; i < c_BOX_NUMBER_OF_SQUARE; i++)
    {
      p1 = face->vtxlist[face->p1];
      p2 = face->vtxlist[face->p2];
      p3 = face->vtxlist[face->p3];
      p4 = face->vtxlist[face->p4];

      quad(dest, &p1, &p2, &p3, &p4, texture);

      face++;
    }
  }

  void c_BOX::set_points(int x, int y, int z)
  {
    points[ 0] = VTX( -(x / 2) << 16, -(y / 2) << 16, -(z / 2) << 16);
    points[ 1] = VTX( -(x / 2) << 16,  (y / 2) << 16, -(z / 2) << 16);
    points[ 2] = VTX(  (x / 2) << 16,  (y / 2) << 16, -(z / 2) << 16);
    points[ 3] = VTX(  (x / 2) << 16, -(y / 2) << 16, -(z / 2) << 16);
    points[ 4] = VTX( -(x / 2) << 16, -(y / 2) << 16,  (z / 2) << 16);
    points[ 5] = VTX( -(x / 2) << 16,  (y / 2) << 16,  (z / 2) << 16);
    points[ 6] = VTX(  (x / 2) << 16,  (y / 2) << 16,  (z / 2) << 16);
    points[ 7] = VTX(  (x / 2) << 16, -(y / 2) << 16,  (z / 2) << 16);
  }

  void c_BOX::set_faces()
  {
    faces[ 0] = SQUARE( points, 0, 3, 2, 1);
    faces[ 1] = SQUARE( points, 4, 5, 6, 7);
    faces[ 2] = SQUARE( points, 0, 1, 5, 4);
    faces[ 3] = SQUARE( points, 2, 3, 7, 6);
    faces[ 4] = SQUARE( points, 0, 4, 7, 3);
    faces[ 5] = SQUARE( points, 1, 2, 6, 5);
  }

  void c_BOX::quad(BITMAP *dest, VTX *p1, VTX *p2, VTX *p3, VTX *p4, BITMAP *texture)
  {
    V3D vtx[4] =
    {
      { p1->x, p1->y, p1->z, 0, 0, 0},
      { p2->x, p2->y, p2->z, (31 << 16), 0, 0},
      { p3->x, p3->y, p3->z, (31 << 16), (31<<16), 0},
      { p4->x, p4->y, p4->z, 0, (31 << 16), 0},
    };

    if (polygon_z_normal(&vtx[0], &vtx[0], &vtx[0]) < 0) return;

    vtx[0].c = MID(0, 255 - fixtoi(p1->z) / 4, 255);
    vtx[1].c = MID(0, 255 - fixtoi(p2->z) / 4, 255);
    vtx[2].c = MID(0, 255 - fixtoi(p3->z) / 4, 255);
    vtx[3].c = MID(0, 255 - fixtoi(p4->z) / 4, 255);

    if (texture == NULL)
      quad3d(dest, POLYTYPE_ATEX_MASK, cube_texture, &vtx[0], &vtx[1], &vtx[2], &vtx[3]);
    else
      quad3d(dest, POLYTYPE_ATEX_MASK, texture, &vtx[0], &vtx[1], &vtx[2], &vtx[3]);
  }
