#ifndef ttt_menu_h
#define ttt_menu_h

#include <allegro.h>
//#include <stdio.h>
//#include <conio.h>
//#include <stdlib.h>
//#include <math.h>
//#include <strings.h>

#include "..\main_u.h"

const int MENU_ITEM_TEXT_LENGTH   = 25;
const int MI_NEW_GAME             = 0;
const int MI_QUIT_GAME            = 1;
const int MI_MAIN_MENU            = 2;
const int ALL_MENU_ITEMS          = 3;

class c_menu_item
{
public:
  c_menu_item(char *_text, int _value, bool _active = false);
  ~c_menu_item();
  
  char *get_text() const;
  int get_value() const;
private:
	char *text[MENU_ITEM_TEXT_LENGTH];
	bool active;
  int menu_value;
protected:
};

static c_menu_item *all_menu_items[ALL_MENU_ITEMS] = {
  new c_menu_item("New game",       MI_NEW_GAME),
  new c_menu_item("Quit game",      MI_QUIT_GAME),
};

class c_menu
{
public:
  c_menu(int _x_pos = (SCREEN_X / 2), int _y_pos = (SCREEN_Y / 2));
  ~c_menu();

  void reset();
  void draw(BITMAP *dest);
  void input();
  int active_item() const;
private:
  int x_pos, y_pos, selected_item, show_selected_nr_ticks, active_menu_item;
  BITMAP *menu_top, *menu_item, *menu_item_sel, *menu_bottom;
protected:
};

#endif
