#include <allegro.h>
//#include <stdio.h>
//#include <conio.h>
//#include <stdlib.h>
//#include <math.h>
//#include <strings.h>

#include "ttt_menu.h"

/*
  C_MENU_ITEM
*/
  c_menu_item::c_menu_item(char *_text, int _value, bool _active)
  {
    text[0] = _text;
    menu_value = _value;
    active = _active;
  }

  c_menu_item::~c_menu_item()
  {
    delete [] text;
  }

  char *c_menu_item::get_text() const
  {
    return text[0];
  }

  int c_menu_item::get_value() const
  {
    return menu_value;
  }

/*
  C_MENU
*/
  c_menu::c_menu(int _x_pos, int _y_pos)
  {
    //menu_top        = (BITMAP *)DATA_FILE[DF_EMPTY].dat;
    //menu_item       = (BITMAP *)DATA_FILE[DF_EMPTY].dat;
    //menu_item_sel   = (BITMAP *)DATA_FILE[DF_EMPTY].dat;
    //menu_bottom     = (BITMAP *)DATA_FILE[DF_EMPTY].dat;

    x_pos = _x_pos;
    y_pos = _y_pos;

    reset();
  }

  c_menu::~c_menu()
  {
  }

  void c_menu::reset()
  {
    selected_item           = 0;
    show_selected_nr_ticks  = 0;
    active_menu_item        = MI_MAIN_MENU;
  }

  void c_menu::draw(BITMAP *dest)
  {
    masked_blit(menu_top, dest, 0, 0, x_pos, y_pos, menu_top->w, menu_top->h);
    for (int i = 0; i < ALL_MENU_ITEMS; i++)
    {
      masked_blit(menu_item, dest, 0, 0, x_pos, y_pos + ((i + 1) * 20), menu_item->w, menu_item->h);

      textprintf_ex(dest, font, x_pos + 50, y_pos + ((i + 1) * 20) + 7, makecol(0,0,0), -1, "%s", all_menu_items[i]->get_text());

      if (i == selected_item)
      {
        set_trans_blender(0, 0, 0, 128);
        draw_trans_sprite(dest, menu_item_sel, x_pos, y_pos + ((i + 1) * 20));
      }
    }
    masked_blit(menu_bottom, dest, 0, 0, x_pos, y_pos + ((ALL_MENU_ITEMS + 1) * 20), menu_bottom->w, menu_bottom->h);
  }

  void c_menu::input()
  {
    if (key[KEY_UP])
    {
      if (selected_item == 0)
        selected_item = ALL_MENU_ITEMS - 1;
      else
        selected_item--;
    }
    if (key[KEY_DOWN])
    {
      if (selected_item == (ALL_MENU_ITEMS - 1))
        selected_item = 0;
      else
        selected_item++;
    }
    if (key[KEY_ENTER]) active_menu_item = all_menu_items[selected_item]->get_value();
  }

  int c_menu::active_item() const
  {
    return active_menu_item;
  }
