#ifndef ttt_field_h
#define ttt_field_h

#include <allegro.h>

#include "ttt_cube.h"

#include "..\main_u.h"

enum SPACE_VALUES { EMPTY = 0, PLAYER_01 = 1, PLAYER_02 = 2};

const int FIELD_X       = 3;
const int FIELD_Y       = 3;
const int ALL_POSITIONS = (FIELD_X * FIELD_Y);

const int f_fl_FIELD_FULL = 1;
const int f_fl_WINNER     = 2;
const int f_fl_ESCAPE     = 4;

class c_space_info
{
public:
  c_space_info(int new_value = EMPTY, int _x = 0, int _y = 0) : value(new_value), x(_x), y(_y)
  {
    cube = new c_BOX(TILE_X, TILE_Y, TILE_X);
  }

  ~c_space_info()
  {
    delete cube;
  }
  void set_to(int new_value)
  {
    value = new_value;
  }
  int x, y, value;
  c_BOX *cube;
};

/*
 - Rows to check if someone won the game
*/
const int NUM_ALL_ROWS = 8;
const int ALL_ROWS[NUM_ALL_ROWS][3] = {
  {0, 1, 2}, //Horizontal
  {3, 4, 5},
  {6, 7, 8},
  {0, 3, 6}, //Vertical
  {1, 4, 7},
  {2, 5, 8},
  {0, 4, 8}, //Diagonal
  {2, 4, 6},
};

class c_field
{
public:
  c_field (int _x_pos = 0, int _y_pos = 0, bool _allow_override = false);
  ~c_field();

  void reset();

  void do_animate();
  void do_translate();
  void draw(BITMAP *dest);

  void set_allow_override(bool _allow_override = false);
  bool set_position(int space_index, int new_owner);
  void set_selector(bool _selecting = true);

  void set_field_bitmap(int bmp_value, BITMAP *bmp);
  void set_selector_bitmap(int bmp_value, BITMAP *bmp);

  int input();
  void switch_player();
  int current_player() { return active_player;}
  int get_winner() { return winner; }

  void check_win();
  void check_draw();

  void set_two_player_mode(bool _mode = true);
  bool is_two_player_game();

  int make_cpu_move();

  int field_flags;
private:
  c_space_info *all_spaces[FIELD_X * FIELD_Y];
  bool allow_override, selecting, field_full;
  BITMAP *field_bitmaps[PLAYER_02 + 1], *selector_bitmaps[PLAYER_02 + 1], *winning_cube;
  int x_pos, y_pos, selected_space, filled_positions, active_player, winner, winning_row;
  int number_of_spaces[PLAYER_02 + 1];

  bool exit_on_full, exit_on_abort, two_player_game;
protected:
};

#endif
