#include <allegro.h>

#include "..\datafile.h"

#include "ttt_field.h"

/*
  C_FIELD
*/
  c_field::c_field(int _x_pos, int _y_pos, bool _allow_override) : x_pos(_x_pos), y_pos(_y_pos), allow_override(_allow_override)
  {
    //init bitmaps
    field_bitmaps[EMPTY]            = create_bitmap(TILE_X, TILE_Y);
    field_bitmaps[PLAYER_01]        = create_bitmap(TILE_X, TILE_Y);
    field_bitmaps[PLAYER_02]        = create_bitmap(TILE_X, TILE_Y);
    clear_to_color(field_bitmaps[EMPTY],     makecol(255, 255, 255));
    clear_to_color(field_bitmaps[PLAYER_01], makecol(0, 255, 0));
    clear_to_color(field_bitmaps[PLAYER_02], makecol(255, 0, 0));

    selector_bitmaps[EMPTY]            = create_bitmap(TILE_X, TILE_Y);
    selector_bitmaps[PLAYER_01]        = create_bitmap(TILE_X, TILE_Y);
    selector_bitmaps[PLAYER_02]        = create_bitmap(TILE_X, TILE_Y);
    clear_to_color(selector_bitmaps[EMPTY],     makecol(192, 192, 192));
    clear_to_color(selector_bitmaps[PLAYER_01], makecol(255, 64, 64));
    clear_to_color(selector_bitmaps[PLAYER_02], makecol(255, 64, 64));

    //create the list with the spaces
    all_spaces[0] = new c_space_info(EMPTY, 0, 0),
    all_spaces[1] = new c_space_info(EMPTY, 1, 0),
    all_spaces[2] = new c_space_info(EMPTY, 2, 0),
    all_spaces[3] = new c_space_info(EMPTY, 0, 1),
    all_spaces[4] = new c_space_info(EMPTY, 1, 1),
    all_spaces[5] = new c_space_info(EMPTY, 2, 1),
    all_spaces[6] = new c_space_info(EMPTY, 0, 2),
    all_spaces[7] = new c_space_info(EMPTY, 1, 2),
    all_spaces[8] = new c_space_info(EMPTY, 2, 2),

    winning_cube = create_bitmap(TILE_X, TILE_Y);
    clear_to_color(winning_cube, makecol(0,192,0));

    //initialize all the cube properties here
    int random_rotation = 3;
    for (int i = 0; i < ALL_POSITIONS; i++)
    {
      all_spaces[i]->cube->set(POSITION, itofix(((all_spaces[i]->x-1) * 2) * TILE_X), itofix(((all_spaces[i]->y-1) * 2) * TILE_Y), itofix(256));
      all_spaces[i]->cube->set(MOVEMENT,           itofix(0), itofix(0), itofix(0));
      all_spaces[i]->cube->set(ROTATION,           itofix(0), itofix(0), itofix(0));

      if (rand()%2)
        all_spaces[i]->cube->set(ROTATION_SPEED, itofix((rand()%random_rotation)+1), itofix((rand()%random_rotation)+1), itofix((rand()%10)+random_rotation));
      else
        all_spaces[i]->cube->set(ROTATION_SPEED, 0 - itofix((rand()%random_rotation)+1), 0 - itofix((rand()%random_rotation)+1), 0 - itofix((rand()%10)+random_rotation));

      all_spaces[i]->cube->set(MIN_3D_POS,         itofix(-32), itofix(-32), itofix(128));
      all_spaces[i]->cube->set(MAX_3D_POS,         itofix(32), itofix(32), itofix(512));
    }

    two_player_game = false;

    reset();
  }

  c_field::~c_field()
  {
    //keeping the memory leaks as minimal as possible ;)
    destroy_bitmap(field_bitmaps[EMPTY]);
    destroy_bitmap(field_bitmaps[PLAYER_01]);
    destroy_bitmap(field_bitmaps[PLAYER_02]);

    destroy_bitmap(selector_bitmaps[EMPTY]);
    destroy_bitmap(selector_bitmaps[PLAYER_01]);
    destroy_bitmap(selector_bitmaps[PLAYER_02]);

    destroy_bitmap(winning_cube);

    delete [] all_spaces;
  }

  void c_field::reset()
  {
    //set every space to empty
    for (int i = 0; i < ALL_POSITIONS; i++) all_spaces[i]->set_to(EMPTY);

    active_player = PLAYER_01;

    //reset variables
    winner            = EMPTY;
    winning_row       = -1;
    field_flags       = 0;
    filled_positions  = 0;
    exit_on_abort     = true;

    number_of_spaces[EMPTY] = 9;
    number_of_spaces[PLAYER_01] = 0;
    number_of_spaces[PLAYER_02] = 0;

    set_selector();
  }

  void c_field::do_animate()
  {
    //aminate all the cubes
    for (int i = 0; i < ALL_POSITIONS; i++)
      all_spaces[i]->cube->animate();
  }

  void c_field::do_translate()
  {
    //translate all the cubes
    for (int i = 0; i < ALL_POSITIONS; i++)
      all_spaces[i]->cube->translate();
  }

  void c_field::draw(BITMAP *dest)
  {
    BITMAP *texture_on_cube = create_bitmap(TILE_X, TILE_Y);

    for (int i = 0; i < ALL_POSITIONS; i++)
    {
      //set the bmp for the cube texture
      blit(field_bitmaps[all_spaces[i]->value], texture_on_cube, 0, 0, 0, 0, TILE_X, TILE_Y);

      //if the current space is the selected one, then the selected_pos bmp will be draw on top of the texture :)
      if ((selecting) && (i == selected_space))
      {
        set_trans_blender(0, 0, 0, 128);
        draw_trans_sprite(texture_on_cube, selector_bitmaps[all_spaces[i]->value], 0, 0);
      }

      //if some-one has won the game, flicker the winning row
      if (winner && ((ALL_ROWS[winning_row][0] == i) || (ALL_ROWS[winning_row][1] == i) || (ALL_ROWS[winning_row][2] == i)))
      {
        set_trans_blender(0, 0, 0, 128);
        draw_trans_sprite(texture_on_cube, winning_cube, 0, 0);
      }

      all_spaces[i]->cube->draw(dest,texture_on_cube);
    }

    destroy_bitmap(texture_on_cube);
  }

  void c_field::set_allow_override(bool _allow_override)
  {
    allow_override = _allow_override;
  }

  bool c_field::set_position(int space_index, int new_owner)
  {
    //no override alloud
    if ((!allow_override) && (all_spaces[space_index]->value != EMPTY)) return false;

    //out of range
    if ( (all_spaces[space_index]->x < 0)         ||
         (all_spaces[space_index]->x >= FIELD_X)  ||
         (all_spaces[space_index]->y < 0)         ||
         (all_spaces[space_index]->y >= FIELD_Y)  )
      return false;

    number_of_spaces[all_spaces[space_index]->value]--;
    number_of_spaces[new_owner]++;

    all_spaces[space_index]->value = new_owner;

    filled_positions++;

    //Check if there's a winner
    check_win();
    //Check if there's a draw
    check_draw();

    return true;
  }

  void c_field::set_selector(bool _selecting)
  {
    selecting = _selecting;

    //Select the middle space
    if (selecting) selected_space = 4;
  }


  void c_field::set_field_bitmap(int bmp_value, BITMAP *bmp)
  {
    blit(bmp, field_bitmaps[bmp_value], 0, 0, 0, 0, TILE_X, TILE_Y);
  }

  void c_field::set_selector_bitmap(int bmp_value, BITMAP *bmp)
  {
    blit(bmp, selector_bitmaps[bmp_value], 0, 0, 0, 0, TILE_X, TILE_Y);
  }

  int c_field::input()
  {
    int value = 1;

    if (selecting)
    {
      //save original coordinates
      int x = all_spaces[selected_space]->x, y = all_spaces[selected_space]->y;
      int org_x = x, org_y = y;

      if (key[KEY_LEFT]   && (x != 0))            x--;
      if (key[KEY_RIGHT]  && (x != FIELD_X - 1))  x++;
      if (key[KEY_UP]     && (y != 0))            y--;
      if (key[KEY_DOWN]   && (y != FIELD_Y - 1))  y++;

      //check is coordinates are changed, if yes, lookup new selected_space
      if ((org_x != x) || (org_y != y))
      {
        for (int i = 0; i < ALL_POSITIONS; i++)
          if ((all_spaces[i]->x == x) && (all_spaces[i]->y == y)) selected_space = i;
      }
      else
      {
        value = 0;
      }

      //if player made move, switch players
      if (key[KEY_ENTER] && (set_position(selected_space, active_player))) switch_player();
    }

    //Check escape flag
    if ((key[KEY_ESC]) && (!(field_flags & f_fl_ESCAPE)))
    {
      field_flags |= f_fl_ESCAPE;
      value = 0;
    }

    return value;
  }

  void c_field::switch_player()
  {
    if (active_player == PLAYER_01)
      active_player = PLAYER_02;
    else
      active_player = PLAYER_01;
  }

  void c_field::check_win()
  {
/*
void c_field::check_win()
{
 int i, won;
 
 // Spaces are marked with a -1, x and o are 0 and 1.
 won = -1;
 for (i = 0 ; i < 3 ; i++)
 {
  // Check for Vertical and Horizontal wins.
  if (space[i][0] != -1 && space[i][1] == space[i][2] == space[i][0]) won = space[i][0];
  if (space[0][i] != -1 && space[1][i] == space[2][i] == space[0][i]) won = space[0][i];
 }
 // Check for the two possible Diagonal wins.
 if (space[0][0] != -1 && space[1][1] == space[2][2] == space[0][0]) won = space[0][0];
 if (space[2][0] != -1 && space[1][1] == space[0][2] == space[2][0]) won = space[2][0];

 // 'won' now holds winning player number.
}
*/

    bool row_can_win;
    int total_row_value;

    if (!(field_flags & f_fl_WINNER))
    {
      for (int i = 0; i < NUM_ALL_ROWS; i++)
      {
        row_can_win = true;
        total_row_value = 0;

        for (int j = 0; j < 3; j++)
        {
          total_row_value += all_spaces[ALL_ROWS[i][j]]->value;
          if (all_spaces[ALL_ROWS[i][j]]->value == EMPTY) row_can_win = false;
        }

        if (row_can_win && ((total_row_value % 3) == 0))
        {
          winner = total_row_value / 3;
          winning_row = i;
          field_flags |= f_fl_WINNER;
          set_selector(false);
        }
      }
    }
  }

  void c_field::check_draw()
  {
    //Check the FIELD_FULL flag
    if ((filled_positions == ALL_POSITIONS) && (!(field_flags & f_fl_FIELD_FULL)))
    {
      field_flags |= f_fl_FIELD_FULL;
      set_selector(false);
    }
  }

  void c_field::set_two_player_mode(bool _mode)
  {
    two_player_game = _mode;
  }

  bool c_field::is_two_player_game()
  {
    return two_player_game;
  }

  int c_field::make_cpu_move()
  {
    /*
       Calc 2 moves ahead and c wich is the best move
    */

    if ((field_flags & f_fl_FIELD_FULL) || (field_flags & f_fl_WINNER)) return 0;

    int pv[3] = {0, 1, 3};
    int row_total[NUM_ALL_ROWS], set_to_position = -1;

    for (int i = 0; i < NUM_ALL_ROWS; i++)
      row_total[i] = (pv[all_spaces[ALL_ROWS[i][0]]->value] + pv[all_spaces[ALL_ROWS[i][1]]->value] + pv[all_spaces[ALL_ROWS[i][2]]->value]);

    //Check if cpu can win a row
    for (int i = 0; i < NUM_ALL_ROWS; i++)
      if (row_total[i] == 6)
      {
        for (int j = 0; j < 3; j++)
          if (all_spaces[ALL_ROWS[i][j]]->value == EMPTY) set_to_position = ALL_ROWS[i][j];

        if (set_to_position != -1) break;
      }

    //Block player if needed
    if (set_to_position == -1)
    {
      for (int i = 0; i < NUM_ALL_ROWS; i++)
        if (row_total[i] == 2)
        {
          for (int j = 0; j < 3; j++)
            if (all_spaces[ALL_ROWS[i][j]]->value == EMPTY) set_to_position = ALL_ROWS[i][j];

          if (set_to_position != -1) break;
        }
    }

    if (set_to_position == -1)
    {
      int empty_spaces[number_of_spaces[EMPTY]], index = 0;
      //Random position
      for (int i = 0; i < ALL_POSITIONS; i++)
      {
        if (all_spaces[i]->value == EMPTY)
        {
          empty_spaces[index] = i;
          index++;
        }
      }

      set_to_position = empty_spaces[rand() % number_of_spaces[EMPTY]];

      //Check if its on pos 1,3,5,7 cuz that way the player can win eazily
      if ((rand() % 3) == 2)
        if (set_to_position % 2) set_to_position = empty_spaces[rand() % number_of_spaces[EMPTY]];
    }

    set_position(set_to_position, active_player);
    switch_player();

    return 1;
  }
