#ifndef cab_serie_h
 /* Contiene todo lo necesario para configurar el Puerto Serie RS232, asi
    como para activar y desactivar la linea RTS
    Bajo DOS, se utiliza la libreria DZCOMM
    Bajo WINDOWS, se utiliza HANDLE de WIN32
    Bajo LINUX se utiliza ioctl
    Autor: Jaime Jose Gavin Sierra
    Alias: JJ
    Correo: jaimejj@mixmail.com
    WEB: http://www.lanzadera.com/ensamblador */
 #define cab_serie_h
 #define boolean int

 //Lo normal es no poner Codigo en los .H, pero esto no es NORMAL 8-D))

 #ifdef ALLEGRO_LINUX
  #include <sys/ioctl.h>
  #include <asm/ioctls.h>
  int ficheroSerie=-1;
 #endif

 #ifdef ALLEGRO_DOS
  #define DZCOMM_SECUNDARY_INCLUDE
  #include <dzcomm.h>
  comm_port* puertoRS232;
 #endif


 enum TPuerto {COM1=1,COM2=2,COM3=3,COM4=4,NULO=5};
 char puerto_com = COM2;     //El COM2 por defecto
 void PuertoSerie(enum TPuerto numero, boolean activar);

 #ifdef ALLEGRO_DOS
  void InicializaPuertoSerie(enum TPuerto numero);
  void EliminarPuertoSerie(void);
 #endif

 #ifdef ALLEGRO_LINUX
  void InicializaPuertoSerie(enum TPuerto numero);
  void EliminarPuertoSerie(void);
 #endif

 void PuertoSerie(enum TPuerto numero, boolean activar);


 /******************************************************/
 void PuertoSerie(enum TPuerto numero, boolean activar){
 //Bajo DOS activo la linea RTS directamente en cada puerto
 //Bajo WIN32 llamo a un programa creado por mi que activa RTS
  int estado;
  if (numero != NULO){
   #ifdef ALLEGRO_WINDOWS
    if (activar==TRUE) AccionPuertoSerieWin(1);
    else AccionPuertoSerieWin(0);
   #endif
   #ifdef ALLEGRO_DOS
    if (activar==TRUE) comm_port_set_line_status(puertoRS232,DZCOMM_RTS,1);
    else comm_port_set_line_status(puertoRS232,DZCOMM_RTS,0);
   #endif
   #ifdef ALLEGRO_LINUX
    if (ficheroSerie!=-1){
     estado= TIOCM_RTS;
     if (activar==TRUE) ioctl (ficheroSerie,TIOCMBIS,&estado);
     else ioctl (ficheroSerie,TIOCMBIC,&estado);
    }
   #endif
  }
 }

 /*********************************************************/
 #ifdef ALLEGRO_DOS
 void InicializaPuertoSerie(enum TPuerto numero){
  //Aqui se leen los datos del archivo puerto.ini
  comm valor;
  short int aux = FALSE;

  if (dzcomm_init()==1){
   switch (numero){
    case COM1: valor = _com1; break;
    case COM2: valor = _com2; break;
    case COM3: valor = _com3; break;
    case COM4: valor = _com4; break;
    default: aux = TRUE; break;
   }
   if (aux != TRUE){
    puertoRS232 = comm_port_init(valor);
    if (puertoRS232==NULL){
     comm_port_uninstall(puertoRS232);
     dzcomm_closedown();
     allegro_message("Error en inicializacion del puerto\n");
     allegro_exit();
     exit(-1);
    }
  //  comm_port_load_settings(puertoRS232,"puerto.ini");
    comm_port_install_handler(puertoRS232);
    comm_port_set_line_status(puertoRS232,DZCOMM_RTS,0);
   }
  }
 }

 /****************************************/
 void EliminarPuertoSerie(void){
  comm_port_uninstall(puertoRS232); dzcomm_closedown();
 }
 #endif


 /*********************************************************/
 #ifdef ALLEGRO_LINUX
 void InicializaPuertoSerie(enum TPuerto numero){
  switch (numero){
   case COM1: ficheroSerie= open ("/dev/ttyS0",O_RDWR|O_NDELAY); break;
   case COM2: ficheroSerie= open ("/dev/ttyS1",O_RDWR|O_NDELAY); break;
   case COM3: ficheroSerie= open ("/dev/ttyS2",O_RDWR|O_NDELAY); break;
   case COM4: ficheroSerie= open ("/dev/ttyS3",O_RDWR|O_NDELAY); break;
  }
 }

 /****************************************/
 void EliminarPuertoSerie(void){
  if (ficheroSerie!=-1)
   close(ficheroSerie);
 }
 #endif



#endif
