#include"main.h"
#include"particle.h"

PARTICLE::PARTICLE(int ix,int iy,float ixs,float iys,int l,int t)
:x(ix),y(iy),xs(ixs),ys(iys),life(l),type(t){
	img=(RLE_SPRITE*)rle[PARTICLE0].dat;
}



bool PARTICLE::update(){
	x+=xs-1;
	y+=ys;
	int c=1;
	if(c && type==3){
		type=4;
		c=0;
	}
	if(c && type==4){
		type=3;
		c=0;
	}
	if(type==-2){
		if(x>319||x<0||y>220||y<20)
			return 0;
	}
	if(type==3){
		img=(RLE_SPRITE*)rle[PARTICLE1+(life%4<2)].dat;
	}
	if(life--)
		return 1;
	return 0;
}



void PARTICLE::draw(BITMAP *bmp){
	if(type==-2){
		xs*=1.1;
		ys*=1.1;
		putpixel(bmp,(int)x,(int)y,1);
	}
	if(type==-1){
		circlefill(bmp,(int)x,(int)y+(int)yoff,life/15,1);
	}
	if(type==0){
		circlefill(bmp,(int)x,(int)y+(int)yoff,life/5,1);
		line(bmp,(int)x,(int)y+(int)yoff,int(x-xs*4),int(y-ys*4)+(int)yoff,1);
	}
	if(type==1){
		float tx=x, ty=y;
		for(int i=1;i<4;i++){
			circlefill(bmp,(int)tx,(int)ty+(int)yoff,i,1);
			tx+=xs*4;
			ty+=ys*4;
		}
	}
	if(type>1)
		draw_rle_sprite(bmp,img,(int)x-img->w/2,(int)y-img->h/2+(int)yoff);
}



void update_particles(list<PARTICLE> *particles){
	for(list<PARTICLE>::iterator i=particles->begin();i!=particles->end();)
		if(i->update())
			i++;
		else
			i=particles->erase(i);
}



void draw_particles(BITMAP *bmp,list<PARTICLE> particles){
	for(list<PARTICLE>::iterator i=particles.begin();i!=particles.end();i++)
		i->draw(bmp);
}

