#include<list>
#include<string>
using namespace std;
#include<math.h>
#include"main.h"
#include"background.h"
#include"campaign.h"

/*Todo
	Have enemies and an AI player in the background.
*/

void eggcheck(int k){
	static int pos=0;
	char pass[]="hack";
	//If you press the right key progress else reset pos.
	if(k == pass[pos])
		pos++;
	else
		pos=0;

	//When you type the correct code switch egg on/off and reset pos.
	if(pos==4){
		egg=egg?0:1;
		pos=0;
	}
}

#define no 6
string text[no]={"Play","Level","Edit","Hiscore","Readme","Exit"};
int sel;
float o;
float a;

void update_menu(){
	if(keypressed()){
		int k=readkey();
		eggcheck(k & 0xff);
		k=k>>8;
		switch(k){
		case KEY_UP:
			sel=sel==0?no-1:sel-1;
			break;
		case KEY_DOWN:
			sel=sel==no-1?0:sel+1;
			break;
		}
	}
	o+=(sel*14-o)/8.;
}

void draw_menu(){
	text_mode(-1);
	for(int i=0;i<no;i++)
		if(i!=sel)
			textprintf_centre(buffer,font,160,140+i*14-(int)o,1,"%s",text[i].c_str());
	for(int i=0;i<(int)text[sel].size();i++)
		textprintf(buffer,font,160-text[sel].size()*6+i*12+int(cos(a+i)*6),140+sel*14-(int)o+int(sin(a-i)*6),1,"%c",text[sel][i]);
}



list<string> readme;
int link[9]={0,0,0,0,0,0,0,0,0};
int rs;

void load_readme(){
	PACKFILE *f=pack_fopen("readme.txt",F_READ);
	char buf[256],l[41];
	int sp,i,h=0,r=0,len;
	l[40]='\0';
	list<string>::iterator hp=NULL;

	while (pack_fgets(buf, sizeof(buf)-1, f) != 0) {
		sp=0;	//Reset startposition.
		do{
			for(len=0;len<40 && buf[sp+len]!='\0';len++); //We don't want to skip past the end.
			for(;buf[sp+len]!=' ' && buf[sp+len]!='\0';len--); //Go to where we don't split a word.
			for(i=0;i<len;i++)
				l[i]=buf[sp+i];
			l[len]='\0';	//End the string
			sp+=len+1;
			readme.push_back(string(l));	//Put it in the list.

			//If it's the title of a new chapter, store the linenumber.
			if(hp!=NULL) if(l==*hp && hp->length()){
				hp++;
				link[h]=r;
				h++;
			}
			r++;
		}while(buf[sp-1]!='\0');
		if(hp==NULL) hp=readme.begin();	//Let the linking begin once we have something to link.
	}
	pack_fclose(f);
}



void update_readme(){
	if(key[KEY_UP])
		rs--;
	if(key[KEY_DOWN])
		rs++;
	for(int i=KEY_1;i<KEY_9;i++){
		if(key[i])
			rs=link[i-KEY_1]?link[i-KEY_1]*8:rs;
	}
	if(key[KEY_0])
		rs=0;
}



void draw_readme(BITMAP *buffer){
	int y=20-rs;
	for(list<string>::iterator i=readme.begin();i!=readme.end();i++){
		y+=8;
		if(y>=0 && y<140)
			textprintf(buffer,font,1,int(-cos(y/140.*M_PI)*70+140),1,"%s",i->c_str());
	}
}



struct hi_entry{
	char name[17];
	int score;
};
hi_entry hiscore[8];
char lname[41];
char hipath[480];

void load_hiscore(char *path){
	//Initialise hiscore path to the practice hiscore file.
	strcpy(hipath,"Practice.hi");
	strcpy(lname,hipath);	//Copy for title
	//If we're not in practice mode.
	if(path!=NULL){
		//Set hiscore file
		replace_extension(hipath, path, "hi", 480);
		strcpy(lname,get_filename(hipath)); //And the title
	}
	//Remove the extension for title
	for(int i=0;;i++)
		if(lname[i]=='.'){
			lname[i]='\0';
			break;
		}

	//Load hixcore file if it exists, otherwise create the default hiscore list.
	if(exists(hipath)){
		PACKFILE *f=pack_fopen(hipath,F_READ);
		for(int i=0;i<8;i++){
			pack_fread((void*)hiscore[i].name,17,f);
			hiscore[i].score=pack_igetw(f);
		}
		pack_fclose(f);
	}
	else{
		strcpy(hiscore[0].name,"Milo Sedlacek");
		strcpy(hiscore[1].name,"Shawn Hargreaves");
		strcpy(hiscore[2].name,"Matthew Leverton");
		strcpy(hiscore[3].name,"Chris 23 Barry");
		strcpy(hiscore[4].name,"Julien Cugniere");
		strcpy(hiscore[5].name,"The Allegroits");
		strcpy(hiscore[6].name,"Idon Nou");
		strcpy(hiscore[7].name,"Anders Andersson");
	}
}

int myscore=-1;
#define MAX_NAME_LEN 16
char yourname[MAX_NAME_LEN+1]="Player";

void draw_hiscore(){
	textprintf_centre(buffer,font,160,80,1,"%s",lname);
	for(int i=0;i<8;i++){
		if(i!=myscore)
			textprintf(buffer,font,20,96+i*16,1,"%i: %s",i+1,hiscore[i].name);
		else
			textprintf(buffer,font,20,96+i*16,1,"%i: %s_",i+1,yourname);
		textprintf_right(buffer,font,300,96+i*16,1,"%i",hiscore[i].score);
		for(int x=20;x<300;x++)
			if(x%4)
				putpixel(buffer,x-1,106+i*16,1);
		//hline(buffer,20,104+i*16,300,1);
	}
}

void update_hiscore(){
	if (keypressed()) {
		int c=readkey();

		if (((c >> 8) == KEY_ENTER) && (yourname[0])) {
			strcpy(hiscore[myscore].name, yourname);
			PACKFILE *f=pack_fopen(hipath,F_WRITE);
			for(int i=0;i<8;i++){
				pack_fwrite((void*)hiscore[i].name,17,f);
				pack_iputw(hiscore[i].score,f);
			}
			pack_fclose(f);
			myscore=-1;
			return;
		}
		else if (((c >> 8) == KEY_BACKSPACE) && (strlen(yourname) > 0)) {
			yourname[strlen(yourname)-1] = 0;
		}
		else if (((c & 0xFF) >= ' ') && ((c & 0xFF) <= '~') && (strlen(yourname) < MAX_NAME_LEN)) {
			yourname[strlen(yourname)+1] = 0;
			yourname[strlen(yourname)] = (c & 0xFF);
		}
	}
}



void menu(){
	sel=0;o=0;a=100;
	BG bg;
	int score=0;
	int mode=0,playmode=0;
	LEVEL level;
	load_hiscore(NULL);

	BITMAP *temp=create_bitmap(72,8);
	textprintf(temp,font,0,0,1,"DEVOSPACE");
	BITMAP *title=create_bitmap(288,32);
	stretch_blit(temp,title,0,0,72,8,0,0,288,32);
	destroy_bitmap(temp);

	load_readme();

	strcpy(lname,"Practice"); //And the title

	while(!key[KEY_ESC] && !wch){
		while(!key[KEY_ESC] && !wch && lc){
			lc--;
			bg.update(0);
			update_scrollers();
			a+=.1;
			if(mode==0)
				update_menu();
			if(mode==3 && myscore>-1)
				update_hiscore();
			if(mode==4)
				update_readme();
		}
		if(key[KEY_ENTER] && mode==0){
			if(sel==0){
				score=0;
				if(playmode==1){
					level.pos=level.events.begin();
					level.time=0;
				}
				if(!playmode)
					score=play(score,NULL);
				if(playmode==1)
					score=play(score,&level);
				if(playmode==2){
					for(int i=0;i<(int)campaign.level.size();i++){
//						score=play(score,&(*i));
//						level=*i;
						strcpy(lname,campaign.name[i].c_str());
						campaign.level[i].time=0;
						score=play(score,&campaign.level[i]);
//						score=play(score,&level);
						if(escexit)
							break;
					}
				}
				myscore=-1;
				for (int i=0; i<8; i++) {
					if (score > hiscore[i].score) {
						for (int j=7; j>i; j--) {
							hiscore[j].score = hiscore[j-1].score;
							strcpy(hiscore[j].name, hiscore[j-1].name);
						}

						hiscore[i].score = score;
						strcpy(hiscore[i].name, yourname);

						myscore = i;
						break;
					}
				}
				mode=3;
			}

			if(sel==1){	//Level
				if(file_select_ex("Select level file or cancel to practice", path, "cpn;lvl", 480, 320, 200)){
					if(!strcmp(get_extension(path),"lvl")){
						playmode=1;
						level.load(path);
						load_hiscore(path);
					}
					if(!strcmp(get_extension(path),"cpn")){
						if(load_campaign()){
							playmode=2;
							load_hiscore(path);
						}
					}
				}
				else{
					playmode=0;
					load_hiscore(NULL);
				}
			}
			if(sel==2)
				edit();
			if(sel==3) //Hiscore
				mode=3;
			if(sel==4) //Readme
				mode=4;
			if(sel==5) //Exit
				break;
			
			while(key[KEY_ESC] || key[KEY_ENTER]);
			sel=0;o=0;
		}
		if(key[KEY_ENTER] && (mode==4 || (mode==3 && myscore==-1))){
			mode=0;
			while(key[KEY_ESC] || key[KEY_ENTER]);
		}

		for(int x=0;x<288;x++)
			for(int y=0;y<32;y++){
				if(!(int(a+x/1.-y/1.)%4))
					putpixel(buffer,x+16+int(cos(a+x/30.+y/30.)*4),y+36+int(sin(a-x/30.+y/30.)*4),getpixel(title,x,y));
				}
		if(mode==0)
			draw_menu();
		if(mode==3)
			draw_hiscore();
		if(mode==4)
			draw_readme(buffer);
		bg.draw(buffer);
		draw_scrollers(buffer);
		acquire_screen();
		stretch_blit(buffer,screen,0,0,320,240,0,0,SCREEN_W,SCREEN_H);
		release_screen();
		clear(buffer);
	}
	destroy_bitmap(buffer);
	destroy_bitmap(title);
}