#include<math.h>
#include<allegro.h>
#include"player.h"
#include"background.h"
#include"main.h"
#include"control.h"
#include"level.h"
#include"campaign.h"

char path[480]="levels/";

char type_name[][11]={
	"Jaw       ","Bombard   ","Asteroid L","Asteroid M","Asteroid S","Steel Cube","Missile   ","Power     "
};
int typeslider(void *dp3, int d2);

char seconds[4]="0";
char ticks[3]="0";

DIALOG objedit[] =
{
   /* (proc)        (x)  (y) (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)                    (dp2) (dp3) */
   { d_box_proc,    0,   0,  224, 120, 1,   0,   0,    0,      0,   0,   NULL,                   NULL, NULL },

   #define D_done 2
   { d_text_proc,   8,   8,  104, 8,   1,   0,   0,    0,      0,   0,   (void*)"Object editor", NULL, NULL },
   { d_button_proc, 120, 8,  40,  16,  1,   0,   0,    D_EXIT,      0,   0,   (void*)"Done",          NULL, NULL },
   { d_button_proc, 160, 8,  56,  16,  1,   0,   0,    D_EXIT,      0,   0,   (void*)"Cancel",        NULL, NULL },
   { d_box_proc,    8,   20, 104, 3,   1,   0,   0,    0,      0,   0,   NULL,                   NULL, NULL },

   #define D_type 7
   { d_text_proc,   8,   32, 32,  8,   1,   0,   0,    0,      0,   0,   (void*)"Type:",         NULL, NULL },
   { d_text_proc,   56,  32, 80,  8,   1,   0,   0,    0,      0,   0,   (void*)type_name[5],    NULL, NULL },
   { d_slider_proc, 152, 32, 64,  8,   1,   0,   0,    0,      7,   5,   NULL,                   (void*)typeslider, NULL },

   { d_text_proc,   8,   48, 32,  8,   1,   0,   0,    0,      0,   0,   (void*)"Time:",         NULL, NULL },
   { d_edit_proc,   56,  48, 32,  8,   1,   0,   0,    0,      3,   0,   (void*)seconds,             NULL, NULL },
   { d_text_proc,   88,  48, 56,  8,   1,   0,   0,    0,      0,   0,   (void*)"Seconds",       NULL, NULL },
   { d_edit_proc,   152, 48, 24,  8,   1,   0,   0,    0,      2,   0,   (void*)ticks,             NULL, NULL },
   { d_text_proc,   176, 48, 40,  8,   1,   0,   0,    0,      0,   0,   (void*)"Ticks",         NULL, NULL },

   #define D_Ypos 15
   { d_text_proc,   8,   64, 32,  8,   1,   0,   0,    0,      0,   0,   (void*)"Ypos:",         NULL, NULL },
   { d_text_proc,   56,   64, 32,  8,   1,   0,   0,    0,      0,   0,   (void*)"Top",         NULL, NULL },
   { d_slider_proc, 56,  72, 160, 8,   1,   0,   0,    0,      360, 180, NULL,                   NULL, NULL },
   { d_text_proc,   168,   64, 32,  8,   1,   0,   0,    0,      0,   0,   (void*)"Bottom",         NULL, NULL },

   #define D_Xspd 18
   { d_text_proc,   8,   88, 32,  8,   1,   0,   0,    0,      0,   0,   (void*)"Xspd:",         NULL, NULL },
   { d_slider_proc, 56,  88, 128, 8,   1,   0,   0,    0,      19, 0, NULL,                   NULL, NULL },

   #define D_Yspd 20
   { d_text_proc,   8,   104, 32,  8,   1,   0,   0,    0,      0,   0,   (void*)"Yspd:",         NULL, NULL },
   { d_slider_proc, 56,  104, 128, 8,   1,   0,   0,    0,      20, 10, NULL,                   NULL, NULL },

   { d_box_proc,    192,   88,  24, 24, 1,   0,   0,    0,      0,   0,   NULL,                   NULL, NULL },

   { NULL,          0,   0,  0,   0,   0,   1,   0,    0,      0,   0,   NULL,                   NULL, NULL }
};

int typeslider(void *dp3, int d2){
	DIALOG d=objedit[6];
	d.dp=type_name[d2];
	object_message(&d,MSG_DRAW,0);
	return D_O_K;
}

int edit(){
	while(key[KEY_ENTER]);
	position_mouse(160,100);

	for(int i=0;i<22;i++){
		objedit[i].x+=SCREEN_W/2-112;
		objedit[i].y+=SCREEN_H/2-56;
	}

 	LEVEL level;
	BG bg;
	int time=0,type=0,mx,my,frame=0,a;
	ENEMY enemy(time+mouse_x,mouse_y-yoff,0,0,0);
	ITEM item(0,0,0,0,0);
	EVENT *e=NULL;
	RLE_SPRITE *img;

	while(!wch && !key[KEY_ESC]){
		while(lc && !wch && !key[KEY_ESC]){
			lc--;
			update_scrollers();
			a++;
			if(a==15){
				a=0;
				frame++;
				frame%=4;
			}
			for(list<EVENT>::iterator i=level.events.begin();i!=level.events.end();i++){
				if(i->type<6){
					int sprite=0;
					if(!i->type)
						sprite=frame%2;
					if(i->type==1)
						sprite=2;
					if(i->type>1 && i->type<5)
						sprite=(i->type-1)*2+1+frame%2;
					if(i->type==5)
						sprite=9+frame;
					i->img=(RLE_SPRITE*)rle[ENEMY0+sprite].dat;
				}
				else
					i->img=(RLE_SPRITE*)rle[ITEM0+i->type-6].dat;
			}
			if(key[KEY_UP])
				yoff+=1;
			if(key[KEY_DOWN])
				yoff-=1;
			if(key[KEY_LEFT]){
				time-=1;
				if(time>0)	bg.update(1);
			}
			if(key[KEY_RIGHT]){
				time+=1;
				bg.update(0);
			}
		}
		get_mouse_mickeys(&mx,&my);
		if(mouse_b&2){
			time+=mx;
			yoff-=my;
			position_mouse(160,100);

			for(int i=0;i<abs(mx) && time-i>0;i++)
				bg.update(mx<0);
		}

		EVENT *e=NULL;
		list<EVENT>::iterator ie;
		img=(RLE_SPRITE*)rle[ENEMY0].dat;
		for(list<EVENT>::iterator i=level.events.begin();i!=level.events.end();i++){
			if(i->time<time+mouse_x+img->w && time+mouse_x<i->time+i->img->w && i->y<mouse_y-yoff+img->h && mouse_y-yoff<i->y+i->img->h){
				e=&(*i);
				ie=i;
				break;
			}
		}

		update_mouse();
		if(mouse_u&1){
			if(e==NULL){	//Add object if clicking in open space.
				level.events.push_front(EVENT(time+mouse_x,mouse_y-yoff,type,-1,0));
				level.events.begin()->img=(RLE_SPRITE*)rle[ENEMY0].dat;
			}
			else{
				objedit[D_type-1].dp=type_name[e->type];
				objedit[D_type].d2=e->type;
				itoa(e->time/30,seconds,10);
				itoa(e->time%30,ticks,10);
				objedit[D_Ypos].d2=e->y+180;
				objedit[D_Xspd].d2=20+int(e->xs*10);
				objedit[D_Yspd].d2=int(e->ys*10)+10;
				int r=do_dialog(objedit,0);
				if(r==D_done){
					e->type=objedit[D_type].d2;
					e->time=atoi(seconds)*30;
					e->time+=atoi(ticks);
					e->y=objedit[D_Ypos].d2-180;
					e->xs=float(objedit[D_Xspd].d2)/float(10.)-2.;
					e->ys=objedit[D_Yspd].d2/10.-1;
				}
				while(key[KEY_ESC] || key[KEY_ENTER]);
				position_mouse(160,100);
			}
		}

		type+=mouse_z;
		position_mouse_z(0);

		if(time<0)time=0;
		if(yoff<30)yoff=30;
		if(yoff>210)yoff=210;

		text_mode(-1);
		bg.draw(buffer);
		for(list<EVENT>::iterator i=level.events.begin();i!=level.events.end();i++)
			draw_rle_sprite(buffer, i->img, (int)i->time-time-i->img->w/2, (int)i->y+(int)yoff-i->img->h/2);

		if(keypressed()){
			switch(readkey()>>8){
			case KEY_DEL:
				if(e!=NULL){
					e=NULL;
					level.events.erase(ie);
				}
				break;
			case KEY_W:
				type++;
				break;
			case KEY_Q:
				type--;
				break;
			case KEY_S:
				if(file_select_ex("Save", path, "lvl", 480, 320, 200)){
					level.events.sort();
					level.save(path);
				}
				else while(key[KEY_ESC]);
				break;
			case KEY_L:
				if(file_select_ex("Load", path, "lvl", 480, 320, 200)){
					level.load(path);
				}
				else while(key[KEY_ESC]);
				break;
			case KEY_P:
				level.events.sort();
				level.pos=level.events.begin();
				level.time=time;
				play(0,&level);
				level.time=0;
				while(key[KEY_ESC]);
				break;
			case KEY_C:
				edit_campaign();
				while(key[KEY_ESC] || key[KEY_ENTER]);
				break;
			case KEY_ENTER:
				if(e!=NULL){
					do_dialog(objedit,0);
					position_mouse(160,100);
				}
				while(key[KEY_ESC] || key[KEY_ENTER]);
				break;
			}
  		}
		if(type>7) type-=8;
		if(type<0) type+=8;

		if(e==NULL){
		if(type<6){
			enemy.x=mouse_x;
			enemy.y=mouse_y-(int)yoff;
			if(enemy.y<-180) enemy.y=-180;
			if(enemy.y>180) enemy.y=180;
			int sprite=0;
			if(!type)
				sprite=frame%2;
			if(type==1)
				sprite=type+1;
			if(type>1 && type<5)
				sprite=(type-1)*2+1+frame%2;
			if(type==5)
				sprite=9+frame;

			enemy.img=(RLE_SPRITE*)rle[ENEMY0+sprite].dat;
			enemy.w=enemy.img->w;
			enemy.h=enemy.img->h;
			enemy.draw(buffer);
		}
		else if(type<8){
			item.img=(RLE_SPRITE*)rle[ITEM0+type-6].dat;
			item.w=item.img->w;
			item.h=item.img->h;
			item.x=mouse_x-item.w/2;
			item.y=mouse_y-(int)yoff;
			if(item.y<-180) item.y=-180;
			if(item.y>180) item.y=180;
			item.draw(buffer);
		}
		}

		if(e!=NULL){
			rect(buffer,e->time-e->img->w/2-2-time,e->y-e->img->h/2-2+(int)yoff,e->time+e->img->w/2+2-time,e->y+e->img->h/2+2+(int)yoff,1);
			line(buffer,mouse_x-4,mouse_y-4,mouse_x+4,mouse_y+4,1);
			line(buffer,mouse_x+4,mouse_y-4,mouse_x-4,mouse_y+4,1);
		}

		textprintf(buffer, font, 0,(int)yoff-4,1,"Playfield centre");
		textprintf(buffer,font,110,200,1,"Time in seconds:");
		for(int x=-time%30;x<350;x+=30)
			textprintf_centre(buffer,font,x,210,1,"%i",(time+x)/30);

		draw_scrollers(buffer);
		acquire_screen();
		stretch_blit(buffer,screen,0,0,320,240,0,0,SCREEN_W,SCREEN_H);
		release_screen();
		clear(buffer);
	}
}
