#include"funnie.h"


//Returns the angle 0-256
int get_angle(float dx,float dy){
	double slope,theangle;
	double deltaH=dx;
	double deltaV=dy;
	if(deltaH){
		slope=double(deltaV)/deltaH;
		theangle=atan(slope);
		if(deltaH<0){
			theangle=theangle+M_PI;
		}
	}
	else if(deltaV>0){
		theangle=M_PI/2;
	}
	else if(deltaV<0){
		theangle=(3*M_PI)/2;
	}
	else{
		theangle=0;
	}
	//Convert to degrees for .rotation
	theangle=(theangle*128)/M_PI;
	if(theangle<0)	theangle+=256;

	return int(theangle);
}


//Pythagoras
double distance(double dx,double dy){
	return sqrt((dx*dx)+(dy*dy));
}



int max(int v1,int v2){
	if(v1>v2)
		return v1;
	else
		return v2;
}



void do_hline(BITMAP *bmp,int x1,int y,int x2,int c,void (*proc)(BITMAP *bmp,int x,int y,int c)){
	int xs,xe;
	if(x1<x2){
		xs=x1;
		xe=x2;
	}
	else{
		xs=x2;
		xe=x1;
	}
	for(int x=xs;x<xe;x++)
		proc(bmp,x,y,c);
}



void do_circlefill(BITMAP *bmp, int x, int y, int radius, int color,void (*proc)(BITMAP *bmp,int x,int y,int c)){
   int cx = 0;
   int cy = radius;
   int df = 1 - radius; 
   int d_e = 3;
   int d_se = -2 * radius + 5;
   int clip, sx, sy, dx, dy;

   if (bmp->clip) {
      sx = x-radius-1;
      sy = y-radius-1;
      dx = x+radius+1;
      dy = y+radius+1;

      if ((sx >= bmp->cr) || (sy >= bmp->cb) || (dx < bmp->cl) || (dy < bmp->ct))
	 return;

      if ((sx >= bmp->cl) && (sy >= bmp->ct) && (dx < bmp->cr) && (dy < bmp->cb))
	 bmp->clip = FALSE;

      clip = TRUE;
   }
   else
      clip = FALSE;

   do {
      do_hline(bmp, x-cy, y-cx, x+cy, color, proc);

      if (cx)
	 do_hline(bmp, x-cy, y+cx, x+cy, color, proc);

      if (df < 0)  {
	 df += d_e;
	 d_e += 2;
	 d_se += 2;
      }
      else { 
	 if (cx != cy) {
	    do_hline(bmp, x-cx, y-cy, x+cx, color, proc);

	    if (cy)
	       do_hline(bmp, x-cx, y+cy, x+cx, color, proc);
	 }

	 df += d_se;
	 d_e += 2;
	 d_se += 4;
	 cy--;
      } 

      cx++; 

   } while (cx <= cy);

   bmp->clip = clip;
}
