#include"funnie.h"

void normalize(RGB *rgb){
	int r=rgb->r;
	int g=rgb->g;
	int b=rgb->b;
	float ch;
	if(r>=g && r>=b)	ch=r;
	if(g>=r && g>=b)	ch=g;
	if(b>=g && b>=r)	ch=b;

	ch=ch/255;

	r=int(r/ch);
	g=int(g/ch);
	b=int(b/ch);
	rgb->r=r;
	rgb->g=g;
	rgb->b=b;
}



//Creation
FUNNIE::FUNNIE(FUNNIE *n){
	nseg=rand()%16+8;
	pos=new V3D_f[nseg];
	for(int i=0;i<nseg;i++){
		pos[i].x=0;
		pos[i].y=0;
		pos[i].z=0;
	}
	spd.x=0;
	spd.y=0;
	spd.z=0;
	rgb.r=rand()%256;
	rgb.g=rand()%256;
	rgb.b=rand()%256;
	normalize(&rgb);
	next=n;
}



//Removal
FUNNIE::~FUNNIE(){
	delete [] pos;
}



void delete_funnie_list(FUNNIE *l){
	FUNNIE *t;
	while(l){
		t=l;
		l=l->next;
		delete t;
	}
}



//Updating
void FUNNIE::update(){
	for(int i=nseg-1;i>0;i--){
		pos[i].x=pos[i-1].x;
		pos[i].y=pos[i-1].y;
		pos[i].z=pos[i-1].z;
	}

	int maxspd=5;
	int areasize=512;

	spd.x+=rand()%3-1;
	spd.y+=rand()%3-1;
	spd.z+=rand()%3-1;

	//To keep them from getting to close.
	//Needs to relate to camera position, which it now doesn't so I leave it out for now.
/*	if(vector_length_f(pos[0].x, pos[0].y, pos[0].z)<64){
		if(pos[0].x<0)	spd.x-=2;
		if(pos[0].x>0)	spd.x+=2;
		if(pos[0].y<0)	spd.y-=2;
		if(pos[0].y>0)	spd.y+=2;
		if(pos[0].z<0)	spd.z-=2;
		if(pos[0].z>0)	spd.z+=2;
	}
*/
	//Don't go too far away.
	if(vector_length_f(pos[0].x, pos[0].y, pos[0].z)>areasize){
		if(pos[0].x<0)	spd.x++;
		if(pos[0].x>0)	spd.x--;
		if(pos[0].y<0)	spd.y++;
		if(pos[0].y>0)	spd.y--;
		if(pos[0].z<0)	spd.z++;
		if(pos[0].z>0)	spd.z--;
	}

	if(spd.x>maxspd)	spd.x=maxspd;
	if(spd.x<-maxspd)	spd.x=-maxspd;
	if(spd.y>maxspd)	spd.y=maxspd;
	if(spd.y<-maxspd)	spd.y=-maxspd;
	if(spd.z>maxspd)	spd.z=maxspd;
	if(spd.z<-maxspd)	spd.z=-maxspd;

	pos[0].x+=spd.x;
	pos[0].y+=spd.y;
	pos[0].z+=spd.z;

	fire_particles(pos[0],spd,rgb,1);
}



void update_funnie_list(FUNNIE *l){
	FUNNIE *t=l;
	while(t){
		t->update();
		t=t->next;
	}
}



//Drawing
ZBUFFER *lzbuf;
int lz;
void zbuf_cb(BITMAP *buffer,int x,int y,int c){
	int z=getpixel(lzbuf,x,y);
	if(z==0 || z>lz){
		putpixel(buffer,x,y,c);
		putpixel(lzbuf,x,y,lz);
	}
}



bool FUNNIE::draw(BITMAP *buffer,ZBUFFER *zbuf,MATRIX_f matrix){
	lzbuf=zbuf;
	V3D_f vtx[nseg];
	for(int i=0;i<nseg;i++){
		vtx[i].x=pos[i].x;
		vtx[i].y=pos[i].y;
		vtx[i].z=pos[i].z;
	}

	set_projection_viewport(0, 0, buffer->w, buffer->h);

	bool pp[nseg];
	for(int i=0;i<nseg;i++){
		apply_matrix_f(&matrix, vtx[i].x, vtx[i].y, vtx[i].z, &vtx[i].x, &vtx[i].y, &vtx[i].z);
		if((0>vtx[i].z) || (-vtx[i].z>vtx[i].x || vtx[i].z<vtx[i].x) || (-vtx[i].z>vtx[i].y || vtx[i].z<vtx[i].y))
			pp[i]=0;
		else
			pp[i]=1;
		if(pp[i]){
			persp_project_f(vtx[i].x,vtx[i].y,vtx[i].z,&vtx[i].x,&vtx[i].y);
		}
	}
	//Fix the head coord, set z to 0 to indicate not on screen.
	if(pp[0])
		head2d=vtx[0];
	else
		head2d.z=0;

	int r,c;
	double z;
	//for(int i=0;i<nseg-1;i++){
	for(int i=nseg-2;i>=0;i--){
		if(pp[i] && pp[i+1]){
			z=1.0/vtx[i].z;
			r=int((nseg/2 * z) * _persp_xscale_f*(1-(i+1)/float(nseg)));
			c=makecol(max(0,rgb.r-int(vtx[i].z/4)-i*4), max(0,rgb.g-int(vtx[i].z/4)-i*4), max(0,rgb.b-int(vtx[i].z/4)-i*4));
			//Prevent ridiculus sizes, rendering times will be unacceptable if you leave this out.
			if(r<buffer->w/8){
				lz=int(vtx[i].z);
				do_circlefill(buffer,int(vtx[i].x),int(vtx[i].y),r,c,zbuf_cb);
				//Alternative graphics
/*				lz=int(vtx[i].z);
				for(;r>0;r-=4)
					do_circle(buffer,int(vtx[i].x),int(vtx[i].y),r,c,zbuf_cb);
*/			}
			//circle(buffer,int(vtx[i].x),int(vtx[i].y),r,c);

			//line doesn't work when I have more than one funnie in a linked list, god knows why. rect works with the same pars.
//			line(buffer,int(vtx[i].x),int(vtx[i].y),int(vtx[i+1].x),int(vtx[i+1].y),makecol(255-int(vtx[i].z/2),255-int(vtx[i].z/2),255-int(vtx[i].z/2)));
		}
	}
	return 1;
}



void draw_funnie_list(FUNNIE *l,BITMAP *buffer,ZBUFFER *zbuf,MATRIX_f matrix){
	int c=0;
	FUNNIE *t=l;
	while(t){
		c+=t->draw(buffer,zbuf,matrix);
		t=t->next;
	}

//	textprintf(buffer,font,0,8,makecol(255,255,255),"%i",c);
}



//Finding nearest funnie at a 2d point.
FUNNIE *get_funnie_at(FUNNIE *l,int x,int y){
	FUNNIE *t=l,*rf=NULL;
	int r;double z,near=0;
	while(t){
		if(t->head2d.z){ //If on screen.
			if(near>t->head2d.z || near==0){	//If nearer than previous nearest.
				//If coord is within funnie head, set near to its z and rf to the funnie.
				z=1.0/t->head2d.z;
				r=int((t->nseg/2 * z) * _persp_xscale_f*(1-1/float(t->nseg)));
				if(distance(x-t->head2d.x,y-t->head2d.y)<r){
					rf=t;
					near=t->head2d.z;
				}
			}
		}

		t=t->next;
	}

	return rf;
}
